/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.CalculationAgent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CalculationAgentChoice")
@ImplementedBy(value=Default.class)
public interface CalculationAgentChoice
extends Validator<CalculationAgent> {
    public static final String NAME = "CalculationAgentChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements CalculationAgentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CalculationAgent calculationAgent) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CalculationAgentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CalculationAgent calculationAgent) {
            ComparisonResult result = this.executeDataRule(calculationAgent);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CalculationAgentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CalculationAgent", (RosettaPath)path, (String)CalculationAgentChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CalculationAgentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CalculationAgent", (RosettaPath)path, (String)CalculationAgentChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CalculationAgent calculationAgent) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)calculationAgent), Arrays.asList("calculationAgentPartyReference", "calculationAgentParty"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

