/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.Beneficiary;
import fpml.consolidated.shared.CorrespondentInformation;
import fpml.consolidated.shared.IntermediaryInformation;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.SettlementMethod;
import fpml.consolidated.shared.SplitSettlement;
import fpml.consolidated.shared.meta.SettlementInstructionMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SettlementInstruction", builder=SettlementInstructionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="SettlementInstruction", model="fpml", builder=SettlementInstructionBuilderImpl.class, version="1.2.2")
public interface SettlementInstruction
extends RosettaModelObject {
    public static final SettlementInstructionMeta metaData = new SettlementInstructionMeta();

    public SettlementMethod getSettlementMethod();

    public CorrespondentInformation getCorrespondentInformation();

    public List<? extends IntermediaryInformation> getIntermediaryInformation();

    public Beneficiary getBeneficiaryBank();

    public Beneficiary getBeneficiary();

    public PartyReference getDepositoryPartyReference();

    public List<? extends SplitSettlement> getSplitSettlement();

    public SettlementInstruction build();

    public SettlementInstructionBuilder toBuilder();

    public static SettlementInstructionBuilder builder() {
        return new SettlementInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends SettlementInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SettlementInstruction> getType() {
        return SettlementInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementMethod"), processor, SettlementMethod.class, this.getSettlementMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correspondentInformation"), processor, CorrespondentInformation.class, this.getCorrespondentInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("intermediaryInformation"), processor, IntermediaryInformation.class, this.getIntermediaryInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("beneficiaryBank"), processor, Beneficiary.class, this.getBeneficiaryBank(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("beneficiary"), processor, Beneficiary.class, this.getBeneficiary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("depositoryPartyReference"), processor, PartyReference.class, this.getDepositoryPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("splitSettlement"), processor, SplitSettlement.class, this.getSplitSettlement(), new AttributeMeta[0]);
    }

    public static class SettlementInstructionBuilderImpl
    implements SettlementInstructionBuilder {
        protected SettlementMethod.SettlementMethodBuilder settlementMethod;
        protected CorrespondentInformation.CorrespondentInformationBuilder correspondentInformation;
        protected List<IntermediaryInformation.IntermediaryInformationBuilder> intermediaryInformation = new ArrayList<IntermediaryInformation.IntermediaryInformationBuilder>();
        protected Beneficiary.BeneficiaryBuilder beneficiaryBank;
        protected Beneficiary.BeneficiaryBuilder beneficiary;
        protected PartyReference.PartyReferenceBuilder depositoryPartyReference;
        protected List<SplitSettlement.SplitSettlementBuilder> splitSettlement = new ArrayList<SplitSettlement.SplitSettlementBuilder>();

        @Override
        @RosettaAttribute(value="settlementMethod")
        @RuneAttribute(value="settlementMethod")
        public SettlementMethod.SettlementMethodBuilder getSettlementMethod() {
            return this.settlementMethod;
        }

        @Override
        public SettlementMethod.SettlementMethodBuilder getOrCreateSettlementMethod() {
            SettlementMethod.SettlementMethodBuilder result = this.settlementMethod != null ? this.settlementMethod : (this.settlementMethod = SettlementMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="correspondentInformation")
        @RuneAttribute(value="correspondentInformation")
        public CorrespondentInformation.CorrespondentInformationBuilder getCorrespondentInformation() {
            return this.correspondentInformation;
        }

        @Override
        public CorrespondentInformation.CorrespondentInformationBuilder getOrCreateCorrespondentInformation() {
            CorrespondentInformation.CorrespondentInformationBuilder result = this.correspondentInformation != null ? this.correspondentInformation : (this.correspondentInformation = CorrespondentInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intermediaryInformation")
        @RuneAttribute(value="intermediaryInformation")
        public List<? extends IntermediaryInformation.IntermediaryInformationBuilder> getIntermediaryInformation() {
            return this.intermediaryInformation;
        }

        @Override
        public IntermediaryInformation.IntermediaryInformationBuilder getOrCreateIntermediaryInformation(int index) {
            if (this.intermediaryInformation == null) {
                this.intermediaryInformation = new ArrayList<IntermediaryInformation.IntermediaryInformationBuilder>();
            }
            return (IntermediaryInformation.IntermediaryInformationBuilder)this.getIndex(this.intermediaryInformation, index, () -> {
                IntermediaryInformation.IntermediaryInformationBuilder newIntermediaryInformation = IntermediaryInformation.builder();
                return newIntermediaryInformation;
            });
        }

        @Override
        @RosettaAttribute(value="beneficiaryBank")
        @RuneAttribute(value="beneficiaryBank")
        public Beneficiary.BeneficiaryBuilder getBeneficiaryBank() {
            return this.beneficiaryBank;
        }

        @Override
        public Beneficiary.BeneficiaryBuilder getOrCreateBeneficiaryBank() {
            Beneficiary.BeneficiaryBuilder result = this.beneficiaryBank != null ? this.beneficiaryBank : (this.beneficiaryBank = Beneficiary.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public Beneficiary.BeneficiaryBuilder getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        public Beneficiary.BeneficiaryBuilder getOrCreateBeneficiary() {
            Beneficiary.BeneficiaryBuilder result = this.beneficiary != null ? this.beneficiary : (this.beneficiary = Beneficiary.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="depositoryPartyReference")
        @RuneAttribute(value="depositoryPartyReference")
        public PartyReference.PartyReferenceBuilder getDepositoryPartyReference() {
            return this.depositoryPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateDepositoryPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.depositoryPartyReference != null ? this.depositoryPartyReference : (this.depositoryPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="splitSettlement")
        @RuneAttribute(value="splitSettlement")
        public List<? extends SplitSettlement.SplitSettlementBuilder> getSplitSettlement() {
            return this.splitSettlement;
        }

        @Override
        public SplitSettlement.SplitSettlementBuilder getOrCreateSplitSettlement(int index) {
            if (this.splitSettlement == null) {
                this.splitSettlement = new ArrayList<SplitSettlement.SplitSettlementBuilder>();
            }
            return (SplitSettlement.SplitSettlementBuilder)this.getIndex(this.splitSettlement, index, () -> {
                SplitSettlement.SplitSettlementBuilder newSplitSettlement = SplitSettlement.builder();
                return newSplitSettlement;
            });
        }

        @Override
        @RosettaAttribute(value="settlementMethod")
        @RuneAttribute(value="settlementMethod")
        public SettlementInstructionBuilder setSettlementMethod(SettlementMethod _settlementMethod) {
            this.settlementMethod = _settlementMethod == null ? null : _settlementMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correspondentInformation")
        @RuneAttribute(value="correspondentInformation")
        public SettlementInstructionBuilder setCorrespondentInformation(CorrespondentInformation _correspondentInformation) {
            this.correspondentInformation = _correspondentInformation == null ? null : _correspondentInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="intermediaryInformation")
        @RuneAttribute(value="intermediaryInformation")
        public SettlementInstructionBuilder addIntermediaryInformation(IntermediaryInformation _intermediaryInformation) {
            if (_intermediaryInformation != null) {
                this.intermediaryInformation.add(_intermediaryInformation.toBuilder());
            }
            return this;
        }

        @Override
        public SettlementInstructionBuilder addIntermediaryInformation(IntermediaryInformation _intermediaryInformation, int idx) {
            this.getIndex(this.intermediaryInformation, idx, () -> _intermediaryInformation.toBuilder());
            return this;
        }

        @Override
        public SettlementInstructionBuilder addIntermediaryInformation(List<? extends IntermediaryInformation> intermediaryInformations) {
            if (intermediaryInformations != null) {
                for (IntermediaryInformation intermediaryInformation : intermediaryInformations) {
                    this.intermediaryInformation.add(intermediaryInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="intermediaryInformation")
        public SettlementInstructionBuilder setIntermediaryInformation(List<? extends IntermediaryInformation> intermediaryInformations) {
            this.intermediaryInformation = intermediaryInformations == null ? new ArrayList<IntermediaryInformation.IntermediaryInformationBuilder>() : (List)intermediaryInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiaryBank")
        @RuneAttribute(value="beneficiaryBank")
        public SettlementInstructionBuilder setBeneficiaryBank(Beneficiary _beneficiaryBank) {
            this.beneficiaryBank = _beneficiaryBank == null ? null : _beneficiaryBank.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public SettlementInstructionBuilder setBeneficiary(Beneficiary _beneficiary) {
            this.beneficiary = _beneficiary == null ? null : _beneficiary.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="depositoryPartyReference")
        @RuneAttribute(value="depositoryPartyReference")
        public SettlementInstructionBuilder setDepositoryPartyReference(PartyReference _depositoryPartyReference) {
            this.depositoryPartyReference = _depositoryPartyReference == null ? null : _depositoryPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="splitSettlement")
        @RuneAttribute(value="splitSettlement")
        public SettlementInstructionBuilder addSplitSettlement(SplitSettlement _splitSettlement) {
            if (_splitSettlement != null) {
                this.splitSettlement.add(_splitSettlement.toBuilder());
            }
            return this;
        }

        @Override
        public SettlementInstructionBuilder addSplitSettlement(SplitSettlement _splitSettlement, int idx) {
            this.getIndex(this.splitSettlement, idx, () -> _splitSettlement.toBuilder());
            return this;
        }

        @Override
        public SettlementInstructionBuilder addSplitSettlement(List<? extends SplitSettlement> splitSettlements) {
            if (splitSettlements != null) {
                for (SplitSettlement splitSettlement : splitSettlements) {
                    this.splitSettlement.add(splitSettlement.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="splitSettlement")
        public SettlementInstructionBuilder setSplitSettlement(List<? extends SplitSettlement> splitSettlements) {
            this.splitSettlement = splitSettlements == null ? new ArrayList<SplitSettlement.SplitSettlementBuilder>() : (List)splitSettlements.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public SettlementInstruction build() {
            return new SettlementInstructionImpl(this);
        }

        @Override
        public SettlementInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementInstructionBuilder prune() {
            if (this.settlementMethod != null && !this.settlementMethod.prune().hasData()) {
                this.settlementMethod = null;
            }
            if (this.correspondentInformation != null && !this.correspondentInformation.prune().hasData()) {
                this.correspondentInformation = null;
            }
            this.intermediaryInformation = this.intermediaryInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.beneficiaryBank != null && !this.beneficiaryBank.prune().hasData()) {
                this.beneficiaryBank = null;
            }
            if (this.beneficiary != null && !this.beneficiary.prune().hasData()) {
                this.beneficiary = null;
            }
            if (this.depositoryPartyReference != null && !this.depositoryPartyReference.prune().hasData()) {
                this.depositoryPartyReference = null;
            }
            this.splitSettlement = this.splitSettlement.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementMethod() != null && this.getSettlementMethod().hasData()) {
                return true;
            }
            if (this.getCorrespondentInformation() != null && this.getCorrespondentInformation().hasData()) {
                return true;
            }
            if (this.getIntermediaryInformation() != null && this.getIntermediaryInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBeneficiaryBank() != null && this.getBeneficiaryBank().hasData()) {
                return true;
            }
            if (this.getBeneficiary() != null && this.getBeneficiary().hasData()) {
                return true;
            }
            if (this.getDepositoryPartyReference() != null && this.getDepositoryPartyReference().hasData()) {
                return true;
            }
            return this.getSplitSettlement() != null && this.getSplitSettlement().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public SettlementInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SettlementInstructionBuilder o = (SettlementInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementMethod(), (RosettaModelObjectBuilder)o.getSettlementMethod(), this::setSettlementMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorrespondentInformation(), (RosettaModelObjectBuilder)o.getCorrespondentInformation(), this::setCorrespondentInformation);
            merger.mergeRosetta(this.getIntermediaryInformation(), o.getIntermediaryInformation(), this::getOrCreateIntermediaryInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBeneficiaryBank(), (RosettaModelObjectBuilder)o.getBeneficiaryBank(), this::setBeneficiaryBank);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBeneficiary(), (RosettaModelObjectBuilder)o.getBeneficiary(), this::setBeneficiary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDepositoryPartyReference(), (RosettaModelObjectBuilder)o.getDepositoryPartyReference(), this::setDepositoryPartyReference);
            merger.mergeRosetta(this.getSplitSettlement(), o.getSplitSettlement(), this::getOrCreateSplitSettlement);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementMethod, _that.getSettlementMethod())) {
                return false;
            }
            if (!Objects.equals(this.correspondentInformation, _that.getCorrespondentInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.intermediaryInformation, _that.getIntermediaryInformation())) {
                return false;
            }
            if (!Objects.equals(this.beneficiaryBank, _that.getBeneficiaryBank())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary, _that.getBeneficiary())) {
                return false;
            }
            if (!Objects.equals(this.depositoryPartyReference, _that.getDepositoryPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.splitSettlement, _that.getSplitSettlement());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementMethod != null ? this.settlementMethod.hashCode() : 0);
            _result = 31 * _result + (this.correspondentInformation != null ? this.correspondentInformation.hashCode() : 0);
            _result = 31 * _result + (this.intermediaryInformation != null ? this.intermediaryInformation.hashCode() : 0);
            _result = 31 * _result + (this.beneficiaryBank != null ? this.beneficiaryBank.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary != null ? this.beneficiary.hashCode() : 0);
            _result = 31 * _result + (this.depositoryPartyReference != null ? this.depositoryPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.splitSettlement != null ? this.splitSettlement.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementInstructionBuilder {settlementMethod=" + String.valueOf(this.settlementMethod) + ", correspondentInformation=" + String.valueOf(this.correspondentInformation) + ", intermediaryInformation=" + String.valueOf(this.intermediaryInformation) + ", beneficiaryBank=" + String.valueOf(this.beneficiaryBank) + ", beneficiary=" + String.valueOf(this.beneficiary) + ", depositoryPartyReference=" + String.valueOf(this.depositoryPartyReference) + ", splitSettlement=" + String.valueOf(this.splitSettlement) + "}";
        }
    }

    public static interface SettlementInstructionBuilder
    extends SettlementInstruction,
    RosettaModelObjectBuilder {
        public SettlementMethod.SettlementMethodBuilder getOrCreateSettlementMethod();

        @Override
        public SettlementMethod.SettlementMethodBuilder getSettlementMethod();

        public CorrespondentInformation.CorrespondentInformationBuilder getOrCreateCorrespondentInformation();

        @Override
        public CorrespondentInformation.CorrespondentInformationBuilder getCorrespondentInformation();

        public IntermediaryInformation.IntermediaryInformationBuilder getOrCreateIntermediaryInformation(int var1);

        public List<? extends IntermediaryInformation.IntermediaryInformationBuilder> getIntermediaryInformation();

        public Beneficiary.BeneficiaryBuilder getOrCreateBeneficiaryBank();

        @Override
        public Beneficiary.BeneficiaryBuilder getBeneficiaryBank();

        public Beneficiary.BeneficiaryBuilder getOrCreateBeneficiary();

        @Override
        public Beneficiary.BeneficiaryBuilder getBeneficiary();

        public PartyReference.PartyReferenceBuilder getOrCreateDepositoryPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getDepositoryPartyReference();

        public SplitSettlement.SplitSettlementBuilder getOrCreateSplitSettlement(int var1);

        public List<? extends SplitSettlement.SplitSettlementBuilder> getSplitSettlement();

        public SettlementInstructionBuilder setSettlementMethod(SettlementMethod var1);

        public SettlementInstructionBuilder setCorrespondentInformation(CorrespondentInformation var1);

        public SettlementInstructionBuilder addIntermediaryInformation(IntermediaryInformation var1);

        public SettlementInstructionBuilder addIntermediaryInformation(IntermediaryInformation var1, int var2);

        public SettlementInstructionBuilder addIntermediaryInformation(List<? extends IntermediaryInformation> var1);

        public SettlementInstructionBuilder setIntermediaryInformation(List<? extends IntermediaryInformation> var1);

        public SettlementInstructionBuilder setBeneficiaryBank(Beneficiary var1);

        public SettlementInstructionBuilder setBeneficiary(Beneficiary var1);

        public SettlementInstructionBuilder setDepositoryPartyReference(PartyReference var1);

        public SettlementInstructionBuilder addSplitSettlement(SplitSettlement var1);

        public SettlementInstructionBuilder addSplitSettlement(SplitSettlement var1, int var2);

        public SettlementInstructionBuilder addSplitSettlement(List<? extends SplitSettlement> var1);

        public SettlementInstructionBuilder setSplitSettlement(List<? extends SplitSettlement> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementMethod"), processor, SettlementMethod.SettlementMethodBuilder.class, this.getSettlementMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correspondentInformation"), processor, CorrespondentInformation.CorrespondentInformationBuilder.class, this.getCorrespondentInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("intermediaryInformation"), processor, IntermediaryInformation.IntermediaryInformationBuilder.class, this.getIntermediaryInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("beneficiaryBank"), processor, Beneficiary.BeneficiaryBuilder.class, this.getBeneficiaryBank(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("beneficiary"), processor, Beneficiary.BeneficiaryBuilder.class, this.getBeneficiary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("depositoryPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getDepositoryPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("splitSettlement"), processor, SplitSettlement.SplitSettlementBuilder.class, this.getSplitSettlement(), new AttributeMeta[0]);
        }

        public SettlementInstructionBuilder prune();
    }

    public static class SettlementInstructionImpl
    implements SettlementInstruction {
        private final SettlementMethod settlementMethod;
        private final CorrespondentInformation correspondentInformation;
        private final List<? extends IntermediaryInformation> intermediaryInformation;
        private final Beneficiary beneficiaryBank;
        private final Beneficiary beneficiary;
        private final PartyReference depositoryPartyReference;
        private final List<? extends SplitSettlement> splitSettlement;

        protected SettlementInstructionImpl(SettlementInstructionBuilder builder) {
            this.settlementMethod = Optional.ofNullable(builder.getSettlementMethod()).map(f -> f.build()).orElse(null);
            this.correspondentInformation = Optional.ofNullable(builder.getCorrespondentInformation()).map(f -> f.build()).orElse(null);
            this.intermediaryInformation = Optional.ofNullable(builder.getIntermediaryInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.beneficiaryBank = Optional.ofNullable(builder.getBeneficiaryBank()).map(f -> f.build()).orElse(null);
            this.beneficiary = Optional.ofNullable(builder.getBeneficiary()).map(f -> f.build()).orElse(null);
            this.depositoryPartyReference = Optional.ofNullable(builder.getDepositoryPartyReference()).map(f -> f.build()).orElse(null);
            this.splitSettlement = Optional.ofNullable(builder.getSplitSettlement()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementMethod")
        @RuneAttribute(value="settlementMethod")
        public SettlementMethod getSettlementMethod() {
            return this.settlementMethod;
        }

        @Override
        @RosettaAttribute(value="correspondentInformation")
        @RuneAttribute(value="correspondentInformation")
        public CorrespondentInformation getCorrespondentInformation() {
            return this.correspondentInformation;
        }

        @Override
        @RosettaAttribute(value="intermediaryInformation")
        @RuneAttribute(value="intermediaryInformation")
        public List<? extends IntermediaryInformation> getIntermediaryInformation() {
            return this.intermediaryInformation;
        }

        @Override
        @RosettaAttribute(value="beneficiaryBank")
        @RuneAttribute(value="beneficiaryBank")
        public Beneficiary getBeneficiaryBank() {
            return this.beneficiaryBank;
        }

        @Override
        @RosettaAttribute(value="beneficiary")
        @RuneAttribute(value="beneficiary")
        public Beneficiary getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        @RosettaAttribute(value="depositoryPartyReference")
        @RuneAttribute(value="depositoryPartyReference")
        public PartyReference getDepositoryPartyReference() {
            return this.depositoryPartyReference;
        }

        @Override
        @RosettaAttribute(value="splitSettlement")
        @RuneAttribute(value="splitSettlement")
        public List<? extends SplitSettlement> getSplitSettlement() {
            return this.splitSettlement;
        }

        @Override
        public SettlementInstruction build() {
            return this;
        }

        @Override
        public SettlementInstructionBuilder toBuilder() {
            SettlementInstructionBuilder builder = SettlementInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementInstructionBuilder builder) {
            Optional.ofNullable(this.getSettlementMethod()).ifPresent(builder::setSettlementMethod);
            Optional.ofNullable(this.getCorrespondentInformation()).ifPresent(builder::setCorrespondentInformation);
            Optional.ofNullable(this.getIntermediaryInformation()).ifPresent(builder::setIntermediaryInformation);
            Optional.ofNullable(this.getBeneficiaryBank()).ifPresent(builder::setBeneficiaryBank);
            Optional.ofNullable(this.getBeneficiary()).ifPresent(builder::setBeneficiary);
            Optional.ofNullable(this.getDepositoryPartyReference()).ifPresent(builder::setDepositoryPartyReference);
            Optional.ofNullable(this.getSplitSettlement()).ifPresent(builder::setSplitSettlement);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementMethod, _that.getSettlementMethod())) {
                return false;
            }
            if (!Objects.equals(this.correspondentInformation, _that.getCorrespondentInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.intermediaryInformation, _that.getIntermediaryInformation())) {
                return false;
            }
            if (!Objects.equals(this.beneficiaryBank, _that.getBeneficiaryBank())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary, _that.getBeneficiary())) {
                return false;
            }
            if (!Objects.equals(this.depositoryPartyReference, _that.getDepositoryPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.splitSettlement, _that.getSplitSettlement());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementMethod != null ? this.settlementMethod.hashCode() : 0);
            _result = 31 * _result + (this.correspondentInformation != null ? this.correspondentInformation.hashCode() : 0);
            _result = 31 * _result + (this.intermediaryInformation != null ? this.intermediaryInformation.hashCode() : 0);
            _result = 31 * _result + (this.beneficiaryBank != null ? this.beneficiaryBank.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary != null ? this.beneficiary.hashCode() : 0);
            _result = 31 * _result + (this.depositoryPartyReference != null ? this.depositoryPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.splitSettlement != null ? this.splitSettlement.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementInstruction {settlementMethod=" + String.valueOf(this.settlementMethod) + ", correspondentInformation=" + String.valueOf(this.correspondentInformation) + ", intermediaryInformation=" + String.valueOf(this.intermediaryInformation) + ", beneficiaryBank=" + String.valueOf(this.beneficiaryBank) + ", beneficiary=" + String.valueOf(this.beneficiary) + ", depositoryPartyReference=" + String.valueOf(this.depositoryPartyReference) + ", splitSettlement=" + String.valueOf(this.splitSettlement) + "}";
        }
    }
}

