/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.Address;
import fpml.consolidated.shared.meta.RoutingExplicitDetailsModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RoutingExplicitDetailsModel", builder=RoutingExplicitDetailsModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RoutingExplicitDetailsModel", model="fpml", builder=RoutingExplicitDetailsModelBuilderImpl.class, version="1.2.2")
public interface RoutingExplicitDetailsModel
extends RosettaModelObject {
    public static final RoutingExplicitDetailsModelMeta metaData = new RoutingExplicitDetailsModelMeta();

    public String getRoutingName();

    public Address getRoutingAddress();

    public String getRoutingAccountNumber();

    public List<String> getRoutingReferenceText();

    public RoutingExplicitDetailsModel build();

    public RoutingExplicitDetailsModelBuilder toBuilder();

    public static RoutingExplicitDetailsModelBuilder builder() {
        return new RoutingExplicitDetailsModelBuilderImpl();
    }

    default public RosettaMetaData<? extends RoutingExplicitDetailsModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RoutingExplicitDetailsModel> getType() {
        return RoutingExplicitDetailsModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("routingName"), String.class, (Object)this.getRoutingName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("routingAddress"), processor, Address.class, this.getRoutingAddress(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("routingAccountNumber"), String.class, (Object)this.getRoutingAccountNumber(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("routingReferenceText"), String.class, this.getRoutingReferenceText(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RoutingExplicitDetailsModelBuilderImpl
    implements RoutingExplicitDetailsModelBuilder {
        protected String routingName;
        protected Address.AddressBuilder routingAddress;
        protected String routingAccountNumber;
        protected List<String> routingReferenceText = new ArrayList<String>();

        @Override
        @RosettaAttribute(value="routingName")
        @RuneAttribute(value="routingName")
        public String getRoutingName() {
            return this.routingName;
        }

        @Override
        @RosettaAttribute(value="routingAddress")
        @RuneAttribute(value="routingAddress")
        public Address.AddressBuilder getRoutingAddress() {
            return this.routingAddress;
        }

        @Override
        public Address.AddressBuilder getOrCreateRoutingAddress() {
            Address.AddressBuilder result = this.routingAddress != null ? this.routingAddress : (this.routingAddress = Address.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="routingAccountNumber")
        @RuneAttribute(value="routingAccountNumber")
        public String getRoutingAccountNumber() {
            return this.routingAccountNumber;
        }

        @Override
        @RosettaAttribute(value="routingReferenceText")
        @RuneAttribute(value="routingReferenceText")
        public List<String> getRoutingReferenceText() {
            return this.routingReferenceText;
        }

        @Override
        @RosettaAttribute(value="routingName")
        @RuneAttribute(value="routingName")
        public RoutingExplicitDetailsModelBuilder setRoutingName(String _routingName) {
            this.routingName = _routingName == null ? null : _routingName;
            return this;
        }

        @Override
        @RosettaAttribute(value="routingAddress")
        @RuneAttribute(value="routingAddress")
        public RoutingExplicitDetailsModelBuilder setRoutingAddress(Address _routingAddress) {
            this.routingAddress = _routingAddress == null ? null : _routingAddress.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="routingAccountNumber")
        @RuneAttribute(value="routingAccountNumber")
        public RoutingExplicitDetailsModelBuilder setRoutingAccountNumber(String _routingAccountNumber) {
            this.routingAccountNumber = _routingAccountNumber == null ? null : _routingAccountNumber;
            return this;
        }

        @Override
        @RosettaAttribute(value="routingReferenceText")
        @RuneAttribute(value="routingReferenceText")
        public RoutingExplicitDetailsModelBuilder addRoutingReferenceText(String _routingReferenceText) {
            if (_routingReferenceText != null) {
                this.routingReferenceText.add(_routingReferenceText);
            }
            return this;
        }

        @Override
        public RoutingExplicitDetailsModelBuilder addRoutingReferenceText(String _routingReferenceText, int idx) {
            this.getIndex(this.routingReferenceText, idx, () -> _routingReferenceText);
            return this;
        }

        @Override
        public RoutingExplicitDetailsModelBuilder addRoutingReferenceText(List<String> routingReferenceTexts) {
            if (routingReferenceTexts != null) {
                for (String toAdd : routingReferenceTexts) {
                    this.routingReferenceText.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="routingReferenceText")
        public RoutingExplicitDetailsModelBuilder setRoutingReferenceText(List<String> routingReferenceTexts) {
            this.routingReferenceText = routingReferenceTexts == null ? new ArrayList<String>() : (List)routingReferenceTexts.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RoutingExplicitDetailsModel build() {
            return new RoutingExplicitDetailsModelImpl(this);
        }

        @Override
        public RoutingExplicitDetailsModelBuilder toBuilder() {
            return this;
        }

        @Override
        public RoutingExplicitDetailsModelBuilder prune() {
            if (this.routingAddress != null && !this.routingAddress.prune().hasData()) {
                this.routingAddress = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRoutingName() != null) {
                return true;
            }
            if (this.getRoutingAddress() != null && this.getRoutingAddress().hasData()) {
                return true;
            }
            if (this.getRoutingAccountNumber() != null) {
                return true;
            }
            return this.getRoutingReferenceText() != null && !this.getRoutingReferenceText().isEmpty();
        }

        public RoutingExplicitDetailsModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RoutingExplicitDetailsModelBuilder o = (RoutingExplicitDetailsModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRoutingAddress(), (RosettaModelObjectBuilder)o.getRoutingAddress(), this::setRoutingAddress);
            merger.mergeBasic((Object)this.getRoutingName(), (Object)o.getRoutingName(), this::setRoutingName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRoutingAccountNumber(), (Object)o.getRoutingAccountNumber(), this::setRoutingAccountNumber, new AttributeMeta[0]);
            merger.mergeBasic(this.getRoutingReferenceText(), o.getRoutingReferenceText(), this::addRoutingReferenceText);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RoutingExplicitDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.routingName, _that.getRoutingName())) {
                return false;
            }
            if (!Objects.equals(this.routingAddress, _that.getRoutingAddress())) {
                return false;
            }
            if (!Objects.equals(this.routingAccountNumber, _that.getRoutingAccountNumber())) {
                return false;
            }
            return ListEquals.listEquals(this.routingReferenceText, _that.getRoutingReferenceText());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.routingName != null ? this.routingName.hashCode() : 0);
            _result = 31 * _result + (this.routingAddress != null ? this.routingAddress.hashCode() : 0);
            _result = 31 * _result + (this.routingAccountNumber != null ? this.routingAccountNumber.hashCode() : 0);
            _result = 31 * _result + (this.routingReferenceText != null ? this.routingReferenceText.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RoutingExplicitDetailsModelBuilder {routingName=" + this.routingName + ", routingAddress=" + String.valueOf(this.routingAddress) + ", routingAccountNumber=" + this.routingAccountNumber + ", routingReferenceText=" + String.valueOf(this.routingReferenceText) + "}";
        }
    }

    public static interface RoutingExplicitDetailsModelBuilder
    extends RoutingExplicitDetailsModel,
    RosettaModelObjectBuilder {
        public Address.AddressBuilder getOrCreateRoutingAddress();

        @Override
        public Address.AddressBuilder getRoutingAddress();

        public RoutingExplicitDetailsModelBuilder setRoutingName(String var1);

        public RoutingExplicitDetailsModelBuilder setRoutingAddress(Address var1);

        public RoutingExplicitDetailsModelBuilder setRoutingAccountNumber(String var1);

        public RoutingExplicitDetailsModelBuilder addRoutingReferenceText(String var1);

        public RoutingExplicitDetailsModelBuilder addRoutingReferenceText(String var1, int var2);

        public RoutingExplicitDetailsModelBuilder addRoutingReferenceText(List<String> var1);

        public RoutingExplicitDetailsModelBuilder setRoutingReferenceText(List<String> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("routingName"), String.class, (Object)this.getRoutingName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("routingAddress"), processor, Address.AddressBuilder.class, this.getRoutingAddress(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("routingAccountNumber"), String.class, (Object)this.getRoutingAccountNumber(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("routingReferenceText"), String.class, this.getRoutingReferenceText(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public RoutingExplicitDetailsModelBuilder prune();
    }

    public static class RoutingExplicitDetailsModelImpl
    implements RoutingExplicitDetailsModel {
        private final String routingName;
        private final Address routingAddress;
        private final String routingAccountNumber;
        private final List<String> routingReferenceText;

        protected RoutingExplicitDetailsModelImpl(RoutingExplicitDetailsModelBuilder builder) {
            this.routingName = builder.getRoutingName();
            this.routingAddress = Optional.ofNullable(builder.getRoutingAddress()).map(f -> f.build()).orElse(null);
            this.routingAccountNumber = builder.getRoutingAccountNumber();
            this.routingReferenceText = Optional.ofNullable(builder.getRoutingReferenceText()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="routingName")
        @RuneAttribute(value="routingName")
        public String getRoutingName() {
            return this.routingName;
        }

        @Override
        @RosettaAttribute(value="routingAddress")
        @RuneAttribute(value="routingAddress")
        public Address getRoutingAddress() {
            return this.routingAddress;
        }

        @Override
        @RosettaAttribute(value="routingAccountNumber")
        @RuneAttribute(value="routingAccountNumber")
        public String getRoutingAccountNumber() {
            return this.routingAccountNumber;
        }

        @Override
        @RosettaAttribute(value="routingReferenceText")
        @RuneAttribute(value="routingReferenceText")
        public List<String> getRoutingReferenceText() {
            return this.routingReferenceText;
        }

        @Override
        public RoutingExplicitDetailsModel build() {
            return this;
        }

        @Override
        public RoutingExplicitDetailsModelBuilder toBuilder() {
            RoutingExplicitDetailsModelBuilder builder = RoutingExplicitDetailsModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RoutingExplicitDetailsModelBuilder builder) {
            Optional.ofNullable(this.getRoutingName()).ifPresent(builder::setRoutingName);
            Optional.ofNullable(this.getRoutingAddress()).ifPresent(builder::setRoutingAddress);
            Optional.ofNullable(this.getRoutingAccountNumber()).ifPresent(builder::setRoutingAccountNumber);
            Optional.ofNullable(this.getRoutingReferenceText()).ifPresent(builder::setRoutingReferenceText);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RoutingExplicitDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.routingName, _that.getRoutingName())) {
                return false;
            }
            if (!Objects.equals(this.routingAddress, _that.getRoutingAddress())) {
                return false;
            }
            if (!Objects.equals(this.routingAccountNumber, _that.getRoutingAccountNumber())) {
                return false;
            }
            return ListEquals.listEquals(this.routingReferenceText, _that.getRoutingReferenceText());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.routingName != null ? this.routingName.hashCode() : 0);
            _result = 31 * _result + (this.routingAddress != null ? this.routingAddress.hashCode() : 0);
            _result = 31 * _result + (this.routingAccountNumber != null ? this.routingAccountNumber.hashCode() : 0);
            _result = 31 * _result + (this.routingReferenceText != null ? this.routingReferenceText.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RoutingExplicitDetailsModel {routingName=" + this.routingName + ", routingAddress=" + String.valueOf(this.routingAddress) + ", routingAccountNumber=" + this.routingAccountNumber + ", routingReferenceText=" + String.valueOf(this.routingReferenceText) + "}";
        }
    }
}

