/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.NonNegativeStep;
import fpml.consolidated.shared.meta.NonNegativeScheduleMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="NonNegativeSchedule", builder=NonNegativeScheduleBuilderImpl.class, version="1.2.2")
@RuneDataType(value="NonNegativeSchedule", model="fpml", builder=NonNegativeScheduleBuilderImpl.class, version="1.2.2")
public interface NonNegativeSchedule
extends RosettaModelObject {
    public static final NonNegativeScheduleMeta metaData = new NonNegativeScheduleMeta();

    public BigDecimal getInitialValue();

    public List<? extends NonNegativeStep> getStep();

    public String getId();

    public NonNegativeSchedule build();

    public NonNegativeScheduleBuilder toBuilder();

    public static NonNegativeScheduleBuilder builder() {
        return new NonNegativeScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends NonNegativeSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonNegativeSchedule> getType() {
        return NonNegativeSchedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("step"), processor, NonNegativeStep.class, this.getStep(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class NonNegativeScheduleBuilderImpl
    implements NonNegativeScheduleBuilder {
        protected BigDecimal initialValue;
        protected List<NonNegativeStep.NonNegativeStepBuilder> step = new ArrayList<NonNegativeStep.NonNegativeStepBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public BigDecimal getInitialValue() {
            return this.initialValue;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public List<? extends NonNegativeStep.NonNegativeStepBuilder> getStep() {
            return this.step;
        }

        @Override
        public NonNegativeStep.NonNegativeStepBuilder getOrCreateStep(int index) {
            if (this.step == null) {
                this.step = new ArrayList<NonNegativeStep.NonNegativeStepBuilder>();
            }
            return (NonNegativeStep.NonNegativeStepBuilder)this.getIndex(this.step, index, () -> {
                NonNegativeStep.NonNegativeStepBuilder newStep = NonNegativeStep.builder();
                return newStep;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public NonNegativeScheduleBuilder setInitialValue(BigDecimal _initialValue) {
            this.initialValue = _initialValue == null ? null : _initialValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public NonNegativeScheduleBuilder addStep(NonNegativeStep _step) {
            if (_step != null) {
                this.step.add(_step.toBuilder());
            }
            return this;
        }

        @Override
        public NonNegativeScheduleBuilder addStep(NonNegativeStep _step, int idx) {
            this.getIndex(this.step, idx, () -> _step.toBuilder());
            return this;
        }

        @Override
        public NonNegativeScheduleBuilder addStep(List<? extends NonNegativeStep> steps) {
            if (steps != null) {
                for (NonNegativeStep nonNegativeStep : steps) {
                    this.step.add(nonNegativeStep.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="step")
        public NonNegativeScheduleBuilder setStep(List<? extends NonNegativeStep> steps) {
            this.step = steps == null ? new ArrayList<NonNegativeStep.NonNegativeStepBuilder>() : (List)steps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public NonNegativeScheduleBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public NonNegativeSchedule build() {
            return new NonNegativeScheduleImpl(this);
        }

        @Override
        public NonNegativeScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public NonNegativeScheduleBuilder prune() {
            this.step = this.step.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getInitialValue() != null) {
                return true;
            }
            if (this.getStep() != null && this.getStep().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public NonNegativeScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NonNegativeScheduleBuilder o = (NonNegativeScheduleBuilder)other;
            merger.mergeRosetta(this.getStep(), o.getStep(), this::getOrCreateStep);
            merger.mergeBasic((Object)this.getInitialValue(), (Object)o.getInitialValue(), this::setInitialValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonNegativeSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.initialValue, _that.getInitialValue())) {
                return false;
            }
            if (!ListEquals.listEquals(this.step, _that.getStep())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialValue != null ? this.initialValue.hashCode() : 0);
            _result = 31 * _result + (this.step != null ? this.step.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonNegativeScheduleBuilder {initialValue=" + String.valueOf(this.initialValue) + ", step=" + String.valueOf(this.step) + ", id=" + this.id + "}";
        }
    }

    public static interface NonNegativeScheduleBuilder
    extends NonNegativeSchedule,
    RosettaModelObjectBuilder {
        public NonNegativeStep.NonNegativeStepBuilder getOrCreateStep(int var1);

        public List<? extends NonNegativeStep.NonNegativeStepBuilder> getStep();

        public NonNegativeScheduleBuilder setInitialValue(BigDecimal var1);

        public NonNegativeScheduleBuilder addStep(NonNegativeStep var1);

        public NonNegativeScheduleBuilder addStep(NonNegativeStep var1, int var2);

        public NonNegativeScheduleBuilder addStep(List<? extends NonNegativeStep> var1);

        public NonNegativeScheduleBuilder setStep(List<? extends NonNegativeStep> var1);

        public NonNegativeScheduleBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("step"), processor, NonNegativeStep.NonNegativeStepBuilder.class, this.getStep(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public NonNegativeScheduleBuilder prune();
    }

    public static class NonNegativeScheduleImpl
    implements NonNegativeSchedule {
        private final BigDecimal initialValue;
        private final List<? extends NonNegativeStep> step;
        private final String id;

        protected NonNegativeScheduleImpl(NonNegativeScheduleBuilder builder) {
            this.initialValue = builder.getInitialValue();
            this.step = Optional.ofNullable(builder.getStep()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public BigDecimal getInitialValue() {
            return this.initialValue;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public List<? extends NonNegativeStep> getStep() {
            return this.step;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public NonNegativeSchedule build() {
            return this;
        }

        @Override
        public NonNegativeScheduleBuilder toBuilder() {
            NonNegativeScheduleBuilder builder = NonNegativeSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonNegativeScheduleBuilder builder) {
            Optional.ofNullable(this.getInitialValue()).ifPresent(builder::setInitialValue);
            Optional.ofNullable(this.getStep()).ifPresent(builder::setStep);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonNegativeSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.initialValue, _that.getInitialValue())) {
                return false;
            }
            if (!ListEquals.listEquals(this.step, _that.getStep())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialValue != null ? this.initialValue.hashCode() : 0);
            _result = 31 * _result + (this.step != null ? this.step.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonNegativeSchedule {initialValue=" + String.valueOf(this.initialValue) + ", step=" + String.valueOf(this.step) + ", id=" + this.id + "}";
        }
    }
}

