/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.AveragingMethodEnum;
import fpml.consolidated.fpmlenum.NegativeInterestRateTreatmentEnum;
import fpml.consolidated.shared.Rounding;
import fpml.consolidated.shared.meta.FloatingRateCalculationModelMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FloatingRateCalculationModel", builder=FloatingRateCalculationModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FloatingRateCalculationModel", model="fpml", builder=FloatingRateCalculationModelBuilderImpl.class, version="1.2.2")
public interface FloatingRateCalculationModel
extends RosettaModelObject {
    public static final FloatingRateCalculationModelMeta metaData = new FloatingRateCalculationModelMeta();

    public BigDecimal getInitialRate();

    public Rounding getFinalRateRounding();

    public AveragingMethodEnum getAveragingMethod();

    public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment();

    public FloatingRateCalculationModel build();

    public FloatingRateCalculationModelBuilder toBuilder();

    public static FloatingRateCalculationModelBuilder builder() {
        return new FloatingRateCalculationModelBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateCalculationModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateCalculationModel> getType() {
        return FloatingRateCalculationModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("initialRate"), BigDecimal.class, (Object)this.getInitialRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.class, this.getFinalRateRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FloatingRateCalculationModelBuilderImpl
    implements FloatingRateCalculationModelBuilder {
        protected BigDecimal initialRate;
        protected Rounding.RoundingBuilder finalRateRounding;
        protected AveragingMethodEnum averagingMethod;
        protected NegativeInterestRateTreatmentEnum negativeInterestRateTreatment;

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public BigDecimal getInitialRate() {
            return this.initialRate;
        }

        @Override
        @RosettaAttribute(value="finalRateRounding")
        @RuneAttribute(value="finalRateRounding")
        public Rounding.RoundingBuilder getFinalRateRounding() {
            return this.finalRateRounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateFinalRateRounding() {
            Rounding.RoundingBuilder result = this.finalRateRounding != null ? this.finalRateRounding : (this.finalRateRounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRateTreatment")
        @RuneAttribute(value="negativeInterestRateTreatment")
        public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment() {
            return this.negativeInterestRateTreatment;
        }

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public FloatingRateCalculationModelBuilder setInitialRate(BigDecimal _initialRate) {
            this.initialRate = _initialRate == null ? null : _initialRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalRateRounding")
        @RuneAttribute(value="finalRateRounding")
        public FloatingRateCalculationModelBuilder setFinalRateRounding(Rounding _finalRateRounding) {
            this.finalRateRounding = _finalRateRounding == null ? null : _finalRateRounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public FloatingRateCalculationModelBuilder setAveragingMethod(AveragingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRateTreatment")
        @RuneAttribute(value="negativeInterestRateTreatment")
        public FloatingRateCalculationModelBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum _negativeInterestRateTreatment) {
            this.negativeInterestRateTreatment = _negativeInterestRateTreatment == null ? null : _negativeInterestRateTreatment;
            return this;
        }

        @Override
        public FloatingRateCalculationModel build() {
            return new FloatingRateCalculationModelImpl(this);
        }

        @Override
        public FloatingRateCalculationModelBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateCalculationModelBuilder prune() {
            if (this.finalRateRounding != null && !this.finalRateRounding.prune().hasData()) {
                this.finalRateRounding = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInitialRate() != null) {
                return true;
            }
            if (this.getFinalRateRounding() != null && this.getFinalRateRounding().hasData()) {
                return true;
            }
            if (this.getAveragingMethod() != null) {
                return true;
            }
            return this.getNegativeInterestRateTreatment() != null;
        }

        public FloatingRateCalculationModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateCalculationModelBuilder o = (FloatingRateCalculationModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalRateRounding(), (RosettaModelObjectBuilder)o.getFinalRateRounding(), this::setFinalRateRounding);
            merger.mergeBasic((Object)this.getInitialRate(), (Object)o.getInitialRate(), this::setInitialRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAveragingMethod(), (Object)o.getAveragingMethod(), this::setAveragingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNegativeInterestRateTreatment(), (Object)o.getNegativeInterestRateTreatment(), this::setNegativeInterestRateTreatment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateCalculationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            if (!Objects.equals(this.finalRateRounding, _that.getFinalRateRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals((Object)this.negativeInterestRateTreatment, (Object)_that.getNegativeInterestRateTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.finalRateRounding != null ? this.finalRateRounding.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRateTreatment != null ? ((Object)((Object)this.negativeInterestRateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateCalculationModelBuilder {initialRate=" + String.valueOf(this.initialRate) + ", finalRateRounding=" + String.valueOf(this.finalRateRounding) + ", averagingMethod=" + String.valueOf((Object)this.averagingMethod) + ", negativeInterestRateTreatment=" + String.valueOf((Object)this.negativeInterestRateTreatment) + "}";
        }
    }

    public static interface FloatingRateCalculationModelBuilder
    extends FloatingRateCalculationModel,
    RosettaModelObjectBuilder {
        public Rounding.RoundingBuilder getOrCreateFinalRateRounding();

        @Override
        public Rounding.RoundingBuilder getFinalRateRounding();

        public FloatingRateCalculationModelBuilder setInitialRate(BigDecimal var1);

        public FloatingRateCalculationModelBuilder setFinalRateRounding(Rounding var1);

        public FloatingRateCalculationModelBuilder setAveragingMethod(AveragingMethodEnum var1);

        public FloatingRateCalculationModelBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("initialRate"), BigDecimal.class, (Object)this.getInitialRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.RoundingBuilder.class, this.getFinalRateRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FloatingRateCalculationModelBuilder prune();
    }

    public static class FloatingRateCalculationModelImpl
    implements FloatingRateCalculationModel {
        private final BigDecimal initialRate;
        private final Rounding finalRateRounding;
        private final AveragingMethodEnum averagingMethod;
        private final NegativeInterestRateTreatmentEnum negativeInterestRateTreatment;

        protected FloatingRateCalculationModelImpl(FloatingRateCalculationModelBuilder builder) {
            this.initialRate = builder.getInitialRate();
            this.finalRateRounding = Optional.ofNullable(builder.getFinalRateRounding()).map(f -> f.build()).orElse(null);
            this.averagingMethod = builder.getAveragingMethod();
            this.negativeInterestRateTreatment = builder.getNegativeInterestRateTreatment();
        }

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public BigDecimal getInitialRate() {
            return this.initialRate;
        }

        @Override
        @RosettaAttribute(value="finalRateRounding")
        @RuneAttribute(value="finalRateRounding")
        public Rounding getFinalRateRounding() {
            return this.finalRateRounding;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRateTreatment")
        @RuneAttribute(value="negativeInterestRateTreatment")
        public NegativeInterestRateTreatmentEnum getNegativeInterestRateTreatment() {
            return this.negativeInterestRateTreatment;
        }

        @Override
        public FloatingRateCalculationModel build() {
            return this;
        }

        @Override
        public FloatingRateCalculationModelBuilder toBuilder() {
            FloatingRateCalculationModelBuilder builder = FloatingRateCalculationModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateCalculationModelBuilder builder) {
            Optional.ofNullable(this.getInitialRate()).ifPresent(builder::setInitialRate);
            Optional.ofNullable(this.getFinalRateRounding()).ifPresent(builder::setFinalRateRounding);
            Optional.ofNullable(this.getAveragingMethod()).ifPresent(builder::setAveragingMethod);
            Optional.ofNullable(this.getNegativeInterestRateTreatment()).ifPresent(builder::setNegativeInterestRateTreatment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateCalculationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.initialRate, _that.getInitialRate())) {
                return false;
            }
            if (!Objects.equals(this.finalRateRounding, _that.getFinalRateRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals((Object)this.negativeInterestRateTreatment, (Object)_that.getNegativeInterestRateTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialRate != null ? this.initialRate.hashCode() : 0);
            _result = 31 * _result + (this.finalRateRounding != null ? this.finalRateRounding.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.negativeInterestRateTreatment != null ? ((Object)((Object)this.negativeInterestRateTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateCalculationModel {initialRate=" + String.valueOf(this.initialRate) + ", finalRateRounding=" + String.valueOf(this.finalRateRounding) + ", averagingMethod=" + String.valueOf((Object)this.averagingMethod) + ", negativeInterestRateTreatment=" + String.valueOf((Object)this.negativeInterestRateTreatment) + "}";
        }
    }
}

