/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.riskdef.meta.TimeDimensionSequenceMeta;
import fpml.consolidated.shared.Period;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="TimeDimensionSequence", builder=TimeDimensionSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TimeDimensionSequence", model="fpml", builder=TimeDimensionSequenceBuilderImpl.class, version="1.2.2")
public interface TimeDimensionSequence
extends RosettaModelObject {
    public static final TimeDimensionSequenceMeta metaData = new TimeDimensionSequenceMeta();

    public ZonedDateTime getDate();

    public Period getTenor();

    public TimeDimensionSequence build();

    public TimeDimensionSequenceBuilder toBuilder();

    public static TimeDimensionSequenceBuilder builder() {
        return new TimeDimensionSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends TimeDimensionSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TimeDimensionSequence> getType() {
        return TimeDimensionSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tenor"), processor, Period.class, this.getTenor(), new AttributeMeta[0]);
    }

    public static class TimeDimensionSequenceBuilderImpl
    implements TimeDimensionSequenceBuilder {
        protected ZonedDateTime date;
        protected Period.PeriodBuilder tenor;

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="tenor")
        @RuneAttribute(value="tenor")
        public Period.PeriodBuilder getTenor() {
            return this.tenor;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTenor() {
            Period.PeriodBuilder result = this.tenor != null ? this.tenor : (this.tenor = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public TimeDimensionSequenceBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        @RosettaAttribute(value="tenor")
        @RuneAttribute(value="tenor")
        public TimeDimensionSequenceBuilder setTenor(Period _tenor) {
            this.tenor = _tenor == null ? null : _tenor.toBuilder();
            return this;
        }

        @Override
        public TimeDimensionSequence build() {
            return new TimeDimensionSequenceImpl(this);
        }

        @Override
        public TimeDimensionSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public TimeDimensionSequenceBuilder prune() {
            if (this.tenor != null && !this.tenor.prune().hasData()) {
                this.tenor = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDate() != null) {
                return true;
            }
            return this.getTenor() != null && this.getTenor().hasData();
        }

        public TimeDimensionSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TimeDimensionSequenceBuilder o = (TimeDimensionSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTenor(), (RosettaModelObjectBuilder)o.getTenor(), this::setTenor);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TimeDimensionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            return Objects.equals(this.tenor, _that.getTenor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.tenor != null ? this.tenor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TimeDimensionSequenceBuilder {date=" + String.valueOf(this.date) + ", tenor=" + String.valueOf(this.tenor) + "}";
        }
    }

    public static interface TimeDimensionSequenceBuilder
    extends TimeDimensionSequence,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateTenor();

        @Override
        public Period.PeriodBuilder getTenor();

        public TimeDimensionSequenceBuilder setDate(ZonedDateTime var1);

        public TimeDimensionSequenceBuilder setTenor(Period var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tenor"), processor, Period.PeriodBuilder.class, this.getTenor(), new AttributeMeta[0]);
        }

        public TimeDimensionSequenceBuilder prune();
    }

    public static class TimeDimensionSequenceImpl
    implements TimeDimensionSequence {
        private final ZonedDateTime date;
        private final Period tenor;

        protected TimeDimensionSequenceImpl(TimeDimensionSequenceBuilder builder) {
            this.date = builder.getDate();
            this.tenor = Optional.ofNullable(builder.getTenor()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="tenor")
        @RuneAttribute(value="tenor")
        public Period getTenor() {
            return this.tenor;
        }

        @Override
        public TimeDimensionSequence build() {
            return this;
        }

        @Override
        public TimeDimensionSequenceBuilder toBuilder() {
            TimeDimensionSequenceBuilder builder = TimeDimensionSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TimeDimensionSequenceBuilder builder) {
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getTenor()).ifPresent(builder::setTenor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TimeDimensionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            return Objects.equals(this.tenor, _that.getTenor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.tenor != null ? this.tenor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TimeDimensionSequence {date=" + String.valueOf(this.date) + ", tenor=" + String.valueOf(this.tenor) + "}";
        }
    }
}

