/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.repo;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.repo.RepoLegBase;
import fpml.consolidated.repo.RepoNearLegSequence;
import fpml.consolidated.repo.meta.RepoNearLegMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.FxRate;
import fpml.consolidated.shared.Money;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RepoNearLeg", builder=RepoNearLegBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RepoNearLeg", model="fpml", builder=RepoNearLegBuilderImpl.class, version="1.2.2")
public interface RepoNearLeg
extends RepoLegBase {
    public static final RepoNearLegMeta metaData = new RepoNearLegMeta();

    public Money getSettlementAmount();

    public FxRate getFxRate();

    public RepoNearLegSequence getRepoNearLegSequence();

    @Override
    public RepoNearLeg build();

    @Override
    public RepoNearLegBuilder toBuilder();

    public static RepoNearLegBuilder builder() {
        return new RepoNearLegBuilderImpl();
    }

    default public RosettaMetaData<? extends RepoNearLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RepoNearLeg> getType() {
        return RepoNearLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementAmount"), processor, Money.class, this.getSettlementAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.class, this.getFxRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("repoNearLegSequence"), processor, RepoNearLegSequence.class, this.getRepoNearLegSequence(), new AttributeMeta[0]);
    }

    public static class RepoNearLegBuilderImpl
    extends RepoLegBase.RepoLegBaseBuilderImpl
    implements RepoNearLegBuilder {
        protected Money.MoneyBuilder settlementAmount;
        protected FxRate.FxRateBuilder fxRate;
        protected RepoNearLegSequence.RepoNearLegSequenceBuilder repoNearLegSequence;

        @Override
        @RosettaAttribute(value="settlementAmount", isRequired=true)
        @RuneAttribute(value="settlementAmount", isRequired=true)
        public Money.MoneyBuilder getSettlementAmount() {
            return this.settlementAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateSettlementAmount() {
            Money.MoneyBuilder result = this.settlementAmount != null ? this.settlementAmount : (this.settlementAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public FxRate.FxRateBuilder getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxRate.FxRateBuilder getOrCreateFxRate() {
            FxRate.FxRateBuilder result = this.fxRate != null ? this.fxRate : (this.fxRate = FxRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="repoNearLegSequence")
        @RuneAttribute(value="repoNearLegSequence")
        public RepoNearLegSequence.RepoNearLegSequenceBuilder getRepoNearLegSequence() {
            return this.repoNearLegSequence;
        }

        @Override
        public RepoNearLegSequence.RepoNearLegSequenceBuilder getOrCreateRepoNearLegSequence() {
            RepoNearLegSequence.RepoNearLegSequenceBuilder result = this.repoNearLegSequence != null ? this.repoNearLegSequence : (this.repoNearLegSequence = RepoNearLegSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public RepoNearLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public RepoNearLegBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public RepoNearLegBuilder setSettlementDate(AdjustableOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementAmount", isRequired=true)
        @RuneAttribute(value="settlementAmount", isRequired=true)
        public RepoNearLegBuilder setSettlementAmount(Money _settlementAmount) {
            this.settlementAmount = _settlementAmount == null ? null : _settlementAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public RepoNearLegBuilder setFxRate(FxRate _fxRate) {
            this.fxRate = _fxRate == null ? null : _fxRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="repoNearLegSequence")
        @RuneAttribute(value="repoNearLegSequence")
        public RepoNearLegBuilder setRepoNearLegSequence(RepoNearLegSequence _repoNearLegSequence) {
            this.repoNearLegSequence = _repoNearLegSequence == null ? null : _repoNearLegSequence.toBuilder();
            return this;
        }

        @Override
        public RepoNearLeg build() {
            return new RepoNearLegImpl(this);
        }

        @Override
        public RepoNearLegBuilder toBuilder() {
            return this;
        }

        @Override
        public RepoNearLegBuilder prune() {
            super.prune();
            if (this.settlementAmount != null && !this.settlementAmount.prune().hasData()) {
                this.settlementAmount = null;
            }
            if (this.fxRate != null && !this.fxRate.prune().hasData()) {
                this.fxRate = null;
            }
            if (this.repoNearLegSequence != null && !this.repoNearLegSequence.prune().hasData()) {
                this.repoNearLegSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSettlementAmount() != null && this.getSettlementAmount().hasData()) {
                return true;
            }
            if (this.getFxRate() != null && this.getFxRate().hasData()) {
                return true;
            }
            return this.getRepoNearLegSequence() != null && this.getRepoNearLegSequence().hasData();
        }

        @Override
        public RepoNearLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RepoNearLegBuilder o = (RepoNearLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementAmount(), (RosettaModelObjectBuilder)o.getSettlementAmount(), this::setSettlementAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxRate(), (RosettaModelObjectBuilder)o.getFxRate(), this::setFxRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRepoNearLegSequence(), (RosettaModelObjectBuilder)o.getRepoNearLegSequence(), this::setRepoNearLegSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RepoNearLeg _that = (RepoNearLeg)this.getType().cast(o);
            if (!Objects.equals(this.settlementAmount, _that.getSettlementAmount())) {
                return false;
            }
            if (!Objects.equals(this.fxRate, _that.getFxRate())) {
                return false;
            }
            return Objects.equals(this.repoNearLegSequence, _that.getRepoNearLegSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementAmount != null ? this.settlementAmount.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            _result = 31 * _result + (this.repoNearLegSequence != null ? this.repoNearLegSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RepoNearLegBuilder {settlementAmount=" + String.valueOf(this.settlementAmount) + ", fxRate=" + String.valueOf(this.fxRate) + ", repoNearLegSequence=" + String.valueOf(this.repoNearLegSequence) + "} " + super.toString();
        }
    }

    public static interface RepoNearLegBuilder
    extends RepoNearLeg,
    RepoLegBase.RepoLegBaseBuilder {
        public Money.MoneyBuilder getOrCreateSettlementAmount();

        @Override
        public Money.MoneyBuilder getSettlementAmount();

        public FxRate.FxRateBuilder getOrCreateFxRate();

        @Override
        public FxRate.FxRateBuilder getFxRate();

        public RepoNearLegSequence.RepoNearLegSequenceBuilder getOrCreateRepoNearLegSequence();

        @Override
        public RepoNearLegSequence.RepoNearLegSequenceBuilder getRepoNearLegSequence();

        @Override
        public RepoNearLegBuilder setId(String var1);

        @Override
        public RepoNearLegBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public RepoNearLegBuilder setSettlementDate(AdjustableOrRelativeDate var1);

        public RepoNearLegBuilder setSettlementAmount(Money var1);

        public RepoNearLegBuilder setFxRate(FxRate var1);

        public RepoNearLegBuilder setRepoNearLegSequence(RepoNearLegSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementAmount"), processor, Money.MoneyBuilder.class, this.getSettlementAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.FxRateBuilder.class, this.getFxRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("repoNearLegSequence"), processor, RepoNearLegSequence.RepoNearLegSequenceBuilder.class, this.getRepoNearLegSequence(), new AttributeMeta[0]);
        }

        @Override
        public RepoNearLegBuilder prune();
    }

    public static class RepoNearLegImpl
    extends RepoLegBase.RepoLegBaseImpl
    implements RepoNearLeg {
        private final Money settlementAmount;
        private final FxRate fxRate;
        private final RepoNearLegSequence repoNearLegSequence;

        protected RepoNearLegImpl(RepoNearLegBuilder builder) {
            super(builder);
            this.settlementAmount = Optional.ofNullable(builder.getSettlementAmount()).map(f -> f.build()).orElse(null);
            this.fxRate = Optional.ofNullable(builder.getFxRate()).map(f -> f.build()).orElse(null);
            this.repoNearLegSequence = Optional.ofNullable(builder.getRepoNearLegSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementAmount", isRequired=true)
        @RuneAttribute(value="settlementAmount", isRequired=true)
        public Money getSettlementAmount() {
            return this.settlementAmount;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public FxRate getFxRate() {
            return this.fxRate;
        }

        @Override
        @RosettaAttribute(value="repoNearLegSequence")
        @RuneAttribute(value="repoNearLegSequence")
        public RepoNearLegSequence getRepoNearLegSequence() {
            return this.repoNearLegSequence;
        }

        @Override
        public RepoNearLeg build() {
            return this;
        }

        @Override
        public RepoNearLegBuilder toBuilder() {
            RepoNearLegBuilder builder = RepoNearLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepoNearLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSettlementAmount()).ifPresent(builder::setSettlementAmount);
            Optional.ofNullable(this.getFxRate()).ifPresent(builder::setFxRate);
            Optional.ofNullable(this.getRepoNearLegSequence()).ifPresent(builder::setRepoNearLegSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RepoNearLeg _that = (RepoNearLeg)this.getType().cast(o);
            if (!Objects.equals(this.settlementAmount, _that.getSettlementAmount())) {
                return false;
            }
            if (!Objects.equals(this.fxRate, _that.getFxRate())) {
                return false;
            }
            return Objects.equals(this.repoNearLegSequence, _that.getRepoNearLegSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementAmount != null ? this.settlementAmount.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            _result = 31 * _result + (this.repoNearLegSequence != null ? this.repoNearLegSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RepoNearLeg {settlementAmount=" + String.valueOf(this.settlementAmount) + ", fxRate=" + String.valueOf(this.fxRate) + ", repoNearLegSequence=" + String.valueOf(this.repoNearLegSequence) + "} " + super.toString();
        }
    }
}

