/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.repo;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.BondEquityModel;
import fpml.consolidated.asset.GenericSecurity;
import fpml.consolidated.repo.CollateralArrangement;
import fpml.consolidated.repo.InitialMargin;
import fpml.consolidated.repo.RateCalculationModel;
import fpml.consolidated.repo.RepoFarLeg;
import fpml.consolidated.repo.RepoNearLeg;
import fpml.consolidated.repo.RepoSequence0;
import fpml.consolidated.repo.RepoSequence1;
import fpml.consolidated.repo.TriParty;
import fpml.consolidated.repo.meta.RepoMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Frequency;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Repo", builder=RepoBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Repo", model="fpml", builder=RepoBuilderImpl.class, version="1.2.2")
public interface Repo
extends Product {
    public static final RepoMeta metaData = new RepoMeta();

    public RateCalculationModel getRateCalculationModel();

    public DayCountFraction getDayCountFraction();

    public RepoSequence0 getRepoSequence0();

    public RepoSequence1 getRepoSequence1();

    public InitialMargin getInitialMargin();

    public RepoNearLeg getNearLeg();

    public RepoFarLeg getFarLeg();

    public Frequency getPaymentFrequency();

    public List<? extends BondEquityModel> getBondEquityModel();

    public GenericSecurity getSecurity();

    public TriParty getTriParty();

    public Boolean getGeneralCollateral();

    public CollateralArrangement getCollateralArrangement();

    public Boolean getEligibleForRehypothecation();

    @Override
    public Repo build();

    @Override
    public RepoBuilder toBuilder();

    public static RepoBuilder builder() {
        return new RepoBuilderImpl();
    }

    default public RosettaMetaData<? extends Repo> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Repo> getType() {
        return Repo.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateCalculationModel"), processor, RateCalculationModel.class, this.getRateCalculationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("repoSequence0"), processor, RepoSequence0.class, this.getRepoSequence0(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("repoSequence1"), processor, RepoSequence1.class, this.getRepoSequence1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialMargin"), processor, InitialMargin.class, this.getInitialMargin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nearLeg"), processor, RepoNearLeg.class, this.getNearLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("farLeg"), processor, RepoFarLeg.class, this.getFarLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondEquityModel"), processor, BondEquityModel.class, this.getBondEquityModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("security"), processor, GenericSecurity.class, this.getSecurity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("triParty"), processor, TriParty.class, this.getTriParty(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("generalCollateral"), Boolean.class, (Object)this.getGeneralCollateral(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralArrangement"), processor, CollateralArrangement.class, this.getCollateralArrangement(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eligibleForRehypothecation"), Boolean.class, (Object)this.getEligibleForRehypothecation(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RepoBuilderImpl
    extends Product.ProductBuilderImpl
    implements RepoBuilder {
        protected RateCalculationModel.RateCalculationModelBuilder rateCalculationModel;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected RepoSequence0.RepoSequence0Builder repoSequence0;
        protected RepoSequence1.RepoSequence1Builder repoSequence1;
        protected InitialMargin.InitialMarginBuilder initialMargin;
        protected RepoNearLeg.RepoNearLegBuilder nearLeg;
        protected RepoFarLeg.RepoFarLegBuilder farLeg;
        protected Frequency.FrequencyBuilder paymentFrequency;
        protected List<BondEquityModel.BondEquityModelBuilder> bondEquityModel = new ArrayList<BondEquityModel.BondEquityModelBuilder>();
        protected GenericSecurity.GenericSecurityBuilder security;
        protected TriParty.TriPartyBuilder triParty;
        protected Boolean generalCollateral;
        protected CollateralArrangement.CollateralArrangementBuilder collateralArrangement;
        protected Boolean eligibleForRehypothecation;

        @Override
        @RosettaAttribute(value="rateCalculationModel", isRequired=true)
        @RuneAttribute(value="rateCalculationModel", isRequired=true)
        public RateCalculationModel.RateCalculationModelBuilder getRateCalculationModel() {
            return this.rateCalculationModel;
        }

        @Override
        public RateCalculationModel.RateCalculationModelBuilder getOrCreateRateCalculationModel() {
            RateCalculationModel.RateCalculationModelBuilder result = this.rateCalculationModel != null ? this.rateCalculationModel : (this.rateCalculationModel = RateCalculationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="repoSequence0")
        @RuneAttribute(value="repoSequence0")
        public RepoSequence0.RepoSequence0Builder getRepoSequence0() {
            return this.repoSequence0;
        }

        @Override
        public RepoSequence0.RepoSequence0Builder getOrCreateRepoSequence0() {
            RepoSequence0.RepoSequence0Builder result = this.repoSequence0 != null ? this.repoSequence0 : (this.repoSequence0 = RepoSequence0.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="repoSequence1")
        @RuneAttribute(value="repoSequence1")
        public RepoSequence1.RepoSequence1Builder getRepoSequence1() {
            return this.repoSequence1;
        }

        @Override
        public RepoSequence1.RepoSequence1Builder getOrCreateRepoSequence1() {
            RepoSequence1.RepoSequence1Builder result = this.repoSequence1 != null ? this.repoSequence1 : (this.repoSequence1 = RepoSequence1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialMargin")
        @RuneAttribute(value="initialMargin")
        public InitialMargin.InitialMarginBuilder getInitialMargin() {
            return this.initialMargin;
        }

        @Override
        public InitialMargin.InitialMarginBuilder getOrCreateInitialMargin() {
            InitialMargin.InitialMarginBuilder result = this.initialMargin != null ? this.initialMargin : (this.initialMargin = InitialMargin.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nearLeg", isRequired=true)
        @RuneAttribute(value="nearLeg", isRequired=true)
        public RepoNearLeg.RepoNearLegBuilder getNearLeg() {
            return this.nearLeg;
        }

        @Override
        public RepoNearLeg.RepoNearLegBuilder getOrCreateNearLeg() {
            RepoNearLeg.RepoNearLegBuilder result = this.nearLeg != null ? this.nearLeg : (this.nearLeg = RepoNearLeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="farLeg")
        @RuneAttribute(value="farLeg")
        public RepoFarLeg.RepoFarLegBuilder getFarLeg() {
            return this.farLeg;
        }

        @Override
        public RepoFarLeg.RepoFarLegBuilder getOrCreateFarLeg() {
            RepoFarLeg.RepoFarLegBuilder result = this.farLeg != null ? this.farLeg : (this.farLeg = RepoFarLeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Frequency.FrequencyBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency() {
            Frequency.FrequencyBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Frequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bondEquityModel")
        @RuneAttribute(value="bondEquityModel")
        public List<? extends BondEquityModel.BondEquityModelBuilder> getBondEquityModel() {
            return this.bondEquityModel;
        }

        @Override
        public BondEquityModel.BondEquityModelBuilder getOrCreateBondEquityModel(int index) {
            if (this.bondEquityModel == null) {
                this.bondEquityModel = new ArrayList<BondEquityModel.BondEquityModelBuilder>();
            }
            return (BondEquityModel.BondEquityModelBuilder)this.getIndex(this.bondEquityModel, index, () -> {
                BondEquityModel.BondEquityModelBuilder newBondEquityModel = BondEquityModel.builder();
                return newBondEquityModel;
            });
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public GenericSecurity.GenericSecurityBuilder getSecurity() {
            return this.security;
        }

        @Override
        public GenericSecurity.GenericSecurityBuilder getOrCreateSecurity() {
            GenericSecurity.GenericSecurityBuilder result = this.security != null ? this.security : (this.security = GenericSecurity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="triParty")
        @RuneAttribute(value="triParty")
        public TriParty.TriPartyBuilder getTriParty() {
            return this.triParty;
        }

        @Override
        public TriParty.TriPartyBuilder getOrCreateTriParty() {
            TriParty.TriPartyBuilder result = this.triParty != null ? this.triParty : (this.triParty = TriParty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="generalCollateral")
        @RuneAttribute(value="generalCollateral")
        public Boolean getGeneralCollateral() {
            return this.generalCollateral;
        }

        @Override
        @RosettaAttribute(value="collateralArrangement")
        @RuneAttribute(value="collateralArrangement")
        public CollateralArrangement.CollateralArrangementBuilder getCollateralArrangement() {
            return this.collateralArrangement;
        }

        @Override
        public CollateralArrangement.CollateralArrangementBuilder getOrCreateCollateralArrangement() {
            CollateralArrangement.CollateralArrangementBuilder result = this.collateralArrangement != null ? this.collateralArrangement : (this.collateralArrangement = CollateralArrangement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eligibleForRehypothecation")
        @RuneAttribute(value="eligibleForRehypothecation")
        public Boolean getEligibleForRehypothecation() {
            return this.eligibleForRehypothecation;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public RepoBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public RepoBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="rateCalculationModel", isRequired=true)
        @RuneAttribute(value="rateCalculationModel", isRequired=true)
        public RepoBuilder setRateCalculationModel(RateCalculationModel _rateCalculationModel) {
            this.rateCalculationModel = _rateCalculationModel == null ? null : _rateCalculationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public RepoBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="repoSequence0")
        @RuneAttribute(value="repoSequence0")
        public RepoBuilder setRepoSequence0(RepoSequence0 _repoSequence0) {
            this.repoSequence0 = _repoSequence0 == null ? null : _repoSequence0.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="repoSequence1")
        @RuneAttribute(value="repoSequence1")
        public RepoBuilder setRepoSequence1(RepoSequence1 _repoSequence1) {
            this.repoSequence1 = _repoSequence1 == null ? null : _repoSequence1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMargin")
        @RuneAttribute(value="initialMargin")
        public RepoBuilder setInitialMargin(InitialMargin _initialMargin) {
            this.initialMargin = _initialMargin == null ? null : _initialMargin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nearLeg", isRequired=true)
        @RuneAttribute(value="nearLeg", isRequired=true)
        public RepoBuilder setNearLeg(RepoNearLeg _nearLeg) {
            this.nearLeg = _nearLeg == null ? null : _nearLeg.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="farLeg")
        @RuneAttribute(value="farLeg")
        public RepoBuilder setFarLeg(RepoFarLeg _farLeg) {
            this.farLeg = _farLeg == null ? null : _farLeg.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public RepoBuilder setPaymentFrequency(Frequency _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bondEquityModel")
        @RuneAttribute(value="bondEquityModel")
        public RepoBuilder addBondEquityModel(BondEquityModel _bondEquityModel) {
            if (_bondEquityModel != null) {
                this.bondEquityModel.add(_bondEquityModel.toBuilder());
            }
            return this;
        }

        @Override
        public RepoBuilder addBondEquityModel(BondEquityModel _bondEquityModel, int idx) {
            this.getIndex(this.bondEquityModel, idx, () -> _bondEquityModel.toBuilder());
            return this;
        }

        @Override
        public RepoBuilder addBondEquityModel(List<? extends BondEquityModel> bondEquityModels) {
            if (bondEquityModels != null) {
                for (BondEquityModel bondEquityModel : bondEquityModels) {
                    this.bondEquityModel.add(bondEquityModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="bondEquityModel")
        public RepoBuilder setBondEquityModel(List<? extends BondEquityModel> bondEquityModels) {
            this.bondEquityModel = bondEquityModels == null ? new ArrayList<BondEquityModel.BondEquityModelBuilder>() : (List)bondEquityModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public RepoBuilder setSecurity(GenericSecurity _security) {
            this.security = _security == null ? null : _security.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triParty")
        @RuneAttribute(value="triParty")
        public RepoBuilder setTriParty(TriParty _triParty) {
            this.triParty = _triParty == null ? null : _triParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="generalCollateral")
        @RuneAttribute(value="generalCollateral")
        public RepoBuilder setGeneralCollateral(Boolean _generalCollateral) {
            this.generalCollateral = _generalCollateral == null ? null : _generalCollateral;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralArrangement")
        @RuneAttribute(value="collateralArrangement")
        public RepoBuilder setCollateralArrangement(CollateralArrangement _collateralArrangement) {
            this.collateralArrangement = _collateralArrangement == null ? null : _collateralArrangement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eligibleForRehypothecation")
        @RuneAttribute(value="eligibleForRehypothecation")
        public RepoBuilder setEligibleForRehypothecation(Boolean _eligibleForRehypothecation) {
            this.eligibleForRehypothecation = _eligibleForRehypothecation == null ? null : _eligibleForRehypothecation;
            return this;
        }

        @Override
        public Repo build() {
            return new RepoImpl(this);
        }

        @Override
        public RepoBuilder toBuilder() {
            return this;
        }

        @Override
        public RepoBuilder prune() {
            super.prune();
            if (this.rateCalculationModel != null && !this.rateCalculationModel.prune().hasData()) {
                this.rateCalculationModel = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.repoSequence0 != null && !this.repoSequence0.prune().hasData()) {
                this.repoSequence0 = null;
            }
            if (this.repoSequence1 != null && !this.repoSequence1.prune().hasData()) {
                this.repoSequence1 = null;
            }
            if (this.initialMargin != null && !this.initialMargin.prune().hasData()) {
                this.initialMargin = null;
            }
            if (this.nearLeg != null && !this.nearLeg.prune().hasData()) {
                this.nearLeg = null;
            }
            if (this.farLeg != null && !this.farLeg.prune().hasData()) {
                this.farLeg = null;
            }
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            this.bondEquityModel = this.bondEquityModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.security != null && !this.security.prune().hasData()) {
                this.security = null;
            }
            if (this.triParty != null && !this.triParty.prune().hasData()) {
                this.triParty = null;
            }
            if (this.collateralArrangement != null && !this.collateralArrangement.prune().hasData()) {
                this.collateralArrangement = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRateCalculationModel() != null && this.getRateCalculationModel().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getRepoSequence0() != null && this.getRepoSequence0().hasData()) {
                return true;
            }
            if (this.getRepoSequence1() != null && this.getRepoSequence1().hasData()) {
                return true;
            }
            if (this.getInitialMargin() != null && this.getInitialMargin().hasData()) {
                return true;
            }
            if (this.getNearLeg() != null && this.getNearLeg().hasData()) {
                return true;
            }
            if (this.getFarLeg() != null && this.getFarLeg().hasData()) {
                return true;
            }
            if (this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData()) {
                return true;
            }
            if (this.getBondEquityModel() != null && this.getBondEquityModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSecurity() != null && this.getSecurity().hasData()) {
                return true;
            }
            if (this.getTriParty() != null && this.getTriParty().hasData()) {
                return true;
            }
            if (this.getGeneralCollateral() != null) {
                return true;
            }
            if (this.getCollateralArrangement() != null && this.getCollateralArrangement().hasData()) {
                return true;
            }
            return this.getEligibleForRehypothecation() != null;
        }

        @Override
        public RepoBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RepoBuilder o = (RepoBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateCalculationModel(), (RosettaModelObjectBuilder)o.getRateCalculationModel(), this::setRateCalculationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRepoSequence0(), (RosettaModelObjectBuilder)o.getRepoSequence0(), this::setRepoSequence0);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRepoSequence1(), (RosettaModelObjectBuilder)o.getRepoSequence1(), this::setRepoSequence1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialMargin(), (RosettaModelObjectBuilder)o.getInitialMargin(), this::setInitialMargin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNearLeg(), (RosettaModelObjectBuilder)o.getNearLeg(), this::setNearLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFarLeg(), (RosettaModelObjectBuilder)o.getFarLeg(), this::setFarLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            merger.mergeRosetta(this.getBondEquityModel(), o.getBondEquityModel(), this::getOrCreateBondEquityModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurity(), (RosettaModelObjectBuilder)o.getSecurity(), this::setSecurity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTriParty(), (RosettaModelObjectBuilder)o.getTriParty(), this::setTriParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralArrangement(), (RosettaModelObjectBuilder)o.getCollateralArrangement(), this::setCollateralArrangement);
            merger.mergeBasic((Object)this.getGeneralCollateral(), (Object)o.getGeneralCollateral(), this::setGeneralCollateral, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEligibleForRehypothecation(), (Object)o.getEligibleForRehypothecation(), this::setEligibleForRehypothecation, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Repo _that = (Repo)this.getType().cast(o);
            if (!Objects.equals(this.rateCalculationModel, _that.getRateCalculationModel())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.repoSequence0, _that.getRepoSequence0())) {
                return false;
            }
            if (!Objects.equals(this.repoSequence1, _that.getRepoSequence1())) {
                return false;
            }
            if (!Objects.equals(this.initialMargin, _that.getInitialMargin())) {
                return false;
            }
            if (!Objects.equals(this.nearLeg, _that.getNearLeg())) {
                return false;
            }
            if (!Objects.equals(this.farLeg, _that.getFarLeg())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.bondEquityModel, _that.getBondEquityModel())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            if (!Objects.equals(this.triParty, _that.getTriParty())) {
                return false;
            }
            if (!Objects.equals(this.generalCollateral, _that.getGeneralCollateral())) {
                return false;
            }
            if (!Objects.equals(this.collateralArrangement, _that.getCollateralArrangement())) {
                return false;
            }
            return Objects.equals(this.eligibleForRehypothecation, _that.getEligibleForRehypothecation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rateCalculationModel != null ? this.rateCalculationModel.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.repoSequence0 != null ? this.repoSequence0.hashCode() : 0);
            _result = 31 * _result + (this.repoSequence1 != null ? this.repoSequence1.hashCode() : 0);
            _result = 31 * _result + (this.initialMargin != null ? this.initialMargin.hashCode() : 0);
            _result = 31 * _result + (this.nearLeg != null ? this.nearLeg.hashCode() : 0);
            _result = 31 * _result + (this.farLeg != null ? this.farLeg.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.bondEquityModel != null ? this.bondEquityModel.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.triParty != null ? this.triParty.hashCode() : 0);
            _result = 31 * _result + (this.generalCollateral != null ? this.generalCollateral.hashCode() : 0);
            _result = 31 * _result + (this.collateralArrangement != null ? this.collateralArrangement.hashCode() : 0);
            _result = 31 * _result + (this.eligibleForRehypothecation != null ? this.eligibleForRehypothecation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RepoBuilder {rateCalculationModel=" + String.valueOf(this.rateCalculationModel) + ", dayCountFraction=" + String.valueOf(this.dayCountFraction) + ", repoSequence0=" + String.valueOf(this.repoSequence0) + ", repoSequence1=" + String.valueOf(this.repoSequence1) + ", initialMargin=" + String.valueOf(this.initialMargin) + ", nearLeg=" + String.valueOf(this.nearLeg) + ", farLeg=" + String.valueOf(this.farLeg) + ", paymentFrequency=" + String.valueOf(this.paymentFrequency) + ", bondEquityModel=" + String.valueOf(this.bondEquityModel) + ", security=" + String.valueOf(this.security) + ", triParty=" + String.valueOf(this.triParty) + ", generalCollateral=" + this.generalCollateral + ", collateralArrangement=" + String.valueOf(this.collateralArrangement) + ", eligibleForRehypothecation=" + this.eligibleForRehypothecation + "} " + super.toString();
        }
    }

    public static interface RepoBuilder
    extends Repo,
    Product.ProductBuilder {
        public RateCalculationModel.RateCalculationModelBuilder getOrCreateRateCalculationModel();

        @Override
        public RateCalculationModel.RateCalculationModelBuilder getRateCalculationModel();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public RepoSequence0.RepoSequence0Builder getOrCreateRepoSequence0();

        @Override
        public RepoSequence0.RepoSequence0Builder getRepoSequence0();

        public RepoSequence1.RepoSequence1Builder getOrCreateRepoSequence1();

        @Override
        public RepoSequence1.RepoSequence1Builder getRepoSequence1();

        public InitialMargin.InitialMarginBuilder getOrCreateInitialMargin();

        @Override
        public InitialMargin.InitialMarginBuilder getInitialMargin();

        public RepoNearLeg.RepoNearLegBuilder getOrCreateNearLeg();

        @Override
        public RepoNearLeg.RepoNearLegBuilder getNearLeg();

        public RepoFarLeg.RepoFarLegBuilder getOrCreateFarLeg();

        @Override
        public RepoFarLeg.RepoFarLegBuilder getFarLeg();

        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency();

        @Override
        public Frequency.FrequencyBuilder getPaymentFrequency();

        public BondEquityModel.BondEquityModelBuilder getOrCreateBondEquityModel(int var1);

        public List<? extends BondEquityModel.BondEquityModelBuilder> getBondEquityModel();

        public GenericSecurity.GenericSecurityBuilder getOrCreateSecurity();

        @Override
        public GenericSecurity.GenericSecurityBuilder getSecurity();

        public TriParty.TriPartyBuilder getOrCreateTriParty();

        @Override
        public TriParty.TriPartyBuilder getTriParty();

        public CollateralArrangement.CollateralArrangementBuilder getOrCreateCollateralArrangement();

        @Override
        public CollateralArrangement.CollateralArrangementBuilder getCollateralArrangement();

        @Override
        public RepoBuilder setProductModel(ProductModel var1);

        @Override
        public RepoBuilder setId(String var1);

        public RepoBuilder setRateCalculationModel(RateCalculationModel var1);

        public RepoBuilder setDayCountFraction(DayCountFraction var1);

        public RepoBuilder setRepoSequence0(RepoSequence0 var1);

        public RepoBuilder setRepoSequence1(RepoSequence1 var1);

        public RepoBuilder setInitialMargin(InitialMargin var1);

        public RepoBuilder setNearLeg(RepoNearLeg var1);

        public RepoBuilder setFarLeg(RepoFarLeg var1);

        public RepoBuilder setPaymentFrequency(Frequency var1);

        public RepoBuilder addBondEquityModel(BondEquityModel var1);

        public RepoBuilder addBondEquityModel(BondEquityModel var1, int var2);

        public RepoBuilder addBondEquityModel(List<? extends BondEquityModel> var1);

        public RepoBuilder setBondEquityModel(List<? extends BondEquityModel> var1);

        public RepoBuilder setSecurity(GenericSecurity var1);

        public RepoBuilder setTriParty(TriParty var1);

        public RepoBuilder setGeneralCollateral(Boolean var1);

        public RepoBuilder setCollateralArrangement(CollateralArrangement var1);

        public RepoBuilder setEligibleForRehypothecation(Boolean var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateCalculationModel"), processor, RateCalculationModel.RateCalculationModelBuilder.class, this.getRateCalculationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("repoSequence0"), processor, RepoSequence0.RepoSequence0Builder.class, this.getRepoSequence0(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("repoSequence1"), processor, RepoSequence1.RepoSequence1Builder.class, this.getRepoSequence1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialMargin"), processor, InitialMargin.InitialMarginBuilder.class, this.getInitialMargin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nearLeg"), processor, RepoNearLeg.RepoNearLegBuilder.class, this.getNearLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("farLeg"), processor, RepoFarLeg.RepoFarLegBuilder.class, this.getFarLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.FrequencyBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondEquityModel"), processor, BondEquityModel.BondEquityModelBuilder.class, this.getBondEquityModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("security"), processor, GenericSecurity.GenericSecurityBuilder.class, this.getSecurity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("triParty"), processor, TriParty.TriPartyBuilder.class, this.getTriParty(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("generalCollateral"), Boolean.class, (Object)this.getGeneralCollateral(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralArrangement"), processor, CollateralArrangement.CollateralArrangementBuilder.class, this.getCollateralArrangement(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eligibleForRehypothecation"), Boolean.class, (Object)this.getEligibleForRehypothecation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public RepoBuilder prune();
    }

    public static class RepoImpl
    extends Product.ProductImpl
    implements Repo {
        private final RateCalculationModel rateCalculationModel;
        private final DayCountFraction dayCountFraction;
        private final RepoSequence0 repoSequence0;
        private final RepoSequence1 repoSequence1;
        private final InitialMargin initialMargin;
        private final RepoNearLeg nearLeg;
        private final RepoFarLeg farLeg;
        private final Frequency paymentFrequency;
        private final List<? extends BondEquityModel> bondEquityModel;
        private final GenericSecurity security;
        private final TriParty triParty;
        private final Boolean generalCollateral;
        private final CollateralArrangement collateralArrangement;
        private final Boolean eligibleForRehypothecation;

        protected RepoImpl(RepoBuilder builder) {
            super(builder);
            this.rateCalculationModel = Optional.ofNullable(builder.getRateCalculationModel()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.repoSequence0 = Optional.ofNullable(builder.getRepoSequence0()).map(f -> f.build()).orElse(null);
            this.repoSequence1 = Optional.ofNullable(builder.getRepoSequence1()).map(f -> f.build()).orElse(null);
            this.initialMargin = Optional.ofNullable(builder.getInitialMargin()).map(f -> f.build()).orElse(null);
            this.nearLeg = Optional.ofNullable(builder.getNearLeg()).map(f -> f.build()).orElse(null);
            this.farLeg = Optional.ofNullable(builder.getFarLeg()).map(f -> f.build()).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
            this.bondEquityModel = Optional.ofNullable(builder.getBondEquityModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.security = Optional.ofNullable(builder.getSecurity()).map(f -> f.build()).orElse(null);
            this.triParty = Optional.ofNullable(builder.getTriParty()).map(f -> f.build()).orElse(null);
            this.generalCollateral = builder.getGeneralCollateral();
            this.collateralArrangement = Optional.ofNullable(builder.getCollateralArrangement()).map(f -> f.build()).orElse(null);
            this.eligibleForRehypothecation = builder.getEligibleForRehypothecation();
        }

        @Override
        @RosettaAttribute(value="rateCalculationModel", isRequired=true)
        @RuneAttribute(value="rateCalculationModel", isRequired=true)
        public RateCalculationModel getRateCalculationModel() {
            return this.rateCalculationModel;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="repoSequence0")
        @RuneAttribute(value="repoSequence0")
        public RepoSequence0 getRepoSequence0() {
            return this.repoSequence0;
        }

        @Override
        @RosettaAttribute(value="repoSequence1")
        @RuneAttribute(value="repoSequence1")
        public RepoSequence1 getRepoSequence1() {
            return this.repoSequence1;
        }

        @Override
        @RosettaAttribute(value="initialMargin")
        @RuneAttribute(value="initialMargin")
        public InitialMargin getInitialMargin() {
            return this.initialMargin;
        }

        @Override
        @RosettaAttribute(value="nearLeg", isRequired=true)
        @RuneAttribute(value="nearLeg", isRequired=true)
        public RepoNearLeg getNearLeg() {
            return this.nearLeg;
        }

        @Override
        @RosettaAttribute(value="farLeg")
        @RuneAttribute(value="farLeg")
        public RepoFarLeg getFarLeg() {
            return this.farLeg;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Frequency getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        @RosettaAttribute(value="bondEquityModel")
        @RuneAttribute(value="bondEquityModel")
        public List<? extends BondEquityModel> getBondEquityModel() {
            return this.bondEquityModel;
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public GenericSecurity getSecurity() {
            return this.security;
        }

        @Override
        @RosettaAttribute(value="triParty")
        @RuneAttribute(value="triParty")
        public TriParty getTriParty() {
            return this.triParty;
        }

        @Override
        @RosettaAttribute(value="generalCollateral")
        @RuneAttribute(value="generalCollateral")
        public Boolean getGeneralCollateral() {
            return this.generalCollateral;
        }

        @Override
        @RosettaAttribute(value="collateralArrangement")
        @RuneAttribute(value="collateralArrangement")
        public CollateralArrangement getCollateralArrangement() {
            return this.collateralArrangement;
        }

        @Override
        @RosettaAttribute(value="eligibleForRehypothecation")
        @RuneAttribute(value="eligibleForRehypothecation")
        public Boolean getEligibleForRehypothecation() {
            return this.eligibleForRehypothecation;
        }

        @Override
        public Repo build() {
            return this;
        }

        @Override
        public RepoBuilder toBuilder() {
            RepoBuilder builder = Repo.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepoBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRateCalculationModel()).ifPresent(builder::setRateCalculationModel);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getRepoSequence0()).ifPresent(builder::setRepoSequence0);
            Optional.ofNullable(this.getRepoSequence1()).ifPresent(builder::setRepoSequence1);
            Optional.ofNullable(this.getInitialMargin()).ifPresent(builder::setInitialMargin);
            Optional.ofNullable(this.getNearLeg()).ifPresent(builder::setNearLeg);
            Optional.ofNullable(this.getFarLeg()).ifPresent(builder::setFarLeg);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
            Optional.ofNullable(this.getBondEquityModel()).ifPresent(builder::setBondEquityModel);
            Optional.ofNullable(this.getSecurity()).ifPresent(builder::setSecurity);
            Optional.ofNullable(this.getTriParty()).ifPresent(builder::setTriParty);
            Optional.ofNullable(this.getGeneralCollateral()).ifPresent(builder::setGeneralCollateral);
            Optional.ofNullable(this.getCollateralArrangement()).ifPresent(builder::setCollateralArrangement);
            Optional.ofNullable(this.getEligibleForRehypothecation()).ifPresent(builder::setEligibleForRehypothecation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Repo _that = (Repo)this.getType().cast(o);
            if (!Objects.equals(this.rateCalculationModel, _that.getRateCalculationModel())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.repoSequence0, _that.getRepoSequence0())) {
                return false;
            }
            if (!Objects.equals(this.repoSequence1, _that.getRepoSequence1())) {
                return false;
            }
            if (!Objects.equals(this.initialMargin, _that.getInitialMargin())) {
                return false;
            }
            if (!Objects.equals(this.nearLeg, _that.getNearLeg())) {
                return false;
            }
            if (!Objects.equals(this.farLeg, _that.getFarLeg())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.bondEquityModel, _that.getBondEquityModel())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            if (!Objects.equals(this.triParty, _that.getTriParty())) {
                return false;
            }
            if (!Objects.equals(this.generalCollateral, _that.getGeneralCollateral())) {
                return false;
            }
            if (!Objects.equals(this.collateralArrangement, _that.getCollateralArrangement())) {
                return false;
            }
            return Objects.equals(this.eligibleForRehypothecation, _that.getEligibleForRehypothecation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rateCalculationModel != null ? this.rateCalculationModel.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.repoSequence0 != null ? this.repoSequence0.hashCode() : 0);
            _result = 31 * _result + (this.repoSequence1 != null ? this.repoSequence1.hashCode() : 0);
            _result = 31 * _result + (this.initialMargin != null ? this.initialMargin.hashCode() : 0);
            _result = 31 * _result + (this.nearLeg != null ? this.nearLeg.hashCode() : 0);
            _result = 31 * _result + (this.farLeg != null ? this.farLeg.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.bondEquityModel != null ? this.bondEquityModel.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.triParty != null ? this.triParty.hashCode() : 0);
            _result = 31 * _result + (this.generalCollateral != null ? this.generalCollateral.hashCode() : 0);
            _result = 31 * _result + (this.collateralArrangement != null ? this.collateralArrangement.hashCode() : 0);
            _result = 31 * _result + (this.eligibleForRehypothecation != null ? this.eligibleForRehypothecation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Repo {rateCalculationModel=" + String.valueOf(this.rateCalculationModel) + ", dayCountFraction=" + String.valueOf(this.dayCountFraction) + ", repoSequence0=" + String.valueOf(this.repoSequence0) + ", repoSequence1=" + String.valueOf(this.repoSequence1) + ", initialMargin=" + String.valueOf(this.initialMargin) + ", nearLeg=" + String.valueOf(this.nearLeg) + ", farLeg=" + String.valueOf(this.farLeg) + ", paymentFrequency=" + String.valueOf(this.paymentFrequency) + ", bondEquityModel=" + String.valueOf(this.bondEquityModel) + ", security=" + String.valueOf(this.security) + ", triParty=" + String.valueOf(this.triParty) + ", generalCollateral=" + this.generalCollateral + ", collateralArrangement=" + String.valueOf(this.collateralArrangement) + ", eligibleForRehypothecation=" + this.eligibleForRehypothecation + "} " + super.toString();
        }
    }
}

