/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.msg.Message;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.reg.fpmlreporting.shared.ReportingStatus;
import fpml.consolidated.reg.fpmlreporting.shared.meta.RegulatoryReportingStatusMessageMeta;
import fpml.consolidated.shared.Party;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryReportingStatusMessage", builder=RegulatoryReportingStatusMessageBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryReportingStatusMessage", model="fpml", builder=RegulatoryReportingStatusMessageBuilderImpl.class, version="1.2.2")
public interface RegulatoryReportingStatusMessage
extends Message {
    public static final RegulatoryReportingStatusMessageMeta metaData = new RegulatoryReportingStatusMessageMeta();

    public ResponseMessageHeader getHeader();

    public PartyTradeIdentifier getTradeIdentifier();

    public List<? extends ReportingStatus> getReportingStatus();

    public List<? extends Party> getParty();

    @Override
    public RegulatoryReportingStatusMessage build();

    @Override
    public RegulatoryReportingStatusMessageBuilder toBuilder();

    public static RegulatoryReportingStatusMessageBuilder builder() {
        return new RegulatoryReportingStatusMessageBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryReportingStatusMessage> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryReportingStatusMessage> getType() {
        return RegulatoryReportingStatusMessage.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingStatus"), processor, ReportingStatus.class, this.getReportingStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class RegulatoryReportingStatusMessageBuilderImpl
    extends Message.MessageBuilderImpl
    implements RegulatoryReportingStatusMessageBuilder {
        protected ResponseMessageHeader.ResponseMessageHeaderBuilder header;
        protected PartyTradeIdentifier.PartyTradeIdentifierBuilder tradeIdentifier;
        protected List<ReportingStatus.ReportingStatusBuilder> reportingStatus = new ArrayList<ReportingStatus.ReportingStatusBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getHeader() {
            return this.header;
        }

        @Override
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getOrCreateHeader() {
            ResponseMessageHeader.ResponseMessageHeaderBuilder result = this.header != null ? this.header : (this.header = ResponseMessageHeader.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier() {
            PartyTradeIdentifier.PartyTradeIdentifierBuilder result = this.tradeIdentifier != null ? this.tradeIdentifier : (this.tradeIdentifier = PartyTradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingStatus")
        @RuneAttribute(value="reportingStatus")
        public List<? extends ReportingStatus.ReportingStatusBuilder> getReportingStatus() {
            return this.reportingStatus;
        }

        @Override
        public ReportingStatus.ReportingStatusBuilder getOrCreateReportingStatus(int index) {
            if (this.reportingStatus == null) {
                this.reportingStatus = new ArrayList<ReportingStatus.ReportingStatusBuilder>();
            }
            return (ReportingStatus.ReportingStatusBuilder)this.getIndex(this.reportingStatus, index, () -> {
                ReportingStatus.ReportingStatusBuilder newReportingStatus = ReportingStatus.builder();
                return newReportingStatus;
            });
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RegulatoryReportingStatusMessageBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RegulatoryReportingStatusMessageBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RegulatoryReportingStatusMessageBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RegulatoryReportingStatusMessageBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public RegulatoryReportingStatusMessageBuilder setTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            this.tradeIdentifier = _tradeIdentifier == null ? null : _tradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingStatus")
        @RuneAttribute(value="reportingStatus")
        public RegulatoryReportingStatusMessageBuilder addReportingStatus(ReportingStatus _reportingStatus) {
            if (_reportingStatus != null) {
                this.reportingStatus.add(_reportingStatus.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder addReportingStatus(ReportingStatus _reportingStatus, int idx) {
            this.getIndex(this.reportingStatus, idx, () -> _reportingStatus.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder addReportingStatus(List<? extends ReportingStatus> reportingStatuss) {
            if (reportingStatuss != null) {
                for (ReportingStatus reportingStatus : reportingStatuss) {
                    this.reportingStatus.add(reportingStatus.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reportingStatus")
        public RegulatoryReportingStatusMessageBuilder setReportingStatus(List<? extends ReportingStatus> reportingStatuss) {
            this.reportingStatus = reportingStatuss == null ? new ArrayList<ReportingStatus.ReportingStatusBuilder>() : (List)reportingStatuss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public RegulatoryReportingStatusMessageBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public RegulatoryReportingStatusMessageBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegulatoryReportingStatusMessage build() {
            return new RegulatoryReportingStatusMessageImpl(this);
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder prune() {
            super.prune();
            if (this.header != null && !this.header.prune().hasData()) {
                this.header = null;
            }
            if (this.tradeIdentifier != null && !this.tradeIdentifier.prune().hasData()) {
                this.tradeIdentifier = null;
            }
            this.reportingStatus = this.reportingStatus.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getHeader() != null && this.getHeader().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getReportingStatus() != null && this.getReportingStatus().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryReportingStatusMessageBuilder o = (RegulatoryReportingStatusMessageBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getHeader(), (RosettaModelObjectBuilder)o.getHeader(), this::setHeader);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeIdentifier(), (RosettaModelObjectBuilder)o.getTradeIdentifier(), this::setTradeIdentifier);
            merger.mergeRosetta(this.getReportingStatus(), o.getReportingStatus(), this::getOrCreateReportingStatus);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryReportingStatusMessage _that = (RegulatoryReportingStatusMessage)this.getType().cast(o);
            if (!Objects.equals(this.header, _that.getHeader())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingStatus, _that.getReportingStatus())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.header != null ? this.header.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.reportingStatus != null ? this.reportingStatus.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryReportingStatusMessageBuilder {header=" + String.valueOf(this.header) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", reportingStatus=" + String.valueOf(this.reportingStatus) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface RegulatoryReportingStatusMessageBuilder
    extends RegulatoryReportingStatusMessage,
    Message.MessageBuilder {
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getOrCreateHeader();

        @Override
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getHeader();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier();

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier();

        public ReportingStatus.ReportingStatusBuilder getOrCreateReportingStatus(int var1);

        public List<? extends ReportingStatus.ReportingStatusBuilder> getReportingStatus();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public RegulatoryReportingStatusMessageBuilder setFpmlVersion(String var1);

        @Override
        public RegulatoryReportingStatusMessageBuilder setExpectedBuild(Integer var1);

        @Override
        public RegulatoryReportingStatusMessageBuilder setActualBuild(Integer var1);

        public RegulatoryReportingStatusMessageBuilder setHeader(ResponseMessageHeader var1);

        public RegulatoryReportingStatusMessageBuilder setTradeIdentifier(PartyTradeIdentifier var1);

        public RegulatoryReportingStatusMessageBuilder addReportingStatus(ReportingStatus var1);

        public RegulatoryReportingStatusMessageBuilder addReportingStatus(ReportingStatus var1, int var2);

        public RegulatoryReportingStatusMessageBuilder addReportingStatus(List<? extends ReportingStatus> var1);

        public RegulatoryReportingStatusMessageBuilder setReportingStatus(List<? extends ReportingStatus> var1);

        public RegulatoryReportingStatusMessageBuilder addParty(Party var1);

        public RegulatoryReportingStatusMessageBuilder addParty(Party var1, int var2);

        public RegulatoryReportingStatusMessageBuilder addParty(List<? extends Party> var1);

        public RegulatoryReportingStatusMessageBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingStatus"), processor, ReportingStatus.ReportingStatusBuilder.class, this.getReportingStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder prune();
    }

    public static class RegulatoryReportingStatusMessageImpl
    extends Message.MessageImpl
    implements RegulatoryReportingStatusMessage {
        private final ResponseMessageHeader header;
        private final PartyTradeIdentifier tradeIdentifier;
        private final List<? extends ReportingStatus> reportingStatus;
        private final List<? extends Party> party;

        protected RegulatoryReportingStatusMessageImpl(RegulatoryReportingStatusMessageBuilder builder) {
            super(builder);
            this.header = Optional.ofNullable(builder.getHeader()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.reportingStatus = Optional.ofNullable(builder.getReportingStatus()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ResponseMessageHeader getHeader() {
            return this.header;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="reportingStatus")
        @RuneAttribute(value="reportingStatus")
        public List<? extends ReportingStatus> getReportingStatus() {
            return this.reportingStatus;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public RegulatoryReportingStatusMessage build() {
            return this;
        }

        @Override
        public RegulatoryReportingStatusMessageBuilder toBuilder() {
            RegulatoryReportingStatusMessageBuilder builder = RegulatoryReportingStatusMessage.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryReportingStatusMessageBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getHeader()).ifPresent(builder::setHeader);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getReportingStatus()).ifPresent(builder::setReportingStatus);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryReportingStatusMessage _that = (RegulatoryReportingStatusMessage)this.getType().cast(o);
            if (!Objects.equals(this.header, _that.getHeader())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingStatus, _that.getReportingStatus())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.header != null ? this.header.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.reportingStatus != null ? this.reportingStatus.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryReportingStatusMessage {header=" + String.valueOf(this.header) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", reportingStatus=" + String.valueOf(this.reportingStatus) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

