/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.product;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingNonCDESizeFieldsModel;
import fpml.consolidated.reg.fpmlreporting.product.meta.RegulatoryReportingProductSizesMeta;
import fpml.consolidated.shared.NonNegativeAmountSchedule;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryReportingProductSizes", builder=RegulatoryReportingProductSizesBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryReportingProductSizes", model="fpml", builder=RegulatoryReportingProductSizesBuilderImpl.class, version="1.2.2")
public interface RegulatoryReportingProductSizes
extends RosettaModelObject {
    public static final RegulatoryReportingProductSizesMeta metaData = new RegulatoryReportingProductSizesMeta();

    public List<? extends NonNegativeMoney> getNotional();

    public NonNegativeMoney getCallAmount();

    public NonNegativeMoney getPutAmount();

    public List<? extends NonNegativeAmountSchedule> getNotionalSchedule();

    public RegulatoryReportingNonCDESizeFieldsModel getRegulatoryReportingNonCDESizeFieldsModel();

    public RegulatoryReportingProductSizes build();

    public RegulatoryReportingProductSizesBuilder toBuilder();

    public static RegulatoryReportingProductSizesBuilder builder() {
        return new RegulatoryReportingProductSizesBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryReportingProductSizes> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryReportingProductSizes> getType() {
        return RegulatoryReportingProductSizes.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callAmount"), processor, NonNegativeMoney.class, this.getCallAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("putAmount"), processor, NonNegativeMoney.class, this.getPutAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalSchedule"), processor, NonNegativeAmountSchedule.class, this.getNotionalSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulatoryReportingNonCDESizeFieldsModel"), processor, RegulatoryReportingNonCDESizeFieldsModel.class, this.getRegulatoryReportingNonCDESizeFieldsModel(), new AttributeMeta[0]);
    }

    public static class RegulatoryReportingProductSizesBuilderImpl
    implements RegulatoryReportingProductSizesBuilder {
        protected List<NonNegativeMoney.NonNegativeMoneyBuilder> notional = new ArrayList<NonNegativeMoney.NonNegativeMoneyBuilder>();
        protected NonNegativeMoney.NonNegativeMoneyBuilder callAmount;
        protected NonNegativeMoney.NonNegativeMoneyBuilder putAmount;
        protected List<NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder> notionalSchedule = new ArrayList<NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder>();
        protected RegulatoryReportingNonCDESizeFieldsModel.RegulatoryReportingNonCDESizeFieldsModelBuilder regulatoryReportingNonCDESizeFieldsModel;

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public List<? extends NonNegativeMoney.NonNegativeMoneyBuilder> getNotional() {
            return this.notional;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional(int index) {
            if (this.notional == null) {
                this.notional = new ArrayList<NonNegativeMoney.NonNegativeMoneyBuilder>();
            }
            return (NonNegativeMoney.NonNegativeMoneyBuilder)this.getIndex(this.notional, index, () -> {
                NonNegativeMoney.NonNegativeMoneyBuilder newNotional = NonNegativeMoney.builder();
                return newNotional;
            });
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getCallAmount() {
            return this.callAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateCallAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.callAmount != null ? this.callAmount : (this.callAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getPutAmount() {
            return this.putAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePutAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.putAmount != null ? this.putAmount : (this.putAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public List<? extends NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder> getNotionalSchedule() {
            return this.notionalSchedule;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalSchedule(int index) {
            if (this.notionalSchedule == null) {
                this.notionalSchedule = new ArrayList<NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder>();
            }
            return (NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder)this.getIndex(this.notionalSchedule, index, () -> {
                NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder newNotionalSchedule = NonNegativeAmountSchedule.builder();
                return newNotionalSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="regulatoryReportingNonCDESizeFieldsModel")
        @RuneAttribute(value="regulatoryReportingNonCDESizeFieldsModel")
        public RegulatoryReportingNonCDESizeFieldsModel.RegulatoryReportingNonCDESizeFieldsModelBuilder getRegulatoryReportingNonCDESizeFieldsModel() {
            return this.regulatoryReportingNonCDESizeFieldsModel;
        }

        @Override
        public RegulatoryReportingNonCDESizeFieldsModel.RegulatoryReportingNonCDESizeFieldsModelBuilder getOrCreateRegulatoryReportingNonCDESizeFieldsModel() {
            RegulatoryReportingNonCDESizeFieldsModel.RegulatoryReportingNonCDESizeFieldsModelBuilder result = this.regulatoryReportingNonCDESizeFieldsModel != null ? this.regulatoryReportingNonCDESizeFieldsModel : (this.regulatoryReportingNonCDESizeFieldsModel = RegulatoryReportingNonCDESizeFieldsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public RegulatoryReportingProductSizesBuilder addNotional(NonNegativeMoney _notional) {
            if (_notional != null) {
                this.notional.add(_notional.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductSizesBuilder addNotional(NonNegativeMoney _notional, int idx) {
            this.getIndex(this.notional, idx, () -> _notional.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductSizesBuilder addNotional(List<? extends NonNegativeMoney> notionals) {
            if (notionals != null) {
                for (NonNegativeMoney nonNegativeMoney : notionals) {
                    this.notional.add(nonNegativeMoney.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notional")
        public RegulatoryReportingProductSizesBuilder setNotional(List<? extends NonNegativeMoney> notionals) {
            this.notional = notionals == null ? new ArrayList<NonNegativeMoney.NonNegativeMoneyBuilder>() : (List)notionals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public RegulatoryReportingProductSizesBuilder setCallAmount(NonNegativeMoney _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public RegulatoryReportingProductSizesBuilder setPutAmount(NonNegativeMoney _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public RegulatoryReportingProductSizesBuilder addNotionalSchedule(NonNegativeAmountSchedule _notionalSchedule) {
            if (_notionalSchedule != null) {
                this.notionalSchedule.add(_notionalSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductSizesBuilder addNotionalSchedule(NonNegativeAmountSchedule _notionalSchedule, int idx) {
            this.getIndex(this.notionalSchedule, idx, () -> _notionalSchedule.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductSizesBuilder addNotionalSchedule(List<? extends NonNegativeAmountSchedule> notionalSchedules) {
            if (notionalSchedules != null) {
                for (NonNegativeAmountSchedule nonNegativeAmountSchedule : notionalSchedules) {
                    this.notionalSchedule.add(nonNegativeAmountSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalSchedule")
        public RegulatoryReportingProductSizesBuilder setNotionalSchedule(List<? extends NonNegativeAmountSchedule> notionalSchedules) {
            this.notionalSchedule = notionalSchedules == null ? new ArrayList<NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder>() : (List)notionalSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="regulatoryReportingNonCDESizeFieldsModel")
        @RuneAttribute(value="regulatoryReportingNonCDESizeFieldsModel")
        public RegulatoryReportingProductSizesBuilder setRegulatoryReportingNonCDESizeFieldsModel(RegulatoryReportingNonCDESizeFieldsModel _regulatoryReportingNonCDESizeFieldsModel) {
            this.regulatoryReportingNonCDESizeFieldsModel = _regulatoryReportingNonCDESizeFieldsModel == null ? null : _regulatoryReportingNonCDESizeFieldsModel.toBuilder();
            return this;
        }

        @Override
        public RegulatoryReportingProductSizes build() {
            return new RegulatoryReportingProductSizesImpl(this);
        }

        @Override
        public RegulatoryReportingProductSizesBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryReportingProductSizesBuilder prune() {
            this.notional = this.notional.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.callAmount != null && !this.callAmount.prune().hasData()) {
                this.callAmount = null;
            }
            if (this.putAmount != null && !this.putAmount.prune().hasData()) {
                this.putAmount = null;
            }
            this.notionalSchedule = this.notionalSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.regulatoryReportingNonCDESizeFieldsModel != null && !this.regulatoryReportingNonCDESizeFieldsModel.prune().hasData()) {
                this.regulatoryReportingNonCDESizeFieldsModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNotional() != null && this.getNotional().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCallAmount() != null && this.getCallAmount().hasData()) {
                return true;
            }
            if (this.getPutAmount() != null && this.getPutAmount().hasData()) {
                return true;
            }
            if (this.getNotionalSchedule() != null && this.getNotionalSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getRegulatoryReportingNonCDESizeFieldsModel() != null && this.getRegulatoryReportingNonCDESizeFieldsModel().hasData();
        }

        public RegulatoryReportingProductSizesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegulatoryReportingProductSizesBuilder o = (RegulatoryReportingProductSizesBuilder)other;
            merger.mergeRosetta(this.getNotional(), o.getNotional(), this::getOrCreateNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallAmount(), (RosettaModelObjectBuilder)o.getCallAmount(), this::setCallAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPutAmount(), (RosettaModelObjectBuilder)o.getPutAmount(), this::setPutAmount);
            merger.mergeRosetta(this.getNotionalSchedule(), o.getNotionalSchedule(), this::getOrCreateNotionalSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegulatoryReportingNonCDESizeFieldsModel(), (RosettaModelObjectBuilder)o.getRegulatoryReportingNonCDESizeFieldsModel(), this::setRegulatoryReportingNonCDESizeFieldsModel);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingProductSizes _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalSchedule, _that.getNotionalSchedule())) {
                return false;
            }
            return Objects.equals(this.regulatoryReportingNonCDESizeFieldsModel, _that.getRegulatoryReportingNonCDESizeFieldsModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalSchedule != null ? this.notionalSchedule.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryReportingNonCDESizeFieldsModel != null ? this.regulatoryReportingNonCDESizeFieldsModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingProductSizesBuilder {notional=" + String.valueOf(this.notional) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", notionalSchedule=" + String.valueOf(this.notionalSchedule) + ", regulatoryReportingNonCDESizeFieldsModel=" + String.valueOf(this.regulatoryReportingNonCDESizeFieldsModel) + "}";
        }
    }

    public static interface RegulatoryReportingProductSizesBuilder
    extends RegulatoryReportingProductSizes,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional(int var1);

        public List<? extends NonNegativeMoney.NonNegativeMoneyBuilder> getNotional();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateCallAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getCallAmount();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePutAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getPutAmount();

        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalSchedule(int var1);

        public List<? extends NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder> getNotionalSchedule();

        public RegulatoryReportingNonCDESizeFieldsModel.RegulatoryReportingNonCDESizeFieldsModelBuilder getOrCreateRegulatoryReportingNonCDESizeFieldsModel();

        @Override
        public RegulatoryReportingNonCDESizeFieldsModel.RegulatoryReportingNonCDESizeFieldsModelBuilder getRegulatoryReportingNonCDESizeFieldsModel();

        public RegulatoryReportingProductSizesBuilder addNotional(NonNegativeMoney var1);

        public RegulatoryReportingProductSizesBuilder addNotional(NonNegativeMoney var1, int var2);

        public RegulatoryReportingProductSizesBuilder addNotional(List<? extends NonNegativeMoney> var1);

        public RegulatoryReportingProductSizesBuilder setNotional(List<? extends NonNegativeMoney> var1);

        public RegulatoryReportingProductSizesBuilder setCallAmount(NonNegativeMoney var1);

        public RegulatoryReportingProductSizesBuilder setPutAmount(NonNegativeMoney var1);

        public RegulatoryReportingProductSizesBuilder addNotionalSchedule(NonNegativeAmountSchedule var1);

        public RegulatoryReportingProductSizesBuilder addNotionalSchedule(NonNegativeAmountSchedule var1, int var2);

        public RegulatoryReportingProductSizesBuilder addNotionalSchedule(List<? extends NonNegativeAmountSchedule> var1);

        public RegulatoryReportingProductSizesBuilder setNotionalSchedule(List<? extends NonNegativeAmountSchedule> var1);

        public RegulatoryReportingProductSizesBuilder setRegulatoryReportingNonCDESizeFieldsModel(RegulatoryReportingNonCDESizeFieldsModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getCallAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("putAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getPutAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalSchedule"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getNotionalSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulatoryReportingNonCDESizeFieldsModel"), processor, RegulatoryReportingNonCDESizeFieldsModel.RegulatoryReportingNonCDESizeFieldsModelBuilder.class, this.getRegulatoryReportingNonCDESizeFieldsModel(), new AttributeMeta[0]);
        }

        public RegulatoryReportingProductSizesBuilder prune();
    }

    public static class RegulatoryReportingProductSizesImpl
    implements RegulatoryReportingProductSizes {
        private final List<? extends NonNegativeMoney> notional;
        private final NonNegativeMoney callAmount;
        private final NonNegativeMoney putAmount;
        private final List<? extends NonNegativeAmountSchedule> notionalSchedule;
        private final RegulatoryReportingNonCDESizeFieldsModel regulatoryReportingNonCDESizeFieldsModel;

        protected RegulatoryReportingProductSizesImpl(RegulatoryReportingProductSizesBuilder builder) {
            this.notional = Optional.ofNullable(builder.getNotional()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.callAmount = Optional.ofNullable(builder.getCallAmount()).map(f -> f.build()).orElse(null);
            this.putAmount = Optional.ofNullable(builder.getPutAmount()).map(f -> f.build()).orElse(null);
            this.notionalSchedule = Optional.ofNullable(builder.getNotionalSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.regulatoryReportingNonCDESizeFieldsModel = Optional.ofNullable(builder.getRegulatoryReportingNonCDESizeFieldsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public List<? extends NonNegativeMoney> getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public NonNegativeMoney getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public NonNegativeMoney getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public List<? extends NonNegativeAmountSchedule> getNotionalSchedule() {
            return this.notionalSchedule;
        }

        @Override
        @RosettaAttribute(value="regulatoryReportingNonCDESizeFieldsModel")
        @RuneAttribute(value="regulatoryReportingNonCDESizeFieldsModel")
        public RegulatoryReportingNonCDESizeFieldsModel getRegulatoryReportingNonCDESizeFieldsModel() {
            return this.regulatoryReportingNonCDESizeFieldsModel;
        }

        @Override
        public RegulatoryReportingProductSizes build() {
            return this;
        }

        @Override
        public RegulatoryReportingProductSizesBuilder toBuilder() {
            RegulatoryReportingProductSizesBuilder builder = RegulatoryReportingProductSizes.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryReportingProductSizesBuilder builder) {
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getCallAmount()).ifPresent(builder::setCallAmount);
            Optional.ofNullable(this.getPutAmount()).ifPresent(builder::setPutAmount);
            Optional.ofNullable(this.getNotionalSchedule()).ifPresent(builder::setNotionalSchedule);
            Optional.ofNullable(this.getRegulatoryReportingNonCDESizeFieldsModel()).ifPresent(builder::setRegulatoryReportingNonCDESizeFieldsModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingProductSizes _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalSchedule, _that.getNotionalSchedule())) {
                return false;
            }
            return Objects.equals(this.regulatoryReportingNonCDESizeFieldsModel, _that.getRegulatoryReportingNonCDESizeFieldsModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalSchedule != null ? this.notionalSchedule.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryReportingNonCDESizeFieldsModel != null ? this.regulatoryReportingNonCDESizeFieldsModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingProductSizes {notional=" + String.valueOf(this.notional) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", notionalSchedule=" + String.valueOf(this.notionalSchedule) + ", regulatoryReportingNonCDESizeFieldsModel=" + String.valueOf(this.regulatoryReportingNonCDESizeFieldsModel) + "}";
        }
    }
}

