/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.product;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.OptionTypeEnum;
import fpml.consolidated.generic.GenericExerciseStyle;
import fpml.consolidated.generic.GenericProductFeature;
import fpml.consolidated.reg.fpmlreporting.product.meta.RegulatoryReportingNonCDEOptionDetailsMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryReportingNonCDEOptionDetails", builder=RegulatoryReportingNonCDEOptionDetailsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryReportingNonCDEOptionDetails", model="fpml", builder=RegulatoryReportingNonCDEOptionDetailsBuilderImpl.class, version="1.2.2")
public interface RegulatoryReportingNonCDEOptionDetails
extends RosettaModelObject {
    public static final RegulatoryReportingNonCDEOptionDetailsMeta metaData = new RegulatoryReportingNonCDEOptionDetailsMeta();

    public OptionTypeEnum getOptionType();

    public List<ZonedDateTime> getFirstExerciseDate();

    public List<ZonedDateTime> getOptionExpirationDate();

    public List<ZonedDateTime> getUnderlyerMaturityDate();

    public GenericExerciseStyle getExerciseStyle();

    public List<? extends GenericProductFeature> getFeature();

    public RegulatoryReportingNonCDEOptionDetails build();

    public RegulatoryReportingNonCDEOptionDetailsBuilder toBuilder();

    public static RegulatoryReportingNonCDEOptionDetailsBuilder builder() {
        return new RegulatoryReportingNonCDEOptionDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryReportingNonCDEOptionDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryReportingNonCDEOptionDetails> getType() {
        return RegulatoryReportingNonCDEOptionDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), ZonedDateTime.class, this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionExpirationDate"), ZonedDateTime.class, this.getOptionExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyerMaturityDate"), ZonedDateTime.class, this.getUnderlyerMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseStyle"), processor, GenericExerciseStyle.class, this.getExerciseStyle(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feature"), processor, GenericProductFeature.class, this.getFeature(), new AttributeMeta[0]);
    }

    public static class RegulatoryReportingNonCDEOptionDetailsBuilderImpl
    implements RegulatoryReportingNonCDEOptionDetailsBuilder {
        protected OptionTypeEnum optionType;
        protected List<ZonedDateTime> firstExerciseDate = new ArrayList<ZonedDateTime>();
        protected List<ZonedDateTime> optionExpirationDate = new ArrayList<ZonedDateTime>();
        protected List<ZonedDateTime> underlyerMaturityDate = new ArrayList<ZonedDateTime>();
        protected GenericExerciseStyle.GenericExerciseStyleBuilder exerciseStyle;
        protected List<GenericProductFeature.GenericProductFeatureBuilder> feature = new ArrayList<GenericProductFeature.GenericProductFeatureBuilder>();

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public List<ZonedDateTime> getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="optionExpirationDate")
        @RuneAttribute(value="optionExpirationDate")
        public List<ZonedDateTime> getOptionExpirationDate() {
            return this.optionExpirationDate;
        }

        @Override
        @RosettaAttribute(value="underlyerMaturityDate")
        @RuneAttribute(value="underlyerMaturityDate")
        public List<ZonedDateTime> getUnderlyerMaturityDate() {
            return this.underlyerMaturityDate;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public GenericExerciseStyle.GenericExerciseStyleBuilder getExerciseStyle() {
            return this.exerciseStyle;
        }

        @Override
        public GenericExerciseStyle.GenericExerciseStyleBuilder getOrCreateExerciseStyle() {
            GenericExerciseStyle.GenericExerciseStyleBuilder result = this.exerciseStyle != null ? this.exerciseStyle : (this.exerciseStyle = GenericExerciseStyle.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public List<? extends GenericProductFeature.GenericProductFeatureBuilder> getFeature() {
            return this.feature;
        }

        @Override
        public GenericProductFeature.GenericProductFeatureBuilder getOrCreateFeature(int index) {
            if (this.feature == null) {
                this.feature = new ArrayList<GenericProductFeature.GenericProductFeatureBuilder>();
            }
            return (GenericProductFeature.GenericProductFeatureBuilder)this.getIndex(this.feature, index, () -> {
                GenericProductFeature.GenericProductFeatureBuilder newFeature = GenericProductFeature.builder();
                return newFeature;
            });
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public RegulatoryReportingNonCDEOptionDetailsBuilder setOptionType(OptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public RegulatoryReportingNonCDEOptionDetailsBuilder addFirstExerciseDate(ZonedDateTime _firstExerciseDate) {
            if (_firstExerciseDate != null) {
                this.firstExerciseDate.add(_firstExerciseDate);
            }
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addFirstExerciseDate(ZonedDateTime _firstExerciseDate, int idx) {
            this.getIndex(this.firstExerciseDate, idx, () -> _firstExerciseDate);
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addFirstExerciseDate(List<ZonedDateTime> firstExerciseDates) {
            if (firstExerciseDates != null) {
                for (ZonedDateTime toAdd : firstExerciseDates) {
                    this.firstExerciseDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="firstExerciseDate")
        public RegulatoryReportingNonCDEOptionDetailsBuilder setFirstExerciseDate(List<ZonedDateTime> firstExerciseDates) {
            this.firstExerciseDate = firstExerciseDates == null ? new ArrayList<ZonedDateTime>() : (List)firstExerciseDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExpirationDate")
        @RuneAttribute(value="optionExpirationDate")
        public RegulatoryReportingNonCDEOptionDetailsBuilder addOptionExpirationDate(ZonedDateTime _optionExpirationDate) {
            if (_optionExpirationDate != null) {
                this.optionExpirationDate.add(_optionExpirationDate);
            }
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addOptionExpirationDate(ZonedDateTime _optionExpirationDate, int idx) {
            this.getIndex(this.optionExpirationDate, idx, () -> _optionExpirationDate);
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addOptionExpirationDate(List<ZonedDateTime> optionExpirationDates) {
            if (optionExpirationDates != null) {
                for (ZonedDateTime toAdd : optionExpirationDates) {
                    this.optionExpirationDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="optionExpirationDate")
        public RegulatoryReportingNonCDEOptionDetailsBuilder setOptionExpirationDate(List<ZonedDateTime> optionExpirationDates) {
            this.optionExpirationDate = optionExpirationDates == null ? new ArrayList<ZonedDateTime>() : (List)optionExpirationDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerMaturityDate")
        @RuneAttribute(value="underlyerMaturityDate")
        public RegulatoryReportingNonCDEOptionDetailsBuilder addUnderlyerMaturityDate(ZonedDateTime _underlyerMaturityDate) {
            if (_underlyerMaturityDate != null) {
                this.underlyerMaturityDate.add(_underlyerMaturityDate);
            }
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addUnderlyerMaturityDate(ZonedDateTime _underlyerMaturityDate, int idx) {
            this.getIndex(this.underlyerMaturityDate, idx, () -> _underlyerMaturityDate);
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addUnderlyerMaturityDate(List<ZonedDateTime> underlyerMaturityDates) {
            if (underlyerMaturityDates != null) {
                for (ZonedDateTime toAdd : underlyerMaturityDates) {
                    this.underlyerMaturityDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlyerMaturityDate")
        public RegulatoryReportingNonCDEOptionDetailsBuilder setUnderlyerMaturityDate(List<ZonedDateTime> underlyerMaturityDates) {
            this.underlyerMaturityDate = underlyerMaturityDates == null ? new ArrayList<ZonedDateTime>() : (List)underlyerMaturityDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public RegulatoryReportingNonCDEOptionDetailsBuilder setExerciseStyle(GenericExerciseStyle _exerciseStyle) {
            this.exerciseStyle = _exerciseStyle == null ? null : _exerciseStyle.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public RegulatoryReportingNonCDEOptionDetailsBuilder addFeature(GenericProductFeature _feature) {
            if (_feature != null) {
                this.feature.add(_feature.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addFeature(GenericProductFeature _feature, int idx) {
            this.getIndex(this.feature, idx, () -> _feature.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder addFeature(List<? extends GenericProductFeature> features) {
            if (features != null) {
                for (GenericProductFeature genericProductFeature : features) {
                    this.feature.add(genericProductFeature.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="feature")
        public RegulatoryReportingNonCDEOptionDetailsBuilder setFeature(List<? extends GenericProductFeature> features) {
            this.feature = features == null ? new ArrayList<GenericProductFeature.GenericProductFeatureBuilder>() : (List)features.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetails build() {
            return new RegulatoryReportingNonCDEOptionDetailsImpl(this);
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder prune() {
            if (this.exerciseStyle != null && !this.exerciseStyle.prune().hasData()) {
                this.exerciseStyle = null;
            }
            this.feature = this.feature.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getFirstExerciseDate() != null && !this.getFirstExerciseDate().isEmpty()) {
                return true;
            }
            if (this.getOptionExpirationDate() != null && !this.getOptionExpirationDate().isEmpty()) {
                return true;
            }
            if (this.getUnderlyerMaturityDate() != null && !this.getUnderlyerMaturityDate().isEmpty()) {
                return true;
            }
            if (this.getExerciseStyle() != null && this.getExerciseStyle().hasData()) {
                return true;
            }
            return this.getFeature() != null && this.getFeature().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RegulatoryReportingNonCDEOptionDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegulatoryReportingNonCDEOptionDetailsBuilder o = (RegulatoryReportingNonCDEOptionDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseStyle(), (RosettaModelObjectBuilder)o.getExerciseStyle(), this::setExerciseStyle);
            merger.mergeRosetta(this.getFeature(), o.getFeature(), this::getOrCreateFeature);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic(this.getFirstExerciseDate(), o.getFirstExerciseDate(), this::addFirstExerciseDate);
            merger.mergeBasic(this.getOptionExpirationDate(), o.getOptionExpirationDate(), this::addOptionExpirationDate);
            merger.mergeBasic(this.getUnderlyerMaturityDate(), o.getUnderlyerMaturityDate(), this::addUnderlyerMaturityDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingNonCDEOptionDetails _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionExpirationDate, _that.getOptionExpirationDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyerMaturityDate, _that.getUnderlyerMaturityDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseStyle, _that.getExerciseStyle())) {
                return false;
            }
            return ListEquals.listEquals(this.feature, _that.getFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.optionExpirationDate != null ? this.optionExpirationDate.hashCode() : 0);
            _result = 31 * _result + (this.underlyerMaturityDate != null ? this.underlyerMaturityDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseStyle != null ? this.exerciseStyle.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingNonCDEOptionDetailsBuilder {optionType=" + String.valueOf((Object)this.optionType) + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", optionExpirationDate=" + String.valueOf(this.optionExpirationDate) + ", underlyerMaturityDate=" + String.valueOf(this.underlyerMaturityDate) + ", exerciseStyle=" + String.valueOf(this.exerciseStyle) + ", feature=" + String.valueOf(this.feature) + "}";
        }
    }

    public static interface RegulatoryReportingNonCDEOptionDetailsBuilder
    extends RegulatoryReportingNonCDEOptionDetails,
    RosettaModelObjectBuilder {
        public GenericExerciseStyle.GenericExerciseStyleBuilder getOrCreateExerciseStyle();

        @Override
        public GenericExerciseStyle.GenericExerciseStyleBuilder getExerciseStyle();

        public GenericProductFeature.GenericProductFeatureBuilder getOrCreateFeature(int var1);

        public List<? extends GenericProductFeature.GenericProductFeatureBuilder> getFeature();

        public RegulatoryReportingNonCDEOptionDetailsBuilder setOptionType(OptionTypeEnum var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addFirstExerciseDate(ZonedDateTime var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addFirstExerciseDate(ZonedDateTime var1, int var2);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addFirstExerciseDate(List<ZonedDateTime> var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder setFirstExerciseDate(List<ZonedDateTime> var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addOptionExpirationDate(ZonedDateTime var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addOptionExpirationDate(ZonedDateTime var1, int var2);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addOptionExpirationDate(List<ZonedDateTime> var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder setOptionExpirationDate(List<ZonedDateTime> var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addUnderlyerMaturityDate(ZonedDateTime var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addUnderlyerMaturityDate(ZonedDateTime var1, int var2);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addUnderlyerMaturityDate(List<ZonedDateTime> var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder setUnderlyerMaturityDate(List<ZonedDateTime> var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder setExerciseStyle(GenericExerciseStyle var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addFeature(GenericProductFeature var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addFeature(GenericProductFeature var1, int var2);

        public RegulatoryReportingNonCDEOptionDetailsBuilder addFeature(List<? extends GenericProductFeature> var1);

        public RegulatoryReportingNonCDEOptionDetailsBuilder setFeature(List<? extends GenericProductFeature> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), ZonedDateTime.class, this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionExpirationDate"), ZonedDateTime.class, this.getOptionExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyerMaturityDate"), ZonedDateTime.class, this.getUnderlyerMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseStyle"), processor, GenericExerciseStyle.GenericExerciseStyleBuilder.class, this.getExerciseStyle(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feature"), processor, GenericProductFeature.GenericProductFeatureBuilder.class, this.getFeature(), new AttributeMeta[0]);
        }

        public RegulatoryReportingNonCDEOptionDetailsBuilder prune();
    }

    public static class RegulatoryReportingNonCDEOptionDetailsImpl
    implements RegulatoryReportingNonCDEOptionDetails {
        private final OptionTypeEnum optionType;
        private final List<ZonedDateTime> firstExerciseDate;
        private final List<ZonedDateTime> optionExpirationDate;
        private final List<ZonedDateTime> underlyerMaturityDate;
        private final GenericExerciseStyle exerciseStyle;
        private final List<? extends GenericProductFeature> feature;

        protected RegulatoryReportingNonCDEOptionDetailsImpl(RegulatoryReportingNonCDEOptionDetailsBuilder builder) {
            this.optionType = builder.getOptionType();
            this.firstExerciseDate = Optional.ofNullable(builder.getFirstExerciseDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.optionExpirationDate = Optional.ofNullable(builder.getOptionExpirationDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.underlyerMaturityDate = Optional.ofNullable(builder.getUnderlyerMaturityDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.exerciseStyle = Optional.ofNullable(builder.getExerciseStyle()).map(f -> f.build()).orElse(null);
            this.feature = Optional.ofNullable(builder.getFeature()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public List<ZonedDateTime> getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="optionExpirationDate")
        @RuneAttribute(value="optionExpirationDate")
        public List<ZonedDateTime> getOptionExpirationDate() {
            return this.optionExpirationDate;
        }

        @Override
        @RosettaAttribute(value="underlyerMaturityDate")
        @RuneAttribute(value="underlyerMaturityDate")
        public List<ZonedDateTime> getUnderlyerMaturityDate() {
            return this.underlyerMaturityDate;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public GenericExerciseStyle getExerciseStyle() {
            return this.exerciseStyle;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public List<? extends GenericProductFeature> getFeature() {
            return this.feature;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetails build() {
            return this;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetailsBuilder toBuilder() {
            RegulatoryReportingNonCDEOptionDetailsBuilder builder = RegulatoryReportingNonCDEOptionDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryReportingNonCDEOptionDetailsBuilder builder) {
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getFirstExerciseDate()).ifPresent(builder::setFirstExerciseDate);
            Optional.ofNullable(this.getOptionExpirationDate()).ifPresent(builder::setOptionExpirationDate);
            Optional.ofNullable(this.getUnderlyerMaturityDate()).ifPresent(builder::setUnderlyerMaturityDate);
            Optional.ofNullable(this.getExerciseStyle()).ifPresent(builder::setExerciseStyle);
            Optional.ofNullable(this.getFeature()).ifPresent(builder::setFeature);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingNonCDEOptionDetails _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.optionExpirationDate, _that.getOptionExpirationDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyerMaturityDate, _that.getUnderlyerMaturityDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseStyle, _that.getExerciseStyle())) {
                return false;
            }
            return ListEquals.listEquals(this.feature, _that.getFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.optionExpirationDate != null ? this.optionExpirationDate.hashCode() : 0);
            _result = 31 * _result + (this.underlyerMaturityDate != null ? this.underlyerMaturityDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseStyle != null ? this.exerciseStyle.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingNonCDEOptionDetails {optionType=" + String.valueOf((Object)this.optionType) + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", optionExpirationDate=" + String.valueOf(this.optionExpirationDate) + ", underlyerMaturityDate=" + String.valueOf(this.underlyerMaturityDate) + ", exerciseStyle=" + String.valueOf(this.exerciseStyle) + ", feature=" + String.valueOf(this.feature) + "}";
        }
    }
}

