/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.recordkeeping.processes.ESMAProductUnderlyerSequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ESMAProductUnderlyerSequenceChoice")
@ImplementedBy(value=Default.class)
public interface ESMAProductUnderlyerSequenceChoice
extends Validator<ESMAProductUnderlyerSequence> {
    public static final String NAME = "ESMAProductUnderlyerSequenceChoice";
    public static final String DEFINITION = "required choice instrumentId, index";

    public static class NoOp
    implements ESMAProductUnderlyerSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAProductUnderlyerSequence eSMAProductUnderlyerSequence) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAProductUnderlyerSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAProductUnderlyerSequence eSMAProductUnderlyerSequence) {
            ComparisonResult result = this.executeDataRule(eSMAProductUnderlyerSequence);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAProductUnderlyerSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAProductUnderlyerSequence", (RosettaPath)path, (String)ESMAProductUnderlyerSequenceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAProductUnderlyerSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAProductUnderlyerSequence", (RosettaPath)path, (String)ESMAProductUnderlyerSequenceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAProductUnderlyerSequence eSMAProductUnderlyerSequence) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)eSMAProductUnderlyerSequence), Arrays.asList("instrumentId", "index"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

