/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.AdditionalData;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.msg.Message;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.recordkeeping.processes.meta.RegulatoryReportingAcknowledgementMeta;
import fpml.consolidated.reg.fpmlreporting.shared.ReportingStatus;
import fpml.consolidated.shared.Party;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryReportingAcknowledgement", builder=RegulatoryReportingAcknowledgementBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryReportingAcknowledgement", model="fpml", builder=RegulatoryReportingAcknowledgementBuilderImpl.class, version="1.2.2")
public interface RegulatoryReportingAcknowledgement
extends Message {
    public static final RegulatoryReportingAcknowledgementMeta metaData = new RegulatoryReportingAcknowledgementMeta();

    public ResponseMessageHeader getHeader();

    public PartyTradeIdentifier getTradeIdentifier();

    public List<? extends ReportingStatus> getReportingStatus();

    public AdditionalData getAdditionalData();

    public List<? extends Party> getParty();

    @Override
    public RegulatoryReportingAcknowledgement build();

    @Override
    public RegulatoryReportingAcknowledgementBuilder toBuilder();

    public static RegulatoryReportingAcknowledgementBuilder builder() {
        return new RegulatoryReportingAcknowledgementBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryReportingAcknowledgement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryReportingAcknowledgement> getType() {
        return RegulatoryReportingAcknowledgement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingStatus"), processor, ReportingStatus.class, this.getReportingStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalData"), processor, AdditionalData.class, this.getAdditionalData(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class RegulatoryReportingAcknowledgementBuilderImpl
    extends Message.MessageBuilderImpl
    implements RegulatoryReportingAcknowledgementBuilder {
        protected ResponseMessageHeader.ResponseMessageHeaderBuilder header;
        protected PartyTradeIdentifier.PartyTradeIdentifierBuilder tradeIdentifier;
        protected List<ReportingStatus.ReportingStatusBuilder> reportingStatus = new ArrayList<ReportingStatus.ReportingStatusBuilder>();
        protected AdditionalData.AdditionalDataBuilder additionalData;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getHeader() {
            return this.header;
        }

        @Override
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getOrCreateHeader() {
            ResponseMessageHeader.ResponseMessageHeaderBuilder result = this.header != null ? this.header : (this.header = ResponseMessageHeader.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier() {
            PartyTradeIdentifier.PartyTradeIdentifierBuilder result = this.tradeIdentifier != null ? this.tradeIdentifier : (this.tradeIdentifier = PartyTradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingStatus")
        @RuneAttribute(value="reportingStatus")
        public List<? extends ReportingStatus.ReportingStatusBuilder> getReportingStatus() {
            return this.reportingStatus;
        }

        @Override
        public ReportingStatus.ReportingStatusBuilder getOrCreateReportingStatus(int index) {
            if (this.reportingStatus == null) {
                this.reportingStatus = new ArrayList<ReportingStatus.ReportingStatusBuilder>();
            }
            return (ReportingStatus.ReportingStatusBuilder)this.getIndex(this.reportingStatus, index, () -> {
                ReportingStatus.ReportingStatusBuilder newReportingStatus = ReportingStatus.builder();
                return newReportingStatus;
            });
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public AdditionalData.AdditionalDataBuilder getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public AdditionalData.AdditionalDataBuilder getOrCreateAdditionalData() {
            AdditionalData.AdditionalDataBuilder result = this.additionalData != null ? this.additionalData : (this.additionalData = AdditionalData.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RegulatoryReportingAcknowledgementBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RegulatoryReportingAcknowledgementBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RegulatoryReportingAcknowledgementBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RegulatoryReportingAcknowledgementBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public RegulatoryReportingAcknowledgementBuilder setTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            this.tradeIdentifier = _tradeIdentifier == null ? null : _tradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingStatus")
        @RuneAttribute(value="reportingStatus")
        public RegulatoryReportingAcknowledgementBuilder addReportingStatus(ReportingStatus _reportingStatus) {
            if (_reportingStatus != null) {
                this.reportingStatus.add(_reportingStatus.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder addReportingStatus(ReportingStatus _reportingStatus, int idx) {
            this.getIndex(this.reportingStatus, idx, () -> _reportingStatus.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder addReportingStatus(List<? extends ReportingStatus> reportingStatuss) {
            if (reportingStatuss != null) {
                for (ReportingStatus reportingStatus : reportingStatuss) {
                    this.reportingStatus.add(reportingStatus.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reportingStatus")
        public RegulatoryReportingAcknowledgementBuilder setReportingStatus(List<? extends ReportingStatus> reportingStatuss) {
            this.reportingStatus = reportingStatuss == null ? new ArrayList<ReportingStatus.ReportingStatusBuilder>() : (List)reportingStatuss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public RegulatoryReportingAcknowledgementBuilder setAdditionalData(AdditionalData _additionalData) {
            this.additionalData = _additionalData == null ? null : _additionalData.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public RegulatoryReportingAcknowledgementBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public RegulatoryReportingAcknowledgementBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegulatoryReportingAcknowledgement build() {
            return new RegulatoryReportingAcknowledgementImpl(this);
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder prune() {
            super.prune();
            if (this.header != null && !this.header.prune().hasData()) {
                this.header = null;
            }
            if (this.tradeIdentifier != null && !this.tradeIdentifier.prune().hasData()) {
                this.tradeIdentifier = null;
            }
            this.reportingStatus = this.reportingStatus.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.additionalData != null && !this.additionalData.prune().hasData()) {
                this.additionalData = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getHeader() != null && this.getHeader().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getReportingStatus() != null && this.getReportingStatus().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAdditionalData() != null && this.getAdditionalData().hasData()) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryReportingAcknowledgementBuilder o = (RegulatoryReportingAcknowledgementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getHeader(), (RosettaModelObjectBuilder)o.getHeader(), this::setHeader);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeIdentifier(), (RosettaModelObjectBuilder)o.getTradeIdentifier(), this::setTradeIdentifier);
            merger.mergeRosetta(this.getReportingStatus(), o.getReportingStatus(), this::getOrCreateReportingStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalData(), (RosettaModelObjectBuilder)o.getAdditionalData(), this::setAdditionalData);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryReportingAcknowledgement _that = (RegulatoryReportingAcknowledgement)this.getType().cast(o);
            if (!Objects.equals(this.header, _that.getHeader())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingStatus, _that.getReportingStatus())) {
                return false;
            }
            if (!Objects.equals(this.additionalData, _that.getAdditionalData())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.header != null ? this.header.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.reportingStatus != null ? this.reportingStatus.hashCode() : 0);
            _result = 31 * _result + (this.additionalData != null ? this.additionalData.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryReportingAcknowledgementBuilder {header=" + String.valueOf(this.header) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", reportingStatus=" + String.valueOf(this.reportingStatus) + ", additionalData=" + String.valueOf(this.additionalData) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface RegulatoryReportingAcknowledgementBuilder
    extends RegulatoryReportingAcknowledgement,
    Message.MessageBuilder {
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getOrCreateHeader();

        @Override
        public ResponseMessageHeader.ResponseMessageHeaderBuilder getHeader();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier();

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier();

        public ReportingStatus.ReportingStatusBuilder getOrCreateReportingStatus(int var1);

        public List<? extends ReportingStatus.ReportingStatusBuilder> getReportingStatus();

        public AdditionalData.AdditionalDataBuilder getOrCreateAdditionalData();

        @Override
        public AdditionalData.AdditionalDataBuilder getAdditionalData();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public RegulatoryReportingAcknowledgementBuilder setFpmlVersion(String var1);

        @Override
        public RegulatoryReportingAcknowledgementBuilder setExpectedBuild(Integer var1);

        @Override
        public RegulatoryReportingAcknowledgementBuilder setActualBuild(Integer var1);

        public RegulatoryReportingAcknowledgementBuilder setHeader(ResponseMessageHeader var1);

        public RegulatoryReportingAcknowledgementBuilder setTradeIdentifier(PartyTradeIdentifier var1);

        public RegulatoryReportingAcknowledgementBuilder addReportingStatus(ReportingStatus var1);

        public RegulatoryReportingAcknowledgementBuilder addReportingStatus(ReportingStatus var1, int var2);

        public RegulatoryReportingAcknowledgementBuilder addReportingStatus(List<? extends ReportingStatus> var1);

        public RegulatoryReportingAcknowledgementBuilder setReportingStatus(List<? extends ReportingStatus> var1);

        public RegulatoryReportingAcknowledgementBuilder setAdditionalData(AdditionalData var1);

        public RegulatoryReportingAcknowledgementBuilder addParty(Party var1);

        public RegulatoryReportingAcknowledgementBuilder addParty(Party var1, int var2);

        public RegulatoryReportingAcknowledgementBuilder addParty(List<? extends Party> var1);

        public RegulatoryReportingAcknowledgementBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingStatus"), processor, ReportingStatus.ReportingStatusBuilder.class, this.getReportingStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalData"), processor, AdditionalData.AdditionalDataBuilder.class, this.getAdditionalData(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder prune();
    }

    public static class RegulatoryReportingAcknowledgementImpl
    extends Message.MessageImpl
    implements RegulatoryReportingAcknowledgement {
        private final ResponseMessageHeader header;
        private final PartyTradeIdentifier tradeIdentifier;
        private final List<? extends ReportingStatus> reportingStatus;
        private final AdditionalData additionalData;
        private final List<? extends Party> party;

        protected RegulatoryReportingAcknowledgementImpl(RegulatoryReportingAcknowledgementBuilder builder) {
            super(builder);
            this.header = Optional.ofNullable(builder.getHeader()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.reportingStatus = Optional.ofNullable(builder.getReportingStatus()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.additionalData = Optional.ofNullable(builder.getAdditionalData()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ResponseMessageHeader getHeader() {
            return this.header;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="reportingStatus")
        @RuneAttribute(value="reportingStatus")
        public List<? extends ReportingStatus> getReportingStatus() {
            return this.reportingStatus;
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public AdditionalData getAdditionalData() {
            return this.additionalData;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public RegulatoryReportingAcknowledgement build() {
            return this;
        }

        @Override
        public RegulatoryReportingAcknowledgementBuilder toBuilder() {
            RegulatoryReportingAcknowledgementBuilder builder = RegulatoryReportingAcknowledgement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryReportingAcknowledgementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getHeader()).ifPresent(builder::setHeader);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getReportingStatus()).ifPresent(builder::setReportingStatus);
            Optional.ofNullable(this.getAdditionalData()).ifPresent(builder::setAdditionalData);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryReportingAcknowledgement _that = (RegulatoryReportingAcknowledgement)this.getType().cast(o);
            if (!Objects.equals(this.header, _that.getHeader())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingStatus, _that.getReportingStatus())) {
                return false;
            }
            if (!Objects.equals(this.additionalData, _that.getAdditionalData())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.header != null ? this.header.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.reportingStatus != null ? this.reportingStatus.hashCode() : 0);
            _result = 31 * _result + (this.additionalData != null ? this.additionalData.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryReportingAcknowledgement {header=" + String.valueOf(this.header) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", reportingStatus=" + String.valueOf(this.reportingStatus) + ", additionalData=" + String.valueOf(this.additionalData) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

