/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.option.shared.OptionNumericStrike;
import fpml.consolidated.option.shared.meta.OptionStrikeMeta;
import fpml.consolidated.shared.Currency;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="OptionStrike", builder=OptionStrikeBuilderImpl.class, version="1.2.2")
@RuneDataType(value="OptionStrike", model="fpml", builder=OptionStrikeBuilderImpl.class, version="1.2.2")
public interface OptionStrike
extends OptionNumericStrike {
    public static final OptionStrikeMeta metaData = new OptionStrikeMeta();

    public Currency getCurrency();

    @Override
    public OptionStrike build();

    @Override
    public OptionStrikeBuilder toBuilder();

    public static OptionStrikeBuilder builder() {
        return new OptionStrikeBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionStrike> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionStrike> getType() {
        return OptionStrike.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, (Object)this.getStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePercentage"), BigDecimal.class, (Object)this.getStrikePercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class OptionStrikeBuilderImpl
    extends OptionNumericStrike.OptionNumericStrikeBuilderImpl
    implements OptionStrikeBuilder {
        protected Currency.CurrencyBuilder currency;

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public OptionStrikeBuilder setStrikePrice(BigDecimal _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePercentage")
        @RuneAttribute(value="strikePercentage")
        public OptionStrikeBuilder setStrikePercentage(BigDecimal _strikePercentage) {
            this.strikePercentage = _strikePercentage == null ? null : _strikePercentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public OptionStrikeBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        public OptionStrike build() {
            return new OptionStrikeImpl(this);
        }

        @Override
        public OptionStrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionStrikeBuilder prune() {
            super.prune();
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getCurrency() != null && this.getCurrency().hasData();
        }

        @Override
        public OptionStrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionStrikeBuilder o = (OptionStrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionStrike _that = (OptionStrike)this.getType().cast(o);
            return Objects.equals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionStrikeBuilder {currency=" + String.valueOf(this.currency) + "} " + super.toString();
        }
    }

    public static interface OptionStrikeBuilder
    extends OptionStrike,
    OptionNumericStrike.OptionNumericStrikeBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        @Override
        public OptionStrikeBuilder setStrikePrice(BigDecimal var1);

        @Override
        public OptionStrikeBuilder setStrikePercentage(BigDecimal var1);

        public OptionStrikeBuilder setCurrency(Currency var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, (Object)this.getStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePercentage"), BigDecimal.class, (Object)this.getStrikePercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        @Override
        public OptionStrikeBuilder prune();
    }

    public static class OptionStrikeImpl
    extends OptionNumericStrike.OptionNumericStrikeImpl
    implements OptionStrike {
        private final Currency currency;

        protected OptionStrikeImpl(OptionStrikeBuilder builder) {
            super(builder);
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        public OptionStrike build() {
            return this;
        }

        @Override
        public OptionStrikeBuilder toBuilder() {
            OptionStrikeBuilder builder = OptionStrike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionStrikeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionStrike _that = (OptionStrike)this.getType().cast(o);
            return Objects.equals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionStrike {currency=" + String.valueOf(this.currency) + "} " + super.toString();
        }
    }
}

