/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.option.shared.meta.OptionDenominationModelMeta;
import fpml.consolidated.shared.Currency;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="OptionDenominationModel", builder=OptionDenominationModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="OptionDenominationModel", model="fpml", builder=OptionDenominationModelBuilderImpl.class, version="1.2.2")
public interface OptionDenominationModel
extends RosettaModelObject {
    public static final OptionDenominationModelMeta metaData = new OptionDenominationModelMeta();

    public BigDecimal getOptionEntitlement();

    public Currency getEntitlementCurrency();

    public BigDecimal getNumberOfOptions();

    public OptionDenominationModel build();

    public OptionDenominationModelBuilder toBuilder();

    public static OptionDenominationModelBuilder builder() {
        return new OptionDenominationModelBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionDenominationModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionDenominationModel> getType() {
        return OptionDenominationModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, (Object)this.getOptionEntitlement(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("entitlementCurrency"), processor, Currency.class, this.getEntitlementCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class OptionDenominationModelBuilderImpl
    implements OptionDenominationModelBuilder {
        protected BigDecimal optionEntitlement;
        protected Currency.CurrencyBuilder entitlementCurrency;
        protected BigDecimal numberOfOptions;

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public BigDecimal getOptionEntitlement() {
            return this.optionEntitlement;
        }

        @Override
        @RosettaAttribute(value="entitlementCurrency")
        @RuneAttribute(value="entitlementCurrency")
        public Currency.CurrencyBuilder getEntitlementCurrency() {
            return this.entitlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateEntitlementCurrency() {
            Currency.CurrencyBuilder result = this.entitlementCurrency != null ? this.entitlementCurrency : (this.entitlementCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public BigDecimal getNumberOfOptions() {
            return this.numberOfOptions;
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public OptionDenominationModelBuilder setOptionEntitlement(BigDecimal _optionEntitlement) {
            this.optionEntitlement = _optionEntitlement == null ? null : _optionEntitlement;
            return this;
        }

        @Override
        @RosettaAttribute(value="entitlementCurrency")
        @RuneAttribute(value="entitlementCurrency")
        public OptionDenominationModelBuilder setEntitlementCurrency(Currency _entitlementCurrency) {
            this.entitlementCurrency = _entitlementCurrency == null ? null : _entitlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public OptionDenominationModelBuilder setNumberOfOptions(BigDecimal _numberOfOptions) {
            this.numberOfOptions = _numberOfOptions == null ? null : _numberOfOptions;
            return this;
        }

        @Override
        public OptionDenominationModel build() {
            return new OptionDenominationModelImpl(this);
        }

        @Override
        public OptionDenominationModelBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionDenominationModelBuilder prune() {
            if (this.entitlementCurrency != null && !this.entitlementCurrency.prune().hasData()) {
                this.entitlementCurrency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getOptionEntitlement() != null) {
                return true;
            }
            if (this.getEntitlementCurrency() != null && this.getEntitlementCurrency().hasData()) {
                return true;
            }
            return this.getNumberOfOptions() != null;
        }

        public OptionDenominationModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OptionDenominationModelBuilder o = (OptionDenominationModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEntitlementCurrency(), (RosettaModelObjectBuilder)o.getEntitlementCurrency(), this::setEntitlementCurrency);
            merger.mergeBasic((Object)this.getOptionEntitlement(), (Object)o.getOptionEntitlement(), this::setOptionEntitlement, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfOptions(), (Object)o.getNumberOfOptions(), this::setNumberOfOptions, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionDenominationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.optionEntitlement, _that.getOptionEntitlement())) {
                return false;
            }
            if (!Objects.equals(this.entitlementCurrency, _that.getEntitlementCurrency())) {
                return false;
            }
            return Objects.equals(this.numberOfOptions, _that.getNumberOfOptions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionEntitlement != null ? this.optionEntitlement.hashCode() : 0);
            _result = 31 * _result + (this.entitlementCurrency != null ? this.entitlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.numberOfOptions != null ? this.numberOfOptions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionDenominationModelBuilder {optionEntitlement=" + String.valueOf(this.optionEntitlement) + ", entitlementCurrency=" + String.valueOf(this.entitlementCurrency) + ", numberOfOptions=" + String.valueOf(this.numberOfOptions) + "}";
        }
    }

    public static interface OptionDenominationModelBuilder
    extends OptionDenominationModel,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateEntitlementCurrency();

        @Override
        public Currency.CurrencyBuilder getEntitlementCurrency();

        public OptionDenominationModelBuilder setOptionEntitlement(BigDecimal var1);

        public OptionDenominationModelBuilder setEntitlementCurrency(Currency var1);

        public OptionDenominationModelBuilder setNumberOfOptions(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, (Object)this.getOptionEntitlement(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("entitlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getEntitlementCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public OptionDenominationModelBuilder prune();
    }

    public static class OptionDenominationModelImpl
    implements OptionDenominationModel {
        private final BigDecimal optionEntitlement;
        private final Currency entitlementCurrency;
        private final BigDecimal numberOfOptions;

        protected OptionDenominationModelImpl(OptionDenominationModelBuilder builder) {
            this.optionEntitlement = builder.getOptionEntitlement();
            this.entitlementCurrency = Optional.ofNullable(builder.getEntitlementCurrency()).map(f -> f.build()).orElse(null);
            this.numberOfOptions = builder.getNumberOfOptions();
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public BigDecimal getOptionEntitlement() {
            return this.optionEntitlement;
        }

        @Override
        @RosettaAttribute(value="entitlementCurrency")
        @RuneAttribute(value="entitlementCurrency")
        public Currency getEntitlementCurrency() {
            return this.entitlementCurrency;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public BigDecimal getNumberOfOptions() {
            return this.numberOfOptions;
        }

        @Override
        public OptionDenominationModel build() {
            return this;
        }

        @Override
        public OptionDenominationModelBuilder toBuilder() {
            OptionDenominationModelBuilder builder = OptionDenominationModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionDenominationModelBuilder builder) {
            Optional.ofNullable(this.getOptionEntitlement()).ifPresent(builder::setOptionEntitlement);
            Optional.ofNullable(this.getEntitlementCurrency()).ifPresent(builder::setEntitlementCurrency);
            Optional.ofNullable(this.getNumberOfOptions()).ifPresent(builder::setNumberOfOptions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionDenominationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.optionEntitlement, _that.getOptionEntitlement())) {
                return false;
            }
            if (!Objects.equals(this.entitlementCurrency, _that.getEntitlementCurrency())) {
                return false;
            }
            return Objects.equals(this.numberOfOptions, _that.getNumberOfOptions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionEntitlement != null ? this.optionEntitlement.hashCode() : 0);
            _result = 31 * _result + (this.entitlementCurrency != null ? this.entitlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.numberOfOptions != null ? this.numberOfOptions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionDenominationModel {optionEntitlement=" + String.valueOf(this.optionEntitlement) + ", entitlementCurrency=" + String.valueOf(this.entitlementCurrency) + ", numberOfOptions=" + String.valueOf(this.numberOfOptions) + "}";
        }
    }
}

