/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.option.shared.meta.OptionMeta;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Option", builder=OptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Option", model="fpml", builder=OptionBuilderImpl.class, version="1.2.2")
public interface Option
extends Product {
    public static final OptionMeta metaData = new OptionMeta();

    public BuyerSellerModel getBuyerSellerModel();

    @Override
    public Option build();

    @Override
    public OptionBuilder toBuilder();

    public static OptionBuilder builder() {
        return new OptionBuilderImpl();
    }

    default public RosettaMetaData<? extends Option> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Option> getType() {
        return Option.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
    }

    public static class OptionBuilderImpl
    extends Product.ProductBuilderImpl
    implements OptionBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public OptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public OptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public OptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        public Option build() {
            return new OptionImpl(this);
        }

        @Override
        public OptionBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData();
        }

        @Override
        public OptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionBuilder o = (OptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Option _that = (Option)this.getType().cast(o);
            return Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + "} " + super.toString();
        }
    }

    public static interface OptionBuilder
    extends Option,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        @Override
        public OptionBuilder setProductModel(ProductModel var1);

        @Override
        public OptionBuilder setId(String var1);

        public OptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        }

        @Override
        public OptionBuilder prune();
    }

    public static class OptionImpl
    extends Product.ProductImpl
    implements Option {
        private final BuyerSellerModel buyerSellerModel;

        protected OptionImpl(OptionBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public Option build() {
            return this;
        }

        @Override
        public OptionBuilder toBuilder() {
            OptionBuilder builder = Option.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Option _that = (Option)this.getType().cast(o);
            return Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Option {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + "} " + super.toString();
        }
    }
}

