/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.LenderClassification;
import fpml.consolidated.loan.TransferFeeDefinitionChoice;
import fpml.consolidated.loan.meta.TransferFeeDefinitionMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TransferFeeDefinition", builder=TransferFeeDefinitionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TransferFeeDefinition", model="fpml", builder=TransferFeeDefinitionBuilderImpl.class, version="1.2.2")
public interface TransferFeeDefinition
extends RosettaModelObject {
    public static final TransferFeeDefinitionMeta metaData = new TransferFeeDefinitionMeta();

    public NonNegativeMoney getAmount();

    public List<? extends TransferFeeDefinitionChoice> getTransferFeeDefinitionChoice();

    public List<? extends LenderClassification> getLenderTypeWaived();

    public TransferFeeDefinition build();

    public TransferFeeDefinitionBuilder toBuilder();

    public static TransferFeeDefinitionBuilder builder() {
        return new TransferFeeDefinitionBuilderImpl();
    }

    default public RosettaMetaData<? extends TransferFeeDefinition> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TransferFeeDefinition> getType() {
        return TransferFeeDefinition.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transferFeeDefinitionChoice"), processor, TransferFeeDefinitionChoice.class, this.getTransferFeeDefinitionChoice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderTypeWaived"), processor, LenderClassification.class, this.getLenderTypeWaived(), new AttributeMeta[0]);
    }

    public static class TransferFeeDefinitionBuilderImpl
    implements TransferFeeDefinitionBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected List<TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder> transferFeeDefinitionChoice = new ArrayList<TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder>();
        protected List<LenderClassification.LenderClassificationBuilder> lenderTypeWaived = new ArrayList<LenderClassification.LenderClassificationBuilder>();

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="transferFeeDefinitionChoice")
        @RuneAttribute(value="transferFeeDefinitionChoice")
        public List<? extends TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder> getTransferFeeDefinitionChoice() {
            return this.transferFeeDefinitionChoice;
        }

        @Override
        public TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder getOrCreateTransferFeeDefinitionChoice(int index) {
            if (this.transferFeeDefinitionChoice == null) {
                this.transferFeeDefinitionChoice = new ArrayList<TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder>();
            }
            return (TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder)this.getIndex(this.transferFeeDefinitionChoice, index, () -> {
                TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder newTransferFeeDefinitionChoice = TransferFeeDefinitionChoice.builder();
                return newTransferFeeDefinitionChoice;
            });
        }

        @Override
        @RosettaAttribute(value="lenderTypeWaived")
        @RuneAttribute(value="lenderTypeWaived")
        public List<? extends LenderClassification.LenderClassificationBuilder> getLenderTypeWaived() {
            return this.lenderTypeWaived;
        }

        @Override
        public LenderClassification.LenderClassificationBuilder getOrCreateLenderTypeWaived(int index) {
            if (this.lenderTypeWaived == null) {
                this.lenderTypeWaived = new ArrayList<LenderClassification.LenderClassificationBuilder>();
            }
            return (LenderClassification.LenderClassificationBuilder)this.getIndex(this.lenderTypeWaived, index, () -> {
                LenderClassification.LenderClassificationBuilder newLenderTypeWaived = LenderClassification.builder();
                return newLenderTypeWaived;
            });
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public TransferFeeDefinitionBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="transferFeeDefinitionChoice")
        @RuneAttribute(value="transferFeeDefinitionChoice")
        public TransferFeeDefinitionBuilder addTransferFeeDefinitionChoice(TransferFeeDefinitionChoice _transferFeeDefinitionChoice) {
            if (_transferFeeDefinitionChoice != null) {
                this.transferFeeDefinitionChoice.add(_transferFeeDefinitionChoice.toBuilder());
            }
            return this;
        }

        @Override
        public TransferFeeDefinitionBuilder addTransferFeeDefinitionChoice(TransferFeeDefinitionChoice _transferFeeDefinitionChoice, int idx) {
            this.getIndex(this.transferFeeDefinitionChoice, idx, () -> _transferFeeDefinitionChoice.toBuilder());
            return this;
        }

        @Override
        public TransferFeeDefinitionBuilder addTransferFeeDefinitionChoice(List<? extends TransferFeeDefinitionChoice> transferFeeDefinitionChoices) {
            if (transferFeeDefinitionChoices != null) {
                for (TransferFeeDefinitionChoice transferFeeDefinitionChoice : transferFeeDefinitionChoices) {
                    this.transferFeeDefinitionChoice.add(transferFeeDefinitionChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="transferFeeDefinitionChoice")
        public TransferFeeDefinitionBuilder setTransferFeeDefinitionChoice(List<? extends TransferFeeDefinitionChoice> transferFeeDefinitionChoices) {
            this.transferFeeDefinitionChoice = transferFeeDefinitionChoices == null ? new ArrayList<TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder>() : (List)transferFeeDefinitionChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderTypeWaived")
        @RuneAttribute(value="lenderTypeWaived")
        public TransferFeeDefinitionBuilder addLenderTypeWaived(LenderClassification _lenderTypeWaived) {
            if (_lenderTypeWaived != null) {
                this.lenderTypeWaived.add(_lenderTypeWaived.toBuilder());
            }
            return this;
        }

        @Override
        public TransferFeeDefinitionBuilder addLenderTypeWaived(LenderClassification _lenderTypeWaived, int idx) {
            this.getIndex(this.lenderTypeWaived, idx, () -> _lenderTypeWaived.toBuilder());
            return this;
        }

        @Override
        public TransferFeeDefinitionBuilder addLenderTypeWaived(List<? extends LenderClassification> lenderTypeWaiveds) {
            if (lenderTypeWaiveds != null) {
                for (LenderClassification lenderClassification : lenderTypeWaiveds) {
                    this.lenderTypeWaived.add(lenderClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="lenderTypeWaived")
        public TransferFeeDefinitionBuilder setLenderTypeWaived(List<? extends LenderClassification> lenderTypeWaiveds) {
            this.lenderTypeWaived = lenderTypeWaiveds == null ? new ArrayList<LenderClassification.LenderClassificationBuilder>() : (List)lenderTypeWaiveds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TransferFeeDefinition build() {
            return new TransferFeeDefinitionImpl(this);
        }

        @Override
        public TransferFeeDefinitionBuilder toBuilder() {
            return this;
        }

        @Override
        public TransferFeeDefinitionBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            this.transferFeeDefinitionChoice = this.transferFeeDefinitionChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.lenderTypeWaived = this.lenderTypeWaived.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getTransferFeeDefinitionChoice() != null && this.getTransferFeeDefinitionChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getLenderTypeWaived() != null && this.getLenderTypeWaived().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TransferFeeDefinitionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TransferFeeDefinitionBuilder o = (TransferFeeDefinitionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta(this.getTransferFeeDefinitionChoice(), o.getTransferFeeDefinitionChoice(), this::getOrCreateTransferFeeDefinitionChoice);
            merger.mergeRosetta(this.getLenderTypeWaived(), o.getLenderTypeWaived(), this::getOrCreateLenderTypeWaived);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransferFeeDefinition _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.transferFeeDefinitionChoice, _that.getTransferFeeDefinitionChoice())) {
                return false;
            }
            return ListEquals.listEquals(this.lenderTypeWaived, _that.getLenderTypeWaived());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.transferFeeDefinitionChoice != null ? this.transferFeeDefinitionChoice.hashCode() : 0);
            _result = 31 * _result + (this.lenderTypeWaived != null ? this.lenderTypeWaived.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransferFeeDefinitionBuilder {amount=" + String.valueOf(this.amount) + ", transferFeeDefinitionChoice=" + String.valueOf(this.transferFeeDefinitionChoice) + ", lenderTypeWaived=" + String.valueOf(this.lenderTypeWaived) + "}";
        }
    }

    public static interface TransferFeeDefinitionBuilder
    extends TransferFeeDefinition,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        public TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder getOrCreateTransferFeeDefinitionChoice(int var1);

        public List<? extends TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder> getTransferFeeDefinitionChoice();

        public LenderClassification.LenderClassificationBuilder getOrCreateLenderTypeWaived(int var1);

        public List<? extends LenderClassification.LenderClassificationBuilder> getLenderTypeWaived();

        public TransferFeeDefinitionBuilder setAmount(NonNegativeMoney var1);

        public TransferFeeDefinitionBuilder addTransferFeeDefinitionChoice(TransferFeeDefinitionChoice var1);

        public TransferFeeDefinitionBuilder addTransferFeeDefinitionChoice(TransferFeeDefinitionChoice var1, int var2);

        public TransferFeeDefinitionBuilder addTransferFeeDefinitionChoice(List<? extends TransferFeeDefinitionChoice> var1);

        public TransferFeeDefinitionBuilder setTransferFeeDefinitionChoice(List<? extends TransferFeeDefinitionChoice> var1);

        public TransferFeeDefinitionBuilder addLenderTypeWaived(LenderClassification var1);

        public TransferFeeDefinitionBuilder addLenderTypeWaived(LenderClassification var1, int var2);

        public TransferFeeDefinitionBuilder addLenderTypeWaived(List<? extends LenderClassification> var1);

        public TransferFeeDefinitionBuilder setLenderTypeWaived(List<? extends LenderClassification> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transferFeeDefinitionChoice"), processor, TransferFeeDefinitionChoice.TransferFeeDefinitionChoiceBuilder.class, this.getTransferFeeDefinitionChoice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderTypeWaived"), processor, LenderClassification.LenderClassificationBuilder.class, this.getLenderTypeWaived(), new AttributeMeta[0]);
        }

        public TransferFeeDefinitionBuilder prune();
    }

    public static class TransferFeeDefinitionImpl
    implements TransferFeeDefinition {
        private final NonNegativeMoney amount;
        private final List<? extends TransferFeeDefinitionChoice> transferFeeDefinitionChoice;
        private final List<? extends LenderClassification> lenderTypeWaived;

        protected TransferFeeDefinitionImpl(TransferFeeDefinitionBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.transferFeeDefinitionChoice = Optional.ofNullable(builder.getTransferFeeDefinitionChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lenderTypeWaived = Optional.ofNullable(builder.getLenderTypeWaived()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="transferFeeDefinitionChoice")
        @RuneAttribute(value="transferFeeDefinitionChoice")
        public List<? extends TransferFeeDefinitionChoice> getTransferFeeDefinitionChoice() {
            return this.transferFeeDefinitionChoice;
        }

        @Override
        @RosettaAttribute(value="lenderTypeWaived")
        @RuneAttribute(value="lenderTypeWaived")
        public List<? extends LenderClassification> getLenderTypeWaived() {
            return this.lenderTypeWaived;
        }

        @Override
        public TransferFeeDefinition build() {
            return this;
        }

        @Override
        public TransferFeeDefinitionBuilder toBuilder() {
            TransferFeeDefinitionBuilder builder = TransferFeeDefinition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransferFeeDefinitionBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getTransferFeeDefinitionChoice()).ifPresent(builder::setTransferFeeDefinitionChoice);
            Optional.ofNullable(this.getLenderTypeWaived()).ifPresent(builder::setLenderTypeWaived);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransferFeeDefinition _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.transferFeeDefinitionChoice, _that.getTransferFeeDefinitionChoice())) {
                return false;
            }
            return ListEquals.listEquals(this.lenderTypeWaived, _that.getLenderTypeWaived());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.transferFeeDefinitionChoice != null ? this.transferFeeDefinitionChoice.hashCode() : 0);
            _result = 31 * _result + (this.lenderTypeWaived != null ? this.lenderTypeWaived.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransferFeeDefinition {amount=" + String.valueOf(this.amount) + ", transferFeeDefinitionChoice=" + String.valueOf(this.transferFeeDefinitionChoice) + ", lenderTypeWaived=" + String.valueOf(this.lenderTypeWaived) + "}";
        }
    }
}

