/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractLoanStatement;
import fpml.consolidated.loan.DealDetailsModel;
import fpml.consolidated.loan.FacilityIdentifier;
import fpml.consolidated.loan.OutstandingContractsStatementChoice;
import fpml.consolidated.loan.meta.OutstandingContractsStatementMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OutstandingContractsStatement", builder=OutstandingContractsStatementBuilderImpl.class, version="1.2.2")
@RuneDataType(value="OutstandingContractsStatement", model="fpml", builder=OutstandingContractsStatementBuilderImpl.class, version="1.2.2")
public interface OutstandingContractsStatement
extends AbstractLoanStatement {
    public static final OutstandingContractsStatementMeta metaData = new OutstandingContractsStatementMeta();

    public DealDetailsModel getDealDetailsModel();

    public FacilityIdentifier getFacilityIdentifier();

    public List<? extends OutstandingContractsStatementChoice> getOutstandingContractsStatementChoice();

    public List<? extends Party> getParty();

    @Override
    public OutstandingContractsStatement build();

    @Override
    public OutstandingContractsStatementBuilder toBuilder();

    public static OutstandingContractsStatementBuilder builder() {
        return new OutstandingContractsStatementBuilderImpl();
    }

    default public RosettaMetaData<? extends OutstandingContractsStatement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OutstandingContractsStatement> getType() {
        return OutstandingContractsStatement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityIdentifier"), processor, FacilityIdentifier.class, this.getFacilityIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("outstandingContractsStatementChoice"), processor, OutstandingContractsStatementChoice.class, this.getOutstandingContractsStatementChoice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class OutstandingContractsStatementBuilderImpl
    extends AbstractLoanStatement.AbstractLoanStatementBuilderImpl
    implements OutstandingContractsStatementBuilder {
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected FacilityIdentifier.FacilityIdentifierBuilder facilityIdentifier;
        protected List<OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder> outstandingContractsStatementChoice = new ArrayList<OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityIdentifier", isRequired=true)
        @RuneAttribute(value="facilityIdentifier", isRequired=true)
        public FacilityIdentifier.FacilityIdentifierBuilder getFacilityIdentifier() {
            return this.facilityIdentifier;
        }

        @Override
        public FacilityIdentifier.FacilityIdentifierBuilder getOrCreateFacilityIdentifier() {
            FacilityIdentifier.FacilityIdentifierBuilder result = this.facilityIdentifier != null ? this.facilityIdentifier : (this.facilityIdentifier = FacilityIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="outstandingContractsStatementChoice", isRequired=true)
        @RuneAttribute(value="outstandingContractsStatementChoice", isRequired=true)
        public List<? extends OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder> getOutstandingContractsStatementChoice() {
            return this.outstandingContractsStatementChoice;
        }

        @Override
        public OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder getOrCreateOutstandingContractsStatementChoice(int index) {
            if (this.outstandingContractsStatementChoice == null) {
                this.outstandingContractsStatementChoice = new ArrayList<OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder>();
            }
            return (OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder)this.getIndex(this.outstandingContractsStatementChoice, index, () -> {
                OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder newOutstandingContractsStatementChoice = OutstandingContractsStatementChoice.builder();
                return newOutstandingContractsStatementChoice;
            });
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public OutstandingContractsStatementBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public OutstandingContractsStatementBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public OutstandingContractsStatementBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public OutstandingContractsStatementBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public OutstandingContractsStatementBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public OutstandingContractsStatementBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public OutstandingContractsStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public OutstandingContractsStatementBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="statementDate", isRequired=true)
        @RuneAttribute(value="statementDate", isRequired=true)
        public OutstandingContractsStatementBuilder setStatementDate(ZonedDateTime _statementDate) {
            this.statementDate = _statementDate == null ? null : _statementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public OutstandingContractsStatementBuilder setComments(String _comments) {
            this.comments = _comments == null ? null : _comments;
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public OutstandingContractsStatementBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityIdentifier", isRequired=true)
        @RuneAttribute(value="facilityIdentifier", isRequired=true)
        public OutstandingContractsStatementBuilder setFacilityIdentifier(FacilityIdentifier _facilityIdentifier) {
            this.facilityIdentifier = _facilityIdentifier == null ? null : _facilityIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="outstandingContractsStatementChoice", isRequired=true)
        @RuneAttribute(value="outstandingContractsStatementChoice", isRequired=true)
        public OutstandingContractsStatementBuilder addOutstandingContractsStatementChoice(OutstandingContractsStatementChoice _outstandingContractsStatementChoice) {
            if (_outstandingContractsStatementChoice != null) {
                this.outstandingContractsStatementChoice.add(_outstandingContractsStatementChoice.toBuilder());
            }
            return this;
        }

        @Override
        public OutstandingContractsStatementBuilder addOutstandingContractsStatementChoice(OutstandingContractsStatementChoice _outstandingContractsStatementChoice, int idx) {
            this.getIndex(this.outstandingContractsStatementChoice, idx, () -> _outstandingContractsStatementChoice.toBuilder());
            return this;
        }

        @Override
        public OutstandingContractsStatementBuilder addOutstandingContractsStatementChoice(List<? extends OutstandingContractsStatementChoice> outstandingContractsStatementChoices) {
            if (outstandingContractsStatementChoices != null) {
                for (OutstandingContractsStatementChoice outstandingContractsStatementChoice : outstandingContractsStatementChoices) {
                    this.outstandingContractsStatementChoice.add(outstandingContractsStatementChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="outstandingContractsStatementChoice")
        public OutstandingContractsStatementBuilder setOutstandingContractsStatementChoice(List<? extends OutstandingContractsStatementChoice> outstandingContractsStatementChoices) {
            this.outstandingContractsStatementChoice = outstandingContractsStatementChoices == null ? new ArrayList<OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder>() : (List)outstandingContractsStatementChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public OutstandingContractsStatementBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public OutstandingContractsStatementBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public OutstandingContractsStatementBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public OutstandingContractsStatementBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public OutstandingContractsStatement build() {
            return new OutstandingContractsStatementImpl(this);
        }

        @Override
        public OutstandingContractsStatementBuilder toBuilder() {
            return this;
        }

        @Override
        public OutstandingContractsStatementBuilder prune() {
            super.prune();
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.facilityIdentifier != null && !this.facilityIdentifier.prune().hasData()) {
                this.facilityIdentifier = null;
            }
            this.outstandingContractsStatementChoice = this.outstandingContractsStatementChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getFacilityIdentifier() != null && this.getFacilityIdentifier().hasData()) {
                return true;
            }
            if (this.getOutstandingContractsStatementChoice() != null && this.getOutstandingContractsStatementChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public OutstandingContractsStatementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OutstandingContractsStatementBuilder o = (OutstandingContractsStatementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityIdentifier(), (RosettaModelObjectBuilder)o.getFacilityIdentifier(), this::setFacilityIdentifier);
            merger.mergeRosetta(this.getOutstandingContractsStatementChoice(), o.getOutstandingContractsStatementChoice(), this::getOrCreateOutstandingContractsStatementChoice);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OutstandingContractsStatement _that = (OutstandingContractsStatement)this.getType().cast(o);
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityIdentifier, _that.getFacilityIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.outstandingContractsStatementChoice, _that.getOutstandingContractsStatementChoice())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityIdentifier != null ? this.facilityIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.outstandingContractsStatementChoice != null ? this.outstandingContractsStatementChoice.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OutstandingContractsStatementBuilder {dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityIdentifier=" + String.valueOf(this.facilityIdentifier) + ", outstandingContractsStatementChoice=" + String.valueOf(this.outstandingContractsStatementChoice) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface OutstandingContractsStatementBuilder
    extends OutstandingContractsStatement,
    AbstractLoanStatement.AbstractLoanStatementBuilder {
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public FacilityIdentifier.FacilityIdentifierBuilder getOrCreateFacilityIdentifier();

        @Override
        public FacilityIdentifier.FacilityIdentifierBuilder getFacilityIdentifier();

        public OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder getOrCreateOutstandingContractsStatementChoice(int var1);

        public List<? extends OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder> getOutstandingContractsStatementChoice();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public OutstandingContractsStatementBuilder setFpmlVersion(String var1);

        @Override
        public OutstandingContractsStatementBuilder setExpectedBuild(Integer var1);

        @Override
        public OutstandingContractsStatementBuilder setActualBuild(Integer var1);

        @Override
        public OutstandingContractsStatementBuilder setHeader(RequestMessageHeader var1);

        @Override
        public OutstandingContractsStatementBuilder setValidationModel(ValidationModel var1);

        @Override
        public OutstandingContractsStatementBuilder setIsCorrection(Boolean var1);

        @Override
        public OutstandingContractsStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public OutstandingContractsStatementBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public OutstandingContractsStatementBuilder setStatementDate(ZonedDateTime var1);

        @Override
        public OutstandingContractsStatementBuilder setComments(String var1);

        public OutstandingContractsStatementBuilder setDealDetailsModel(DealDetailsModel var1);

        public OutstandingContractsStatementBuilder setFacilityIdentifier(FacilityIdentifier var1);

        public OutstandingContractsStatementBuilder addOutstandingContractsStatementChoice(OutstandingContractsStatementChoice var1);

        public OutstandingContractsStatementBuilder addOutstandingContractsStatementChoice(OutstandingContractsStatementChoice var1, int var2);

        public OutstandingContractsStatementBuilder addOutstandingContractsStatementChoice(List<? extends OutstandingContractsStatementChoice> var1);

        public OutstandingContractsStatementBuilder setOutstandingContractsStatementChoice(List<? extends OutstandingContractsStatementChoice> var1);

        public OutstandingContractsStatementBuilder addParty(Party var1);

        public OutstandingContractsStatementBuilder addParty(Party var1, int var2);

        public OutstandingContractsStatementBuilder addParty(List<? extends Party> var1);

        public OutstandingContractsStatementBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityIdentifier"), processor, FacilityIdentifier.FacilityIdentifierBuilder.class, this.getFacilityIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("outstandingContractsStatementChoice"), processor, OutstandingContractsStatementChoice.OutstandingContractsStatementChoiceBuilder.class, this.getOutstandingContractsStatementChoice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public OutstandingContractsStatementBuilder prune();
    }

    public static class OutstandingContractsStatementImpl
    extends AbstractLoanStatement.AbstractLoanStatementImpl
    implements OutstandingContractsStatement {
        private final DealDetailsModel dealDetailsModel;
        private final FacilityIdentifier facilityIdentifier;
        private final List<? extends OutstandingContractsStatementChoice> outstandingContractsStatementChoice;
        private final List<? extends Party> party;

        protected OutstandingContractsStatementImpl(OutstandingContractsStatementBuilder builder) {
            super(builder);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.facilityIdentifier = Optional.ofNullable(builder.getFacilityIdentifier()).map(f -> f.build()).orElse(null);
            this.outstandingContractsStatementChoice = Optional.ofNullable(builder.getOutstandingContractsStatementChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityIdentifier", isRequired=true)
        @RuneAttribute(value="facilityIdentifier", isRequired=true)
        public FacilityIdentifier getFacilityIdentifier() {
            return this.facilityIdentifier;
        }

        @Override
        @RosettaAttribute(value="outstandingContractsStatementChoice", isRequired=true)
        @RuneAttribute(value="outstandingContractsStatementChoice", isRequired=true)
        public List<? extends OutstandingContractsStatementChoice> getOutstandingContractsStatementChoice() {
            return this.outstandingContractsStatementChoice;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public OutstandingContractsStatement build() {
            return this;
        }

        @Override
        public OutstandingContractsStatementBuilder toBuilder() {
            OutstandingContractsStatementBuilder builder = OutstandingContractsStatement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OutstandingContractsStatementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getFacilityIdentifier()).ifPresent(builder::setFacilityIdentifier);
            Optional.ofNullable(this.getOutstandingContractsStatementChoice()).ifPresent(builder::setOutstandingContractsStatementChoice);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OutstandingContractsStatement _that = (OutstandingContractsStatement)this.getType().cast(o);
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityIdentifier, _that.getFacilityIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.outstandingContractsStatementChoice, _that.getOutstandingContractsStatementChoice())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityIdentifier != null ? this.facilityIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.outstandingContractsStatementChoice != null ? this.outstandingContractsStatementChoice.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OutstandingContractsStatement {dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityIdentifier=" + String.valueOf(this.facilityIdentifier) + ", outstandingContractsStatementChoice=" + String.valueOf(this.outstandingContractsStatementChoice) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

