/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.LoanTradingCostOfCarry;
import fpml.consolidated.loan.LoanTradingDelayedCompensation;
import fpml.consolidated.loan.LoanTradingEconomicBenefit;
import fpml.consolidated.loan.meta.LoanTradingCounterpartySettlementFundingFactorsSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanTradingCounterpartySettlementFundingFactorsSequence", builder=LoanTradingCounterpartySettlementFundingFactorsSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanTradingCounterpartySettlementFundingFactorsSequence", model="fpml", builder=LoanTradingCounterpartySettlementFundingFactorsSequenceBuilderImpl.class, version="1.2.2")
public interface LoanTradingCounterpartySettlementFundingFactorsSequence
extends RosettaModelObject {
    public static final LoanTradingCounterpartySettlementFundingFactorsSequenceMeta metaData = new LoanTradingCounterpartySettlementFundingFactorsSequenceMeta();

    public LoanTradingDelayedCompensation getDelayedCompensation();

    public LoanTradingCostOfCarry getCostOfCarry();

    public List<? extends LoanTradingEconomicBenefit> getEconomicBenefit();

    public LoanTradingCounterpartySettlementFundingFactorsSequence build();

    public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder toBuilder();

    public static LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder builder() {
        return new LoanTradingCounterpartySettlementFundingFactorsSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradingCounterpartySettlementFundingFactorsSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradingCounterpartySettlementFundingFactorsSequence> getType() {
        return LoanTradingCounterpartySettlementFundingFactorsSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("delayedCompensation"), processor, LoanTradingDelayedCompensation.class, this.getDelayedCompensation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("costOfCarry"), processor, LoanTradingCostOfCarry.class, this.getCostOfCarry(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("economicBenefit"), processor, LoanTradingEconomicBenefit.class, this.getEconomicBenefit(), new AttributeMeta[0]);
    }

    public static class LoanTradingCounterpartySettlementFundingFactorsSequenceBuilderImpl
    implements LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder {
        protected LoanTradingDelayedCompensation.LoanTradingDelayedCompensationBuilder delayedCompensation;
        protected LoanTradingCostOfCarry.LoanTradingCostOfCarryBuilder costOfCarry;
        protected List<LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder> economicBenefit = new ArrayList<LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder>();

        @Override
        @RosettaAttribute(value="delayedCompensation", isRequired=true)
        @RuneAttribute(value="delayedCompensation", isRequired=true)
        public LoanTradingDelayedCompensation.LoanTradingDelayedCompensationBuilder getDelayedCompensation() {
            return this.delayedCompensation;
        }

        @Override
        public LoanTradingDelayedCompensation.LoanTradingDelayedCompensationBuilder getOrCreateDelayedCompensation() {
            LoanTradingDelayedCompensation.LoanTradingDelayedCompensationBuilder result = this.delayedCompensation != null ? this.delayedCompensation : (this.delayedCompensation = LoanTradingDelayedCompensation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="costOfCarry", isRequired=true)
        @RuneAttribute(value="costOfCarry", isRequired=true)
        public LoanTradingCostOfCarry.LoanTradingCostOfCarryBuilder getCostOfCarry() {
            return this.costOfCarry;
        }

        @Override
        public LoanTradingCostOfCarry.LoanTradingCostOfCarryBuilder getOrCreateCostOfCarry() {
            LoanTradingCostOfCarry.LoanTradingCostOfCarryBuilder result = this.costOfCarry != null ? this.costOfCarry : (this.costOfCarry = LoanTradingCostOfCarry.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="economicBenefit")
        @RuneAttribute(value="economicBenefit")
        public List<? extends LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder> getEconomicBenefit() {
            return this.economicBenefit;
        }

        @Override
        public LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder getOrCreateEconomicBenefit(int index) {
            if (this.economicBenefit == null) {
                this.economicBenefit = new ArrayList<LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder>();
            }
            return (LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder)this.getIndex(this.economicBenefit, index, () -> {
                LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder newEconomicBenefit = LoanTradingEconomicBenefit.builder();
                return newEconomicBenefit;
            });
        }

        @Override
        @RosettaAttribute(value="delayedCompensation", isRequired=true)
        @RuneAttribute(value="delayedCompensation", isRequired=true)
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder setDelayedCompensation(LoanTradingDelayedCompensation _delayedCompensation) {
            this.delayedCompensation = _delayedCompensation == null ? null : _delayedCompensation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="costOfCarry", isRequired=true)
        @RuneAttribute(value="costOfCarry", isRequired=true)
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder setCostOfCarry(LoanTradingCostOfCarry _costOfCarry) {
            this.costOfCarry = _costOfCarry == null ? null : _costOfCarry.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="economicBenefit")
        @RuneAttribute(value="economicBenefit")
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder addEconomicBenefit(LoanTradingEconomicBenefit _economicBenefit) {
            if (_economicBenefit != null) {
                this.economicBenefit.add(_economicBenefit.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder addEconomicBenefit(LoanTradingEconomicBenefit _economicBenefit, int idx) {
            this.getIndex(this.economicBenefit, idx, () -> _economicBenefit.toBuilder());
            return this;
        }

        @Override
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder addEconomicBenefit(List<? extends LoanTradingEconomicBenefit> economicBenefits) {
            if (economicBenefits != null) {
                for (LoanTradingEconomicBenefit loanTradingEconomicBenefit : economicBenefits) {
                    this.economicBenefit.add(loanTradingEconomicBenefit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="economicBenefit")
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder setEconomicBenefit(List<? extends LoanTradingEconomicBenefit> economicBenefits) {
            this.economicBenefit = economicBenefits == null ? new ArrayList<LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder>() : (List)economicBenefits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanTradingCounterpartySettlementFundingFactorsSequence build() {
            return new LoanTradingCounterpartySettlementFundingFactorsSequenceImpl(this);
        }

        @Override
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder prune() {
            if (this.delayedCompensation != null && !this.delayedCompensation.prune().hasData()) {
                this.delayedCompensation = null;
            }
            if (this.costOfCarry != null && !this.costOfCarry.prune().hasData()) {
                this.costOfCarry = null;
            }
            this.economicBenefit = this.economicBenefit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDelayedCompensation() != null && this.getDelayedCompensation().hasData()) {
                return true;
            }
            if (this.getCostOfCarry() != null && this.getCostOfCarry().hasData()) {
                return true;
            }
            return this.getEconomicBenefit() != null && this.getEconomicBenefit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder o = (LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDelayedCompensation(), (RosettaModelObjectBuilder)o.getDelayedCompensation(), this::setDelayedCompensation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCostOfCarry(), (RosettaModelObjectBuilder)o.getCostOfCarry(), this::setCostOfCarry);
            merger.mergeRosetta(this.getEconomicBenefit(), o.getEconomicBenefit(), this::getOrCreateEconomicBenefit);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingCounterpartySettlementFundingFactorsSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.delayedCompensation, _that.getDelayedCompensation())) {
                return false;
            }
            if (!Objects.equals(this.costOfCarry, _that.getCostOfCarry())) {
                return false;
            }
            return ListEquals.listEquals(this.economicBenefit, _that.getEconomicBenefit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.delayedCompensation != null ? this.delayedCompensation.hashCode() : 0);
            _result = 31 * _result + (this.costOfCarry != null ? this.costOfCarry.hashCode() : 0);
            _result = 31 * _result + (this.economicBenefit != null ? this.economicBenefit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder {delayedCompensation=" + String.valueOf(this.delayedCompensation) + ", costOfCarry=" + String.valueOf(this.costOfCarry) + ", economicBenefit=" + String.valueOf(this.economicBenefit) + "}";
        }
    }

    public static interface LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder
    extends LoanTradingCounterpartySettlementFundingFactorsSequence,
    RosettaModelObjectBuilder {
        public LoanTradingDelayedCompensation.LoanTradingDelayedCompensationBuilder getOrCreateDelayedCompensation();

        @Override
        public LoanTradingDelayedCompensation.LoanTradingDelayedCompensationBuilder getDelayedCompensation();

        public LoanTradingCostOfCarry.LoanTradingCostOfCarryBuilder getOrCreateCostOfCarry();

        @Override
        public LoanTradingCostOfCarry.LoanTradingCostOfCarryBuilder getCostOfCarry();

        public LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder getOrCreateEconomicBenefit(int var1);

        public List<? extends LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder> getEconomicBenefit();

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder setDelayedCompensation(LoanTradingDelayedCompensation var1);

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder setCostOfCarry(LoanTradingCostOfCarry var1);

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder addEconomicBenefit(LoanTradingEconomicBenefit var1);

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder addEconomicBenefit(LoanTradingEconomicBenefit var1, int var2);

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder addEconomicBenefit(List<? extends LoanTradingEconomicBenefit> var1);

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder setEconomicBenefit(List<? extends LoanTradingEconomicBenefit> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("delayedCompensation"), processor, LoanTradingDelayedCompensation.LoanTradingDelayedCompensationBuilder.class, this.getDelayedCompensation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("costOfCarry"), processor, LoanTradingCostOfCarry.LoanTradingCostOfCarryBuilder.class, this.getCostOfCarry(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("economicBenefit"), processor, LoanTradingEconomicBenefit.LoanTradingEconomicBenefitBuilder.class, this.getEconomicBenefit(), new AttributeMeta[0]);
        }

        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder prune();
    }

    public static class LoanTradingCounterpartySettlementFundingFactorsSequenceImpl
    implements LoanTradingCounterpartySettlementFundingFactorsSequence {
        private final LoanTradingDelayedCompensation delayedCompensation;
        private final LoanTradingCostOfCarry costOfCarry;
        private final List<? extends LoanTradingEconomicBenefit> economicBenefit;

        protected LoanTradingCounterpartySettlementFundingFactorsSequenceImpl(LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder builder) {
            this.delayedCompensation = Optional.ofNullable(builder.getDelayedCompensation()).map(f -> f.build()).orElse(null);
            this.costOfCarry = Optional.ofNullable(builder.getCostOfCarry()).map(f -> f.build()).orElse(null);
            this.economicBenefit = Optional.ofNullable(builder.getEconomicBenefit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="delayedCompensation", isRequired=true)
        @RuneAttribute(value="delayedCompensation", isRequired=true)
        public LoanTradingDelayedCompensation getDelayedCompensation() {
            return this.delayedCompensation;
        }

        @Override
        @RosettaAttribute(value="costOfCarry", isRequired=true)
        @RuneAttribute(value="costOfCarry", isRequired=true)
        public LoanTradingCostOfCarry getCostOfCarry() {
            return this.costOfCarry;
        }

        @Override
        @RosettaAttribute(value="economicBenefit")
        @RuneAttribute(value="economicBenefit")
        public List<? extends LoanTradingEconomicBenefit> getEconomicBenefit() {
            return this.economicBenefit;
        }

        @Override
        public LoanTradingCounterpartySettlementFundingFactorsSequence build() {
            return this;
        }

        @Override
        public LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder toBuilder() {
            LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder builder = LoanTradingCounterpartySettlementFundingFactorsSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradingCounterpartySettlementFundingFactorsSequenceBuilder builder) {
            Optional.ofNullable(this.getDelayedCompensation()).ifPresent(builder::setDelayedCompensation);
            Optional.ofNullable(this.getCostOfCarry()).ifPresent(builder::setCostOfCarry);
            Optional.ofNullable(this.getEconomicBenefit()).ifPresent(builder::setEconomicBenefit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingCounterpartySettlementFundingFactorsSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.delayedCompensation, _that.getDelayedCompensation())) {
                return false;
            }
            if (!Objects.equals(this.costOfCarry, _that.getCostOfCarry())) {
                return false;
            }
            return ListEquals.listEquals(this.economicBenefit, _that.getEconomicBenefit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.delayedCompensation != null ? this.delayedCompensation.hashCode() : 0);
            _result = 31 * _result + (this.costOfCarry != null ? this.costOfCarry.hashCode() : 0);
            _result = 31 * _result + (this.economicBenefit != null ? this.economicBenefit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingCounterpartySettlementFundingFactorsSequence {delayedCompensation=" + String.valueOf(this.delayedCompensation) + ", costOfCarry=" + String.valueOf(this.costOfCarry) + ", economicBenefit=" + String.valueOf(this.economicBenefit) + "}";
        }
    }
}

