/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.loan.LoanTradeSummary;
import fpml.consolidated.loan.LoanTradeType;
import fpml.consolidated.loan.meta.LoanTradeDetailsModelMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTradeDetailsModel", builder=LoanTradeDetailsModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanTradeDetailsModel", model="fpml", builder=LoanTradeDetailsModelBuilderImpl.class, version="1.2.2")
public interface LoanTradeDetailsModel
extends RosettaModelObject {
    public static final LoanTradeDetailsModelMeta metaData = new LoanTradeDetailsModelMeta();

    public TradeIdentifier getTradeIdentifier();

    public LoanTradeSummary getTradeSummary();

    public LoanTradeType getTrade();

    public LoanTradeDetailsModel build();

    public LoanTradeDetailsModelBuilder toBuilder();

    public static LoanTradeDetailsModelBuilder builder() {
        return new LoanTradeDetailsModelBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradeDetailsModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradeDetailsModel> getType() {
        return LoanTradeDetailsModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeSummary"), processor, LoanTradeSummary.class, this.getTradeSummary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, LoanTradeType.class, this.getTrade(), new AttributeMeta[0]);
    }

    public static class LoanTradeDetailsModelBuilderImpl
    implements LoanTradeDetailsModelBuilder {
        protected TradeIdentifier.TradeIdentifierBuilder tradeIdentifier;
        protected LoanTradeSummary.LoanTradeSummaryBuilder tradeSummary;
        protected LoanTradeType.LoanTradeTypeBuilder trade;

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public TradeIdentifier.TradeIdentifierBuilder getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.tradeIdentifier != null ? this.tradeIdentifier : (this.tradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeSummary")
        @RuneAttribute(value="tradeSummary")
        public LoanTradeSummary.LoanTradeSummaryBuilder getTradeSummary() {
            return this.tradeSummary;
        }

        @Override
        public LoanTradeSummary.LoanTradeSummaryBuilder getOrCreateTradeSummary() {
            LoanTradeSummary.LoanTradeSummaryBuilder result = this.tradeSummary != null ? this.tradeSummary : (this.tradeSummary = LoanTradeSummary.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public LoanTradeType.LoanTradeTypeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public LoanTradeType.LoanTradeTypeBuilder getOrCreateTrade() {
            LoanTradeType.LoanTradeTypeBuilder result = this.trade != null ? this.trade : (this.trade = LoanTradeType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public LoanTradeDetailsModelBuilder setTradeIdentifier(TradeIdentifier _tradeIdentifier) {
            this.tradeIdentifier = _tradeIdentifier == null ? null : _tradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeSummary")
        @RuneAttribute(value="tradeSummary")
        public LoanTradeDetailsModelBuilder setTradeSummary(LoanTradeSummary _tradeSummary) {
            this.tradeSummary = _tradeSummary == null ? null : _tradeSummary.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public LoanTradeDetailsModelBuilder setTrade(LoanTradeType _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        public LoanTradeDetailsModel build() {
            return new LoanTradeDetailsModelImpl(this);
        }

        @Override
        public LoanTradeDetailsModelBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradeDetailsModelBuilder prune() {
            if (this.tradeIdentifier != null && !this.tradeIdentifier.prune().hasData()) {
                this.tradeIdentifier = null;
            }
            if (this.tradeSummary != null && !this.tradeSummary.prune().hasData()) {
                this.tradeSummary = null;
            }
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getTradeSummary() != null && this.getTradeSummary().hasData()) {
                return true;
            }
            return this.getTrade() != null && this.getTrade().hasData();
        }

        public LoanTradeDetailsModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTradeDetailsModelBuilder o = (LoanTradeDetailsModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeIdentifier(), (RosettaModelObjectBuilder)o.getTradeIdentifier(), this::setTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeSummary(), (RosettaModelObjectBuilder)o.getTradeSummary(), this::setTradeSummary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradeDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.tradeSummary, _that.getTradeSummary())) {
                return false;
            }
            return Objects.equals(this.trade, _that.getTrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeSummary != null ? this.tradeSummary.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradeDetailsModelBuilder {tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", tradeSummary=" + String.valueOf(this.tradeSummary) + ", trade=" + String.valueOf(this.trade) + "}";
        }
    }

    public static interface LoanTradeDetailsModelBuilder
    extends LoanTradeDetailsModel,
    RosettaModelObjectBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier();

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getTradeIdentifier();

        public LoanTradeSummary.LoanTradeSummaryBuilder getOrCreateTradeSummary();

        @Override
        public LoanTradeSummary.LoanTradeSummaryBuilder getTradeSummary();

        public LoanTradeType.LoanTradeTypeBuilder getOrCreateTrade();

        @Override
        public LoanTradeType.LoanTradeTypeBuilder getTrade();

        public LoanTradeDetailsModelBuilder setTradeIdentifier(TradeIdentifier var1);

        public LoanTradeDetailsModelBuilder setTradeSummary(LoanTradeSummary var1);

        public LoanTradeDetailsModelBuilder setTrade(LoanTradeType var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeSummary"), processor, LoanTradeSummary.LoanTradeSummaryBuilder.class, this.getTradeSummary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, LoanTradeType.LoanTradeTypeBuilder.class, this.getTrade(), new AttributeMeta[0]);
        }

        public LoanTradeDetailsModelBuilder prune();
    }

    public static class LoanTradeDetailsModelImpl
    implements LoanTradeDetailsModel {
        private final TradeIdentifier tradeIdentifier;
        private final LoanTradeSummary tradeSummary;
        private final LoanTradeType trade;

        protected LoanTradeDetailsModelImpl(LoanTradeDetailsModelBuilder builder) {
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.tradeSummary = Optional.ofNullable(builder.getTradeSummary()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public TradeIdentifier getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="tradeSummary")
        @RuneAttribute(value="tradeSummary")
        public LoanTradeSummary getTradeSummary() {
            return this.tradeSummary;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public LoanTradeType getTrade() {
            return this.trade;
        }

        @Override
        public LoanTradeDetailsModel build() {
            return this;
        }

        @Override
        public LoanTradeDetailsModelBuilder toBuilder() {
            LoanTradeDetailsModelBuilder builder = LoanTradeDetailsModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradeDetailsModelBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getTradeSummary()).ifPresent(builder::setTradeSummary);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradeDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.tradeSummary, _that.getTradeSummary())) {
                return false;
            }
            return Objects.equals(this.trade, _that.getTrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.tradeSummary != null ? this.tradeSummary.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradeDetailsModel {tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", tradeSummary=" + String.valueOf(this.tradeSummary) + ", trade=" + String.valueOf(this.trade) + "}";
        }
    }
}

