/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.FeeRateOptionBase;
import fpml.consolidated.loan.LcAccrualSequence;
import fpml.consolidated.loan.meta.LcAccrualMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LcAccrual", builder=LcAccrualBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LcAccrual", model="fpml", builder=LcAccrualBuilderImpl.class, version="1.2.2")
public interface LcAccrual
extends FeeRateOptionBase {
    public static final LcAccrualMeta metaData = new LcAccrualMeta();

    public LcAccrualSequence getLcAccrualSequence();

    @Override
    public LcAccrual build();

    @Override
    public LcAccrualBuilder toBuilder();

    public static LcAccrualBuilder builder() {
        return new LcAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends LcAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcAccrual> getType() {
        return LcAccrual.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lcAccrualSequence"), processor, LcAccrualSequence.class, this.getLcAccrualSequence(), new AttributeMeta[0]);
    }

    public static class LcAccrualBuilderImpl
    extends FeeRateOptionBase.FeeRateOptionBaseBuilderImpl
    implements LcAccrualBuilder {
        protected LcAccrualSequence.LcAccrualSequenceBuilder lcAccrualSequence;

        @Override
        @RosettaAttribute(value="lcAccrualSequence")
        @RuneAttribute(value="lcAccrualSequence")
        public LcAccrualSequence.LcAccrualSequenceBuilder getLcAccrualSequence() {
            return this.lcAccrualSequence;
        }

        @Override
        public LcAccrualSequence.LcAccrualSequenceBuilder getOrCreateLcAccrualSequence() {
            LcAccrualSequence.LcAccrualSequenceBuilder result = this.lcAccrualSequence != null ? this.lcAccrualSequence : (this.lcAccrualSequence = LcAccrualSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public LcAccrualBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public LcAccrualBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public LcAccrualBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public LcAccrualBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="lcAccrualSequence")
        @RuneAttribute(value="lcAccrualSequence")
        public LcAccrualBuilder setLcAccrualSequence(LcAccrualSequence _lcAccrualSequence) {
            this.lcAccrualSequence = _lcAccrualSequence == null ? null : _lcAccrualSequence.toBuilder();
            return this;
        }

        @Override
        public LcAccrual build() {
            return new LcAccrualImpl(this);
        }

        @Override
        public LcAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public LcAccrualBuilder prune() {
            super.prune();
            if (this.lcAccrualSequence != null && !this.lcAccrualSequence.prune().hasData()) {
                this.lcAccrualSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getLcAccrualSequence() != null && this.getLcAccrualSequence().hasData();
        }

        @Override
        public LcAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LcAccrualBuilder o = (LcAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLcAccrualSequence(), (RosettaModelObjectBuilder)o.getLcAccrualSequence(), this::setLcAccrualSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcAccrual _that = (LcAccrual)this.getType().cast(o);
            return Objects.equals(this.lcAccrualSequence, _that.getLcAccrualSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lcAccrualSequence != null ? this.lcAccrualSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcAccrualBuilder {lcAccrualSequence=" + String.valueOf(this.lcAccrualSequence) + "} " + super.toString();
        }
    }

    public static interface LcAccrualBuilder
    extends LcAccrual,
    FeeRateOptionBase.FeeRateOptionBaseBuilder {
        public LcAccrualSequence.LcAccrualSequenceBuilder getOrCreateLcAccrualSequence();

        @Override
        public LcAccrualSequence.LcAccrualSequenceBuilder getLcAccrualSequence();

        @Override
        public LcAccrualBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public LcAccrualBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public LcAccrualBuilder setPaymentFrequency(Period var1);

        @Override
        public LcAccrualBuilder setRate(BigDecimal var1);

        public LcAccrualBuilder setLcAccrualSequence(LcAccrualSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lcAccrualSequence"), processor, LcAccrualSequence.LcAccrualSequenceBuilder.class, this.getLcAccrualSequence(), new AttributeMeta[0]);
        }

        @Override
        public LcAccrualBuilder prune();
    }

    public static class LcAccrualImpl
    extends FeeRateOptionBase.FeeRateOptionBaseImpl
    implements LcAccrual {
        private final LcAccrualSequence lcAccrualSequence;

        protected LcAccrualImpl(LcAccrualBuilder builder) {
            super(builder);
            this.lcAccrualSequence = Optional.ofNullable(builder.getLcAccrualSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="lcAccrualSequence")
        @RuneAttribute(value="lcAccrualSequence")
        public LcAccrualSequence getLcAccrualSequence() {
            return this.lcAccrualSequence;
        }

        @Override
        public LcAccrual build() {
            return this;
        }

        @Override
        public LcAccrualBuilder toBuilder() {
            LcAccrualBuilder builder = LcAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcAccrualBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLcAccrualSequence()).ifPresent(builder::setLcAccrualSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcAccrual _that = (LcAccrual)this.getType().cast(o);
            return Objects.equals(this.lcAccrualSequence, _that.getLcAccrualSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.lcAccrualSequence != null ? this.lcAccrualSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcAccrual {lcAccrualSequence=" + String.valueOf(this.lcAccrualSequence) + "} " + super.toString();
        }
    }
}

