/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityCommitmentModel;
import fpml.consolidated.loan.FacilityDatesModel;
import fpml.consolidated.loan.FacilityIdentifier;
import fpml.consolidated.loan.FacilityRolesModel;
import fpml.consolidated.loan.meta.FacilitySummaryMeta;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilitySummary", builder=FacilitySummaryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FacilitySummary", model="fpml", builder=FacilitySummaryBuilderImpl.class, version="1.2.2")
public interface FacilitySummary
extends FacilityIdentifier {
    public static final FacilitySummaryMeta metaData = new FacilitySummaryMeta();

    public FacilityRolesModel getFacilityRolesModel();

    public FacilityDatesModel getFacilityDatesModel();

    public FacilityCommitmentModel getFacilityCommitmentModel();

    @Override
    public FacilitySummary build();

    @Override
    public FacilitySummaryBuilder toBuilder();

    public static FacilitySummaryBuilder builder() {
        return new FacilitySummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilitySummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilitySummary> getType() {
        return FacilitySummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityRolesModel"), processor, FacilityRolesModel.class, this.getFacilityRolesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDatesModel"), processor, FacilityDatesModel.class, this.getFacilityDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityCommitmentModel"), processor, FacilityCommitmentModel.class, this.getFacilityCommitmentModel(), new AttributeMeta[0]);
    }

    public static class FacilitySummaryBuilderImpl
    extends FacilityIdentifier.FacilityIdentifierBuilderImpl
    implements FacilitySummaryBuilder {
        protected FacilityRolesModel.FacilityRolesModelBuilder facilityRolesModel;
        protected FacilityDatesModel.FacilityDatesModelBuilder facilityDatesModel;
        protected FacilityCommitmentModel.FacilityCommitmentModelBuilder facilityCommitmentModel;

        @Override
        @RosettaAttribute(value="facilityRolesModel", isRequired=true)
        @RuneAttribute(value="facilityRolesModel", isRequired=true)
        public FacilityRolesModel.FacilityRolesModelBuilder getFacilityRolesModel() {
            return this.facilityRolesModel;
        }

        @Override
        public FacilityRolesModel.FacilityRolesModelBuilder getOrCreateFacilityRolesModel() {
            FacilityRolesModel.FacilityRolesModelBuilder result = this.facilityRolesModel != null ? this.facilityRolesModel : (this.facilityRolesModel = FacilityRolesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityDatesModel", isRequired=true)
        @RuneAttribute(value="facilityDatesModel", isRequired=true)
        public FacilityDatesModel.FacilityDatesModelBuilder getFacilityDatesModel() {
            return this.facilityDatesModel;
        }

        @Override
        public FacilityDatesModel.FacilityDatesModelBuilder getOrCreateFacilityDatesModel() {
            FacilityDatesModel.FacilityDatesModelBuilder result = this.facilityDatesModel != null ? this.facilityDatesModel : (this.facilityDatesModel = FacilityDatesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityCommitmentModel", isRequired=true)
        @RuneAttribute(value="facilityCommitmentModel", isRequired=true)
        public FacilityCommitmentModel.FacilityCommitmentModelBuilder getFacilityCommitmentModel() {
            return this.facilityCommitmentModel;
        }

        @Override
        public FacilityCommitmentModel.FacilityCommitmentModelBuilder getOrCreateFacilityCommitmentModel() {
            FacilityCommitmentModel.FacilityCommitmentModelBuilder result = this.facilityCommitmentModel != null ? this.facilityCommitmentModel : (this.facilityCommitmentModel = FacilityCommitmentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FacilitySummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public FacilitySummaryBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public FacilitySummaryBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public FacilitySummaryBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public FacilitySummaryBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public FacilitySummaryBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public FacilitySummaryBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public FacilitySummaryBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityRolesModel", isRequired=true)
        @RuneAttribute(value="facilityRolesModel", isRequired=true)
        public FacilitySummaryBuilder setFacilityRolesModel(FacilityRolesModel _facilityRolesModel) {
            this.facilityRolesModel = _facilityRolesModel == null ? null : _facilityRolesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDatesModel", isRequired=true)
        @RuneAttribute(value="facilityDatesModel", isRequired=true)
        public FacilitySummaryBuilder setFacilityDatesModel(FacilityDatesModel _facilityDatesModel) {
            this.facilityDatesModel = _facilityDatesModel == null ? null : _facilityDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityCommitmentModel", isRequired=true)
        @RuneAttribute(value="facilityCommitmentModel", isRequired=true)
        public FacilitySummaryBuilder setFacilityCommitmentModel(FacilityCommitmentModel _facilityCommitmentModel) {
            this.facilityCommitmentModel = _facilityCommitmentModel == null ? null : _facilityCommitmentModel.toBuilder();
            return this;
        }

        @Override
        public FacilitySummary build() {
            return new FacilitySummaryImpl(this);
        }

        @Override
        public FacilitySummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilitySummaryBuilder prune() {
            super.prune();
            if (this.facilityRolesModel != null && !this.facilityRolesModel.prune().hasData()) {
                this.facilityRolesModel = null;
            }
            if (this.facilityDatesModel != null && !this.facilityDatesModel.prune().hasData()) {
                this.facilityDatesModel = null;
            }
            if (this.facilityCommitmentModel != null && !this.facilityCommitmentModel.prune().hasData()) {
                this.facilityCommitmentModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFacilityRolesModel() != null && this.getFacilityRolesModel().hasData()) {
                return true;
            }
            if (this.getFacilityDatesModel() != null && this.getFacilityDatesModel().hasData()) {
                return true;
            }
            return this.getFacilityCommitmentModel() != null && this.getFacilityCommitmentModel().hasData();
        }

        @Override
        public FacilitySummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FacilitySummaryBuilder o = (FacilitySummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityRolesModel(), (RosettaModelObjectBuilder)o.getFacilityRolesModel(), this::setFacilityRolesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityDatesModel(), (RosettaModelObjectBuilder)o.getFacilityDatesModel(), this::setFacilityDatesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityCommitmentModel(), (RosettaModelObjectBuilder)o.getFacilityCommitmentModel(), this::setFacilityCommitmentModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilitySummary _that = (FacilitySummary)this.getType().cast(o);
            if (!Objects.equals(this.facilityRolesModel, _that.getFacilityRolesModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDatesModel, _that.getFacilityDatesModel())) {
                return false;
            }
            return Objects.equals(this.facilityCommitmentModel, _that.getFacilityCommitmentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityRolesModel != null ? this.facilityRolesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDatesModel != null ? this.facilityDatesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityCommitmentModel != null ? this.facilityCommitmentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilitySummaryBuilder {facilityRolesModel=" + String.valueOf(this.facilityRolesModel) + ", facilityDatesModel=" + String.valueOf(this.facilityDatesModel) + ", facilityCommitmentModel=" + String.valueOf(this.facilityCommitmentModel) + "} " + super.toString();
        }
    }

    public static interface FacilitySummaryBuilder
    extends FacilitySummary,
    FacilityIdentifier.FacilityIdentifierBuilder {
        public FacilityRolesModel.FacilityRolesModelBuilder getOrCreateFacilityRolesModel();

        @Override
        public FacilityRolesModel.FacilityRolesModelBuilder getFacilityRolesModel();

        public FacilityDatesModel.FacilityDatesModelBuilder getOrCreateFacilityDatesModel();

        @Override
        public FacilityDatesModel.FacilityDatesModelBuilder getFacilityDatesModel();

        public FacilityCommitmentModel.FacilityCommitmentModelBuilder getOrCreateFacilityCommitmentModel();

        @Override
        public FacilityCommitmentModel.FacilityCommitmentModelBuilder getFacilityCommitmentModel();

        @Override
        public FacilitySummaryBuilder setId(String var1);

        @Override
        public FacilitySummaryBuilder setPartyReference(PartyReference var1);

        @Override
        public FacilitySummaryBuilder addInstrumentId(InstrumentId var1);

        @Override
        public FacilitySummaryBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public FacilitySummaryBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FacilitySummaryBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FacilitySummaryBuilder setDescription(String var1);

        @Override
        public FacilitySummaryBuilder setDealReference(DealReference var1);

        public FacilitySummaryBuilder setFacilityRolesModel(FacilityRolesModel var1);

        public FacilitySummaryBuilder setFacilityDatesModel(FacilityDatesModel var1);

        public FacilitySummaryBuilder setFacilityCommitmentModel(FacilityCommitmentModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityRolesModel"), processor, FacilityRolesModel.FacilityRolesModelBuilder.class, this.getFacilityRolesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDatesModel"), processor, FacilityDatesModel.FacilityDatesModelBuilder.class, this.getFacilityDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityCommitmentModel"), processor, FacilityCommitmentModel.FacilityCommitmentModelBuilder.class, this.getFacilityCommitmentModel(), new AttributeMeta[0]);
        }

        @Override
        public FacilitySummaryBuilder prune();
    }

    public static class FacilitySummaryImpl
    extends FacilityIdentifier.FacilityIdentifierImpl
    implements FacilitySummary {
        private final FacilityRolesModel facilityRolesModel;
        private final FacilityDatesModel facilityDatesModel;
        private final FacilityCommitmentModel facilityCommitmentModel;

        protected FacilitySummaryImpl(FacilitySummaryBuilder builder) {
            super(builder);
            this.facilityRolesModel = Optional.ofNullable(builder.getFacilityRolesModel()).map(f -> f.build()).orElse(null);
            this.facilityDatesModel = Optional.ofNullable(builder.getFacilityDatesModel()).map(f -> f.build()).orElse(null);
            this.facilityCommitmentModel = Optional.ofNullable(builder.getFacilityCommitmentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityRolesModel", isRequired=true)
        @RuneAttribute(value="facilityRolesModel", isRequired=true)
        public FacilityRolesModel getFacilityRolesModel() {
            return this.facilityRolesModel;
        }

        @Override
        @RosettaAttribute(value="facilityDatesModel", isRequired=true)
        @RuneAttribute(value="facilityDatesModel", isRequired=true)
        public FacilityDatesModel getFacilityDatesModel() {
            return this.facilityDatesModel;
        }

        @Override
        @RosettaAttribute(value="facilityCommitmentModel", isRequired=true)
        @RuneAttribute(value="facilityCommitmentModel", isRequired=true)
        public FacilityCommitmentModel getFacilityCommitmentModel() {
            return this.facilityCommitmentModel;
        }

        @Override
        public FacilitySummary build() {
            return this;
        }

        @Override
        public FacilitySummaryBuilder toBuilder() {
            FacilitySummaryBuilder builder = FacilitySummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilitySummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityRolesModel()).ifPresent(builder::setFacilityRolesModel);
            Optional.ofNullable(this.getFacilityDatesModel()).ifPresent(builder::setFacilityDatesModel);
            Optional.ofNullable(this.getFacilityCommitmentModel()).ifPresent(builder::setFacilityCommitmentModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilitySummary _that = (FacilitySummary)this.getType().cast(o);
            if (!Objects.equals(this.facilityRolesModel, _that.getFacilityRolesModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDatesModel, _that.getFacilityDatesModel())) {
                return false;
            }
            return Objects.equals(this.facilityCommitmentModel, _that.getFacilityCommitmentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityRolesModel != null ? this.facilityRolesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDatesModel != null ? this.facilityDatesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityCommitmentModel != null ? this.facilityCommitmentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilitySummary {facilityRolesModel=" + String.valueOf(this.facilityRolesModel) + ", facilityDatesModel=" + String.valueOf(this.facilityDatesModel) + ", facilityCommitmentModel=" + String.valueOf(this.facilityCommitmentModel) + "} " + super.toString();
        }
    }
}

