/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractLoanStatement;
import fpml.consolidated.loan.DealDetailsModel;
import fpml.consolidated.loan.FacilityDetailsModel;
import fpml.consolidated.loan.FacilityPosition;
import fpml.consolidated.loan.LoanContractDetailsModel;
import fpml.consolidated.loan.meta.FacilityPositionStatementMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityPositionStatement", builder=FacilityPositionStatementBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FacilityPositionStatement", model="fpml", builder=FacilityPositionStatementBuilderImpl.class, version="1.2.2")
public interface FacilityPositionStatement
extends AbstractLoanStatement {
    public static final FacilityPositionStatementMeta metaData = new FacilityPositionStatementMeta();

    public FacilityPosition getFacilityPosition();

    public PartyReference getPositionPartyReference();

    public DealDetailsModel getDealDetailsModel();

    public FacilityDetailsModel getFacilityDetailsModel();

    public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel();

    public List<? extends Party> getParty();

    @Override
    public FacilityPositionStatement build();

    @Override
    public FacilityPositionStatementBuilder toBuilder();

    public static FacilityPositionStatementBuilder builder() {
        return new FacilityPositionStatementBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityPositionStatement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityPositionStatement> getType() {
        return FacilityPositionStatement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.class, this.getFacilityPosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("positionPartyReference"), processor, PartyReference.class, this.getPositionPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class FacilityPositionStatementBuilderImpl
    extends AbstractLoanStatement.AbstractLoanStatementBuilderImpl
    implements FacilityPositionStatementBuilder {
        protected FacilityPosition.FacilityPositionBuilder facilityPosition;
        protected PartyReference.PartyReferenceBuilder positionPartyReference;
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected FacilityDetailsModel.FacilityDetailsModelBuilder facilityDetailsModel;
        protected List<LoanContractDetailsModel.LoanContractDetailsModelBuilder> loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="facilityPosition", isRequired=true)
        @RuneAttribute(value="facilityPosition", isRequired=true)
        public FacilityPosition.FacilityPositionBuilder getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition() {
            FacilityPosition.FacilityPositionBuilder result = this.facilityPosition != null ? this.facilityPosition : (this.facilityPosition = FacilityPosition.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="positionPartyReference", isRequired=true)
        @RuneAttribute(value="positionPartyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getPositionPartyReference() {
            return this.positionPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePositionPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.positionPartyReference != null ? this.positionPartyReference : (this.positionPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel() {
            FacilityDetailsModel.FacilityDetailsModelBuilder result = this.facilityDetailsModel != null ? this.facilityDetailsModel : (this.facilityDetailsModel = FacilityDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int index) {
            if (this.loanContractDetailsModel == null) {
                this.loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
            }
            return (LoanContractDetailsModel.LoanContractDetailsModelBuilder)this.getIndex(this.loanContractDetailsModel, index, () -> {
                LoanContractDetailsModel.LoanContractDetailsModelBuilder newLoanContractDetailsModel = LoanContractDetailsModel.builder();
                return newLoanContractDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public FacilityPositionStatementBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public FacilityPositionStatementBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public FacilityPositionStatementBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public FacilityPositionStatementBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public FacilityPositionStatementBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public FacilityPositionStatementBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public FacilityPositionStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public FacilityPositionStatementBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="statementDate", isRequired=true)
        @RuneAttribute(value="statementDate", isRequired=true)
        public FacilityPositionStatementBuilder setStatementDate(ZonedDateTime _statementDate) {
            this.statementDate = _statementDate == null ? null : _statementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public FacilityPositionStatementBuilder setComments(String _comments) {
            this.comments = _comments == null ? null : _comments;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityPosition", isRequired=true)
        @RuneAttribute(value="facilityPosition", isRequired=true)
        public FacilityPositionStatementBuilder setFacilityPosition(FacilityPosition _facilityPosition) {
            this.facilityPosition = _facilityPosition == null ? null : _facilityPosition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="positionPartyReference", isRequired=true)
        @RuneAttribute(value="positionPartyReference", isRequired=true)
        public FacilityPositionStatementBuilder setPositionPartyReference(PartyReference _positionPartyReference) {
            this.positionPartyReference = _positionPartyReference == null ? null : _positionPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public FacilityPositionStatementBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityPositionStatementBuilder setFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel) {
            this.facilityDetailsModel = _facilityDetailsModel == null ? null : _facilityDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public FacilityPositionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel) {
            if (_loanContractDetailsModel != null) {
                this.loanContractDetailsModel.add(_loanContractDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityPositionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel, int idx) {
            this.getIndex(this.loanContractDetailsModel, idx, () -> _loanContractDetailsModel.toBuilder());
            return this;
        }

        @Override
        public FacilityPositionStatementBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            if (loanContractDetailsModels != null) {
                for (LoanContractDetailsModel loanContractDetailsModel : loanContractDetailsModels) {
                    this.loanContractDetailsModel.add(loanContractDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanContractDetailsModel")
        public FacilityPositionStatementBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            this.loanContractDetailsModel = loanContractDetailsModels == null ? new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>() : (List)loanContractDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public FacilityPositionStatementBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityPositionStatementBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public FacilityPositionStatementBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public FacilityPositionStatementBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FacilityPositionStatement build() {
            return new FacilityPositionStatementImpl(this);
        }

        @Override
        public FacilityPositionStatementBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityPositionStatementBuilder prune() {
            super.prune();
            if (this.facilityPosition != null && !this.facilityPosition.prune().hasData()) {
                this.facilityPosition = null;
            }
            if (this.positionPartyReference != null && !this.positionPartyReference.prune().hasData()) {
                this.positionPartyReference = null;
            }
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.facilityDetailsModel != null && !this.facilityDetailsModel.prune().hasData()) {
                this.facilityDetailsModel = null;
            }
            this.loanContractDetailsModel = this.loanContractDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFacilityPosition() != null && this.getFacilityPosition().hasData()) {
                return true;
            }
            if (this.getPositionPartyReference() != null && this.getPositionPartyReference().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getFacilityDetailsModel() != null && this.getFacilityDetailsModel().hasData()) {
                return true;
            }
            if (this.getLoanContractDetailsModel() != null && this.getLoanContractDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FacilityPositionStatementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FacilityPositionStatementBuilder o = (FacilityPositionStatementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityPosition(), (RosettaModelObjectBuilder)o.getFacilityPosition(), this::setFacilityPosition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPositionPartyReference(), (RosettaModelObjectBuilder)o.getPositionPartyReference(), this::setPositionPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityDetailsModel(), (RosettaModelObjectBuilder)o.getFacilityDetailsModel(), this::setFacilityDetailsModel);
            merger.mergeRosetta(this.getLoanContractDetailsModel(), o.getLoanContractDetailsModel(), this::getOrCreateLoanContractDetailsModel);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityPositionStatement _that = (FacilityPositionStatement)this.getType().cast(o);
            if (!Objects.equals(this.facilityPosition, _that.getFacilityPosition())) {
                return false;
            }
            if (!Objects.equals(this.positionPartyReference, _that.getPositionPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            _result = 31 * _result + (this.positionPartyReference != null ? this.positionPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityPositionStatementBuilder {facilityPosition=" + String.valueOf(this.facilityPosition) + ", positionPartyReference=" + String.valueOf(this.positionPartyReference) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityDetailsModel=" + String.valueOf(this.facilityDetailsModel) + ", loanContractDetailsModel=" + String.valueOf(this.loanContractDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface FacilityPositionStatementBuilder
    extends FacilityPositionStatement,
    AbstractLoanStatement.AbstractLoanStatementBuilder {
        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition();

        @Override
        public FacilityPosition.FacilityPositionBuilder getFacilityPosition();

        public PartyReference.PartyReferenceBuilder getOrCreatePositionPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPositionPartyReference();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel();

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel();

        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int var1);

        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public FacilityPositionStatementBuilder setFpmlVersion(String var1);

        @Override
        public FacilityPositionStatementBuilder setExpectedBuild(Integer var1);

        @Override
        public FacilityPositionStatementBuilder setActualBuild(Integer var1);

        @Override
        public FacilityPositionStatementBuilder setHeader(RequestMessageHeader var1);

        @Override
        public FacilityPositionStatementBuilder setValidationModel(ValidationModel var1);

        @Override
        public FacilityPositionStatementBuilder setIsCorrection(Boolean var1);

        @Override
        public FacilityPositionStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public FacilityPositionStatementBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public FacilityPositionStatementBuilder setStatementDate(ZonedDateTime var1);

        @Override
        public FacilityPositionStatementBuilder setComments(String var1);

        public FacilityPositionStatementBuilder setFacilityPosition(FacilityPosition var1);

        public FacilityPositionStatementBuilder setPositionPartyReference(PartyReference var1);

        public FacilityPositionStatementBuilder setDealDetailsModel(DealDetailsModel var1);

        public FacilityPositionStatementBuilder setFacilityDetailsModel(FacilityDetailsModel var1);

        public FacilityPositionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1);

        public FacilityPositionStatementBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1, int var2);

        public FacilityPositionStatementBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public FacilityPositionStatementBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public FacilityPositionStatementBuilder addParty(Party var1);

        public FacilityPositionStatementBuilder addParty(Party var1, int var2);

        public FacilityPositionStatementBuilder addParty(List<? extends Party> var1);

        public FacilityPositionStatementBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.FacilityPositionBuilder.class, this.getFacilityPosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("positionPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPositionPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.FacilityDetailsModelBuilder.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.LoanContractDetailsModelBuilder.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public FacilityPositionStatementBuilder prune();
    }

    public static class FacilityPositionStatementImpl
    extends AbstractLoanStatement.AbstractLoanStatementImpl
    implements FacilityPositionStatement {
        private final FacilityPosition facilityPosition;
        private final PartyReference positionPartyReference;
        private final DealDetailsModel dealDetailsModel;
        private final FacilityDetailsModel facilityDetailsModel;
        private final List<? extends LoanContractDetailsModel> loanContractDetailsModel;
        private final List<? extends Party> party;

        protected FacilityPositionStatementImpl(FacilityPositionStatementBuilder builder) {
            super(builder);
            this.facilityPosition = Optional.ofNullable(builder.getFacilityPosition()).map(f -> f.build()).orElse(null);
            this.positionPartyReference = Optional.ofNullable(builder.getPositionPartyReference()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.facilityDetailsModel = Optional.ofNullable(builder.getFacilityDetailsModel()).map(f -> f.build()).orElse(null);
            this.loanContractDetailsModel = Optional.ofNullable(builder.getLoanContractDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityPosition", isRequired=true)
        @RuneAttribute(value="facilityPosition", isRequired=true)
        public FacilityPosition getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        @RosettaAttribute(value="positionPartyReference", isRequired=true)
        @RuneAttribute(value="positionPartyReference", isRequired=true)
        public PartyReference getPositionPartyReference() {
            return this.positionPartyReference;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public FacilityPositionStatement build() {
            return this;
        }

        @Override
        public FacilityPositionStatementBuilder toBuilder() {
            FacilityPositionStatementBuilder builder = FacilityPositionStatement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityPositionStatementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityPosition()).ifPresent(builder::setFacilityPosition);
            Optional.ofNullable(this.getPositionPartyReference()).ifPresent(builder::setPositionPartyReference);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getFacilityDetailsModel()).ifPresent(builder::setFacilityDetailsModel);
            Optional.ofNullable(this.getLoanContractDetailsModel()).ifPresent(builder::setLoanContractDetailsModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityPositionStatement _that = (FacilityPositionStatement)this.getType().cast(o);
            if (!Objects.equals(this.facilityPosition, _that.getFacilityPosition())) {
                return false;
            }
            if (!Objects.equals(this.positionPartyReference, _that.getPositionPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            _result = 31 * _result + (this.positionPartyReference != null ? this.positionPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityPositionStatement {facilityPosition=" + String.valueOf(this.facilityPosition) + ", positionPartyReference=" + String.valueOf(this.positionPartyReference) + ", dealDetailsModel=" + String.valueOf(this.dealDetailsModel) + ", facilityDetailsModel=" + String.valueOf(this.facilityDetailsModel) + ", loanContractDetailsModel=" + String.valueOf(this.loanContractDetailsModel) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

