/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.CommitmentSchedule;
import fpml.consolidated.loan.FacilityCommitment;
import fpml.consolidated.loan.FxTerms;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.FacilityCommitmentModelMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FacilityCommitmentModel", builder=FacilityCommitmentModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FacilityCommitmentModel", model="fpml", builder=FacilityCommitmentModelBuilderImpl.class, version="1.2.2")
public interface FacilityCommitmentModel
extends RosettaModelObject {
    public static final FacilityCommitmentModelMeta metaData = new FacilityCommitmentModelMeta();

    public FacilityCommitment getCurrentCommitment();

    public MoneyWithParticipantShare getOriginalCommitment();

    public CommitmentSchedule getCommitmentSchedule();

    public FxTerms getDealFxRate();

    public FacilityCommitmentModel build();

    public FacilityCommitmentModelBuilder toBuilder();

    public static FacilityCommitmentModelBuilder builder() {
        return new FacilityCommitmentModelBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityCommitmentModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityCommitmentModel> getType() {
        return FacilityCommitmentModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currentCommitment"), processor, FacilityCommitment.class, this.getCurrentCommitment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originalCommitment"), processor, MoneyWithParticipantShare.class, this.getOriginalCommitment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commitmentSchedule"), processor, CommitmentSchedule.class, this.getCommitmentSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealFxRate"), processor, FxTerms.class, this.getDealFxRate(), new AttributeMeta[0]);
    }

    public static class FacilityCommitmentModelBuilderImpl
    implements FacilityCommitmentModelBuilder {
        protected FacilityCommitment.FacilityCommitmentBuilder currentCommitment;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder originalCommitment;
        protected CommitmentSchedule.CommitmentScheduleBuilder commitmentSchedule;
        protected FxTerms.FxTermsBuilder dealFxRate;

        @Override
        @RosettaAttribute(value="currentCommitment", isRequired=true)
        @RuneAttribute(value="currentCommitment", isRequired=true)
        public FacilityCommitment.FacilityCommitmentBuilder getCurrentCommitment() {
            return this.currentCommitment;
        }

        @Override
        public FacilityCommitment.FacilityCommitmentBuilder getOrCreateCurrentCommitment() {
            FacilityCommitment.FacilityCommitmentBuilder result = this.currentCommitment != null ? this.currentCommitment : (this.currentCommitment = FacilityCommitment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originalCommitment")
        @RuneAttribute(value="originalCommitment")
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOriginalCommitment() {
            return this.originalCommitment;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateOriginalCommitment() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.originalCommitment != null ? this.originalCommitment : (this.originalCommitment = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commitmentSchedule")
        @RuneAttribute(value="commitmentSchedule")
        public CommitmentSchedule.CommitmentScheduleBuilder getCommitmentSchedule() {
            return this.commitmentSchedule;
        }

        @Override
        public CommitmentSchedule.CommitmentScheduleBuilder getOrCreateCommitmentSchedule() {
            CommitmentSchedule.CommitmentScheduleBuilder result = this.commitmentSchedule != null ? this.commitmentSchedule : (this.commitmentSchedule = CommitmentSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealFxRate")
        @RuneAttribute(value="dealFxRate")
        public FxTerms.FxTermsBuilder getDealFxRate() {
            return this.dealFxRate;
        }

        @Override
        public FxTerms.FxTermsBuilder getOrCreateDealFxRate() {
            FxTerms.FxTermsBuilder result = this.dealFxRate != null ? this.dealFxRate : (this.dealFxRate = FxTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currentCommitment", isRequired=true)
        @RuneAttribute(value="currentCommitment", isRequired=true)
        public FacilityCommitmentModelBuilder setCurrentCommitment(FacilityCommitment _currentCommitment) {
            this.currentCommitment = _currentCommitment == null ? null : _currentCommitment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originalCommitment")
        @RuneAttribute(value="originalCommitment")
        public FacilityCommitmentModelBuilder setOriginalCommitment(MoneyWithParticipantShare _originalCommitment) {
            this.originalCommitment = _originalCommitment == null ? null : _originalCommitment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commitmentSchedule")
        @RuneAttribute(value="commitmentSchedule")
        public FacilityCommitmentModelBuilder setCommitmentSchedule(CommitmentSchedule _commitmentSchedule) {
            this.commitmentSchedule = _commitmentSchedule == null ? null : _commitmentSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealFxRate")
        @RuneAttribute(value="dealFxRate")
        public FacilityCommitmentModelBuilder setDealFxRate(FxTerms _dealFxRate) {
            this.dealFxRate = _dealFxRate == null ? null : _dealFxRate.toBuilder();
            return this;
        }

        @Override
        public FacilityCommitmentModel build() {
            return new FacilityCommitmentModelImpl(this);
        }

        @Override
        public FacilityCommitmentModelBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityCommitmentModelBuilder prune() {
            if (this.currentCommitment != null && !this.currentCommitment.prune().hasData()) {
                this.currentCommitment = null;
            }
            if (this.originalCommitment != null && !this.originalCommitment.prune().hasData()) {
                this.originalCommitment = null;
            }
            if (this.commitmentSchedule != null && !this.commitmentSchedule.prune().hasData()) {
                this.commitmentSchedule = null;
            }
            if (this.dealFxRate != null && !this.dealFxRate.prune().hasData()) {
                this.dealFxRate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurrentCommitment() != null && this.getCurrentCommitment().hasData()) {
                return true;
            }
            if (this.getOriginalCommitment() != null && this.getOriginalCommitment().hasData()) {
                return true;
            }
            if (this.getCommitmentSchedule() != null && this.getCommitmentSchedule().hasData()) {
                return true;
            }
            return this.getDealFxRate() != null && this.getDealFxRate().hasData();
        }

        public FacilityCommitmentModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FacilityCommitmentModelBuilder o = (FacilityCommitmentModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrentCommitment(), (RosettaModelObjectBuilder)o.getCurrentCommitment(), this::setCurrentCommitment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginalCommitment(), (RosettaModelObjectBuilder)o.getOriginalCommitment(), this::setOriginalCommitment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommitmentSchedule(), (RosettaModelObjectBuilder)o.getCommitmentSchedule(), this::setCommitmentSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealFxRate(), (RosettaModelObjectBuilder)o.getDealFxRate(), this::setDealFxRate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityCommitmentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.currentCommitment, _that.getCurrentCommitment())) {
                return false;
            }
            if (!Objects.equals(this.originalCommitment, _that.getOriginalCommitment())) {
                return false;
            }
            if (!Objects.equals(this.commitmentSchedule, _that.getCommitmentSchedule())) {
                return false;
            }
            return Objects.equals(this.dealFxRate, _that.getDealFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currentCommitment != null ? this.currentCommitment.hashCode() : 0);
            _result = 31 * _result + (this.originalCommitment != null ? this.originalCommitment.hashCode() : 0);
            _result = 31 * _result + (this.commitmentSchedule != null ? this.commitmentSchedule.hashCode() : 0);
            _result = 31 * _result + (this.dealFxRate != null ? this.dealFxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityCommitmentModelBuilder {currentCommitment=" + String.valueOf(this.currentCommitment) + ", originalCommitment=" + String.valueOf(this.originalCommitment) + ", commitmentSchedule=" + String.valueOf(this.commitmentSchedule) + ", dealFxRate=" + String.valueOf(this.dealFxRate) + "}";
        }
    }

    public static interface FacilityCommitmentModelBuilder
    extends FacilityCommitmentModel,
    RosettaModelObjectBuilder {
        public FacilityCommitment.FacilityCommitmentBuilder getOrCreateCurrentCommitment();

        @Override
        public FacilityCommitment.FacilityCommitmentBuilder getCurrentCommitment();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateOriginalCommitment();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOriginalCommitment();

        public CommitmentSchedule.CommitmentScheduleBuilder getOrCreateCommitmentSchedule();

        @Override
        public CommitmentSchedule.CommitmentScheduleBuilder getCommitmentSchedule();

        public FxTerms.FxTermsBuilder getOrCreateDealFxRate();

        @Override
        public FxTerms.FxTermsBuilder getDealFxRate();

        public FacilityCommitmentModelBuilder setCurrentCommitment(FacilityCommitment var1);

        public FacilityCommitmentModelBuilder setOriginalCommitment(MoneyWithParticipantShare var1);

        public FacilityCommitmentModelBuilder setCommitmentSchedule(CommitmentSchedule var1);

        public FacilityCommitmentModelBuilder setDealFxRate(FxTerms var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currentCommitment"), processor, FacilityCommitment.FacilityCommitmentBuilder.class, this.getCurrentCommitment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originalCommitment"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getOriginalCommitment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commitmentSchedule"), processor, CommitmentSchedule.CommitmentScheduleBuilder.class, this.getCommitmentSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealFxRate"), processor, FxTerms.FxTermsBuilder.class, this.getDealFxRate(), new AttributeMeta[0]);
        }

        public FacilityCommitmentModelBuilder prune();
    }

    public static class FacilityCommitmentModelImpl
    implements FacilityCommitmentModel {
        private final FacilityCommitment currentCommitment;
        private final MoneyWithParticipantShare originalCommitment;
        private final CommitmentSchedule commitmentSchedule;
        private final FxTerms dealFxRate;

        protected FacilityCommitmentModelImpl(FacilityCommitmentModelBuilder builder) {
            this.currentCommitment = Optional.ofNullable(builder.getCurrentCommitment()).map(f -> f.build()).orElse(null);
            this.originalCommitment = Optional.ofNullable(builder.getOriginalCommitment()).map(f -> f.build()).orElse(null);
            this.commitmentSchedule = Optional.ofNullable(builder.getCommitmentSchedule()).map(f -> f.build()).orElse(null);
            this.dealFxRate = Optional.ofNullable(builder.getDealFxRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="currentCommitment", isRequired=true)
        @RuneAttribute(value="currentCommitment", isRequired=true)
        public FacilityCommitment getCurrentCommitment() {
            return this.currentCommitment;
        }

        @Override
        @RosettaAttribute(value="originalCommitment")
        @RuneAttribute(value="originalCommitment")
        public MoneyWithParticipantShare getOriginalCommitment() {
            return this.originalCommitment;
        }

        @Override
        @RosettaAttribute(value="commitmentSchedule")
        @RuneAttribute(value="commitmentSchedule")
        public CommitmentSchedule getCommitmentSchedule() {
            return this.commitmentSchedule;
        }

        @Override
        @RosettaAttribute(value="dealFxRate")
        @RuneAttribute(value="dealFxRate")
        public FxTerms getDealFxRate() {
            return this.dealFxRate;
        }

        @Override
        public FacilityCommitmentModel build() {
            return this;
        }

        @Override
        public FacilityCommitmentModelBuilder toBuilder() {
            FacilityCommitmentModelBuilder builder = FacilityCommitmentModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityCommitmentModelBuilder builder) {
            Optional.ofNullable(this.getCurrentCommitment()).ifPresent(builder::setCurrentCommitment);
            Optional.ofNullable(this.getOriginalCommitment()).ifPresent(builder::setOriginalCommitment);
            Optional.ofNullable(this.getCommitmentSchedule()).ifPresent(builder::setCommitmentSchedule);
            Optional.ofNullable(this.getDealFxRate()).ifPresent(builder::setDealFxRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityCommitmentModel _that = this.getType().cast(o);
            if (!Objects.equals(this.currentCommitment, _that.getCurrentCommitment())) {
                return false;
            }
            if (!Objects.equals(this.originalCommitment, _that.getOriginalCommitment())) {
                return false;
            }
            if (!Objects.equals(this.commitmentSchedule, _that.getCommitmentSchedule())) {
                return false;
            }
            return Objects.equals(this.dealFxRate, _that.getDealFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currentCommitment != null ? this.currentCommitment.hashCode() : 0);
            _result = 31 * _result + (this.originalCommitment != null ? this.originalCommitment.hashCode() : 0);
            _result = 31 * _result + (this.commitmentSchedule != null ? this.commitmentSchedule.hashCode() : 0);
            _result = 31 * _result + (this.dealFxRate != null ? this.dealFxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityCommitmentModel {currentCommitment=" + String.valueOf(this.currentCommitment) + ", originalCommitment=" + String.valueOf(this.originalCommitment) + ", commitmentSchedule=" + String.valueOf(this.commitmentSchedule) + ", dealFxRate=" + String.valueOf(this.dealFxRate) + "}";
        }
    }
}

