/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.AbstractLoanServicingEventMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLoanServicingEvent", builder=AbstractLoanServicingEventBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractLoanServicingEvent", model="fpml", builder=AbstractLoanServicingEventBuilderImpl.class, version="1.2.2")
public interface AbstractLoanServicingEvent
extends AbstractLoanEvent {
    public static final AbstractLoanServicingEventMeta metaData = new AbstractLoanServicingEventMeta();

    public BusinessEventPartiesModel getBusinessEventPartiesModel();

    public ZonedDateTime getEffectiveDate();

    public LoanLegalActionReference getLegalActionReference();

    @Override
    public AbstractLoanServicingEvent build();

    @Override
    public AbstractLoanServicingEventBuilder toBuilder();

    public static AbstractLoanServicingEventBuilder builder() {
        return new AbstractLoanServicingEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanServicingEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanServicingEvent> getType() {
        return AbstractLoanServicingEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
    }

    public static class AbstractLoanServicingEventBuilderImpl
    extends AbstractLoanEvent.AbstractLoanEventBuilderImpl
    implements AbstractLoanServicingEventBuilder {
        protected BusinessEventPartiesModel.BusinessEventPartiesModelBuilder businessEventPartiesModel;
        protected ZonedDateTime effectiveDate;
        protected LoanLegalActionReference.LoanLegalActionReferenceBuilder legalActionReference;

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public BusinessEventPartiesModel.BusinessEventPartiesModelBuilder getBusinessEventPartiesModel() {
            return this.businessEventPartiesModel;
        }

        @Override
        public BusinessEventPartiesModel.BusinessEventPartiesModelBuilder getOrCreateBusinessEventPartiesModel() {
            BusinessEventPartiesModel.BusinessEventPartiesModelBuilder result = this.businessEventPartiesModel != null ? this.businessEventPartiesModel : (this.businessEventPartiesModel = BusinessEventPartiesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LoanLegalActionReference.LoanLegalActionReferenceBuilder getLegalActionReference() {
            return this.legalActionReference;
        }

        @Override
        public LoanLegalActionReference.LoanLegalActionReferenceBuilder getOrCreateLegalActionReference() {
            LoanLegalActionReference.LoanLegalActionReferenceBuilder result = this.legalActionReference != null ? this.legalActionReference : (this.legalActionReference = LoanLegalActionReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractLoanServicingEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanServicingEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanServicingEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractLoanServicingEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLoanServicingEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractLoanServicingEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractLoanServicingEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AbstractLoanServicingEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractLoanServicingEventBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AbstractLoanServicingEventBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        public AbstractLoanServicingEvent build() {
            return new AbstractLoanServicingEventImpl(this);
        }

        @Override
        public AbstractLoanServicingEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanServicingEventBuilder prune() {
            super.prune();
            if (this.businessEventPartiesModel != null && !this.businessEventPartiesModel.prune().hasData()) {
                this.businessEventPartiesModel = null;
            }
            if (this.legalActionReference != null && !this.legalActionReference.prune().hasData()) {
                this.legalActionReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBusinessEventPartiesModel() != null && this.getBusinessEventPartiesModel().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            return this.getLegalActionReference() != null && this.getLegalActionReference().hasData();
        }

        @Override
        public AbstractLoanServicingEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanServicingEventBuilder o = (AbstractLoanServicingEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), (RosettaModelObjectBuilder)o.getBusinessEventPartiesModel(), this::setBusinessEventPartiesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalActionReference(), (RosettaModelObjectBuilder)o.getLegalActionReference(), this::setLegalActionReference);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanServicingEvent _that = (AbstractLoanServicingEvent)this.getType().cast(o);
            if (!Objects.equals(this.businessEventPartiesModel, _that.getBusinessEventPartiesModel())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.legalActionReference, _that.getLegalActionReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessEventPartiesModel != null ? this.businessEventPartiesModel.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.legalActionReference != null ? this.legalActionReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanServicingEventBuilder {businessEventPartiesModel=" + String.valueOf(this.businessEventPartiesModel) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", legalActionReference=" + String.valueOf(this.legalActionReference) + "} " + super.toString();
        }
    }

    public static interface AbstractLoanServicingEventBuilder
    extends AbstractLoanServicingEvent,
    AbstractLoanEvent.AbstractLoanEventBuilder {
        public BusinessEventPartiesModel.BusinessEventPartiesModelBuilder getOrCreateBusinessEventPartiesModel();

        @Override
        public BusinessEventPartiesModel.BusinessEventPartiesModelBuilder getBusinessEventPartiesModel();

        public LoanLegalActionReference.LoanLegalActionReferenceBuilder getOrCreateLegalActionReference();

        @Override
        public LoanLegalActionReference.LoanLegalActionReferenceBuilder getLegalActionReference();

        @Override
        public AbstractLoanServicingEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractLoanServicingEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractLoanServicingEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanServicingEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanServicingEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractLoanServicingEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractLoanServicingEventBuilder setComment(String var1);

        public AbstractLoanServicingEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        public AbstractLoanServicingEventBuilder setEffectiveDate(ZonedDateTime var1);

        public AbstractLoanServicingEventBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, this.getLegalActionReference(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanServicingEventBuilder prune();
    }

    public static class AbstractLoanServicingEventImpl
    extends AbstractLoanEvent.AbstractLoanEventImpl
    implements AbstractLoanServicingEvent {
        private final BusinessEventPartiesModel businessEventPartiesModel;
        private final ZonedDateTime effectiveDate;
        private final LoanLegalActionReference legalActionReference;

        protected AbstractLoanServicingEventImpl(AbstractLoanServicingEventBuilder builder) {
            super(builder);
            this.businessEventPartiesModel = Optional.ofNullable(builder.getBusinessEventPartiesModel()).map(f -> f.build()).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.legalActionReference = Optional.ofNullable(builder.getLegalActionReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public BusinessEventPartiesModel getBusinessEventPartiesModel() {
            return this.businessEventPartiesModel;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LoanLegalActionReference getLegalActionReference() {
            return this.legalActionReference;
        }

        @Override
        public AbstractLoanServicingEvent build() {
            return this;
        }

        @Override
        public AbstractLoanServicingEventBuilder toBuilder() {
            AbstractLoanServicingEventBuilder builder = AbstractLoanServicingEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanServicingEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBusinessEventPartiesModel()).ifPresent(builder::setBusinessEventPartiesModel);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getLegalActionReference()).ifPresent(builder::setLegalActionReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanServicingEvent _that = (AbstractLoanServicingEvent)this.getType().cast(o);
            if (!Objects.equals(this.businessEventPartiesModel, _that.getBusinessEventPartiesModel())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.legalActionReference, _that.getLegalActionReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessEventPartiesModel != null ? this.businessEventPartiesModel.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.legalActionReference != null ? this.legalActionReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanServicingEvent {businessEventPartiesModel=" + String.valueOf(this.businessEventPartiesModel) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", legalActionReference=" + String.valueOf(this.legalActionReference) + "} " + super.toString();
        }
    }
}

