/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AbstractAccrualOptionBase;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.LoanFloatingRate;
import fpml.consolidated.loan.meta.AbstractLoanFloatingRateOptionBaseMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AbstractLoanFloatingRateOptionBase", builder=AbstractLoanFloatingRateOptionBaseBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractLoanFloatingRateOptionBase", model="fpml", builder=AbstractLoanFloatingRateOptionBaseBuilderImpl.class, version="1.2.2")
public interface AbstractLoanFloatingRateOptionBase
extends AbstractAccrualOptionBase {
    public static final AbstractLoanFloatingRateOptionBaseMeta metaData = new AbstractLoanFloatingRateOptionBaseMeta();

    public LoanFloatingRate getRate();

    @Override
    public AbstractLoanFloatingRateOptionBase build();

    @Override
    public AbstractLoanFloatingRateOptionBaseBuilder toBuilder();

    public static AbstractLoanFloatingRateOptionBaseBuilder builder() {
        return new AbstractLoanFloatingRateOptionBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanFloatingRateOptionBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanFloatingRateOptionBase> getType() {
        return AbstractLoanFloatingRateOptionBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rate"), processor, LoanFloatingRate.class, this.getRate(), new AttributeMeta[0]);
    }

    public static class AbstractLoanFloatingRateOptionBaseBuilderImpl
    extends AbstractAccrualOptionBase.AbstractAccrualOptionBaseBuilderImpl
    implements AbstractLoanFloatingRateOptionBaseBuilder {
        protected LoanFloatingRate.LoanFloatingRateBuilder rate;

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public LoanFloatingRate.LoanFloatingRateBuilder getRate() {
            return this.rate;
        }

        @Override
        public LoanFloatingRate.LoanFloatingRateBuilder getOrCreateRate() {
            LoanFloatingRate.LoanFloatingRateBuilder result = this.rate != null ? this.rate : (this.rate = LoanFloatingRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public AbstractLoanFloatingRateOptionBaseBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public AbstractLoanFloatingRateOptionBaseBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public AbstractLoanFloatingRateOptionBaseBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public AbstractLoanFloatingRateOptionBaseBuilder setRate(LoanFloatingRate _rate) {
            this.rate = _rate == null ? null : _rate.toBuilder();
            return this;
        }

        @Override
        public AbstractLoanFloatingRateOptionBase build() {
            return new AbstractLoanFloatingRateOptionBaseImpl(this);
        }

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder prune() {
            super.prune();
            if (this.rate != null && !this.rate.prune().hasData()) {
                this.rate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getRate() != null && this.getRate().hasData();
        }

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanFloatingRateOptionBaseBuilder o = (AbstractLoanFloatingRateOptionBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRate(), (RosettaModelObjectBuilder)o.getRate(), this::setRate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanFloatingRateOptionBase _that = (AbstractLoanFloatingRateOptionBase)this.getType().cast(o);
            return Objects.equals(this.rate, _that.getRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanFloatingRateOptionBaseBuilder {rate=" + String.valueOf(this.rate) + "} " + super.toString();
        }
    }

    public static interface AbstractLoanFloatingRateOptionBaseBuilder
    extends AbstractLoanFloatingRateOptionBase,
    AbstractAccrualOptionBase.AbstractAccrualOptionBaseBuilder {
        public LoanFloatingRate.LoanFloatingRateBuilder getOrCreateRate();

        @Override
        public LoanFloatingRate.LoanFloatingRateBuilder getRate();

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder setPaymentFrequency(Period var1);

        public AbstractLoanFloatingRateOptionBaseBuilder setRate(LoanFloatingRate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rate"), processor, LoanFloatingRate.LoanFloatingRateBuilder.class, this.getRate(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder prune();
    }

    public static class AbstractLoanFloatingRateOptionBaseImpl
    extends AbstractAccrualOptionBase.AbstractAccrualOptionBaseImpl
    implements AbstractLoanFloatingRateOptionBase {
        private final LoanFloatingRate rate;

        protected AbstractLoanFloatingRateOptionBaseImpl(AbstractLoanFloatingRateOptionBaseBuilder builder) {
            super(builder);
            this.rate = Optional.ofNullable(builder.getRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public LoanFloatingRate getRate() {
            return this.rate;
        }

        @Override
        public AbstractLoanFloatingRateOptionBase build() {
            return this;
        }

        @Override
        public AbstractLoanFloatingRateOptionBaseBuilder toBuilder() {
            AbstractLoanFloatingRateOptionBaseBuilder builder = AbstractLoanFloatingRateOptionBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanFloatingRateOptionBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanFloatingRateOptionBase _that = (AbstractLoanFloatingRateOptionBase)this.getType().cast(o);
            return Objects.equals(this.rate, _that.getRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanFloatingRateOptionBase {rate=" + String.valueOf(this.rate) + "} " + super.toString();
        }
    }
}

