/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanAllocationEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.FacilityPosition;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanAllocationReference;
import fpml.consolidated.loan.meta.AbstractLoanAllocationSettlementEventMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLoanAllocationSettlementEvent", builder=AbstractLoanAllocationSettlementEventBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractLoanAllocationSettlementEvent", model="fpml", builder=AbstractLoanAllocationSettlementEventBuilderImpl.class, version="1.2.2")
public interface AbstractLoanAllocationSettlementEvent
extends AbstractLoanAllocationEvent {
    public static final AbstractLoanAllocationSettlementEventMeta metaData = new AbstractLoanAllocationSettlementEventMeta();

    public ZonedDateTime getSettlementDate();

    public NonNegativeMoney getAllocationAmount();

    public FacilityPosition getFacilityPosition();

    @Override
    public AbstractLoanAllocationSettlementEvent build();

    @Override
    public AbstractLoanAllocationSettlementEventBuilder toBuilder();

    public static AbstractLoanAllocationSettlementEventBuilder builder() {
        return new AbstractLoanAllocationSettlementEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanAllocationSettlementEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanAllocationSettlementEvent> getType() {
        return AbstractLoanAllocationSettlementEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.class, this.getAllocationReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationAmount"), processor, NonNegativeMoney.class, this.getAllocationAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.class, this.getFacilityPosition(), new AttributeMeta[0]);
    }

    public static class AbstractLoanAllocationSettlementEventBuilderImpl
    extends AbstractLoanAllocationEvent.AbstractLoanAllocationEventBuilderImpl
    implements AbstractLoanAllocationSettlementEventBuilder {
        protected ZonedDateTime settlementDate;
        protected NonNegativeMoney.NonNegativeMoneyBuilder allocationAmount;
        protected FacilityPosition.FacilityPositionBuilder facilityPosition;

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public ZonedDateTime getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="allocationAmount", isRequired=true)
        @RuneAttribute(value="allocationAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAllocationAmount() {
            return this.allocationAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAllocationAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.allocationAmount != null ? this.allocationAmount : (this.allocationAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityPosition", isRequired=true)
        @RuneAttribute(value="facilityPosition", isRequired=true)
        public FacilityPosition.FacilityPositionBuilder getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition() {
            FacilityPosition.FacilityPositionBuilder result = this.facilityPosition != null ? this.facilityPosition : (this.facilityPosition = FacilityPosition.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractLoanAllocationSettlementEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanAllocationSettlementEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanAllocationSettlementEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractLoanAllocationSettlementEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractLoanAllocationSettlementEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractLoanAllocationSettlementEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractLoanAllocationSettlementEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationReference", isRequired=true)
        @RuneAttribute(value="allocationReference", isRequired=true)
        public AbstractLoanAllocationSettlementEventBuilder setAllocationReference(LoanAllocationReference _allocationReference) {
            this.allocationReference = _allocationReference == null ? null : _allocationReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AbstractLoanAllocationSettlementEventBuilder setSettlementDate(ZonedDateTime _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationAmount", isRequired=true)
        @RuneAttribute(value="allocationAmount", isRequired=true)
        public AbstractLoanAllocationSettlementEventBuilder setAllocationAmount(NonNegativeMoney _allocationAmount) {
            this.allocationAmount = _allocationAmount == null ? null : _allocationAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityPosition", isRequired=true)
        @RuneAttribute(value="facilityPosition", isRequired=true)
        public AbstractLoanAllocationSettlementEventBuilder setFacilityPosition(FacilityPosition _facilityPosition) {
            this.facilityPosition = _facilityPosition == null ? null : _facilityPosition.toBuilder();
            return this;
        }

        @Override
        public AbstractLoanAllocationSettlementEvent build() {
            return new AbstractLoanAllocationSettlementEventImpl(this);
        }

        @Override
        public AbstractLoanAllocationSettlementEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanAllocationSettlementEventBuilder prune() {
            super.prune();
            if (this.allocationAmount != null && !this.allocationAmount.prune().hasData()) {
                this.allocationAmount = null;
            }
            if (this.facilityPosition != null && !this.facilityPosition.prune().hasData()) {
                this.facilityPosition = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSettlementDate() != null) {
                return true;
            }
            if (this.getAllocationAmount() != null && this.getAllocationAmount().hasData()) {
                return true;
            }
            return this.getFacilityPosition() != null && this.getFacilityPosition().hasData();
        }

        @Override
        public AbstractLoanAllocationSettlementEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanAllocationSettlementEventBuilder o = (AbstractLoanAllocationSettlementEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocationAmount(), (RosettaModelObjectBuilder)o.getAllocationAmount(), this::setAllocationAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityPosition(), (RosettaModelObjectBuilder)o.getFacilityPosition(), this::setFacilityPosition);
            merger.mergeBasic((Object)this.getSettlementDate(), (Object)o.getSettlementDate(), this::setSettlementDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanAllocationSettlementEvent _that = (AbstractLoanAllocationSettlementEvent)this.getType().cast(o);
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.allocationAmount, _that.getAllocationAmount())) {
                return false;
            }
            return Objects.equals(this.facilityPosition, _that.getFacilityPosition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.allocationAmount != null ? this.allocationAmount.hashCode() : 0);
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanAllocationSettlementEventBuilder {settlementDate=" + String.valueOf(this.settlementDate) + ", allocationAmount=" + String.valueOf(this.allocationAmount) + ", facilityPosition=" + String.valueOf(this.facilityPosition) + "} " + super.toString();
        }
    }

    public static interface AbstractLoanAllocationSettlementEventBuilder
    extends AbstractLoanAllocationSettlementEvent,
    AbstractLoanAllocationEvent.AbstractLoanAllocationEventBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAllocationAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAllocationAmount();

        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition();

        @Override
        public FacilityPosition.FacilityPositionBuilder getFacilityPosition();

        @Override
        public AbstractLoanAllocationSettlementEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractLoanAllocationSettlementEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractLoanAllocationSettlementEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanAllocationSettlementEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractLoanAllocationSettlementEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractLoanAllocationSettlementEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractLoanAllocationSettlementEventBuilder setComment(String var1);

        @Override
        public AbstractLoanAllocationSettlementEventBuilder setAllocationReference(LoanAllocationReference var1);

        public AbstractLoanAllocationSettlementEventBuilder setSettlementDate(ZonedDateTime var1);

        public AbstractLoanAllocationSettlementEventBuilder setAllocationAmount(NonNegativeMoney var1);

        public AbstractLoanAllocationSettlementEventBuilder setFacilityPosition(FacilityPosition var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.LoanAllocationReferenceBuilder.class, (RosettaModelObjectBuilder)this.getAllocationReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAllocationAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.FacilityPositionBuilder.class, this.getFacilityPosition(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanAllocationSettlementEventBuilder prune();
    }

    public static class AbstractLoanAllocationSettlementEventImpl
    extends AbstractLoanAllocationEvent.AbstractLoanAllocationEventImpl
    implements AbstractLoanAllocationSettlementEvent {
        private final ZonedDateTime settlementDate;
        private final NonNegativeMoney allocationAmount;
        private final FacilityPosition facilityPosition;

        protected AbstractLoanAllocationSettlementEventImpl(AbstractLoanAllocationSettlementEventBuilder builder) {
            super(builder);
            this.settlementDate = builder.getSettlementDate();
            this.allocationAmount = Optional.ofNullable(builder.getAllocationAmount()).map(f -> f.build()).orElse(null);
            this.facilityPosition = Optional.ofNullable(builder.getFacilityPosition()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public ZonedDateTime getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="allocationAmount", isRequired=true)
        @RuneAttribute(value="allocationAmount", isRequired=true)
        public NonNegativeMoney getAllocationAmount() {
            return this.allocationAmount;
        }

        @Override
        @RosettaAttribute(value="facilityPosition", isRequired=true)
        @RuneAttribute(value="facilityPosition", isRequired=true)
        public FacilityPosition getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        public AbstractLoanAllocationSettlementEvent build() {
            return this;
        }

        @Override
        public AbstractLoanAllocationSettlementEventBuilder toBuilder() {
            AbstractLoanAllocationSettlementEventBuilder builder = AbstractLoanAllocationSettlementEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanAllocationSettlementEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getAllocationAmount()).ifPresent(builder::setAllocationAmount);
            Optional.ofNullable(this.getFacilityPosition()).ifPresent(builder::setFacilityPosition);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanAllocationSettlementEvent _that = (AbstractLoanAllocationSettlementEvent)this.getType().cast(o);
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.allocationAmount, _that.getAllocationAmount())) {
                return false;
            }
            return Objects.equals(this.facilityPosition, _that.getFacilityPosition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.allocationAmount != null ? this.allocationAmount.hashCode() : 0);
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanAllocationSettlementEvent {settlementDate=" + String.valueOf(this.settlementDate) + ", allocationAmount=" + String.valueOf(this.allocationAmount) + ", facilityPosition=" + String.valueOf(this.facilityPosition) + "} " + super.toString();
        }
    }
}

