/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractServicingNotification;
import fpml.consolidated.loan.EventPayment;
import fpml.consolidated.loan.FacilityPosition;
import fpml.consolidated.loan.meta.AbstractContractNotificationMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractContractNotification", builder=AbstractContractNotificationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractContractNotification", model="fpml", builder=AbstractContractNotificationBuilderImpl.class, version="1.2.2")
public interface AbstractContractNotification
extends AbstractServicingNotification {
    public static final AbstractContractNotificationMeta metaData = new AbstractContractNotificationMeta();

    public List<? extends FacilityPosition> getFacilityPosition();

    @Override
    public AbstractContractNotification build();

    @Override
    public AbstractContractNotificationBuilder toBuilder();

    public static AbstractContractNotificationBuilder builder() {
        return new AbstractContractNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractContractNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractContractNotification> getType() {
        return AbstractContractNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.class, this.getEventPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.class, this.getFacilityPosition(), new AttributeMeta[0]);
    }

    public static class AbstractContractNotificationBuilderImpl
    extends AbstractServicingNotification.AbstractServicingNotificationBuilderImpl
    implements AbstractContractNotificationBuilder {
        protected List<FacilityPosition.FacilityPositionBuilder> facilityPosition = new ArrayList<FacilityPosition.FacilityPositionBuilder>();

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public List<? extends FacilityPosition.FacilityPositionBuilder> getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition(int index) {
            if (this.facilityPosition == null) {
                this.facilityPosition = new ArrayList<FacilityPosition.FacilityPositionBuilder>();
            }
            return (FacilityPosition.FacilityPositionBuilder)this.getIndex(this.facilityPosition, index, () -> {
                FacilityPosition.FacilityPositionBuilder newFacilityPosition = FacilityPosition.builder();
                return newFacilityPosition;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public AbstractContractNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public AbstractContractNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public AbstractContractNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public AbstractContractNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public AbstractContractNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public AbstractContractNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public AbstractContractNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public AbstractContractNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public AbstractContractNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public AbstractContractNotificationBuilder setIsGlobalOnly(Boolean _isGlobalOnly) {
            this.isGlobalOnly = _isGlobalOnly == null ? null : _isGlobalOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public AbstractContractNotificationBuilder addEventPayment(EventPayment _eventPayment) {
            if (_eventPayment != null) {
                this.eventPayment.add(_eventPayment.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractContractNotificationBuilder addEventPayment(EventPayment _eventPayment, int idx) {
            this.getIndex(this.eventPayment, idx, () -> _eventPayment.toBuilder());
            return this;
        }

        @Override
        public AbstractContractNotificationBuilder addEventPayment(List<? extends EventPayment> eventPayments) {
            if (eventPayments != null) {
                for (EventPayment eventPayment : eventPayments) {
                    this.eventPayment.add(eventPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPayment")
        public AbstractContractNotificationBuilder setEventPayment(List<? extends EventPayment> eventPayments) {
            this.eventPayment = eventPayments == null ? new ArrayList() : (List)eventPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public AbstractContractNotificationBuilder addFacilityPosition(FacilityPosition _facilityPosition) {
            if (_facilityPosition != null) {
                this.facilityPosition.add(_facilityPosition.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractContractNotificationBuilder addFacilityPosition(FacilityPosition _facilityPosition, int idx) {
            this.getIndex(this.facilityPosition, idx, () -> _facilityPosition.toBuilder());
            return this;
        }

        @Override
        public AbstractContractNotificationBuilder addFacilityPosition(List<? extends FacilityPosition> facilityPositions) {
            if (facilityPositions != null) {
                for (FacilityPosition facilityPosition : facilityPositions) {
                    this.facilityPosition.add(facilityPosition.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityPosition")
        public AbstractContractNotificationBuilder setFacilityPosition(List<? extends FacilityPosition> facilityPositions) {
            this.facilityPosition = facilityPositions == null ? new ArrayList<FacilityPosition.FacilityPositionBuilder>() : (List)facilityPositions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AbstractContractNotification build() {
            return new AbstractContractNotificationImpl(this);
        }

        @Override
        public AbstractContractNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractContractNotificationBuilder prune() {
            super.prune();
            this.facilityPosition = this.facilityPosition.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getFacilityPosition() != null && this.getFacilityPosition().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public AbstractContractNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractContractNotificationBuilder o = (AbstractContractNotificationBuilder)other;
            merger.mergeRosetta(this.getFacilityPosition(), o.getFacilityPosition(), this::getOrCreateFacilityPosition);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractContractNotification _that = (AbstractContractNotification)this.getType().cast(o);
            return ListEquals.listEquals(this.facilityPosition, _that.getFacilityPosition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractContractNotificationBuilder {facilityPosition=" + String.valueOf(this.facilityPosition) + "} " + super.toString();
        }
    }

    public static interface AbstractContractNotificationBuilder
    extends AbstractContractNotification,
    AbstractServicingNotification.AbstractServicingNotificationBuilder {
        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition(int var1);

        public List<? extends FacilityPosition.FacilityPositionBuilder> getFacilityPosition();

        @Override
        public AbstractContractNotificationBuilder setFpmlVersion(String var1);

        @Override
        public AbstractContractNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public AbstractContractNotificationBuilder setActualBuild(Integer var1);

        @Override
        public AbstractContractNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public AbstractContractNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public AbstractContractNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public AbstractContractNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public AbstractContractNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public AbstractContractNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public AbstractContractNotificationBuilder setIsGlobalOnly(Boolean var1);

        @Override
        public AbstractContractNotificationBuilder addEventPayment(EventPayment var1);

        @Override
        public AbstractContractNotificationBuilder addEventPayment(EventPayment var1, int var2);

        @Override
        public AbstractContractNotificationBuilder addEventPayment(List<? extends EventPayment> var1);

        @Override
        public AbstractContractNotificationBuilder setEventPayment(List<? extends EventPayment> var1);

        public AbstractContractNotificationBuilder addFacilityPosition(FacilityPosition var1);

        public AbstractContractNotificationBuilder addFacilityPosition(FacilityPosition var1, int var2);

        public AbstractContractNotificationBuilder addFacilityPosition(List<? extends FacilityPosition> var1);

        public AbstractContractNotificationBuilder setFacilityPosition(List<? extends FacilityPosition> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.EventPaymentBuilder.class, this.getEventPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.FacilityPositionBuilder.class, this.getFacilityPosition(), new AttributeMeta[0]);
        }

        @Override
        public AbstractContractNotificationBuilder prune();
    }

    public static class AbstractContractNotificationImpl
    extends AbstractServicingNotification.AbstractServicingNotificationImpl
    implements AbstractContractNotification {
        private final List<? extends FacilityPosition> facilityPosition;

        protected AbstractContractNotificationImpl(AbstractContractNotificationBuilder builder) {
            super(builder);
            this.facilityPosition = Optional.ofNullable(builder.getFacilityPosition()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public List<? extends FacilityPosition> getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        public AbstractContractNotification build() {
            return this;
        }

        @Override
        public AbstractContractNotificationBuilder toBuilder() {
            AbstractContractNotificationBuilder builder = AbstractContractNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractContractNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityPosition()).ifPresent(builder::setFacilityPosition);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractContractNotification _that = (AbstractContractNotification)this.getType().cast(o);
            return ListEquals.listEquals(this.facilityPosition, _that.getFacilityPosition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractContractNotification {facilityPosition=" + String.valueOf(this.facilityPosition) + "} " + super.toString();
        }
    }
}

