/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.ird.FxFixingDate;
import fpml.consolidated.ird.PriceSourceDisruption;
import fpml.consolidated.ird.meta.NonDeliverableSettlementMeta;
import fpml.consolidated.shared.AdjustableDates;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.SettlementRateOption;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="NonDeliverableSettlement", builder=NonDeliverableSettlementBuilderImpl.class, version="1.2.2")
@RuneDataType(value="NonDeliverableSettlement", model="fpml", builder=NonDeliverableSettlementBuilderImpl.class, version="1.2.2")
public interface NonDeliverableSettlement
extends RosettaModelObject {
    public static final NonDeliverableSettlementMeta metaData = new NonDeliverableSettlementMeta();

    public Currency getReferenceCurrency();

    public FxFixingDate getFxFixingDate();

    public AdjustableDates getFxFixingSchedule();

    public SettlementRateOption getSettlementRateOption();

    public PriceSourceDisruption getPriceSourceDisruption();

    public NonDeliverableSettlement build();

    public NonDeliverableSettlementBuilder toBuilder();

    public static NonDeliverableSettlementBuilder builder() {
        return new NonDeliverableSettlementBuilderImpl();
    }

    default public RosettaMetaData<? extends NonDeliverableSettlement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonDeliverableSettlement> getType() {
        return NonDeliverableSettlement.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.class, this.getReferenceCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFixingDate"), processor, FxFixingDate.class, this.getFxFixingDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFixingSchedule"), processor, AdjustableDates.class, this.getFxFixingSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementRateOption"), processor, SettlementRateOption.class, this.getSettlementRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSourceDisruption"), processor, PriceSourceDisruption.class, this.getPriceSourceDisruption(), new AttributeMeta[0]);
    }

    public static class NonDeliverableSettlementBuilderImpl
    implements NonDeliverableSettlementBuilder {
        protected Currency.CurrencyBuilder referenceCurrency;
        protected FxFixingDate.FxFixingDateBuilder fxFixingDate;
        protected AdjustableDates.AdjustableDatesBuilder fxFixingSchedule;
        protected SettlementRateOption.SettlementRateOptionBuilder settlementRateOption;
        protected PriceSourceDisruption.PriceSourceDisruptionBuilder priceSourceDisruption;

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency.CurrencyBuilder getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateReferenceCurrency() {
            Currency.CurrencyBuilder result = this.referenceCurrency != null ? this.referenceCurrency : (this.referenceCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxFixingDate")
        @RuneAttribute(value="fxFixingDate")
        public FxFixingDate.FxFixingDateBuilder getFxFixingDate() {
            return this.fxFixingDate;
        }

        @Override
        public FxFixingDate.FxFixingDateBuilder getOrCreateFxFixingDate() {
            FxFixingDate.FxFixingDateBuilder result = this.fxFixingDate != null ? this.fxFixingDate : (this.fxFixingDate = FxFixingDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxFixingSchedule")
        @RuneAttribute(value="fxFixingSchedule")
        public AdjustableDates.AdjustableDatesBuilder getFxFixingSchedule() {
            return this.fxFixingSchedule;
        }

        @Override
        public AdjustableDates.AdjustableDatesBuilder getOrCreateFxFixingSchedule() {
            AdjustableDates.AdjustableDatesBuilder result = this.fxFixingSchedule != null ? this.fxFixingSchedule : (this.fxFixingSchedule = AdjustableDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementRateOption")
        @RuneAttribute(value="settlementRateOption")
        public SettlementRateOption.SettlementRateOptionBuilder getSettlementRateOption() {
            return this.settlementRateOption;
        }

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateSettlementRateOption() {
            SettlementRateOption.SettlementRateOptionBuilder result = this.settlementRateOption != null ? this.settlementRateOption : (this.settlementRateOption = SettlementRateOption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceSourceDisruption")
        @RuneAttribute(value="priceSourceDisruption")
        public PriceSourceDisruption.PriceSourceDisruptionBuilder getPriceSourceDisruption() {
            return this.priceSourceDisruption;
        }

        @Override
        public PriceSourceDisruption.PriceSourceDisruptionBuilder getOrCreatePriceSourceDisruption() {
            PriceSourceDisruption.PriceSourceDisruptionBuilder result = this.priceSourceDisruption != null ? this.priceSourceDisruption : (this.priceSourceDisruption = PriceSourceDisruption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public NonDeliverableSettlementBuilder setReferenceCurrency(Currency _referenceCurrency) {
            this.referenceCurrency = _referenceCurrency == null ? null : _referenceCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFixingDate")
        @RuneAttribute(value="fxFixingDate")
        public NonDeliverableSettlementBuilder setFxFixingDate(FxFixingDate _fxFixingDate) {
            this.fxFixingDate = _fxFixingDate == null ? null : _fxFixingDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFixingSchedule")
        @RuneAttribute(value="fxFixingSchedule")
        public NonDeliverableSettlementBuilder setFxFixingSchedule(AdjustableDates _fxFixingSchedule) {
            this.fxFixingSchedule = _fxFixingSchedule == null ? null : _fxFixingSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementRateOption")
        @RuneAttribute(value="settlementRateOption")
        public NonDeliverableSettlementBuilder setSettlementRateOption(SettlementRateOption _settlementRateOption) {
            this.settlementRateOption = _settlementRateOption == null ? null : _settlementRateOption.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSourceDisruption")
        @RuneAttribute(value="priceSourceDisruption")
        public NonDeliverableSettlementBuilder setPriceSourceDisruption(PriceSourceDisruption _priceSourceDisruption) {
            this.priceSourceDisruption = _priceSourceDisruption == null ? null : _priceSourceDisruption.toBuilder();
            return this;
        }

        @Override
        public NonDeliverableSettlement build() {
            return new NonDeliverableSettlementImpl(this);
        }

        @Override
        public NonDeliverableSettlementBuilder toBuilder() {
            return this;
        }

        @Override
        public NonDeliverableSettlementBuilder prune() {
            if (this.referenceCurrency != null && !this.referenceCurrency.prune().hasData()) {
                this.referenceCurrency = null;
            }
            if (this.fxFixingDate != null && !this.fxFixingDate.prune().hasData()) {
                this.fxFixingDate = null;
            }
            if (this.fxFixingSchedule != null && !this.fxFixingSchedule.prune().hasData()) {
                this.fxFixingSchedule = null;
            }
            if (this.settlementRateOption != null && !this.settlementRateOption.prune().hasData()) {
                this.settlementRateOption = null;
            }
            if (this.priceSourceDisruption != null && !this.priceSourceDisruption.prune().hasData()) {
                this.priceSourceDisruption = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getReferenceCurrency() != null && this.getReferenceCurrency().hasData()) {
                return true;
            }
            if (this.getFxFixingDate() != null && this.getFxFixingDate().hasData()) {
                return true;
            }
            if (this.getFxFixingSchedule() != null && this.getFxFixingSchedule().hasData()) {
                return true;
            }
            if (this.getSettlementRateOption() != null && this.getSettlementRateOption().hasData()) {
                return true;
            }
            return this.getPriceSourceDisruption() != null && this.getPriceSourceDisruption().hasData();
        }

        public NonDeliverableSettlementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NonDeliverableSettlementBuilder o = (NonDeliverableSettlementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceCurrency(), (RosettaModelObjectBuilder)o.getReferenceCurrency(), this::setReferenceCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFixingDate(), (RosettaModelObjectBuilder)o.getFxFixingDate(), this::setFxFixingDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFixingSchedule(), (RosettaModelObjectBuilder)o.getFxFixingSchedule(), this::setFxFixingSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementRateOption(), (RosettaModelObjectBuilder)o.getSettlementRateOption(), this::setSettlementRateOption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceSourceDisruption(), (RosettaModelObjectBuilder)o.getPriceSourceDisruption(), this::setPriceSourceDisruption);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonDeliverableSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fxFixingDate, _that.getFxFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fxFixingSchedule, _that.getFxFixingSchedule())) {
                return false;
            }
            if (!Objects.equals(this.settlementRateOption, _that.getSettlementRateOption())) {
                return false;
            }
            return Objects.equals(this.priceSourceDisruption, _that.getPriceSourceDisruption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingDate != null ? this.fxFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingSchedule != null ? this.fxFixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.settlementRateOption != null ? this.settlementRateOption.hashCode() : 0);
            _result = 31 * _result + (this.priceSourceDisruption != null ? this.priceSourceDisruption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonDeliverableSettlementBuilder {referenceCurrency=" + String.valueOf(this.referenceCurrency) + ", fxFixingDate=" + String.valueOf(this.fxFixingDate) + ", fxFixingSchedule=" + String.valueOf(this.fxFixingSchedule) + ", settlementRateOption=" + String.valueOf(this.settlementRateOption) + ", priceSourceDisruption=" + String.valueOf(this.priceSourceDisruption) + "}";
        }
    }

    public static interface NonDeliverableSettlementBuilder
    extends NonDeliverableSettlement,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateReferenceCurrency();

        @Override
        public Currency.CurrencyBuilder getReferenceCurrency();

        public FxFixingDate.FxFixingDateBuilder getOrCreateFxFixingDate();

        @Override
        public FxFixingDate.FxFixingDateBuilder getFxFixingDate();

        public AdjustableDates.AdjustableDatesBuilder getOrCreateFxFixingSchedule();

        @Override
        public AdjustableDates.AdjustableDatesBuilder getFxFixingSchedule();

        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateSettlementRateOption();

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getSettlementRateOption();

        public PriceSourceDisruption.PriceSourceDisruptionBuilder getOrCreatePriceSourceDisruption();

        @Override
        public PriceSourceDisruption.PriceSourceDisruptionBuilder getPriceSourceDisruption();

        public NonDeliverableSettlementBuilder setReferenceCurrency(Currency var1);

        public NonDeliverableSettlementBuilder setFxFixingDate(FxFixingDate var1);

        public NonDeliverableSettlementBuilder setFxFixingSchedule(AdjustableDates var1);

        public NonDeliverableSettlementBuilder setSettlementRateOption(SettlementRateOption var1);

        public NonDeliverableSettlementBuilder setPriceSourceDisruption(PriceSourceDisruption var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.CurrencyBuilder.class, this.getReferenceCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFixingDate"), processor, FxFixingDate.FxFixingDateBuilder.class, this.getFxFixingDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFixingSchedule"), processor, AdjustableDates.AdjustableDatesBuilder.class, this.getFxFixingSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementRateOption"), processor, SettlementRateOption.SettlementRateOptionBuilder.class, this.getSettlementRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSourceDisruption"), processor, PriceSourceDisruption.PriceSourceDisruptionBuilder.class, this.getPriceSourceDisruption(), new AttributeMeta[0]);
        }

        public NonDeliverableSettlementBuilder prune();
    }

    public static class NonDeliverableSettlementImpl
    implements NonDeliverableSettlement {
        private final Currency referenceCurrency;
        private final FxFixingDate fxFixingDate;
        private final AdjustableDates fxFixingSchedule;
        private final SettlementRateOption settlementRateOption;
        private final PriceSourceDisruption priceSourceDisruption;

        protected NonDeliverableSettlementImpl(NonDeliverableSettlementBuilder builder) {
            this.referenceCurrency = Optional.ofNullable(builder.getReferenceCurrency()).map(f -> f.build()).orElse(null);
            this.fxFixingDate = Optional.ofNullable(builder.getFxFixingDate()).map(f -> f.build()).orElse(null);
            this.fxFixingSchedule = Optional.ofNullable(builder.getFxFixingSchedule()).map(f -> f.build()).orElse(null);
            this.settlementRateOption = Optional.ofNullable(builder.getSettlementRateOption()).map(f -> f.build()).orElse(null);
            this.priceSourceDisruption = Optional.ofNullable(builder.getPriceSourceDisruption()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        @RosettaAttribute(value="fxFixingDate")
        @RuneAttribute(value="fxFixingDate")
        public FxFixingDate getFxFixingDate() {
            return this.fxFixingDate;
        }

        @Override
        @RosettaAttribute(value="fxFixingSchedule")
        @RuneAttribute(value="fxFixingSchedule")
        public AdjustableDates getFxFixingSchedule() {
            return this.fxFixingSchedule;
        }

        @Override
        @RosettaAttribute(value="settlementRateOption")
        @RuneAttribute(value="settlementRateOption")
        public SettlementRateOption getSettlementRateOption() {
            return this.settlementRateOption;
        }

        @Override
        @RosettaAttribute(value="priceSourceDisruption")
        @RuneAttribute(value="priceSourceDisruption")
        public PriceSourceDisruption getPriceSourceDisruption() {
            return this.priceSourceDisruption;
        }

        @Override
        public NonDeliverableSettlement build() {
            return this;
        }

        @Override
        public NonDeliverableSettlementBuilder toBuilder() {
            NonDeliverableSettlementBuilder builder = NonDeliverableSettlement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonDeliverableSettlementBuilder builder) {
            Optional.ofNullable(this.getReferenceCurrency()).ifPresent(builder::setReferenceCurrency);
            Optional.ofNullable(this.getFxFixingDate()).ifPresent(builder::setFxFixingDate);
            Optional.ofNullable(this.getFxFixingSchedule()).ifPresent(builder::setFxFixingSchedule);
            Optional.ofNullable(this.getSettlementRateOption()).ifPresent(builder::setSettlementRateOption);
            Optional.ofNullable(this.getPriceSourceDisruption()).ifPresent(builder::setPriceSourceDisruption);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonDeliverableSettlement _that = this.getType().cast(o);
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fxFixingDate, _that.getFxFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fxFixingSchedule, _that.getFxFixingSchedule())) {
                return false;
            }
            if (!Objects.equals(this.settlementRateOption, _that.getSettlementRateOption())) {
                return false;
            }
            return Objects.equals(this.priceSourceDisruption, _that.getPriceSourceDisruption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingDate != null ? this.fxFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingSchedule != null ? this.fxFixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.settlementRateOption != null ? this.settlementRateOption.hashCode() : 0);
            _result = 31 * _result + (this.priceSourceDisruption != null ? this.priceSourceDisruption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonDeliverableSettlement {referenceCurrency=" + String.valueOf(this.referenceCurrency) + ", fxFixingDate=" + String.valueOf(this.fxFixingDate) + ", fxFixingSchedule=" + String.valueOf(this.fxFixingSchedule) + ", settlementRateOption=" + String.valueOf(this.settlementRateOption) + ", priceSourceDisruption=" + String.valueOf(this.priceSourceDisruption) + "}";
        }
    }
}

