/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.CsaTypeEnum;
import fpml.consolidated.ird.meta.MidMarketValuationMethodMeta;
import fpml.consolidated.shared.BenchmarkRate;
import fpml.consolidated.shared.CashSettlementReferenceBanks;
import fpml.consolidated.shared.Currency;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MidMarketValuationMethod", builder=MidMarketValuationMethodBuilderImpl.class, version="1.2.2")
@RuneDataType(value="MidMarketValuationMethod", model="fpml", builder=MidMarketValuationMethodBuilderImpl.class, version="1.2.2")
public interface MidMarketValuationMethod
extends RosettaModelObject {
    public static final MidMarketValuationMethodMeta metaData = new MidMarketValuationMethodMeta();

    public List<? extends Currency> getCashSettlementCurrency();

    public CsaTypeEnum getApplicableCsa();

    public CashSettlementReferenceBanks getCashSettlementReferenceBanks();

    public Currency getCashCollateralCurrency();

    public BenchmarkRate getCashCollateralInterestRate();

    public BenchmarkRate getAgreedDiscountRate();

    public MidMarketValuationMethod build();

    public MidMarketValuationMethodBuilder toBuilder();

    public static MidMarketValuationMethodBuilder builder() {
        return new MidMarketValuationMethodBuilderImpl();
    }

    default public RosettaMetaData<? extends MidMarketValuationMethod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MidMarketValuationMethod> getType() {
        return MidMarketValuationMethod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("cashSettlementCurrency"), processor, Currency.class, this.getCashSettlementCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("applicableCsa"), CsaTypeEnum.class, (Object)this.getApplicableCsa(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlementReferenceBanks"), processor, CashSettlementReferenceBanks.class, this.getCashSettlementReferenceBanks(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashCollateralCurrency"), processor, Currency.class, this.getCashCollateralCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashCollateralInterestRate"), processor, BenchmarkRate.class, this.getCashCollateralInterestRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreedDiscountRate"), processor, BenchmarkRate.class, this.getAgreedDiscountRate(), new AttributeMeta[0]);
    }

    public static class MidMarketValuationMethodBuilderImpl
    implements MidMarketValuationMethodBuilder {
        protected List<Currency.CurrencyBuilder> cashSettlementCurrency = new ArrayList<Currency.CurrencyBuilder>();
        protected CsaTypeEnum applicableCsa;
        protected CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder cashSettlementReferenceBanks;
        protected Currency.CurrencyBuilder cashCollateralCurrency;
        protected BenchmarkRate.BenchmarkRateBuilder cashCollateralInterestRate;
        protected BenchmarkRate.BenchmarkRateBuilder agreedDiscountRate;

        @Override
        @RosettaAttribute(value="cashSettlementCurrency")
        @RuneAttribute(value="cashSettlementCurrency")
        public List<? extends Currency.CurrencyBuilder> getCashSettlementCurrency() {
            return this.cashSettlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCashSettlementCurrency(int index) {
            if (this.cashSettlementCurrency == null) {
                this.cashSettlementCurrency = new ArrayList<Currency.CurrencyBuilder>();
            }
            return (Currency.CurrencyBuilder)this.getIndex(this.cashSettlementCurrency, index, () -> {
                Currency.CurrencyBuilder newCashSettlementCurrency = Currency.builder();
                return newCashSettlementCurrency;
            });
        }

        @Override
        @RosettaAttribute(value="applicableCsa")
        @RuneAttribute(value="applicableCsa")
        public CsaTypeEnum getApplicableCsa() {
            return this.applicableCsa;
        }

        @Override
        @RosettaAttribute(value="cashSettlementReferenceBanks")
        @RuneAttribute(value="cashSettlementReferenceBanks")
        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getCashSettlementReferenceBanks() {
            return this.cashSettlementReferenceBanks;
        }

        @Override
        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getOrCreateCashSettlementReferenceBanks() {
            CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder result = this.cashSettlementReferenceBanks != null ? this.cashSettlementReferenceBanks : (this.cashSettlementReferenceBanks = CashSettlementReferenceBanks.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashCollateralCurrency")
        @RuneAttribute(value="cashCollateralCurrency")
        public Currency.CurrencyBuilder getCashCollateralCurrency() {
            return this.cashCollateralCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCashCollateralCurrency() {
            Currency.CurrencyBuilder result = this.cashCollateralCurrency != null ? this.cashCollateralCurrency : (this.cashCollateralCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashCollateralInterestRate")
        @RuneAttribute(value="cashCollateralInterestRate")
        public BenchmarkRate.BenchmarkRateBuilder getCashCollateralInterestRate() {
            return this.cashCollateralInterestRate;
        }

        @Override
        public BenchmarkRate.BenchmarkRateBuilder getOrCreateCashCollateralInterestRate() {
            BenchmarkRate.BenchmarkRateBuilder result = this.cashCollateralInterestRate != null ? this.cashCollateralInterestRate : (this.cashCollateralInterestRate = BenchmarkRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreedDiscountRate")
        @RuneAttribute(value="agreedDiscountRate")
        public BenchmarkRate.BenchmarkRateBuilder getAgreedDiscountRate() {
            return this.agreedDiscountRate;
        }

        @Override
        public BenchmarkRate.BenchmarkRateBuilder getOrCreateAgreedDiscountRate() {
            BenchmarkRate.BenchmarkRateBuilder result = this.agreedDiscountRate != null ? this.agreedDiscountRate : (this.agreedDiscountRate = BenchmarkRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashSettlementCurrency")
        @RuneAttribute(value="cashSettlementCurrency")
        public MidMarketValuationMethodBuilder addCashSettlementCurrency(Currency _cashSettlementCurrency) {
            if (_cashSettlementCurrency != null) {
                this.cashSettlementCurrency.add(_cashSettlementCurrency.toBuilder());
            }
            return this;
        }

        @Override
        public MidMarketValuationMethodBuilder addCashSettlementCurrency(Currency _cashSettlementCurrency, int idx) {
            this.getIndex(this.cashSettlementCurrency, idx, () -> _cashSettlementCurrency.toBuilder());
            return this;
        }

        @Override
        public MidMarketValuationMethodBuilder addCashSettlementCurrency(List<? extends Currency> cashSettlementCurrencys) {
            if (cashSettlementCurrencys != null) {
                for (Currency currency : cashSettlementCurrencys) {
                    this.cashSettlementCurrency.add(currency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="cashSettlementCurrency")
        public MidMarketValuationMethodBuilder setCashSettlementCurrency(List<? extends Currency> cashSettlementCurrencys) {
            this.cashSettlementCurrency = cashSettlementCurrencys == null ? new ArrayList<Currency.CurrencyBuilder>() : (List)cashSettlementCurrencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="applicableCsa")
        @RuneAttribute(value="applicableCsa")
        public MidMarketValuationMethodBuilder setApplicableCsa(CsaTypeEnum _applicableCsa) {
            this.applicableCsa = _applicableCsa == null ? null : _applicableCsa;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlementReferenceBanks")
        @RuneAttribute(value="cashSettlementReferenceBanks")
        public MidMarketValuationMethodBuilder setCashSettlementReferenceBanks(CashSettlementReferenceBanks _cashSettlementReferenceBanks) {
            this.cashSettlementReferenceBanks = _cashSettlementReferenceBanks == null ? null : _cashSettlementReferenceBanks.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashCollateralCurrency")
        @RuneAttribute(value="cashCollateralCurrency")
        public MidMarketValuationMethodBuilder setCashCollateralCurrency(Currency _cashCollateralCurrency) {
            this.cashCollateralCurrency = _cashCollateralCurrency == null ? null : _cashCollateralCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashCollateralInterestRate")
        @RuneAttribute(value="cashCollateralInterestRate")
        public MidMarketValuationMethodBuilder setCashCollateralInterestRate(BenchmarkRate _cashCollateralInterestRate) {
            this.cashCollateralInterestRate = _cashCollateralInterestRate == null ? null : _cashCollateralInterestRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreedDiscountRate")
        @RuneAttribute(value="agreedDiscountRate")
        public MidMarketValuationMethodBuilder setAgreedDiscountRate(BenchmarkRate _agreedDiscountRate) {
            this.agreedDiscountRate = _agreedDiscountRate == null ? null : _agreedDiscountRate.toBuilder();
            return this;
        }

        @Override
        public MidMarketValuationMethod build() {
            return new MidMarketValuationMethodImpl(this);
        }

        @Override
        public MidMarketValuationMethodBuilder toBuilder() {
            return this;
        }

        @Override
        public MidMarketValuationMethodBuilder prune() {
            this.cashSettlementCurrency = this.cashSettlementCurrency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.cashSettlementReferenceBanks != null && !this.cashSettlementReferenceBanks.prune().hasData()) {
                this.cashSettlementReferenceBanks = null;
            }
            if (this.cashCollateralCurrency != null && !this.cashCollateralCurrency.prune().hasData()) {
                this.cashCollateralCurrency = null;
            }
            if (this.cashCollateralInterestRate != null && !this.cashCollateralInterestRate.prune().hasData()) {
                this.cashCollateralInterestRate = null;
            }
            if (this.agreedDiscountRate != null && !this.agreedDiscountRate.prune().hasData()) {
                this.agreedDiscountRate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCashSettlementCurrency() != null && this.getCashSettlementCurrency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getApplicableCsa() != null) {
                return true;
            }
            if (this.getCashSettlementReferenceBanks() != null && this.getCashSettlementReferenceBanks().hasData()) {
                return true;
            }
            if (this.getCashCollateralCurrency() != null && this.getCashCollateralCurrency().hasData()) {
                return true;
            }
            if (this.getCashCollateralInterestRate() != null && this.getCashCollateralInterestRate().hasData()) {
                return true;
            }
            return this.getAgreedDiscountRate() != null && this.getAgreedDiscountRate().hasData();
        }

        public MidMarketValuationMethodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MidMarketValuationMethodBuilder o = (MidMarketValuationMethodBuilder)other;
            merger.mergeRosetta(this.getCashSettlementCurrency(), o.getCashSettlementCurrency(), this::getOrCreateCashSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlementReferenceBanks(), (RosettaModelObjectBuilder)o.getCashSettlementReferenceBanks(), this::setCashSettlementReferenceBanks);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashCollateralCurrency(), (RosettaModelObjectBuilder)o.getCashCollateralCurrency(), this::setCashCollateralCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashCollateralInterestRate(), (RosettaModelObjectBuilder)o.getCashCollateralInterestRate(), this::setCashCollateralInterestRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreedDiscountRate(), (RosettaModelObjectBuilder)o.getAgreedDiscountRate(), this::setAgreedDiscountRate);
            merger.mergeBasic((Object)this.getApplicableCsa(), (Object)o.getApplicableCsa(), this::setApplicableCsa, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MidMarketValuationMethod _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.cashSettlementCurrency, _that.getCashSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.applicableCsa, (Object)_that.getApplicableCsa())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementReferenceBanks, _that.getCashSettlementReferenceBanks())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralCurrency, _that.getCashCollateralCurrency())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralInterestRate, _that.getCashCollateralInterestRate())) {
                return false;
            }
            return Objects.equals(this.agreedDiscountRate, _that.getAgreedDiscountRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashSettlementCurrency != null ? this.cashSettlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.applicableCsa != null ? ((Object)((Object)this.applicableCsa)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementReferenceBanks != null ? this.cashSettlementReferenceBanks.hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralCurrency != null ? this.cashCollateralCurrency.hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralInterestRate != null ? this.cashCollateralInterestRate.hashCode() : 0);
            _result = 31 * _result + (this.agreedDiscountRate != null ? this.agreedDiscountRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MidMarketValuationMethodBuilder {cashSettlementCurrency=" + String.valueOf(this.cashSettlementCurrency) + ", applicableCsa=" + String.valueOf((Object)this.applicableCsa) + ", cashSettlementReferenceBanks=" + String.valueOf(this.cashSettlementReferenceBanks) + ", cashCollateralCurrency=" + String.valueOf(this.cashCollateralCurrency) + ", cashCollateralInterestRate=" + String.valueOf(this.cashCollateralInterestRate) + ", agreedDiscountRate=" + String.valueOf(this.agreedDiscountRate) + "}";
        }
    }

    public static interface MidMarketValuationMethodBuilder
    extends MidMarketValuationMethod,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCashSettlementCurrency(int var1);

        public List<? extends Currency.CurrencyBuilder> getCashSettlementCurrency();

        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getOrCreateCashSettlementReferenceBanks();

        @Override
        public CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder getCashSettlementReferenceBanks();

        public Currency.CurrencyBuilder getOrCreateCashCollateralCurrency();

        @Override
        public Currency.CurrencyBuilder getCashCollateralCurrency();

        public BenchmarkRate.BenchmarkRateBuilder getOrCreateCashCollateralInterestRate();

        @Override
        public BenchmarkRate.BenchmarkRateBuilder getCashCollateralInterestRate();

        public BenchmarkRate.BenchmarkRateBuilder getOrCreateAgreedDiscountRate();

        @Override
        public BenchmarkRate.BenchmarkRateBuilder getAgreedDiscountRate();

        public MidMarketValuationMethodBuilder addCashSettlementCurrency(Currency var1);

        public MidMarketValuationMethodBuilder addCashSettlementCurrency(Currency var1, int var2);

        public MidMarketValuationMethodBuilder addCashSettlementCurrency(List<? extends Currency> var1);

        public MidMarketValuationMethodBuilder setCashSettlementCurrency(List<? extends Currency> var1);

        public MidMarketValuationMethodBuilder setApplicableCsa(CsaTypeEnum var1);

        public MidMarketValuationMethodBuilder setCashSettlementReferenceBanks(CashSettlementReferenceBanks var1);

        public MidMarketValuationMethodBuilder setCashCollateralCurrency(Currency var1);

        public MidMarketValuationMethodBuilder setCashCollateralInterestRate(BenchmarkRate var1);

        public MidMarketValuationMethodBuilder setAgreedDiscountRate(BenchmarkRate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("cashSettlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getCashSettlementCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("applicableCsa"), CsaTypeEnum.class, (Object)this.getApplicableCsa(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlementReferenceBanks"), processor, CashSettlementReferenceBanks.CashSettlementReferenceBanksBuilder.class, this.getCashSettlementReferenceBanks(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashCollateralCurrency"), processor, Currency.CurrencyBuilder.class, this.getCashCollateralCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashCollateralInterestRate"), processor, BenchmarkRate.BenchmarkRateBuilder.class, this.getCashCollateralInterestRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreedDiscountRate"), processor, BenchmarkRate.BenchmarkRateBuilder.class, this.getAgreedDiscountRate(), new AttributeMeta[0]);
        }

        public MidMarketValuationMethodBuilder prune();
    }

    public static class MidMarketValuationMethodImpl
    implements MidMarketValuationMethod {
        private final List<? extends Currency> cashSettlementCurrency;
        private final CsaTypeEnum applicableCsa;
        private final CashSettlementReferenceBanks cashSettlementReferenceBanks;
        private final Currency cashCollateralCurrency;
        private final BenchmarkRate cashCollateralInterestRate;
        private final BenchmarkRate agreedDiscountRate;

        protected MidMarketValuationMethodImpl(MidMarketValuationMethodBuilder builder) {
            this.cashSettlementCurrency = Optional.ofNullable(builder.getCashSettlementCurrency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.applicableCsa = builder.getApplicableCsa();
            this.cashSettlementReferenceBanks = Optional.ofNullable(builder.getCashSettlementReferenceBanks()).map(f -> f.build()).orElse(null);
            this.cashCollateralCurrency = Optional.ofNullable(builder.getCashCollateralCurrency()).map(f -> f.build()).orElse(null);
            this.cashCollateralInterestRate = Optional.ofNullable(builder.getCashCollateralInterestRate()).map(f -> f.build()).orElse(null);
            this.agreedDiscountRate = Optional.ofNullable(builder.getAgreedDiscountRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="cashSettlementCurrency")
        @RuneAttribute(value="cashSettlementCurrency")
        public List<? extends Currency> getCashSettlementCurrency() {
            return this.cashSettlementCurrency;
        }

        @Override
        @RosettaAttribute(value="applicableCsa")
        @RuneAttribute(value="applicableCsa")
        public CsaTypeEnum getApplicableCsa() {
            return this.applicableCsa;
        }

        @Override
        @RosettaAttribute(value="cashSettlementReferenceBanks")
        @RuneAttribute(value="cashSettlementReferenceBanks")
        public CashSettlementReferenceBanks getCashSettlementReferenceBanks() {
            return this.cashSettlementReferenceBanks;
        }

        @Override
        @RosettaAttribute(value="cashCollateralCurrency")
        @RuneAttribute(value="cashCollateralCurrency")
        public Currency getCashCollateralCurrency() {
            return this.cashCollateralCurrency;
        }

        @Override
        @RosettaAttribute(value="cashCollateralInterestRate")
        @RuneAttribute(value="cashCollateralInterestRate")
        public BenchmarkRate getCashCollateralInterestRate() {
            return this.cashCollateralInterestRate;
        }

        @Override
        @RosettaAttribute(value="agreedDiscountRate")
        @RuneAttribute(value="agreedDiscountRate")
        public BenchmarkRate getAgreedDiscountRate() {
            return this.agreedDiscountRate;
        }

        @Override
        public MidMarketValuationMethod build() {
            return this;
        }

        @Override
        public MidMarketValuationMethodBuilder toBuilder() {
            MidMarketValuationMethodBuilder builder = MidMarketValuationMethod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MidMarketValuationMethodBuilder builder) {
            Optional.ofNullable(this.getCashSettlementCurrency()).ifPresent(builder::setCashSettlementCurrency);
            Optional.ofNullable(this.getApplicableCsa()).ifPresent(builder::setApplicableCsa);
            Optional.ofNullable(this.getCashSettlementReferenceBanks()).ifPresent(builder::setCashSettlementReferenceBanks);
            Optional.ofNullable(this.getCashCollateralCurrency()).ifPresent(builder::setCashCollateralCurrency);
            Optional.ofNullable(this.getCashCollateralInterestRate()).ifPresent(builder::setCashCollateralInterestRate);
            Optional.ofNullable(this.getAgreedDiscountRate()).ifPresent(builder::setAgreedDiscountRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MidMarketValuationMethod _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.cashSettlementCurrency, _that.getCashSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.applicableCsa, (Object)_that.getApplicableCsa())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementReferenceBanks, _that.getCashSettlementReferenceBanks())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralCurrency, _that.getCashCollateralCurrency())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralInterestRate, _that.getCashCollateralInterestRate())) {
                return false;
            }
            return Objects.equals(this.agreedDiscountRate, _that.getAgreedDiscountRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashSettlementCurrency != null ? this.cashSettlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.applicableCsa != null ? ((Object)((Object)this.applicableCsa)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementReferenceBanks != null ? this.cashSettlementReferenceBanks.hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralCurrency != null ? this.cashCollateralCurrency.hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralInterestRate != null ? this.cashCollateralInterestRate.hashCode() : 0);
            _result = 31 * _result + (this.agreedDiscountRate != null ? this.agreedDiscountRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MidMarketValuationMethod {cashSettlementCurrency=" + String.valueOf(this.cashSettlementCurrency) + ", applicableCsa=" + String.valueOf((Object)this.applicableCsa) + ", cashSettlementReferenceBanks=" + String.valueOf(this.cashSettlementReferenceBanks) + ", cashCollateralCurrency=" + String.valueOf(this.cashCollateralCurrency) + ", cashCollateralInterestRate=" + String.valueOf(this.cashCollateralInterestRate) + ", agreedDiscountRate=" + String.valueOf(this.agreedDiscountRate) + "}";
        }
    }
}

