/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.fx.FxOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FxOptionChoice")
@ImplementedBy(value=Default.class)
public interface FxOptionChoice
extends Validator<FxOption> {
    public static final String NAME = "FxOptionChoice";
    public static final String DEFINITION = "optional choice americanExercise, europeanExercise";

    public static class NoOp
    implements FxOptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FxOption fxOption) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FxOptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FxOption fxOption) {
            ComparisonResult result = this.executeDataRule(fxOption);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FxOptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FxOption", (RosettaPath)path, (String)FxOptionChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FxOptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FxOption", (RosettaPath)path, (String)FxOptionChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FxOption fxOption) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)fxOption), Arrays.asList("americanExercise", "europeanExercise"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

