/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.targets.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.fx.targets.FxTarget;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FxTargetChoice")
@ImplementedBy(value=Default.class)
public interface FxTargetChoice
extends Validator<FxTarget> {
    public static final String NAME = "FxTargetChoice";
    public static final String DEFINITION = "required choice knockoutLevel, knockoutCount";

    public static class NoOp
    implements FxTargetChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FxTarget fxTarget) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FxTargetChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FxTarget fxTarget) {
            ComparisonResult result = this.executeDataRule(fxTarget);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FxTargetChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FxTarget", (RosettaPath)path, (String)FxTargetChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FxTargetChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FxTarget", (RosettaPath)path, (String)FxTargetChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FxTarget fxTarget) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)fxTarget), Arrays.asList("knockoutLevel", "knockoutCount"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

