/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.TriggerConditionEnum;
import fpml.consolidated.fx.FxTriggerBase;
import fpml.consolidated.fx.accruals.meta.FxAccrualTriggerMeta;
import fpml.consolidated.shared.InformationSource;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAccrualTrigger", builder=FxAccrualTriggerBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxAccrualTrigger", model="fpml", builder=FxAccrualTriggerBuilderImpl.class, version="1.2.2")
public interface FxAccrualTrigger
extends FxTriggerBase {
    public static final FxAccrualTriggerMeta metaData = new FxAccrualTriggerMeta();

    public List<? extends InformationSource> getInformationSource();

    public String getId();

    @Override
    public FxAccrualTrigger build();

    @Override
    public FxAccrualTriggerBuilder toBuilder();

    public static FxAccrualTriggerBuilder builder() {
        return new FxAccrualTriggerBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrualTrigger> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrualTrigger> getType() {
        return FxAccrualTrigger.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxAccrualTriggerBuilderImpl
    extends FxTriggerBase.FxTriggerBaseBuilderImpl
    implements FxAccrualTriggerBuilder {
        protected List<InformationSource.InformationSourceBuilder> informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int index) {
            if (this.informationSource == null) {
                this.informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
            }
            return (InformationSource.InformationSourceBuilder)this.getIndex(this.informationSource, index, () -> {
                InformationSource.InformationSourceBuilder newInformationSource = InformationSource.builder();
                return newInformationSource;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="triggerCondition", isRequired=true)
        @RuneAttribute(value="triggerCondition", isRequired=true)
        public FxAccrualTriggerBuilder setTriggerCondition(TriggerConditionEnum _triggerCondition) {
            this.triggerCondition = _triggerCondition == null ? null : _triggerCondition;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public FxAccrualTriggerBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerRate", isRequired=true)
        @RuneAttribute(value="triggerRate", isRequired=true)
        public FxAccrualTriggerBuilder setTriggerRate(BigDecimal _triggerRate) {
            this.triggerRate = _triggerRate == null ? null : _triggerRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxAccrualTriggerBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxAccrualTriggerBuilder addInformationSource(InformationSource _informationSource) {
            if (_informationSource != null) {
                this.informationSource.add(_informationSource.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualTriggerBuilder addInformationSource(InformationSource _informationSource, int idx) {
            this.getIndex(this.informationSource, idx, () -> _informationSource.toBuilder());
            return this;
        }

        @Override
        public FxAccrualTriggerBuilder addInformationSource(List<? extends InformationSource> informationSources) {
            if (informationSources != null) {
                for (InformationSource informationSource : informationSources) {
                    this.informationSource.add(informationSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="informationSource")
        public FxAccrualTriggerBuilder setInformationSource(List<? extends InformationSource> informationSources) {
            this.informationSource = informationSources == null ? new ArrayList<InformationSource.InformationSourceBuilder>() : (List)informationSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxAccrualTriggerBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public FxAccrualTrigger build() {
            return new FxAccrualTriggerImpl(this);
        }

        @Override
        public FxAccrualTriggerBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualTriggerBuilder prune() {
            super.prune();
            this.informationSource = this.informationSource.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        @Override
        public FxAccrualTriggerBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxAccrualTriggerBuilder o = (FxAccrualTriggerBuilder)other;
            merger.mergeRosetta(this.getInformationSource(), o.getInformationSource(), this::getOrCreateInformationSource);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualTrigger _that = (FxAccrualTrigger)this.getType().cast(o);
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualTriggerBuilder {informationSource=" + String.valueOf(this.informationSource) + ", id=" + this.id + "} " + super.toString();
        }
    }

    public static interface FxAccrualTriggerBuilder
    extends FxAccrualTrigger,
    FxTriggerBase.FxTriggerBaseBuilder {
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int var1);

        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource();

        @Override
        public FxAccrualTriggerBuilder setTriggerCondition(TriggerConditionEnum var1);

        @Override
        public FxAccrualTriggerBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        @Override
        public FxAccrualTriggerBuilder setTriggerRate(BigDecimal var1);

        @Override
        public FxAccrualTriggerBuilder setSpotRate(BigDecimal var1);

        public FxAccrualTriggerBuilder addInformationSource(InformationSource var1);

        public FxAccrualTriggerBuilder addInformationSource(InformationSource var1, int var2);

        public FxAccrualTriggerBuilder addInformationSource(List<? extends InformationSource> var1);

        public FxAccrualTriggerBuilder setInformationSource(List<? extends InformationSource> var1);

        public FxAccrualTriggerBuilder setId(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, (RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public FxAccrualTriggerBuilder prune();
    }

    public static class FxAccrualTriggerImpl
    extends FxTriggerBase.FxTriggerBaseImpl
    implements FxAccrualTrigger {
        private final List<? extends InformationSource> informationSource;
        private final String id;

        protected FxAccrualTriggerImpl(FxAccrualTriggerBuilder builder) {
            super(builder);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource> getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public FxAccrualTrigger build() {
            return this;
        }

        @Override
        public FxAccrualTriggerBuilder toBuilder() {
            FxAccrualTriggerBuilder builder = FxAccrualTrigger.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualTriggerBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualTrigger _that = (FxAccrualTrigger)this.getType().cast(o);
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualTrigger {informationSource=" + String.valueOf(this.informationSource) + ", id=" + this.id + "} " + super.toString();
        }
    }
}

