/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.accruals.FxAccrual;
import fpml.consolidated.fx.accruals.FxAccrualBarrier;
import fpml.consolidated.fx.accruals.FxAccrualLinearPayoffRegion;
import fpml.consolidated.fx.accruals.FxAccrualSettlementPeriodSchedule;
import fpml.consolidated.fx.accruals.FxAverageRate;
import fpml.consolidated.fx.accruals.FxExpiryDateOrScheduleModel;
import fpml.consolidated.fx.accruals.FxSettlementDateOrScheduleModel;
import fpml.consolidated.fx.accruals.meta.FxAccrualForwardMeta;
import fpml.consolidated.shared.FxCashSettlementSimple;
import fpml.consolidated.shared.NonNegativeAmountSchedule;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.shared.SimplePayment;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAccrualForward", builder=FxAccrualForwardBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxAccrualForward", model="fpml", builder=FxAccrualForwardBuilderImpl.class, version="1.2.2")
public interface FxAccrualForward
extends Product {
    public static final FxAccrualForwardMeta metaData = new FxAccrualForwardMeta();

    public NonNegativeAmountSchedule getNotionalAmount();

    public FxAccrual getAccrual();

    public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel();

    public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel();

    public BigDecimal getSpotRate();

    public List<? extends FxAccrualLinearPayoffRegion> getLinearPayoffRegion();

    public FxAverageRate getAverageRate();

    public List<? extends FxAccrualBarrier> getBarrier();

    public List<? extends SimplePayment> getAdditionalPayment();

    public FxCashSettlementSimple getCashSettlement();

    public FxAccrualSettlementPeriodSchedule getSettlementPeriodSchedule();

    @Override
    public FxAccrualForward build();

    @Override
    public FxAccrualForwardBuilder toBuilder();

    public static FxAccrualForwardBuilder builder() {
        return new FxAccrualForwardBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrualForward> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrualForward> getType() {
        return FxAccrualForward.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.class, this.getAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("linearPayoffRegion"), processor, FxAccrualLinearPayoffRegion.class, this.getLinearPayoffRegion(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averageRate"), processor, FxAverageRate.class, this.getAverageRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, SimplePayment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.class, this.getCashSettlement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodSchedule"), processor, FxAccrualSettlementPeriodSchedule.class, this.getSettlementPeriodSchedule(), new AttributeMeta[0]);
    }

    public static class FxAccrualForwardBuilderImpl
    extends Product.ProductBuilderImpl
    implements FxAccrualForwardBuilder {
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder notionalAmount;
        protected FxAccrual.FxAccrualBuilder accrual;
        protected FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder fxExpiryDateOrScheduleModel;
        protected FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder fxSettlementDateOrScheduleModel;
        protected BigDecimal spotRate;
        protected List<FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder> linearPayoffRegion = new ArrayList<FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder>();
        protected FxAverageRate.FxAverageRateBuilder averageRate;
        protected List<FxAccrualBarrier.FxAccrualBarrierBuilder> barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
        protected List<SimplePayment.SimplePaymentBuilder> additionalPayment = new ArrayList<SimplePayment.SimplePaymentBuilder>();
        protected FxCashSettlementSimple.FxCashSettlementSimpleBuilder cashSettlement;
        protected FxAccrualSettlementPeriodSchedule.FxAccrualSettlementPeriodScheduleBuilder settlementPeriodSchedule;

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual.FxAccrualBuilder getAccrual() {
            return this.accrual;
        }

        @Override
        public FxAccrual.FxAccrualBuilder getOrCreateAccrual() {
            FxAccrual.FxAccrualBuilder result = this.accrual != null ? this.accrual : (this.accrual = FxAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel() {
            FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder result = this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel : (this.fxExpiryDateOrScheduleModel = FxExpiryDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel() {
            FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder result = this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel : (this.fxSettlementDateOrScheduleModel = FxSettlementDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="linearPayoffRegion", isRequired=true)
        @RuneAttribute(value="linearPayoffRegion", isRequired=true)
        public List<? extends FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder> getLinearPayoffRegion() {
            return this.linearPayoffRegion;
        }

        @Override
        public FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder getOrCreateLinearPayoffRegion(int index) {
            if (this.linearPayoffRegion == null) {
                this.linearPayoffRegion = new ArrayList<FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder>();
            }
            return (FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder)this.getIndex(this.linearPayoffRegion, index, () -> {
                FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder newLinearPayoffRegion = FxAccrualLinearPayoffRegion.builder();
                return newLinearPayoffRegion;
            });
        }

        @Override
        @RosettaAttribute(value="averageRate")
        @RuneAttribute(value="averageRate")
        public FxAverageRate.FxAverageRateBuilder getAverageRate() {
            return this.averageRate;
        }

        @Override
        public FxAverageRate.FxAverageRateBuilder getOrCreateAverageRate() {
            FxAverageRate.FxAverageRateBuilder result = this.averageRate != null ? this.averageRate : (this.averageRate = FxAverageRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int index) {
            if (this.barrier == null) {
                this.barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
            }
            return (FxAccrualBarrier.FxAccrualBarrierBuilder)this.getIndex(this.barrier, index, () -> {
                FxAccrualBarrier.FxAccrualBarrierBuilder newBarrier = FxAccrualBarrier.builder();
                return newBarrier;
            });
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends SimplePayment.SimplePaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public SimplePayment.SimplePaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<SimplePayment.SimplePaymentBuilder>();
            }
            return (SimplePayment.SimplePaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                SimplePayment.SimplePaymentBuilder newAdditionalPayment = SimplePayment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement() {
            FxCashSettlementSimple.FxCashSettlementSimpleBuilder result = this.cashSettlement != null ? this.cashSettlement : (this.cashSettlement = FxCashSettlementSimple.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodSchedule")
        @RuneAttribute(value="settlementPeriodSchedule")
        public FxAccrualSettlementPeriodSchedule.FxAccrualSettlementPeriodScheduleBuilder getSettlementPeriodSchedule() {
            return this.settlementPeriodSchedule;
        }

        @Override
        public FxAccrualSettlementPeriodSchedule.FxAccrualSettlementPeriodScheduleBuilder getOrCreateSettlementPeriodSchedule() {
            FxAccrualSettlementPeriodSchedule.FxAccrualSettlementPeriodScheduleBuilder result = this.settlementPeriodSchedule != null ? this.settlementPeriodSchedule : (this.settlementPeriodSchedule = FxAccrualSettlementPeriodSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxAccrualForwardBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxAccrualForwardBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxAccrualForwardBuilder setNotionalAmount(NonNegativeAmountSchedule _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrualForwardBuilder setAccrual(FxAccrual _accrual) {
            this.accrual = _accrual == null ? null : _accrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxAccrualForwardBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel _fxExpiryDateOrScheduleModel) {
            this.fxExpiryDateOrScheduleModel = _fxExpiryDateOrScheduleModel == null ? null : _fxExpiryDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxAccrualForwardBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel _fxSettlementDateOrScheduleModel) {
            this.fxSettlementDateOrScheduleModel = _fxSettlementDateOrScheduleModel == null ? null : _fxSettlementDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxAccrualForwardBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="linearPayoffRegion", isRequired=true)
        @RuneAttribute(value="linearPayoffRegion", isRequired=true)
        public FxAccrualForwardBuilder addLinearPayoffRegion(FxAccrualLinearPayoffRegion _linearPayoffRegion) {
            if (_linearPayoffRegion != null) {
                this.linearPayoffRegion.add(_linearPayoffRegion.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualForwardBuilder addLinearPayoffRegion(FxAccrualLinearPayoffRegion _linearPayoffRegion, int idx) {
            this.getIndex(this.linearPayoffRegion, idx, () -> _linearPayoffRegion.toBuilder());
            return this;
        }

        @Override
        public FxAccrualForwardBuilder addLinearPayoffRegion(List<? extends FxAccrualLinearPayoffRegion> linearPayoffRegions) {
            if (linearPayoffRegions != null) {
                for (FxAccrualLinearPayoffRegion fxAccrualLinearPayoffRegion : linearPayoffRegions) {
                    this.linearPayoffRegion.add(fxAccrualLinearPayoffRegion.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="linearPayoffRegion")
        public FxAccrualForwardBuilder setLinearPayoffRegion(List<? extends FxAccrualLinearPayoffRegion> linearPayoffRegions) {
            this.linearPayoffRegion = linearPayoffRegions == null ? new ArrayList<FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder>() : (List)linearPayoffRegions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="averageRate")
        @RuneAttribute(value="averageRate")
        public FxAccrualForwardBuilder setAverageRate(FxAverageRate _averageRate) {
            this.averageRate = _averageRate == null ? null : _averageRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxAccrualForwardBuilder addBarrier(FxAccrualBarrier _barrier) {
            if (_barrier != null) {
                this.barrier.add(_barrier.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualForwardBuilder addBarrier(FxAccrualBarrier _barrier, int idx) {
            this.getIndex(this.barrier, idx, () -> _barrier.toBuilder());
            return this;
        }

        @Override
        public FxAccrualForwardBuilder addBarrier(List<? extends FxAccrualBarrier> barriers) {
            if (barriers != null) {
                for (FxAccrualBarrier fxAccrualBarrier : barriers) {
                    this.barrier.add(fxAccrualBarrier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrier")
        public FxAccrualForwardBuilder setBarrier(List<? extends FxAccrualBarrier> barriers) {
            this.barrier = barriers == null ? new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>() : (List)barriers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public FxAccrualForwardBuilder addAdditionalPayment(SimplePayment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualForwardBuilder addAdditionalPayment(SimplePayment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public FxAccrualForwardBuilder addAdditionalPayment(List<? extends SimplePayment> additionalPayments) {
            if (additionalPayments != null) {
                for (SimplePayment simplePayment : additionalPayments) {
                    this.additionalPayment.add(simplePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public FxAccrualForwardBuilder setAdditionalPayment(List<? extends SimplePayment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<SimplePayment.SimplePaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxAccrualForwardBuilder setCashSettlement(FxCashSettlementSimple _cashSettlement) {
            this.cashSettlement = _cashSettlement == null ? null : _cashSettlement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodSchedule")
        @RuneAttribute(value="settlementPeriodSchedule")
        public FxAccrualForwardBuilder setSettlementPeriodSchedule(FxAccrualSettlementPeriodSchedule _settlementPeriodSchedule) {
            this.settlementPeriodSchedule = _settlementPeriodSchedule == null ? null : _settlementPeriodSchedule.toBuilder();
            return this;
        }

        @Override
        public FxAccrualForward build() {
            return new FxAccrualForwardImpl(this);
        }

        @Override
        public FxAccrualForwardBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualForwardBuilder prune() {
            super.prune();
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            if (this.accrual != null && !this.accrual.prune().hasData()) {
                this.accrual = null;
            }
            if (this.fxExpiryDateOrScheduleModel != null && !this.fxExpiryDateOrScheduleModel.prune().hasData()) {
                this.fxExpiryDateOrScheduleModel = null;
            }
            if (this.fxSettlementDateOrScheduleModel != null && !this.fxSettlementDateOrScheduleModel.prune().hasData()) {
                this.fxSettlementDateOrScheduleModel = null;
            }
            this.linearPayoffRegion = this.linearPayoffRegion.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.averageRate != null && !this.averageRate.prune().hasData()) {
                this.averageRate = null;
            }
            this.barrier = this.barrier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.cashSettlement != null && !this.cashSettlement.prune().hasData()) {
                this.cashSettlement = null;
            }
            if (this.settlementPeriodSchedule != null && !this.settlementPeriodSchedule.prune().hasData()) {
                this.settlementPeriodSchedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getAccrual() != null && this.getAccrual().hasData()) {
                return true;
            }
            if (this.getFxExpiryDateOrScheduleModel() != null && this.getFxExpiryDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getFxSettlementDateOrScheduleModel() != null && this.getFxSettlementDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getSpotRate() != null) {
                return true;
            }
            if (this.getLinearPayoffRegion() != null && this.getLinearPayoffRegion().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAverageRate() != null && this.getAverageRate().hasData()) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCashSettlement() != null && this.getCashSettlement().hasData()) {
                return true;
            }
            return this.getSettlementPeriodSchedule() != null && this.getSettlementPeriodSchedule().hasData();
        }

        @Override
        public FxAccrualForwardBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxAccrualForwardBuilder o = (FxAccrualForwardBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrual(), (RosettaModelObjectBuilder)o.getAccrual(), this::setAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxExpiryDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxExpiryDateOrScheduleModel(), this::setFxExpiryDateOrScheduleModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxSettlementDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxSettlementDateOrScheduleModel(), this::setFxSettlementDateOrScheduleModel);
            merger.mergeRosetta(this.getLinearPayoffRegion(), o.getLinearPayoffRegion(), this::getOrCreateLinearPayoffRegion);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAverageRate(), (RosettaModelObjectBuilder)o.getAverageRate(), this::setAverageRate);
            merger.mergeRosetta(this.getBarrier(), o.getBarrier(), this::getOrCreateBarrier);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlement(), (RosettaModelObjectBuilder)o.getCashSettlement(), this::setCashSettlement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPeriodSchedule(), (RosettaModelObjectBuilder)o.getSettlementPeriodSchedule(), this::setSettlementPeriodSchedule);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualForward _that = (FxAccrualForward)this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.linearPayoffRegion, _that.getLinearPayoffRegion())) {
                return false;
            }
            if (!Objects.equals(this.averageRate, _that.getAverageRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            return Objects.equals(this.settlementPeriodSchedule, _that.getSettlementPeriodSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.linearPayoffRegion != null ? this.linearPayoffRegion.hashCode() : 0);
            _result = 31 * _result + (this.averageRate != null ? this.averageRate.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodSchedule != null ? this.settlementPeriodSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualForwardBuilder {notionalAmount=" + String.valueOf(this.notionalAmount) + ", accrual=" + String.valueOf(this.accrual) + ", fxExpiryDateOrScheduleModel=" + String.valueOf(this.fxExpiryDateOrScheduleModel) + ", fxSettlementDateOrScheduleModel=" + String.valueOf(this.fxSettlementDateOrScheduleModel) + ", spotRate=" + String.valueOf(this.spotRate) + ", linearPayoffRegion=" + String.valueOf(this.linearPayoffRegion) + ", averageRate=" + String.valueOf(this.averageRate) + ", barrier=" + String.valueOf(this.barrier) + ", additionalPayment=" + String.valueOf(this.additionalPayment) + ", cashSettlement=" + String.valueOf(this.cashSettlement) + ", settlementPeriodSchedule=" + String.valueOf(this.settlementPeriodSchedule) + "} " + super.toString();
        }
    }

    public static interface FxAccrualForwardBuilder
    extends FxAccrualForward,
    Product.ProductBuilder {
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount();

        public FxAccrual.FxAccrualBuilder getOrCreateAccrual();

        @Override
        public FxAccrual.FxAccrualBuilder getAccrual();

        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel();

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel();

        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel();

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel();

        public FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder getOrCreateLinearPayoffRegion(int var1);

        public List<? extends FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder> getLinearPayoffRegion();

        public FxAverageRate.FxAverageRateBuilder getOrCreateAverageRate();

        @Override
        public FxAverageRate.FxAverageRateBuilder getAverageRate();

        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int var1);

        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier();

        public SimplePayment.SimplePaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends SimplePayment.SimplePaymentBuilder> getAdditionalPayment();

        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement();

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement();

        public FxAccrualSettlementPeriodSchedule.FxAccrualSettlementPeriodScheduleBuilder getOrCreateSettlementPeriodSchedule();

        @Override
        public FxAccrualSettlementPeriodSchedule.FxAccrualSettlementPeriodScheduleBuilder getSettlementPeriodSchedule();

        @Override
        public FxAccrualForwardBuilder setProductModel(ProductModel var1);

        @Override
        public FxAccrualForwardBuilder setId(String var1);

        public FxAccrualForwardBuilder setNotionalAmount(NonNegativeAmountSchedule var1);

        public FxAccrualForwardBuilder setAccrual(FxAccrual var1);

        public FxAccrualForwardBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel var1);

        public FxAccrualForwardBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel var1);

        public FxAccrualForwardBuilder setSpotRate(BigDecimal var1);

        public FxAccrualForwardBuilder addLinearPayoffRegion(FxAccrualLinearPayoffRegion var1);

        public FxAccrualForwardBuilder addLinearPayoffRegion(FxAccrualLinearPayoffRegion var1, int var2);

        public FxAccrualForwardBuilder addLinearPayoffRegion(List<? extends FxAccrualLinearPayoffRegion> var1);

        public FxAccrualForwardBuilder setLinearPayoffRegion(List<? extends FxAccrualLinearPayoffRegion> var1);

        public FxAccrualForwardBuilder setAverageRate(FxAverageRate var1);

        public FxAccrualForwardBuilder addBarrier(FxAccrualBarrier var1);

        public FxAccrualForwardBuilder addBarrier(FxAccrualBarrier var1, int var2);

        public FxAccrualForwardBuilder addBarrier(List<? extends FxAccrualBarrier> var1);

        public FxAccrualForwardBuilder setBarrier(List<? extends FxAccrualBarrier> var1);

        public FxAccrualForwardBuilder addAdditionalPayment(SimplePayment var1);

        public FxAccrualForwardBuilder addAdditionalPayment(SimplePayment var1, int var2);

        public FxAccrualForwardBuilder addAdditionalPayment(List<? extends SimplePayment> var1);

        public FxAccrualForwardBuilder setAdditionalPayment(List<? extends SimplePayment> var1);

        public FxAccrualForwardBuilder setCashSettlement(FxCashSettlementSimple var1);

        public FxAccrualForwardBuilder setSettlementPeriodSchedule(FxAccrualSettlementPeriodSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.FxAccrualBuilder.class, this.getAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("linearPayoffRegion"), processor, FxAccrualLinearPayoffRegion.FxAccrualLinearPayoffRegionBuilder.class, this.getLinearPayoffRegion(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averageRate"), processor, FxAverageRate.FxAverageRateBuilder.class, this.getAverageRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.FxAccrualBarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, SimplePayment.SimplePaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.FxCashSettlementSimpleBuilder.class, this.getCashSettlement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodSchedule"), processor, FxAccrualSettlementPeriodSchedule.FxAccrualSettlementPeriodScheduleBuilder.class, this.getSettlementPeriodSchedule(), new AttributeMeta[0]);
        }

        @Override
        public FxAccrualForwardBuilder prune();
    }

    public static class FxAccrualForwardImpl
    extends Product.ProductImpl
    implements FxAccrualForward {
        private final NonNegativeAmountSchedule notionalAmount;
        private final FxAccrual accrual;
        private final FxExpiryDateOrScheduleModel fxExpiryDateOrScheduleModel;
        private final FxSettlementDateOrScheduleModel fxSettlementDateOrScheduleModel;
        private final BigDecimal spotRate;
        private final List<? extends FxAccrualLinearPayoffRegion> linearPayoffRegion;
        private final FxAverageRate averageRate;
        private final List<? extends FxAccrualBarrier> barrier;
        private final List<? extends SimplePayment> additionalPayment;
        private final FxCashSettlementSimple cashSettlement;
        private final FxAccrualSettlementPeriodSchedule settlementPeriodSchedule;

        protected FxAccrualForwardImpl(FxAccrualForwardBuilder builder) {
            super(builder);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.accrual = Optional.ofNullable(builder.getAccrual()).map(f -> f.build()).orElse(null);
            this.fxExpiryDateOrScheduleModel = Optional.ofNullable(builder.getFxExpiryDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.fxSettlementDateOrScheduleModel = Optional.ofNullable(builder.getFxSettlementDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.spotRate = builder.getSpotRate();
            this.linearPayoffRegion = Optional.ofNullable(builder.getLinearPayoffRegion()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.averageRate = Optional.ofNullable(builder.getAverageRate()).map(f -> f.build()).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.cashSettlement = Optional.ofNullable(builder.getCashSettlement()).map(f -> f.build()).orElse(null);
            this.settlementPeriodSchedule = Optional.ofNullable(builder.getSettlementPeriodSchedule()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual getAccrual() {
            return this.accrual;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="linearPayoffRegion", isRequired=true)
        @RuneAttribute(value="linearPayoffRegion", isRequired=true)
        public List<? extends FxAccrualLinearPayoffRegion> getLinearPayoffRegion() {
            return this.linearPayoffRegion;
        }

        @Override
        @RosettaAttribute(value="averageRate")
        @RuneAttribute(value="averageRate")
        public FxAverageRate getAverageRate() {
            return this.averageRate;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier> getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends SimplePayment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodSchedule")
        @RuneAttribute(value="settlementPeriodSchedule")
        public FxAccrualSettlementPeriodSchedule getSettlementPeriodSchedule() {
            return this.settlementPeriodSchedule;
        }

        @Override
        public FxAccrualForward build() {
            return this;
        }

        @Override
        public FxAccrualForwardBuilder toBuilder() {
            FxAccrualForwardBuilder builder = FxAccrualForward.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualForwardBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getAccrual()).ifPresent(builder::setAccrual);
            Optional.ofNullable(this.getFxExpiryDateOrScheduleModel()).ifPresent(builder::setFxExpiryDateOrScheduleModel);
            Optional.ofNullable(this.getFxSettlementDateOrScheduleModel()).ifPresent(builder::setFxSettlementDateOrScheduleModel);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getLinearPayoffRegion()).ifPresent(builder::setLinearPayoffRegion);
            Optional.ofNullable(this.getAverageRate()).ifPresent(builder::setAverageRate);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
            Optional.ofNullable(this.getCashSettlement()).ifPresent(builder::setCashSettlement);
            Optional.ofNullable(this.getSettlementPeriodSchedule()).ifPresent(builder::setSettlementPeriodSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualForward _that = (FxAccrualForward)this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.linearPayoffRegion, _that.getLinearPayoffRegion())) {
                return false;
            }
            if (!Objects.equals(this.averageRate, _that.getAverageRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            return Objects.equals(this.settlementPeriodSchedule, _that.getSettlementPeriodSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.linearPayoffRegion != null ? this.linearPayoffRegion.hashCode() : 0);
            _result = 31 * _result + (this.averageRate != null ? this.averageRate.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodSchedule != null ? this.settlementPeriodSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualForward {notionalAmount=" + String.valueOf(this.notionalAmount) + ", accrual=" + String.valueOf(this.accrual) + ", fxExpiryDateOrScheduleModel=" + String.valueOf(this.fxExpiryDateOrScheduleModel) + ", fxSettlementDateOrScheduleModel=" + String.valueOf(this.fxSettlementDateOrScheduleModel) + ", spotRate=" + String.valueOf(this.spotRate) + ", linearPayoffRegion=" + String.valueOf(this.linearPayoffRegion) + ", averageRate=" + String.valueOf(this.averageRate) + ", barrier=" + String.valueOf(this.barrier) + ", additionalPayment=" + String.valueOf(this.additionalPayment) + ", cashSettlement=" + String.valueOf(this.cashSettlement) + ", settlementPeriodSchedule=" + String.valueOf(this.settlementPeriodSchedule) + "} " + super.toString();
        }
    }
}

