/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.FxOptionPremium;
import fpml.consolidated.fx.accruals.FxAccrual;
import fpml.consolidated.fx.accruals.FxAccrualBarrier;
import fpml.consolidated.fx.accruals.FxAccrualTrigger;
import fpml.consolidated.fx.accruals.FxExpiryDateOrScheduleModel;
import fpml.consolidated.fx.accruals.FxSettlementDateOrScheduleModel;
import fpml.consolidated.fx.accruals.meta.FxAccrualDigitalOptionMeta;
import fpml.consolidated.option.shared.Option;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.ExerciseProcedure;
import fpml.consolidated.shared.NonNegativeAmountSchedule;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAccrualDigitalOption", builder=FxAccrualDigitalOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxAccrualDigitalOption", model="fpml", builder=FxAccrualDigitalOptionBuilderImpl.class, version="1.2.2")
public interface FxAccrualDigitalOption
extends Option {
    public static final FxAccrualDigitalOptionMeta metaData = new FxAccrualDigitalOptionMeta();

    public NonNegativeAmountSchedule getNotionalAmount();

    public FxAccrual getAccrual();

    public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel();

    public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel();

    public ExerciseProcedure getExerciseProcedure();

    public FxAccrualTrigger getTrigger();

    public List<? extends FxAccrualBarrier> getBarrier();

    public List<? extends FxOptionPremium> getPremium();

    @Override
    public FxAccrualDigitalOption build();

    @Override
    public FxAccrualDigitalOptionBuilder toBuilder();

    public static FxAccrualDigitalOptionBuilder builder() {
        return new FxAccrualDigitalOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrualDigitalOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrualDigitalOption> getType() {
        return FxAccrualDigitalOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.class, this.getAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trigger"), processor, FxAccrualTrigger.class, this.getTrigger(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.class, this.getPremium(), new AttributeMeta[0]);
    }

    public static class FxAccrualDigitalOptionBuilderImpl
    extends Option.OptionBuilderImpl
    implements FxAccrualDigitalOptionBuilder {
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder notionalAmount;
        protected FxAccrual.FxAccrualBuilder accrual;
        protected FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder fxExpiryDateOrScheduleModel;
        protected FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder fxSettlementDateOrScheduleModel;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected FxAccrualTrigger.FxAccrualTriggerBuilder trigger;
        protected List<FxAccrualBarrier.FxAccrualBarrierBuilder> barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
        protected List<FxOptionPremium.FxOptionPremiumBuilder> premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual.FxAccrualBuilder getAccrual() {
            return this.accrual;
        }

        @Override
        public FxAccrual.FxAccrualBuilder getOrCreateAccrual() {
            FxAccrual.FxAccrualBuilder result = this.accrual != null ? this.accrual : (this.accrual = FxAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel() {
            FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder result = this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel : (this.fxExpiryDateOrScheduleModel = FxExpiryDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel() {
            FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder result = this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel : (this.fxSettlementDateOrScheduleModel = FxSettlementDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trigger", isRequired=true)
        @RuneAttribute(value="trigger", isRequired=true)
        public FxAccrualTrigger.FxAccrualTriggerBuilder getTrigger() {
            return this.trigger;
        }

        @Override
        public FxAccrualTrigger.FxAccrualTriggerBuilder getOrCreateTrigger() {
            FxAccrualTrigger.FxAccrualTriggerBuilder result = this.trigger != null ? this.trigger : (this.trigger = FxAccrualTrigger.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int index) {
            if (this.barrier == null) {
                this.barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
            }
            return (FxAccrualBarrier.FxAccrualBarrierBuilder)this.getIndex(this.barrier, index, () -> {
                FxAccrualBarrier.FxAccrualBarrierBuilder newBarrier = FxAccrualBarrier.builder();
                return newBarrier;
            });
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();
            }
            return (FxOptionPremium.FxOptionPremiumBuilder)this.getIndex(this.premium, index, () -> {
                FxOptionPremium.FxOptionPremiumBuilder newPremium = FxOptionPremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxAccrualDigitalOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxAccrualDigitalOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public FxAccrualDigitalOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxAccrualDigitalOptionBuilder setNotionalAmount(NonNegativeAmountSchedule _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrualDigitalOptionBuilder setAccrual(FxAccrual _accrual) {
            this.accrual = _accrual == null ? null : _accrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxAccrualDigitalOptionBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel _fxExpiryDateOrScheduleModel) {
            this.fxExpiryDateOrScheduleModel = _fxExpiryDateOrScheduleModel == null ? null : _fxExpiryDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxAccrualDigitalOptionBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel _fxSettlementDateOrScheduleModel) {
            this.fxSettlementDateOrScheduleModel = _fxSettlementDateOrScheduleModel == null ? null : _fxSettlementDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public FxAccrualDigitalOptionBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trigger", isRequired=true)
        @RuneAttribute(value="trigger", isRequired=true)
        public FxAccrualDigitalOptionBuilder setTrigger(FxAccrualTrigger _trigger) {
            this.trigger = _trigger == null ? null : _trigger.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxAccrualDigitalOptionBuilder addBarrier(FxAccrualBarrier _barrier) {
            if (_barrier != null) {
                this.barrier.add(_barrier.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualDigitalOptionBuilder addBarrier(FxAccrualBarrier _barrier, int idx) {
            this.getIndex(this.barrier, idx, () -> _barrier.toBuilder());
            return this;
        }

        @Override
        public FxAccrualDigitalOptionBuilder addBarrier(List<? extends FxAccrualBarrier> barriers) {
            if (barriers != null) {
                for (FxAccrualBarrier fxAccrualBarrier : barriers) {
                    this.barrier.add(fxAccrualBarrier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrier")
        public FxAccrualDigitalOptionBuilder setBarrier(List<? extends FxAccrualBarrier> barriers) {
            this.barrier = barriers == null ? new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>() : (List)barriers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxAccrualDigitalOptionBuilder addPremium(FxOptionPremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualDigitalOptionBuilder addPremium(FxOptionPremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public FxAccrualDigitalOptionBuilder addPremium(List<? extends FxOptionPremium> premiums) {
            if (premiums != null) {
                for (FxOptionPremium fxOptionPremium : premiums) {
                    this.premium.add(fxOptionPremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public FxAccrualDigitalOptionBuilder setPremium(List<? extends FxOptionPremium> premiums) {
            this.premium = premiums == null ? new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxAccrualDigitalOption build() {
            return new FxAccrualDigitalOptionImpl(this);
        }

        @Override
        public FxAccrualDigitalOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualDigitalOptionBuilder prune() {
            super.prune();
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            if (this.accrual != null && !this.accrual.prune().hasData()) {
                this.accrual = null;
            }
            if (this.fxExpiryDateOrScheduleModel != null && !this.fxExpiryDateOrScheduleModel.prune().hasData()) {
                this.fxExpiryDateOrScheduleModel = null;
            }
            if (this.fxSettlementDateOrScheduleModel != null && !this.fxSettlementDateOrScheduleModel.prune().hasData()) {
                this.fxSettlementDateOrScheduleModel = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.trigger != null && !this.trigger.prune().hasData()) {
                this.trigger = null;
            }
            this.barrier = this.barrier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getAccrual() != null && this.getAccrual().hasData()) {
                return true;
            }
            if (this.getFxExpiryDateOrScheduleModel() != null && this.getFxExpiryDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getFxSettlementDateOrScheduleModel() != null && this.getFxSettlementDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getTrigger() != null && this.getTrigger().hasData()) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxAccrualDigitalOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxAccrualDigitalOptionBuilder o = (FxAccrualDigitalOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrual(), (RosettaModelObjectBuilder)o.getAccrual(), this::setAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxExpiryDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxExpiryDateOrScheduleModel(), this::setFxExpiryDateOrScheduleModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxSettlementDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxSettlementDateOrScheduleModel(), this::setFxSettlementDateOrScheduleModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrigger(), (RosettaModelObjectBuilder)o.getTrigger(), this::setTrigger);
            merger.mergeRosetta(this.getBarrier(), o.getBarrier(), this::getOrCreateBarrier);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualDigitalOption _that = (FxAccrualDigitalOption)this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.trigger, _that.getTrigger())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualDigitalOptionBuilder {notionalAmount=" + String.valueOf(this.notionalAmount) + ", accrual=" + String.valueOf(this.accrual) + ", fxExpiryDateOrScheduleModel=" + String.valueOf(this.fxExpiryDateOrScheduleModel) + ", fxSettlementDateOrScheduleModel=" + String.valueOf(this.fxSettlementDateOrScheduleModel) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", trigger=" + String.valueOf(this.trigger) + ", barrier=" + String.valueOf(this.barrier) + ", premium=" + String.valueOf(this.premium) + "} " + super.toString();
        }
    }

    public static interface FxAccrualDigitalOptionBuilder
    extends FxAccrualDigitalOption,
    Option.OptionBuilder {
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount();

        public FxAccrual.FxAccrualBuilder getOrCreateAccrual();

        @Override
        public FxAccrual.FxAccrualBuilder getAccrual();

        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel();

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel();

        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel();

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public FxAccrualTrigger.FxAccrualTriggerBuilder getOrCreateTrigger();

        @Override
        public FxAccrualTrigger.FxAccrualTriggerBuilder getTrigger();

        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int var1);

        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier();

        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int var1);

        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium();

        @Override
        public FxAccrualDigitalOptionBuilder setProductModel(ProductModel var1);

        @Override
        public FxAccrualDigitalOptionBuilder setId(String var1);

        @Override
        public FxAccrualDigitalOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public FxAccrualDigitalOptionBuilder setNotionalAmount(NonNegativeAmountSchedule var1);

        public FxAccrualDigitalOptionBuilder setAccrual(FxAccrual var1);

        public FxAccrualDigitalOptionBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel var1);

        public FxAccrualDigitalOptionBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel var1);

        public FxAccrualDigitalOptionBuilder setExerciseProcedure(ExerciseProcedure var1);

        public FxAccrualDigitalOptionBuilder setTrigger(FxAccrualTrigger var1);

        public FxAccrualDigitalOptionBuilder addBarrier(FxAccrualBarrier var1);

        public FxAccrualDigitalOptionBuilder addBarrier(FxAccrualBarrier var1, int var2);

        public FxAccrualDigitalOptionBuilder addBarrier(List<? extends FxAccrualBarrier> var1);

        public FxAccrualDigitalOptionBuilder setBarrier(List<? extends FxAccrualBarrier> var1);

        public FxAccrualDigitalOptionBuilder addPremium(FxOptionPremium var1);

        public FxAccrualDigitalOptionBuilder addPremium(FxOptionPremium var1, int var2);

        public FxAccrualDigitalOptionBuilder addPremium(List<? extends FxOptionPremium> var1);

        public FxAccrualDigitalOptionBuilder setPremium(List<? extends FxOptionPremium> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.FxAccrualBuilder.class, this.getAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trigger"), processor, FxAccrualTrigger.FxAccrualTriggerBuilder.class, this.getTrigger(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.FxAccrualBarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.FxOptionPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
        }

        @Override
        public FxAccrualDigitalOptionBuilder prune();
    }

    public static class FxAccrualDigitalOptionImpl
    extends Option.OptionImpl
    implements FxAccrualDigitalOption {
        private final NonNegativeAmountSchedule notionalAmount;
        private final FxAccrual accrual;
        private final FxExpiryDateOrScheduleModel fxExpiryDateOrScheduleModel;
        private final FxSettlementDateOrScheduleModel fxSettlementDateOrScheduleModel;
        private final ExerciseProcedure exerciseProcedure;
        private final FxAccrualTrigger trigger;
        private final List<? extends FxAccrualBarrier> barrier;
        private final List<? extends FxOptionPremium> premium;

        protected FxAccrualDigitalOptionImpl(FxAccrualDigitalOptionBuilder builder) {
            super(builder);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.accrual = Optional.ofNullable(builder.getAccrual()).map(f -> f.build()).orElse(null);
            this.fxExpiryDateOrScheduleModel = Optional.ofNullable(builder.getFxExpiryDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.fxSettlementDateOrScheduleModel = Optional.ofNullable(builder.getFxSettlementDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.trigger = Optional.ofNullable(builder.getTrigger()).map(f -> f.build()).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual getAccrual() {
            return this.accrual;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="trigger", isRequired=true)
        @RuneAttribute(value="trigger", isRequired=true)
        public FxAccrualTrigger getTrigger() {
            return this.trigger;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier> getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium> getPremium() {
            return this.premium;
        }

        @Override
        public FxAccrualDigitalOption build() {
            return this;
        }

        @Override
        public FxAccrualDigitalOptionBuilder toBuilder() {
            FxAccrualDigitalOptionBuilder builder = FxAccrualDigitalOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualDigitalOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getAccrual()).ifPresent(builder::setAccrual);
            Optional.ofNullable(this.getFxExpiryDateOrScheduleModel()).ifPresent(builder::setFxExpiryDateOrScheduleModel);
            Optional.ofNullable(this.getFxSettlementDateOrScheduleModel()).ifPresent(builder::setFxSettlementDateOrScheduleModel);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getTrigger()).ifPresent(builder::setTrigger);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualDigitalOption _that = (FxAccrualDigitalOption)this.getType().cast(o);
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.trigger, _that.getTrigger())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualDigitalOption {notionalAmount=" + String.valueOf(this.notionalAmount) + ", accrual=" + String.valueOf(this.accrual) + ", fxExpiryDateOrScheduleModel=" + String.valueOf(this.fxExpiryDateOrScheduleModel) + ", fxSettlementDateOrScheduleModel=" + String.valueOf(this.fxSettlementDateOrScheduleModel) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", trigger=" + String.valueOf(this.trigger) + ", barrier=" + String.valueOf(this.barrier) + ", premium=" + String.valueOf(this.premium) + "} " + super.toString();
        }
    }
}

