/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.FxDigitalOptionSequence0;
import fpml.consolidated.fx.FxDigitalOptionSequence1;
import fpml.consolidated.fx.FxOptionPayout;
import fpml.consolidated.fx.FxOptionPremium;
import fpml.consolidated.fx.meta.FxDigitalOptionMeta;
import fpml.consolidated.option.shared.Option;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.ExerciseProcedure;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxDigitalOption", builder=FxDigitalOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxDigitalOption", model="fpml", builder=FxDigitalOptionBuilderImpl.class, version="1.2.2")
public interface FxDigitalOption
extends Option {
    public static final FxDigitalOptionMeta metaData = new FxDigitalOptionMeta();

    public AdjustableOrRelativeDate getEffectiveDate();

    public Period getTenorPeriod();

    public FxDigitalOptionSequence0 getFxDigitalOptionSequence0();

    public FxDigitalOptionSequence1 getFxDigitalOptionSequence1();

    public ExerciseProcedure getExerciseProcedure();

    public FxOptionPayout getPayout();

    public List<? extends FxOptionPremium> getPremium();

    @Override
    public FxDigitalOption build();

    @Override
    public FxDigitalOptionBuilder toBuilder();

    public static FxDigitalOptionBuilder builder() {
        return new FxDigitalOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends FxDigitalOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxDigitalOption> getType() {
        return FxDigitalOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.class, this.getTenorPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxDigitalOptionSequence0"), processor, FxDigitalOptionSequence0.class, this.getFxDigitalOptionSequence0(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxDigitalOptionSequence1"), processor, FxDigitalOptionSequence1.class, this.getFxDigitalOptionSequence1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payout"), processor, FxOptionPayout.class, this.getPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.class, this.getPremium(), new AttributeMeta[0]);
    }

    public static class FxDigitalOptionBuilderImpl
    extends Option.OptionBuilderImpl
    implements FxDigitalOptionBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected Period.PeriodBuilder tenorPeriod;
        protected FxDigitalOptionSequence0.FxDigitalOptionSequence0Builder fxDigitalOptionSequence0;
        protected FxDigitalOptionSequence1.FxDigitalOptionSequence1Builder fxDigitalOptionSequence1;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected FxOptionPayout.FxOptionPayoutBuilder payout;
        protected List<FxOptionPremium.FxOptionPremiumBuilder> premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public Period.PeriodBuilder getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTenorPeriod() {
            Period.PeriodBuilder result = this.tenorPeriod != null ? this.tenorPeriod : (this.tenorPeriod = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxDigitalOptionSequence0")
        @RuneAttribute(value="fxDigitalOptionSequence0")
        public FxDigitalOptionSequence0.FxDigitalOptionSequence0Builder getFxDigitalOptionSequence0() {
            return this.fxDigitalOptionSequence0;
        }

        @Override
        public FxDigitalOptionSequence0.FxDigitalOptionSequence0Builder getOrCreateFxDigitalOptionSequence0() {
            FxDigitalOptionSequence0.FxDigitalOptionSequence0Builder result = this.fxDigitalOptionSequence0 != null ? this.fxDigitalOptionSequence0 : (this.fxDigitalOptionSequence0 = FxDigitalOptionSequence0.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxDigitalOptionSequence1")
        @RuneAttribute(value="fxDigitalOptionSequence1")
        public FxDigitalOptionSequence1.FxDigitalOptionSequence1Builder getFxDigitalOptionSequence1() {
            return this.fxDigitalOptionSequence1;
        }

        @Override
        public FxDigitalOptionSequence1.FxDigitalOptionSequence1Builder getOrCreateFxDigitalOptionSequence1() {
            FxDigitalOptionSequence1.FxDigitalOptionSequence1Builder result = this.fxDigitalOptionSequence1 != null ? this.fxDigitalOptionSequence1 : (this.fxDigitalOptionSequence1 = FxDigitalOptionSequence1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public FxOptionPayout.FxOptionPayoutBuilder getPayout() {
            return this.payout;
        }

        @Override
        public FxOptionPayout.FxOptionPayoutBuilder getOrCreatePayout() {
            FxOptionPayout.FxOptionPayoutBuilder result = this.payout != null ? this.payout : (this.payout = FxOptionPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();
            }
            return (FxOptionPremium.FxOptionPremiumBuilder)this.getIndex(this.premium, index, () -> {
                FxOptionPremium.FxOptionPremiumBuilder newPremium = FxOptionPremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxDigitalOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxDigitalOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public FxDigitalOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public FxDigitalOptionBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public FxDigitalOptionBuilder setTenorPeriod(Period _tenorPeriod) {
            this.tenorPeriod = _tenorPeriod == null ? null : _tenorPeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxDigitalOptionSequence0")
        @RuneAttribute(value="fxDigitalOptionSequence0")
        public FxDigitalOptionBuilder setFxDigitalOptionSequence0(FxDigitalOptionSequence0 _fxDigitalOptionSequence0) {
            this.fxDigitalOptionSequence0 = _fxDigitalOptionSequence0 == null ? null : _fxDigitalOptionSequence0.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxDigitalOptionSequence1")
        @RuneAttribute(value="fxDigitalOptionSequence1")
        public FxDigitalOptionBuilder setFxDigitalOptionSequence1(FxDigitalOptionSequence1 _fxDigitalOptionSequence1) {
            this.fxDigitalOptionSequence1 = _fxDigitalOptionSequence1 == null ? null : _fxDigitalOptionSequence1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public FxDigitalOptionBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public FxDigitalOptionBuilder setPayout(FxOptionPayout _payout) {
            this.payout = _payout == null ? null : _payout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxDigitalOptionBuilder addPremium(FxOptionPremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public FxDigitalOptionBuilder addPremium(FxOptionPremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public FxDigitalOptionBuilder addPremium(List<? extends FxOptionPremium> premiums) {
            if (premiums != null) {
                for (FxOptionPremium fxOptionPremium : premiums) {
                    this.premium.add(fxOptionPremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public FxDigitalOptionBuilder setPremium(List<? extends FxOptionPremium> premiums) {
            this.premium = premiums == null ? new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxDigitalOption build() {
            return new FxDigitalOptionImpl(this);
        }

        @Override
        public FxDigitalOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public FxDigitalOptionBuilder prune() {
            super.prune();
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.tenorPeriod != null && !this.tenorPeriod.prune().hasData()) {
                this.tenorPeriod = null;
            }
            if (this.fxDigitalOptionSequence0 != null && !this.fxDigitalOptionSequence0.prune().hasData()) {
                this.fxDigitalOptionSequence0 = null;
            }
            if (this.fxDigitalOptionSequence1 != null && !this.fxDigitalOptionSequence1.prune().hasData()) {
                this.fxDigitalOptionSequence1 = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.payout != null && !this.payout.prune().hasData()) {
                this.payout = null;
            }
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getTenorPeriod() != null && this.getTenorPeriod().hasData()) {
                return true;
            }
            if (this.getFxDigitalOptionSequence0() != null && this.getFxDigitalOptionSequence0().hasData()) {
                return true;
            }
            if (this.getFxDigitalOptionSequence1() != null && this.getFxDigitalOptionSequence1().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getPayout() != null && this.getPayout().hasData()) {
                return true;
            }
            return this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxDigitalOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxDigitalOptionBuilder o = (FxDigitalOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTenorPeriod(), (RosettaModelObjectBuilder)o.getTenorPeriod(), this::setTenorPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxDigitalOptionSequence0(), (RosettaModelObjectBuilder)o.getFxDigitalOptionSequence0(), this::setFxDigitalOptionSequence0);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxDigitalOptionSequence1(), (RosettaModelObjectBuilder)o.getFxDigitalOptionSequence1(), this::setFxDigitalOptionSequence1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayout(), (RosettaModelObjectBuilder)o.getPayout(), this::setPayout);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxDigitalOption _that = (FxDigitalOption)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.tenorPeriod, _that.getTenorPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fxDigitalOptionSequence0, _that.getFxDigitalOptionSequence0())) {
                return false;
            }
            if (!Objects.equals(this.fxDigitalOptionSequence1, _that.getFxDigitalOptionSequence1())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fxDigitalOptionSequence0 != null ? this.fxDigitalOptionSequence0.hashCode() : 0);
            _result = 31 * _result + (this.fxDigitalOptionSequence1 != null ? this.fxDigitalOptionSequence1.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxDigitalOptionBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", tenorPeriod=" + String.valueOf(this.tenorPeriod) + ", fxDigitalOptionSequence0=" + String.valueOf(this.fxDigitalOptionSequence0) + ", fxDigitalOptionSequence1=" + String.valueOf(this.fxDigitalOptionSequence1) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", payout=" + String.valueOf(this.payout) + ", premium=" + String.valueOf(this.premium) + "} " + super.toString();
        }
    }

    public static interface FxDigitalOptionBuilder
    extends FxDigitalOption,
    Option.OptionBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public Period.PeriodBuilder getOrCreateTenorPeriod();

        @Override
        public Period.PeriodBuilder getTenorPeriod();

        public FxDigitalOptionSequence0.FxDigitalOptionSequence0Builder getOrCreateFxDigitalOptionSequence0();

        @Override
        public FxDigitalOptionSequence0.FxDigitalOptionSequence0Builder getFxDigitalOptionSequence0();

        public FxDigitalOptionSequence1.FxDigitalOptionSequence1Builder getOrCreateFxDigitalOptionSequence1();

        @Override
        public FxDigitalOptionSequence1.FxDigitalOptionSequence1Builder getFxDigitalOptionSequence1();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public FxOptionPayout.FxOptionPayoutBuilder getOrCreatePayout();

        @Override
        public FxOptionPayout.FxOptionPayoutBuilder getPayout();

        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int var1);

        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium();

        @Override
        public FxDigitalOptionBuilder setProductModel(ProductModel var1);

        @Override
        public FxDigitalOptionBuilder setId(String var1);

        @Override
        public FxDigitalOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public FxDigitalOptionBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public FxDigitalOptionBuilder setTenorPeriod(Period var1);

        public FxDigitalOptionBuilder setFxDigitalOptionSequence0(FxDigitalOptionSequence0 var1);

        public FxDigitalOptionBuilder setFxDigitalOptionSequence1(FxDigitalOptionSequence1 var1);

        public FxDigitalOptionBuilder setExerciseProcedure(ExerciseProcedure var1);

        public FxDigitalOptionBuilder setPayout(FxOptionPayout var1);

        public FxDigitalOptionBuilder addPremium(FxOptionPremium var1);

        public FxDigitalOptionBuilder addPremium(FxOptionPremium var1, int var2);

        public FxDigitalOptionBuilder addPremium(List<? extends FxOptionPremium> var1);

        public FxDigitalOptionBuilder setPremium(List<? extends FxOptionPremium> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.PeriodBuilder.class, this.getTenorPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxDigitalOptionSequence0"), processor, FxDigitalOptionSequence0.FxDigitalOptionSequence0Builder.class, this.getFxDigitalOptionSequence0(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxDigitalOptionSequence1"), processor, FxDigitalOptionSequence1.FxDigitalOptionSequence1Builder.class, this.getFxDigitalOptionSequence1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payout"), processor, FxOptionPayout.FxOptionPayoutBuilder.class, this.getPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.FxOptionPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
        }

        @Override
        public FxDigitalOptionBuilder prune();
    }

    public static class FxDigitalOptionImpl
    extends Option.OptionImpl
    implements FxDigitalOption {
        private final AdjustableOrRelativeDate effectiveDate;
        private final Period tenorPeriod;
        private final FxDigitalOptionSequence0 fxDigitalOptionSequence0;
        private final FxDigitalOptionSequence1 fxDigitalOptionSequence1;
        private final ExerciseProcedure exerciseProcedure;
        private final FxOptionPayout payout;
        private final List<? extends FxOptionPremium> premium;

        protected FxDigitalOptionImpl(FxDigitalOptionBuilder builder) {
            super(builder);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.tenorPeriod = Optional.ofNullable(builder.getTenorPeriod()).map(f -> f.build()).orElse(null);
            this.fxDigitalOptionSequence0 = Optional.ofNullable(builder.getFxDigitalOptionSequence0()).map(f -> f.build()).orElse(null);
            this.fxDigitalOptionSequence1 = Optional.ofNullable(builder.getFxDigitalOptionSequence1()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.payout = Optional.ofNullable(builder.getPayout()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public Period getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        @RosettaAttribute(value="fxDigitalOptionSequence0")
        @RuneAttribute(value="fxDigitalOptionSequence0")
        public FxDigitalOptionSequence0 getFxDigitalOptionSequence0() {
            return this.fxDigitalOptionSequence0;
        }

        @Override
        @RosettaAttribute(value="fxDigitalOptionSequence1")
        @RuneAttribute(value="fxDigitalOptionSequence1")
        public FxDigitalOptionSequence1 getFxDigitalOptionSequence1() {
            return this.fxDigitalOptionSequence1;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public FxOptionPayout getPayout() {
            return this.payout;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium> getPremium() {
            return this.premium;
        }

        @Override
        public FxDigitalOption build() {
            return this;
        }

        @Override
        public FxDigitalOptionBuilder toBuilder() {
            FxDigitalOptionBuilder builder = FxDigitalOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxDigitalOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getTenorPeriod()).ifPresent(builder::setTenorPeriod);
            Optional.ofNullable(this.getFxDigitalOptionSequence0()).ifPresent(builder::setFxDigitalOptionSequence0);
            Optional.ofNullable(this.getFxDigitalOptionSequence1()).ifPresent(builder::setFxDigitalOptionSequence1);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getPayout()).ifPresent(builder::setPayout);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxDigitalOption _that = (FxDigitalOption)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.tenorPeriod, _that.getTenorPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fxDigitalOptionSequence0, _that.getFxDigitalOptionSequence0())) {
                return false;
            }
            if (!Objects.equals(this.fxDigitalOptionSequence1, _that.getFxDigitalOptionSequence1())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fxDigitalOptionSequence0 != null ? this.fxDigitalOptionSequence0.hashCode() : 0);
            _result = 31 * _result + (this.fxDigitalOptionSequence1 != null ? this.fxDigitalOptionSequence1.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxDigitalOption {effectiveDate=" + String.valueOf(this.effectiveDate) + ", tenorPeriod=" + String.valueOf(this.tenorPeriod) + ", fxDigitalOptionSequence0=" + String.valueOf(this.fxDigitalOptionSequence0) + ", fxDigitalOptionSequence1=" + String.valueOf(this.fxDigitalOptionSequence1) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", payout=" + String.valueOf(this.payout) + ", premium=" + String.valueOf(this.premium) + "} " + super.toString();
        }
    }
}

