/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.EquityPremium;
import fpml.consolidated.eq.shared.EquityStrike;
import fpml.consolidated.eq.shared.FeatureModel;
import fpml.consolidated.eqd.EquityDerivativeShortFormBase;
import fpml.consolidated.eqd.EquityExerciseValuationSettlement;
import fpml.consolidated.eqd.meta.BrokerEquityOptionMeta;
import fpml.consolidated.fpmlenum.EquityOptionTypeEnum;
import fpml.consolidated.option.shared.StrategyFeature;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.ProductModel;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BrokerEquityOption", builder=BrokerEquityOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="BrokerEquityOption", model="fpml", builder=BrokerEquityOptionBuilderImpl.class, version="1.2.2")
public interface BrokerEquityOption
extends EquityDerivativeShortFormBase {
    public static final BrokerEquityOptionMeta metaData = new BrokerEquityOptionMeta();

    public Boolean getDeltaCrossed();

    public Money getBrokerageFee();

    public String getBrokerNotes();

    @Override
    public BrokerEquityOption build();

    @Override
    public BrokerEquityOptionBuilder toBuilder();

    public static BrokerEquityOptionBuilder builder() {
        return new BrokerEquityOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends BrokerEquityOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BrokerEquityOption> getType() {
        return BrokerEquityOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.class, this.getEquityExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.class, this.getFeatureModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.class, this.getStrategyFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, EquityStrike.class, this.getStrike(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotPrice"), BigDecimal.class, (Object)this.getSpotPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityPremium"), processor, EquityPremium.class, this.getEquityPremium(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deltaCrossed"), Boolean.class, (Object)this.getDeltaCrossed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("brokerageFee"), processor, Money.class, this.getBrokerageFee(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerNotes"), String.class, (Object)this.getBrokerNotes(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class BrokerEquityOptionBuilderImpl
    extends EquityDerivativeShortFormBase.EquityDerivativeShortFormBaseBuilderImpl
    implements BrokerEquityOptionBuilder {
        protected Boolean deltaCrossed;
        protected Money.MoneyBuilder brokerageFee;
        protected String brokerNotes;

        @Override
        @RosettaAttribute(value="deltaCrossed")
        @RuneAttribute(value="deltaCrossed")
        public Boolean getDeltaCrossed() {
            return this.deltaCrossed;
        }

        @Override
        @RosettaAttribute(value="brokerageFee")
        @RuneAttribute(value="brokerageFee")
        public Money.MoneyBuilder getBrokerageFee() {
            return this.brokerageFee;
        }

        @Override
        public Money.MoneyBuilder getOrCreateBrokerageFee() {
            Money.MoneyBuilder result = this.brokerageFee != null ? this.brokerageFee : (this.brokerageFee = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="brokerNotes")
        @RuneAttribute(value="brokerNotes")
        public String getBrokerNotes() {
            return this.brokerNotes;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public BrokerEquityOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BrokerEquityOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BrokerEquityOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public BrokerEquityOptionBuilder setOptionType(EquityOptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityEffectiveDate")
        @RuneAttribute(value="equityEffectiveDate")
        public BrokerEquityOptionBuilder setEquityEffectiveDate(ZonedDateTime _equityEffectiveDate) {
            this.equityEffectiveDate = _equityEffectiveDate == null ? null : _equityEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public BrokerEquityOptionBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public BrokerEquityOptionBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExercise", isRequired=true)
        @RuneAttribute(value="equityExercise", isRequired=true)
        public BrokerEquityOptionBuilder setEquityExercise(EquityExerciseValuationSettlement _equityExercise) {
            this.equityExercise = _equityExercise == null ? null : _equityExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="featureModel")
        @RuneAttribute(value="featureModel")
        public BrokerEquityOptionBuilder setFeatureModel(FeatureModel _featureModel) {
            this.featureModel = _featureModel == null ? null : _featureModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strategyFeature")
        @RuneAttribute(value="strategyFeature")
        public BrokerEquityOptionBuilder setStrategyFeature(StrategyFeature _strategyFeature) {
            this.strategyFeature = _strategyFeature == null ? null : _strategyFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public BrokerEquityOptionBuilder setStrike(EquityStrike _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public BrokerEquityOptionBuilder setSpotPrice(BigDecimal _spotPrice) {
            this.spotPrice = _spotPrice == null ? null : _spotPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public BrokerEquityOptionBuilder setNumberOfOptions(BigDecimal _numberOfOptions) {
            this.numberOfOptions = _numberOfOptions == null ? null : _numberOfOptions;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityPremium")
        @RuneAttribute(value="equityPremium")
        public BrokerEquityOptionBuilder setEquityPremium(EquityPremium _equityPremium) {
            this.equityPremium = _equityPremium == null ? null : _equityPremium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deltaCrossed")
        @RuneAttribute(value="deltaCrossed")
        public BrokerEquityOptionBuilder setDeltaCrossed(Boolean _deltaCrossed) {
            this.deltaCrossed = _deltaCrossed == null ? null : _deltaCrossed;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerageFee")
        @RuneAttribute(value="brokerageFee")
        public BrokerEquityOptionBuilder setBrokerageFee(Money _brokerageFee) {
            this.brokerageFee = _brokerageFee == null ? null : _brokerageFee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerNotes")
        @RuneAttribute(value="brokerNotes")
        public BrokerEquityOptionBuilder setBrokerNotes(String _brokerNotes) {
            this.brokerNotes = _brokerNotes == null ? null : _brokerNotes;
            return this;
        }

        @Override
        public BrokerEquityOption build() {
            return new BrokerEquityOptionImpl(this);
        }

        @Override
        public BrokerEquityOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public BrokerEquityOptionBuilder prune() {
            super.prune();
            if (this.brokerageFee != null && !this.brokerageFee.prune().hasData()) {
                this.brokerageFee = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeltaCrossed() != null) {
                return true;
            }
            if (this.getBrokerageFee() != null && this.getBrokerageFee().hasData()) {
                return true;
            }
            return this.getBrokerNotes() != null;
        }

        @Override
        public BrokerEquityOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BrokerEquityOptionBuilder o = (BrokerEquityOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBrokerageFee(), (RosettaModelObjectBuilder)o.getBrokerageFee(), this::setBrokerageFee);
            merger.mergeBasic((Object)this.getDeltaCrossed(), (Object)o.getDeltaCrossed(), this::setDeltaCrossed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBrokerNotes(), (Object)o.getBrokerNotes(), this::setBrokerNotes, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BrokerEquityOption _that = (BrokerEquityOption)this.getType().cast(o);
            if (!Objects.equals(this.deltaCrossed, _that.getDeltaCrossed())) {
                return false;
            }
            if (!Objects.equals(this.brokerageFee, _that.getBrokerageFee())) {
                return false;
            }
            return Objects.equals(this.brokerNotes, _that.getBrokerNotes());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deltaCrossed != null ? this.deltaCrossed.hashCode() : 0);
            _result = 31 * _result + (this.brokerageFee != null ? this.brokerageFee.hashCode() : 0);
            _result = 31 * _result + (this.brokerNotes != null ? this.brokerNotes.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BrokerEquityOptionBuilder {deltaCrossed=" + this.deltaCrossed + ", brokerageFee=" + String.valueOf(this.brokerageFee) + ", brokerNotes=" + this.brokerNotes + "} " + super.toString();
        }
    }

    public static interface BrokerEquityOptionBuilder
    extends BrokerEquityOption,
    EquityDerivativeShortFormBase.EquityDerivativeShortFormBaseBuilder {
        public Money.MoneyBuilder getOrCreateBrokerageFee();

        @Override
        public Money.MoneyBuilder getBrokerageFee();

        @Override
        public BrokerEquityOptionBuilder setProductModel(ProductModel var1);

        @Override
        public BrokerEquityOptionBuilder setId(String var1);

        @Override
        public BrokerEquityOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public BrokerEquityOptionBuilder setOptionType(EquityOptionTypeEnum var1);

        @Override
        public BrokerEquityOptionBuilder setEquityEffectiveDate(ZonedDateTime var1);

        @Override
        public BrokerEquityOptionBuilder setUnderlyer(Underlyer var1);

        @Override
        public BrokerEquityOptionBuilder setNotional(NonNegativeMoney var1);

        @Override
        public BrokerEquityOptionBuilder setEquityExercise(EquityExerciseValuationSettlement var1);

        @Override
        public BrokerEquityOptionBuilder setFeatureModel(FeatureModel var1);

        @Override
        public BrokerEquityOptionBuilder setStrategyFeature(StrategyFeature var1);

        @Override
        public BrokerEquityOptionBuilder setStrike(EquityStrike var1);

        @Override
        public BrokerEquityOptionBuilder setSpotPrice(BigDecimal var1);

        @Override
        public BrokerEquityOptionBuilder setNumberOfOptions(BigDecimal var1);

        @Override
        public BrokerEquityOptionBuilder setEquityPremium(EquityPremium var1);

        public BrokerEquityOptionBuilder setDeltaCrossed(Boolean var1);

        public BrokerEquityOptionBuilder setBrokerageFee(Money var1);

        public BrokerEquityOptionBuilder setBrokerNotes(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder.class, (RosettaModelObjectBuilder)this.getEquityExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.FeatureModelBuilder.class, (RosettaModelObjectBuilder)this.getFeatureModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.StrategyFeatureBuilder.class, (RosettaModelObjectBuilder)this.getStrategyFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, EquityStrike.EquityStrikeBuilder.class, (RosettaModelObjectBuilder)this.getStrike(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotPrice"), BigDecimal.class, (Object)this.getSpotPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityPremium"), processor, EquityPremium.EquityPremiumBuilder.class, (RosettaModelObjectBuilder)this.getEquityPremium(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deltaCrossed"), Boolean.class, (Object)this.getDeltaCrossed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("brokerageFee"), processor, Money.MoneyBuilder.class, this.getBrokerageFee(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerNotes"), String.class, (Object)this.getBrokerNotes(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public BrokerEquityOptionBuilder prune();
    }

    public static class BrokerEquityOptionImpl
    extends EquityDerivativeShortFormBase.EquityDerivativeShortFormBaseImpl
    implements BrokerEquityOption {
        private final Boolean deltaCrossed;
        private final Money brokerageFee;
        private final String brokerNotes;

        protected BrokerEquityOptionImpl(BrokerEquityOptionBuilder builder) {
            super(builder);
            this.deltaCrossed = builder.getDeltaCrossed();
            this.brokerageFee = Optional.ofNullable(builder.getBrokerageFee()).map(f -> f.build()).orElse(null);
            this.brokerNotes = builder.getBrokerNotes();
        }

        @Override
        @RosettaAttribute(value="deltaCrossed")
        @RuneAttribute(value="deltaCrossed")
        public Boolean getDeltaCrossed() {
            return this.deltaCrossed;
        }

        @Override
        @RosettaAttribute(value="brokerageFee")
        @RuneAttribute(value="brokerageFee")
        public Money getBrokerageFee() {
            return this.brokerageFee;
        }

        @Override
        @RosettaAttribute(value="brokerNotes")
        @RuneAttribute(value="brokerNotes")
        public String getBrokerNotes() {
            return this.brokerNotes;
        }

        @Override
        public BrokerEquityOption build() {
            return this;
        }

        @Override
        public BrokerEquityOptionBuilder toBuilder() {
            BrokerEquityOptionBuilder builder = BrokerEquityOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BrokerEquityOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeltaCrossed()).ifPresent(builder::setDeltaCrossed);
            Optional.ofNullable(this.getBrokerageFee()).ifPresent(builder::setBrokerageFee);
            Optional.ofNullable(this.getBrokerNotes()).ifPresent(builder::setBrokerNotes);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BrokerEquityOption _that = (BrokerEquityOption)this.getType().cast(o);
            if (!Objects.equals(this.deltaCrossed, _that.getDeltaCrossed())) {
                return false;
            }
            if (!Objects.equals(this.brokerageFee, _that.getBrokerageFee())) {
                return false;
            }
            return Objects.equals(this.brokerNotes, _that.getBrokerNotes());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deltaCrossed != null ? this.deltaCrossed.hashCode() : 0);
            _result = 31 * _result + (this.brokerageFee != null ? this.brokerageFee.hashCode() : 0);
            _result = 31 * _result + (this.brokerNotes != null ? this.brokerNotes.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BrokerEquityOption {deltaCrossed=" + this.deltaCrossed + ", brokerageFee=" + String.valueOf(this.brokerageFee) + ", brokerNotes=" + this.brokerNotes + "} " + super.toString();
        }
    }
}

