/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.DirectionalLegUnderlyer;
import fpml.consolidated.eq.shared.EquityValuation;
import fpml.consolidated.eq.shared.meta.DirectionalLegUnderlyerValuationMeta;
import fpml.consolidated.option.shared.FxFeature;
import fpml.consolidated.option.shared.OptionSettlementModel;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.LegIdentifier;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DirectionalLegUnderlyerValuation", builder=DirectionalLegUnderlyerValuationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="DirectionalLegUnderlyerValuation", model="fpml", builder=DirectionalLegUnderlyerValuationBuilderImpl.class, version="1.2.2")
public interface DirectionalLegUnderlyerValuation
extends DirectionalLegUnderlyer {
    public static final DirectionalLegUnderlyerValuationMeta metaData = new DirectionalLegUnderlyerValuationMeta();

    public EquityValuation getValuation();

    @Override
    public DirectionalLegUnderlyerValuation build();

    @Override
    public DirectionalLegUnderlyerValuationBuilder toBuilder();

    public static DirectionalLegUnderlyerValuationBuilder builder() {
        return new DirectionalLegUnderlyerValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends DirectionalLegUnderlyerValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DirectionalLegUnderlyerValuation> getType() {
        return DirectionalLegUnderlyerValuation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuation"), processor, EquityValuation.class, this.getValuation(), new AttributeMeta[0]);
    }

    public static class DirectionalLegUnderlyerValuationBuilderImpl
    extends DirectionalLegUnderlyer.DirectionalLegUnderlyerBuilderImpl
    implements DirectionalLegUnderlyerValuationBuilder {
        protected EquityValuation.EquityValuationBuilder valuation;

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public EquityValuation.EquityValuationBuilder getValuation() {
            return this.valuation;
        }

        @Override
        public EquityValuation.EquityValuationBuilder getOrCreateValuation() {
            EquityValuation.EquityValuationBuilder result = this.valuation != null ? this.valuation : (this.valuation = EquityValuation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DirectionalLegUnderlyerValuationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public DirectionalLegUnderlyerValuationBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public DirectionalLegUnderlyerValuationBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public DirectionalLegUnderlyerValuationBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public DirectionalLegUnderlyerValuationBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public DirectionalLegUnderlyerValuationBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public DirectionalLegUnderlyerValuationBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public DirectionalLegUnderlyerValuationBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public DirectionalLegUnderlyerValuationBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public DirectionalLegUnderlyerValuationBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public DirectionalLegUnderlyerValuationBuilder setFxFeature(FxFeature _fxFeature) {
            this.fxFeature = _fxFeature == null ? null : _fxFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public DirectionalLegUnderlyerValuationBuilder setValuation(EquityValuation _valuation) {
            this.valuation = _valuation == null ? null : _valuation.toBuilder();
            return this;
        }

        @Override
        public DirectionalLegUnderlyerValuation build() {
            return new DirectionalLegUnderlyerValuationImpl(this);
        }

        @Override
        public DirectionalLegUnderlyerValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public DirectionalLegUnderlyerValuationBuilder prune() {
            super.prune();
            if (this.valuation != null && !this.valuation.prune().hasData()) {
                this.valuation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getValuation() != null && this.getValuation().hasData();
        }

        @Override
        public DirectionalLegUnderlyerValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DirectionalLegUnderlyerValuationBuilder o = (DirectionalLegUnderlyerValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuation(), (RosettaModelObjectBuilder)o.getValuation(), this::setValuation);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DirectionalLegUnderlyerValuation _that = (DirectionalLegUnderlyerValuation)this.getType().cast(o);
            return Objects.equals(this.valuation, _that.getValuation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.valuation != null ? this.valuation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DirectionalLegUnderlyerValuationBuilder {valuation=" + String.valueOf(this.valuation) + "} " + super.toString();
        }
    }

    public static interface DirectionalLegUnderlyerValuationBuilder
    extends DirectionalLegUnderlyerValuation,
    DirectionalLegUnderlyer.DirectionalLegUnderlyerBuilder {
        public EquityValuation.EquityValuationBuilder getOrCreateValuation();

        @Override
        public EquityValuation.EquityValuationBuilder getValuation();

        @Override
        public DirectionalLegUnderlyerValuationBuilder setId(String var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public DirectionalLegUnderlyerValuationBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder setUnderlyer(Underlyer var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder setOptionSettlementModel(OptionSettlementModel var1);

        @Override
        public DirectionalLegUnderlyerValuationBuilder setFxFeature(FxFeature var1);

        public DirectionalLegUnderlyerValuationBuilder setValuation(EquityValuation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionSettlementModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, (RosettaModelObjectBuilder)this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuation"), processor, EquityValuation.EquityValuationBuilder.class, this.getValuation(), new AttributeMeta[0]);
        }

        @Override
        public DirectionalLegUnderlyerValuationBuilder prune();
    }

    public static class DirectionalLegUnderlyerValuationImpl
    extends DirectionalLegUnderlyer.DirectionalLegUnderlyerImpl
    implements DirectionalLegUnderlyerValuation {
        private final EquityValuation valuation;

        protected DirectionalLegUnderlyerValuationImpl(DirectionalLegUnderlyerValuationBuilder builder) {
            super(builder);
            this.valuation = Optional.ofNullable(builder.getValuation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public EquityValuation getValuation() {
            return this.valuation;
        }

        @Override
        public DirectionalLegUnderlyerValuation build() {
            return this;
        }

        @Override
        public DirectionalLegUnderlyerValuationBuilder toBuilder() {
            DirectionalLegUnderlyerValuationBuilder builder = DirectionalLegUnderlyerValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DirectionalLegUnderlyerValuationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getValuation()).ifPresent(builder::setValuation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DirectionalLegUnderlyerValuation _that = (DirectionalLegUnderlyerValuation)this.getType().cast(o);
            return Objects.equals(this.valuation, _that.getValuation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.valuation != null ? this.valuation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DirectionalLegUnderlyerValuation {valuation=" + String.valueOf(this.valuation) + "} " + super.toString();
        }
    }
}

