/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.Algorithm;
import fpml.consolidated.doc.AllocationReportingStatus;
import fpml.consolidated.doc.BlockTradeModel;
import fpml.consolidated.doc.ClearingStatusValue;
import fpml.consolidated.doc.ConfirmationMethod;
import fpml.consolidated.doc.EndUserExceptionModel;
import fpml.consolidated.doc.ExecutionDateTime;
import fpml.consolidated.doc.ExecutionType;
import fpml.consolidated.doc.ExecutionVenueType;
import fpml.consolidated.doc.PortfolioName;
import fpml.consolidated.doc.PricingContext;
import fpml.consolidated.doc.ReportingRegime;
import fpml.consolidated.doc.ReportingRole;
import fpml.consolidated.doc.TradeCategory;
import fpml.consolidated.doc.TradeProcessingTimestamps;
import fpml.consolidated.doc.Trader;
import fpml.consolidated.doc.TransactionClassificationModel;
import fpml.consolidated.doc.VerificationMethod;
import fpml.consolidated.doc.meta.PartyTradeInformationMeta;
import fpml.consolidated.shared.CollateralizationType;
import fpml.consolidated.shared.PartyAndAccountReferencesModel;
import fpml.consolidated.shared.RelatedBusinessUnit;
import fpml.consolidated.shared.RelatedParty;
import fpml.consolidated.shared.RelatedPerson;
import fpml.consolidated.shared.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartyTradeInformation", builder=PartyTradeInformationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PartyTradeInformation", model="fpml", builder=PartyTradeInformationBuilderImpl.class, version="1.2.2")
public interface PartyTradeInformation
extends RosettaModelObject {
    public static final PartyTradeInformationMeta metaData = new PartyTradeInformationMeta();

    public PartyAndAccountReferencesModel getPartyAndAccountReferencesModel();

    public List<? extends RelatedParty> getRelatedParty();

    public ReportingRole getReportingRole();

    public List<? extends RelatedBusinessUnit> getRelatedBusinessUnit();

    public List<? extends RelatedPerson> getRelatedPerson();

    public List<? extends Algorithm> getAlgorithm();

    public Boolean getIsAccountingHedge();

    public List<? extends TradeCategory> getCategory();

    public ExecutionDateTime getExecutionDateTime();

    public TradeProcessingTimestamps getTimestamps();

    public Boolean getIntentToAllocate();

    public AllocationReportingStatus getAllocationStatus();

    public Boolean getIntentToClear();

    public ClearingStatusValue getClearingStatus();

    public CollateralizationType getCollateralizationType();

    public PortfolioName getCollateralPortfolio();

    public PortfolioName getCollateralPortfolioInitialMargin();

    public PortfolioName getCollateralPortfolioVariationMargin();

    public List<? extends ReportingRegime> getReportingRegime();

    public EndUserExceptionModel getEndUserExceptionModel();

    public Boolean getNonStandardTerms();

    public Boolean getOffMarketPrice();

    public List<? extends PricingContext> getPricingContext();

    public BlockTradeModel getBlockTradeModel();

    public ExecutionType getExecutionType();

    public ExecutionVenueType getExecutionVenueType();

    public VerificationMethod getVerificationMethod();

    public ConfirmationMethod getConfirmationMethod();

    public Boolean getCompressedTrade();

    public TransactionClassificationModel getTransactionClassificationModel();

    public Boolean getIsDisputed();

    public List<? extends Unit> getUnit();

    public List<? extends Trader> getTrader();

    public PartyTradeInformation build();

    public PartyTradeInformationBuilder toBuilder();

    public static PartyTradeInformationBuilder builder() {
        return new PartyTradeInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends PartyTradeInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartyTradeInformation> getType() {
        return PartyTradeInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyAndAccountReferencesModel"), processor, PartyAndAccountReferencesModel.class, this.getPartyAndAccountReferencesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRole"), processor, ReportingRole.class, this.getReportingRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedBusinessUnit"), processor, RelatedBusinessUnit.class, this.getRelatedBusinessUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedPerson"), processor, RelatedPerson.class, this.getRelatedPerson(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("algorithm"), processor, Algorithm.class, this.getAlgorithm(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isAccountingHedge"), Boolean.class, (Object)this.getIsAccountingHedge(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("category"), processor, TradeCategory.class, this.getCategory(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDateTime"), processor, ExecutionDateTime.class, this.getExecutionDateTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("timestamps"), processor, TradeProcessingTimestamps.class, this.getTimestamps(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intentToAllocate"), Boolean.class, (Object)this.getIntentToAllocate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationStatus"), processor, AllocationReportingStatus.class, this.getAllocationStatus(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intentToClear"), Boolean.class, (Object)this.getIntentToClear(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingStatus"), processor, ClearingStatusValue.class, this.getClearingStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralizationType"), processor, CollateralizationType.class, this.getCollateralizationType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolio"), processor, PortfolioName.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolioInitialMargin"), processor, PortfolioName.class, this.getCollateralPortfolioInitialMargin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolioVariationMargin"), processor, PortfolioName.class, this.getCollateralPortfolioVariationMargin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRegime"), processor, ReportingRegime.class, this.getReportingRegime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("endUserExceptionModel"), processor, EndUserExceptionModel.class, this.getEndUserExceptionModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonStandardTerms"), Boolean.class, (Object)this.getNonStandardTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("offMarketPrice"), Boolean.class, (Object)this.getOffMarketPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingContext"), processor, PricingContext.class, this.getPricingContext(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("blockTradeModel"), processor, BlockTradeModel.class, this.getBlockTradeModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionType"), processor, ExecutionType.class, this.getExecutionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.class, this.getExecutionVenueType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("verificationMethod"), processor, VerificationMethod.class, this.getVerificationMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("confirmationMethod"), processor, ConfirmationMethod.class, this.getConfirmationMethod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compressedTrade"), Boolean.class, (Object)this.getCompressedTrade(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transactionClassificationModel"), processor, TransactionClassificationModel.class, this.getTransactionClassificationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isDisputed"), Boolean.class, (Object)this.getIsDisputed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, Unit.class, this.getUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trader"), processor, Trader.class, this.getTrader(), new AttributeMeta[0]);
    }

    public static class PartyTradeInformationBuilderImpl
    implements PartyTradeInformationBuilder {
        protected PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder partyAndAccountReferencesModel;
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
        protected ReportingRole.ReportingRoleBuilder reportingRole;
        protected List<RelatedBusinessUnit.RelatedBusinessUnitBuilder> relatedBusinessUnit = new ArrayList<RelatedBusinessUnit.RelatedBusinessUnitBuilder>();
        protected List<RelatedPerson.RelatedPersonBuilder> relatedPerson = new ArrayList<RelatedPerson.RelatedPersonBuilder>();
        protected List<Algorithm.AlgorithmBuilder> algorithm = new ArrayList<Algorithm.AlgorithmBuilder>();
        protected Boolean isAccountingHedge;
        protected List<TradeCategory.TradeCategoryBuilder> category = new ArrayList<TradeCategory.TradeCategoryBuilder>();
        protected ExecutionDateTime.ExecutionDateTimeBuilder executionDateTime;
        protected TradeProcessingTimestamps.TradeProcessingTimestampsBuilder timestamps;
        protected Boolean intentToAllocate;
        protected AllocationReportingStatus.AllocationReportingStatusBuilder allocationStatus;
        protected Boolean intentToClear;
        protected ClearingStatusValue.ClearingStatusValueBuilder clearingStatus;
        protected CollateralizationType.CollateralizationTypeBuilder collateralizationType;
        protected PortfolioName.PortfolioNameBuilder collateralPortfolio;
        protected PortfolioName.PortfolioNameBuilder collateralPortfolioInitialMargin;
        protected PortfolioName.PortfolioNameBuilder collateralPortfolioVariationMargin;
        protected List<ReportingRegime.ReportingRegimeBuilder> reportingRegime = new ArrayList<ReportingRegime.ReportingRegimeBuilder>();
        protected EndUserExceptionModel.EndUserExceptionModelBuilder endUserExceptionModel;
        protected Boolean nonStandardTerms;
        protected Boolean offMarketPrice;
        protected List<PricingContext.PricingContextBuilder> pricingContext = new ArrayList<PricingContext.PricingContextBuilder>();
        protected BlockTradeModel.BlockTradeModelBuilder blockTradeModel;
        protected ExecutionType.ExecutionTypeBuilder executionType;
        protected ExecutionVenueType.ExecutionVenueTypeBuilder executionVenueType;
        protected VerificationMethod.VerificationMethodBuilder verificationMethod;
        protected ConfirmationMethod.ConfirmationMethodBuilder confirmationMethod;
        protected Boolean compressedTrade;
        protected TransactionClassificationModel.TransactionClassificationModelBuilder transactionClassificationModel;
        protected Boolean isDisputed;
        protected List<Unit.UnitBuilder> unit = new ArrayList<Unit.UnitBuilder>();
        protected List<Trader.TraderBuilder> trader = new ArrayList<Trader.TraderBuilder>();

        @Override
        @RosettaAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        @RuneAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getPartyAndAccountReferencesModel() {
            return this.partyAndAccountReferencesModel;
        }

        @Override
        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getOrCreatePartyAndAccountReferencesModel() {
            PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder result = this.partyAndAccountReferencesModel != null ? this.partyAndAccountReferencesModel : (this.partyAndAccountReferencesModel = PartyAndAccountReferencesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingRole.ReportingRoleBuilder getReportingRole() {
            return this.reportingRole;
        }

        @Override
        public ReportingRole.ReportingRoleBuilder getOrCreateReportingRole() {
            ReportingRole.ReportingRoleBuilder result = this.reportingRole != null ? this.reportingRole : (this.reportingRole = ReportingRole.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedBusinessUnit")
        @RuneAttribute(value="relatedBusinessUnit")
        public List<? extends RelatedBusinessUnit.RelatedBusinessUnitBuilder> getRelatedBusinessUnit() {
            return this.relatedBusinessUnit;
        }

        @Override
        public RelatedBusinessUnit.RelatedBusinessUnitBuilder getOrCreateRelatedBusinessUnit(int index) {
            if (this.relatedBusinessUnit == null) {
                this.relatedBusinessUnit = new ArrayList<RelatedBusinessUnit.RelatedBusinessUnitBuilder>();
            }
            return (RelatedBusinessUnit.RelatedBusinessUnitBuilder)this.getIndex(this.relatedBusinessUnit, index, () -> {
                RelatedBusinessUnit.RelatedBusinessUnitBuilder newRelatedBusinessUnit = RelatedBusinessUnit.builder();
                return newRelatedBusinessUnit;
            });
        }

        @Override
        @RosettaAttribute(value="relatedPerson")
        @RuneAttribute(value="relatedPerson")
        public List<? extends RelatedPerson.RelatedPersonBuilder> getRelatedPerson() {
            return this.relatedPerson;
        }

        @Override
        public RelatedPerson.RelatedPersonBuilder getOrCreateRelatedPerson(int index) {
            if (this.relatedPerson == null) {
                this.relatedPerson = new ArrayList<RelatedPerson.RelatedPersonBuilder>();
            }
            return (RelatedPerson.RelatedPersonBuilder)this.getIndex(this.relatedPerson, index, () -> {
                RelatedPerson.RelatedPersonBuilder newRelatedPerson = RelatedPerson.builder();
                return newRelatedPerson;
            });
        }

        @Override
        @RosettaAttribute(value="algorithm")
        @RuneAttribute(value="algorithm")
        public List<? extends Algorithm.AlgorithmBuilder> getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public Algorithm.AlgorithmBuilder getOrCreateAlgorithm(int index) {
            if (this.algorithm == null) {
                this.algorithm = new ArrayList<Algorithm.AlgorithmBuilder>();
            }
            return (Algorithm.AlgorithmBuilder)this.getIndex(this.algorithm, index, () -> {
                Algorithm.AlgorithmBuilder newAlgorithm = Algorithm.builder();
                return newAlgorithm;
            });
        }

        @Override
        @RosettaAttribute(value="isAccountingHedge")
        @RuneAttribute(value="isAccountingHedge")
        public Boolean getIsAccountingHedge() {
            return this.isAccountingHedge;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public List<? extends TradeCategory.TradeCategoryBuilder> getCategory() {
            return this.category;
        }

        @Override
        public TradeCategory.TradeCategoryBuilder getOrCreateCategory(int index) {
            if (this.category == null) {
                this.category = new ArrayList<TradeCategory.TradeCategoryBuilder>();
            }
            return (TradeCategory.TradeCategoryBuilder)this.getIndex(this.category, index, () -> {
                TradeCategory.TradeCategoryBuilder newCategory = TradeCategory.builder();
                return newCategory;
            });
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public ExecutionDateTime.ExecutionDateTimeBuilder getExecutionDateTime() {
            return this.executionDateTime;
        }

        @Override
        public ExecutionDateTime.ExecutionDateTimeBuilder getOrCreateExecutionDateTime() {
            ExecutionDateTime.ExecutionDateTimeBuilder result = this.executionDateTime != null ? this.executionDateTime : (this.executionDateTime = ExecutionDateTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="timestamps")
        @RuneAttribute(value="timestamps")
        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getTimestamps() {
            return this.timestamps;
        }

        @Override
        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getOrCreateTimestamps() {
            TradeProcessingTimestamps.TradeProcessingTimestampsBuilder result = this.timestamps != null ? this.timestamps : (this.timestamps = TradeProcessingTimestamps.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intentToAllocate")
        @RuneAttribute(value="intentToAllocate")
        public Boolean getIntentToAllocate() {
            return this.intentToAllocate;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public AllocationReportingStatus.AllocationReportingStatusBuilder getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        public AllocationReportingStatus.AllocationReportingStatusBuilder getOrCreateAllocationStatus() {
            AllocationReportingStatus.AllocationReportingStatusBuilder result = this.allocationStatus != null ? this.allocationStatus : (this.allocationStatus = AllocationReportingStatus.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intentToClear")
        @RuneAttribute(value="intentToClear")
        public Boolean getIntentToClear() {
            return this.intentToClear;
        }

        @Override
        @RosettaAttribute(value="clearingStatus")
        @RuneAttribute(value="clearingStatus")
        public ClearingStatusValue.ClearingStatusValueBuilder getClearingStatus() {
            return this.clearingStatus;
        }

        @Override
        public ClearingStatusValue.ClearingStatusValueBuilder getOrCreateClearingStatus() {
            ClearingStatusValue.ClearingStatusValueBuilder result = this.clearingStatus != null ? this.clearingStatus : (this.clearingStatus = ClearingStatusValue.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public CollateralizationType.CollateralizationTypeBuilder getCollateralizationType() {
            return this.collateralizationType;
        }

        @Override
        public CollateralizationType.CollateralizationTypeBuilder getOrCreateCollateralizationType() {
            CollateralizationType.CollateralizationTypeBuilder result = this.collateralizationType != null ? this.collateralizationType : (this.collateralizationType = CollateralizationType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public PortfolioName.PortfolioNameBuilder getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        public PortfolioName.PortfolioNameBuilder getOrCreateCollateralPortfolio() {
            PortfolioName.PortfolioNameBuilder result = this.collateralPortfolio != null ? this.collateralPortfolio : (this.collateralPortfolio = PortfolioName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioInitialMargin")
        @RuneAttribute(value="collateralPortfolioInitialMargin")
        public PortfolioName.PortfolioNameBuilder getCollateralPortfolioInitialMargin() {
            return this.collateralPortfolioInitialMargin;
        }

        @Override
        public PortfolioName.PortfolioNameBuilder getOrCreateCollateralPortfolioInitialMargin() {
            PortfolioName.PortfolioNameBuilder result = this.collateralPortfolioInitialMargin != null ? this.collateralPortfolioInitialMargin : (this.collateralPortfolioInitialMargin = PortfolioName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioVariationMargin")
        @RuneAttribute(value="collateralPortfolioVariationMargin")
        public PortfolioName.PortfolioNameBuilder getCollateralPortfolioVariationMargin() {
            return this.collateralPortfolioVariationMargin;
        }

        @Override
        public PortfolioName.PortfolioNameBuilder getOrCreateCollateralPortfolioVariationMargin() {
            PortfolioName.PortfolioNameBuilder result = this.collateralPortfolioVariationMargin != null ? this.collateralPortfolioVariationMargin : (this.collateralPortfolioVariationMargin = PortfolioName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public List<? extends ReportingRegime.ReportingRegimeBuilder> getReportingRegime() {
            return this.reportingRegime;
        }

        @Override
        public ReportingRegime.ReportingRegimeBuilder getOrCreateReportingRegime(int index) {
            if (this.reportingRegime == null) {
                this.reportingRegime = new ArrayList<ReportingRegime.ReportingRegimeBuilder>();
            }
            return (ReportingRegime.ReportingRegimeBuilder)this.getIndex(this.reportingRegime, index, () -> {
                ReportingRegime.ReportingRegimeBuilder newReportingRegime = ReportingRegime.builder();
                return newReportingRegime;
            });
        }

        @Override
        @RosettaAttribute(value="endUserExceptionModel")
        @RuneAttribute(value="endUserExceptionModel")
        public EndUserExceptionModel.EndUserExceptionModelBuilder getEndUserExceptionModel() {
            return this.endUserExceptionModel;
        }

        @Override
        public EndUserExceptionModel.EndUserExceptionModelBuilder getOrCreateEndUserExceptionModel() {
            EndUserExceptionModel.EndUserExceptionModelBuilder result = this.endUserExceptionModel != null ? this.endUserExceptionModel : (this.endUserExceptionModel = EndUserExceptionModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonStandardTerms")
        @RuneAttribute(value="nonStandardTerms")
        public Boolean getNonStandardTerms() {
            return this.nonStandardTerms;
        }

        @Override
        @RosettaAttribute(value="offMarketPrice")
        @RuneAttribute(value="offMarketPrice")
        public Boolean getOffMarketPrice() {
            return this.offMarketPrice;
        }

        @Override
        @RosettaAttribute(value="pricingContext")
        @RuneAttribute(value="pricingContext")
        public List<? extends PricingContext.PricingContextBuilder> getPricingContext() {
            return this.pricingContext;
        }

        @Override
        public PricingContext.PricingContextBuilder getOrCreatePricingContext(int index) {
            if (this.pricingContext == null) {
                this.pricingContext = new ArrayList<PricingContext.PricingContextBuilder>();
            }
            return (PricingContext.PricingContextBuilder)this.getIndex(this.pricingContext, index, () -> {
                PricingContext.PricingContextBuilder newPricingContext = PricingContext.builder();
                return newPricingContext;
            });
        }

        @Override
        @RosettaAttribute(value="blockTradeModel")
        @RuneAttribute(value="blockTradeModel")
        public BlockTradeModel.BlockTradeModelBuilder getBlockTradeModel() {
            return this.blockTradeModel;
        }

        @Override
        public BlockTradeModel.BlockTradeModelBuilder getOrCreateBlockTradeModel() {
            BlockTradeModel.BlockTradeModelBuilder result = this.blockTradeModel != null ? this.blockTradeModel : (this.blockTradeModel = BlockTradeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="executionType")
        @RuneAttribute(value="executionType")
        public ExecutionType.ExecutionTypeBuilder getExecutionType() {
            return this.executionType;
        }

        @Override
        public ExecutionType.ExecutionTypeBuilder getOrCreateExecutionType() {
            ExecutionType.ExecutionTypeBuilder result = this.executionType != null ? this.executionType : (this.executionType = ExecutionType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType() {
            ExecutionVenueType.ExecutionVenueTypeBuilder result = this.executionVenueType != null ? this.executionVenueType : (this.executionVenueType = ExecutionVenueType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="verificationMethod")
        @RuneAttribute(value="verificationMethod")
        public VerificationMethod.VerificationMethodBuilder getVerificationMethod() {
            return this.verificationMethod;
        }

        @Override
        public VerificationMethod.VerificationMethodBuilder getOrCreateVerificationMethod() {
            VerificationMethod.VerificationMethodBuilder result = this.verificationMethod != null ? this.verificationMethod : (this.verificationMethod = VerificationMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ConfirmationMethod.ConfirmationMethodBuilder getConfirmationMethod() {
            return this.confirmationMethod;
        }

        @Override
        public ConfirmationMethod.ConfirmationMethodBuilder getOrCreateConfirmationMethod() {
            ConfirmationMethod.ConfirmationMethodBuilder result = this.confirmationMethod != null ? this.confirmationMethod : (this.confirmationMethod = ConfirmationMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="compressedTrade")
        @RuneAttribute(value="compressedTrade")
        public Boolean getCompressedTrade() {
            return this.compressedTrade;
        }

        @Override
        @RosettaAttribute(value="transactionClassificationModel")
        @RuneAttribute(value="transactionClassificationModel")
        public TransactionClassificationModel.TransactionClassificationModelBuilder getTransactionClassificationModel() {
            return this.transactionClassificationModel;
        }

        @Override
        public TransactionClassificationModel.TransactionClassificationModelBuilder getOrCreateTransactionClassificationModel() {
            TransactionClassificationModel.TransactionClassificationModelBuilder result = this.transactionClassificationModel != null ? this.transactionClassificationModel : (this.transactionClassificationModel = TransactionClassificationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="isDisputed")
        @RuneAttribute(value="isDisputed")
        public Boolean getIsDisputed() {
            return this.isDisputed;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public List<? extends Unit.UnitBuilder> getUnit() {
            return this.unit;
        }

        @Override
        public Unit.UnitBuilder getOrCreateUnit(int index) {
            if (this.unit == null) {
                this.unit = new ArrayList<Unit.UnitBuilder>();
            }
            return (Unit.UnitBuilder)this.getIndex(this.unit, index, () -> {
                Unit.UnitBuilder newUnit = Unit.builder();
                return newUnit;
            });
        }

        @Override
        @RosettaAttribute(value="trader")
        @RuneAttribute(value="trader")
        public List<? extends Trader.TraderBuilder> getTrader() {
            return this.trader;
        }

        @Override
        public Trader.TraderBuilder getOrCreateTrader(int index) {
            if (this.trader == null) {
                this.trader = new ArrayList<Trader.TraderBuilder>();
            }
            return (Trader.TraderBuilder)this.getIndex(this.trader, index, () -> {
                Trader.TraderBuilder newTrader = Trader.builder();
                return newTrader;
            });
        }

        @Override
        @RosettaAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        @RuneAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        public PartyTradeInformationBuilder setPartyAndAccountReferencesModel(PartyAndAccountReferencesModel _partyAndAccountReferencesModel) {
            this.partyAndAccountReferencesModel = _partyAndAccountReferencesModel == null ? null : _partyAndAccountReferencesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public PartyTradeInformationBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public PartyTradeInformationBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public PartyTradeInformationBuilder setReportingRole(ReportingRole _reportingRole) {
            this.reportingRole = _reportingRole == null ? null : _reportingRole.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedBusinessUnit")
        @RuneAttribute(value="relatedBusinessUnit")
        public PartyTradeInformationBuilder addRelatedBusinessUnit(RelatedBusinessUnit _relatedBusinessUnit) {
            if (_relatedBusinessUnit != null) {
                this.relatedBusinessUnit.add(_relatedBusinessUnit.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addRelatedBusinessUnit(RelatedBusinessUnit _relatedBusinessUnit, int idx) {
            this.getIndex(this.relatedBusinessUnit, idx, () -> _relatedBusinessUnit.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addRelatedBusinessUnit(List<? extends RelatedBusinessUnit> relatedBusinessUnits) {
            if (relatedBusinessUnits != null) {
                for (RelatedBusinessUnit relatedBusinessUnit : relatedBusinessUnits) {
                    this.relatedBusinessUnit.add(relatedBusinessUnit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedBusinessUnit")
        public PartyTradeInformationBuilder setRelatedBusinessUnit(List<? extends RelatedBusinessUnit> relatedBusinessUnits) {
            this.relatedBusinessUnit = relatedBusinessUnits == null ? new ArrayList<RelatedBusinessUnit.RelatedBusinessUnitBuilder>() : (List)relatedBusinessUnits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedPerson")
        @RuneAttribute(value="relatedPerson")
        public PartyTradeInformationBuilder addRelatedPerson(RelatedPerson _relatedPerson) {
            if (_relatedPerson != null) {
                this.relatedPerson.add(_relatedPerson.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addRelatedPerson(RelatedPerson _relatedPerson, int idx) {
            this.getIndex(this.relatedPerson, idx, () -> _relatedPerson.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addRelatedPerson(List<? extends RelatedPerson> relatedPersons) {
            if (relatedPersons != null) {
                for (RelatedPerson relatedPerson : relatedPersons) {
                    this.relatedPerson.add(relatedPerson.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedPerson")
        public PartyTradeInformationBuilder setRelatedPerson(List<? extends RelatedPerson> relatedPersons) {
            this.relatedPerson = relatedPersons == null ? new ArrayList<RelatedPerson.RelatedPersonBuilder>() : (List)relatedPersons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="algorithm")
        @RuneAttribute(value="algorithm")
        public PartyTradeInformationBuilder addAlgorithm(Algorithm _algorithm) {
            if (_algorithm != null) {
                this.algorithm.add(_algorithm.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addAlgorithm(Algorithm _algorithm, int idx) {
            this.getIndex(this.algorithm, idx, () -> _algorithm.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addAlgorithm(List<? extends Algorithm> algorithms) {
            if (algorithms != null) {
                for (Algorithm algorithm : algorithms) {
                    this.algorithm.add(algorithm.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="algorithm")
        public PartyTradeInformationBuilder setAlgorithm(List<? extends Algorithm> algorithms) {
            this.algorithm = algorithms == null ? new ArrayList<Algorithm.AlgorithmBuilder>() : (List)algorithms.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isAccountingHedge")
        @RuneAttribute(value="isAccountingHedge")
        public PartyTradeInformationBuilder setIsAccountingHedge(Boolean _isAccountingHedge) {
            this.isAccountingHedge = _isAccountingHedge == null ? null : _isAccountingHedge;
            return this;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public PartyTradeInformationBuilder addCategory(TradeCategory _category) {
            if (_category != null) {
                this.category.add(_category.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addCategory(TradeCategory _category, int idx) {
            this.getIndex(this.category, idx, () -> _category.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addCategory(List<? extends TradeCategory> categorys) {
            if (categorys != null) {
                for (TradeCategory tradeCategory : categorys) {
                    this.category.add(tradeCategory.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="category")
        public PartyTradeInformationBuilder setCategory(List<? extends TradeCategory> categorys) {
            this.category = categorys == null ? new ArrayList<TradeCategory.TradeCategoryBuilder>() : (List)categorys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public PartyTradeInformationBuilder setExecutionDateTime(ExecutionDateTime _executionDateTime) {
            this.executionDateTime = _executionDateTime == null ? null : _executionDateTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="timestamps")
        @RuneAttribute(value="timestamps")
        public PartyTradeInformationBuilder setTimestamps(TradeProcessingTimestamps _timestamps) {
            this.timestamps = _timestamps == null ? null : _timestamps.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="intentToAllocate")
        @RuneAttribute(value="intentToAllocate")
        public PartyTradeInformationBuilder setIntentToAllocate(Boolean _intentToAllocate) {
            this.intentToAllocate = _intentToAllocate == null ? null : _intentToAllocate;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public PartyTradeInformationBuilder setAllocationStatus(AllocationReportingStatus _allocationStatus) {
            this.allocationStatus = _allocationStatus == null ? null : _allocationStatus.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="intentToClear")
        @RuneAttribute(value="intentToClear")
        public PartyTradeInformationBuilder setIntentToClear(Boolean _intentToClear) {
            this.intentToClear = _intentToClear == null ? null : _intentToClear;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingStatus")
        @RuneAttribute(value="clearingStatus")
        public PartyTradeInformationBuilder setClearingStatus(ClearingStatusValue _clearingStatus) {
            this.clearingStatus = _clearingStatus == null ? null : _clearingStatus.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public PartyTradeInformationBuilder setCollateralizationType(CollateralizationType _collateralizationType) {
            this.collateralizationType = _collateralizationType == null ? null : _collateralizationType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public PartyTradeInformationBuilder setCollateralPortfolio(PortfolioName _collateralPortfolio) {
            this.collateralPortfolio = _collateralPortfolio == null ? null : _collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioInitialMargin")
        @RuneAttribute(value="collateralPortfolioInitialMargin")
        public PartyTradeInformationBuilder setCollateralPortfolioInitialMargin(PortfolioName _collateralPortfolioInitialMargin) {
            this.collateralPortfolioInitialMargin = _collateralPortfolioInitialMargin == null ? null : _collateralPortfolioInitialMargin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioVariationMargin")
        @RuneAttribute(value="collateralPortfolioVariationMargin")
        public PartyTradeInformationBuilder setCollateralPortfolioVariationMargin(PortfolioName _collateralPortfolioVariationMargin) {
            this.collateralPortfolioVariationMargin = _collateralPortfolioVariationMargin == null ? null : _collateralPortfolioVariationMargin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public PartyTradeInformationBuilder addReportingRegime(ReportingRegime _reportingRegime) {
            if (_reportingRegime != null) {
                this.reportingRegime.add(_reportingRegime.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addReportingRegime(ReportingRegime _reportingRegime, int idx) {
            this.getIndex(this.reportingRegime, idx, () -> _reportingRegime.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addReportingRegime(List<? extends ReportingRegime> reportingRegimes) {
            if (reportingRegimes != null) {
                for (ReportingRegime reportingRegime : reportingRegimes) {
                    this.reportingRegime.add(reportingRegime.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reportingRegime")
        public PartyTradeInformationBuilder setReportingRegime(List<? extends ReportingRegime> reportingRegimes) {
            this.reportingRegime = reportingRegimes == null ? new ArrayList<ReportingRegime.ReportingRegimeBuilder>() : (List)reportingRegimes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="endUserExceptionModel")
        @RuneAttribute(value="endUserExceptionModel")
        public PartyTradeInformationBuilder setEndUserExceptionModel(EndUserExceptionModel _endUserExceptionModel) {
            this.endUserExceptionModel = _endUserExceptionModel == null ? null : _endUserExceptionModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonStandardTerms")
        @RuneAttribute(value="nonStandardTerms")
        public PartyTradeInformationBuilder setNonStandardTerms(Boolean _nonStandardTerms) {
            this.nonStandardTerms = _nonStandardTerms == null ? null : _nonStandardTerms;
            return this;
        }

        @Override
        @RosettaAttribute(value="offMarketPrice")
        @RuneAttribute(value="offMarketPrice")
        public PartyTradeInformationBuilder setOffMarketPrice(Boolean _offMarketPrice) {
            this.offMarketPrice = _offMarketPrice == null ? null : _offMarketPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingContext")
        @RuneAttribute(value="pricingContext")
        public PartyTradeInformationBuilder addPricingContext(PricingContext _pricingContext) {
            if (_pricingContext != null) {
                this.pricingContext.add(_pricingContext.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addPricingContext(PricingContext _pricingContext, int idx) {
            this.getIndex(this.pricingContext, idx, () -> _pricingContext.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addPricingContext(List<? extends PricingContext> pricingContexts) {
            if (pricingContexts != null) {
                for (PricingContext pricingContext : pricingContexts) {
                    this.pricingContext.add(pricingContext.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="pricingContext")
        public PartyTradeInformationBuilder setPricingContext(List<? extends PricingContext> pricingContexts) {
            this.pricingContext = pricingContexts == null ? new ArrayList<PricingContext.PricingContextBuilder>() : (List)pricingContexts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="blockTradeModel")
        @RuneAttribute(value="blockTradeModel")
        public PartyTradeInformationBuilder setBlockTradeModel(BlockTradeModel _blockTradeModel) {
            this.blockTradeModel = _blockTradeModel == null ? null : _blockTradeModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="executionType")
        @RuneAttribute(value="executionType")
        public PartyTradeInformationBuilder setExecutionType(ExecutionType _executionType) {
            this.executionType = _executionType == null ? null : _executionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public PartyTradeInformationBuilder setExecutionVenueType(ExecutionVenueType _executionVenueType) {
            this.executionVenueType = _executionVenueType == null ? null : _executionVenueType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="verificationMethod")
        @RuneAttribute(value="verificationMethod")
        public PartyTradeInformationBuilder setVerificationMethod(VerificationMethod _verificationMethod) {
            this.verificationMethod = _verificationMethod == null ? null : _verificationMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public PartyTradeInformationBuilder setConfirmationMethod(ConfirmationMethod _confirmationMethod) {
            this.confirmationMethod = _confirmationMethod == null ? null : _confirmationMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="compressedTrade")
        @RuneAttribute(value="compressedTrade")
        public PartyTradeInformationBuilder setCompressedTrade(Boolean _compressedTrade) {
            this.compressedTrade = _compressedTrade == null ? null : _compressedTrade;
            return this;
        }

        @Override
        @RosettaAttribute(value="transactionClassificationModel")
        @RuneAttribute(value="transactionClassificationModel")
        public PartyTradeInformationBuilder setTransactionClassificationModel(TransactionClassificationModel _transactionClassificationModel) {
            this.transactionClassificationModel = _transactionClassificationModel == null ? null : _transactionClassificationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isDisputed")
        @RuneAttribute(value="isDisputed")
        public PartyTradeInformationBuilder setIsDisputed(Boolean _isDisputed) {
            this.isDisputed = _isDisputed == null ? null : _isDisputed;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public PartyTradeInformationBuilder addUnit(Unit _unit) {
            if (_unit != null) {
                this.unit.add(_unit.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addUnit(Unit _unit, int idx) {
            this.getIndex(this.unit, idx, () -> _unit.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addUnit(List<? extends Unit> units) {
            if (units != null) {
                for (Unit unit : units) {
                    this.unit.add(unit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="unit")
        public PartyTradeInformationBuilder setUnit(List<? extends Unit> units) {
            this.unit = units == null ? new ArrayList<Unit.UnitBuilder>() : (List)units.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="trader")
        @RuneAttribute(value="trader")
        public PartyTradeInformationBuilder addTrader(Trader _trader) {
            if (_trader != null) {
                this.trader.add(_trader.toBuilder());
            }
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addTrader(Trader _trader, int idx) {
            this.getIndex(this.trader, idx, () -> _trader.toBuilder());
            return this;
        }

        @Override
        public PartyTradeInformationBuilder addTrader(List<? extends Trader> traders) {
            if (traders != null) {
                for (Trader trader : traders) {
                    this.trader.add(trader.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="trader")
        public PartyTradeInformationBuilder setTrader(List<? extends Trader> traders) {
            this.trader = traders == null ? new ArrayList<Trader.TraderBuilder>() : (List)traders.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyTradeInformation build() {
            return new PartyTradeInformationImpl(this);
        }

        @Override
        public PartyTradeInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyTradeInformationBuilder prune() {
            if (this.partyAndAccountReferencesModel != null && !this.partyAndAccountReferencesModel.prune().hasData()) {
                this.partyAndAccountReferencesModel = null;
            }
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.reportingRole != null && !this.reportingRole.prune().hasData()) {
                this.reportingRole = null;
            }
            this.relatedBusinessUnit = this.relatedBusinessUnit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.relatedPerson = this.relatedPerson.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.algorithm = this.algorithm.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.category = this.category.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.executionDateTime != null && !this.executionDateTime.prune().hasData()) {
                this.executionDateTime = null;
            }
            if (this.timestamps != null && !this.timestamps.prune().hasData()) {
                this.timestamps = null;
            }
            if (this.allocationStatus != null && !this.allocationStatus.prune().hasData()) {
                this.allocationStatus = null;
            }
            if (this.clearingStatus != null && !this.clearingStatus.prune().hasData()) {
                this.clearingStatus = null;
            }
            if (this.collateralizationType != null && !this.collateralizationType.prune().hasData()) {
                this.collateralizationType = null;
            }
            if (this.collateralPortfolio != null && !this.collateralPortfolio.prune().hasData()) {
                this.collateralPortfolio = null;
            }
            if (this.collateralPortfolioInitialMargin != null && !this.collateralPortfolioInitialMargin.prune().hasData()) {
                this.collateralPortfolioInitialMargin = null;
            }
            if (this.collateralPortfolioVariationMargin != null && !this.collateralPortfolioVariationMargin.prune().hasData()) {
                this.collateralPortfolioVariationMargin = null;
            }
            this.reportingRegime = this.reportingRegime.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.endUserExceptionModel != null && !this.endUserExceptionModel.prune().hasData()) {
                this.endUserExceptionModel = null;
            }
            this.pricingContext = this.pricingContext.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.blockTradeModel != null && !this.blockTradeModel.prune().hasData()) {
                this.blockTradeModel = null;
            }
            if (this.executionType != null && !this.executionType.prune().hasData()) {
                this.executionType = null;
            }
            if (this.executionVenueType != null && !this.executionVenueType.prune().hasData()) {
                this.executionVenueType = null;
            }
            if (this.verificationMethod != null && !this.verificationMethod.prune().hasData()) {
                this.verificationMethod = null;
            }
            if (this.confirmationMethod != null && !this.confirmationMethod.prune().hasData()) {
                this.confirmationMethod = null;
            }
            if (this.transactionClassificationModel != null && !this.transactionClassificationModel.prune().hasData()) {
                this.transactionClassificationModel = null;
            }
            this.unit = this.unit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.trader = this.trader.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyAndAccountReferencesModel() != null && this.getPartyAndAccountReferencesModel().hasData()) {
                return true;
            }
            if (this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getReportingRole() != null && this.getReportingRole().hasData()) {
                return true;
            }
            if (this.getRelatedBusinessUnit() != null && this.getRelatedBusinessUnit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRelatedPerson() != null && this.getRelatedPerson().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAlgorithm() != null && this.getAlgorithm().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIsAccountingHedge() != null) {
                return true;
            }
            if (this.getCategory() != null && this.getCategory().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExecutionDateTime() != null && this.getExecutionDateTime().hasData()) {
                return true;
            }
            if (this.getTimestamps() != null && this.getTimestamps().hasData()) {
                return true;
            }
            if (this.getIntentToAllocate() != null) {
                return true;
            }
            if (this.getAllocationStatus() != null && this.getAllocationStatus().hasData()) {
                return true;
            }
            if (this.getIntentToClear() != null) {
                return true;
            }
            if (this.getClearingStatus() != null && this.getClearingStatus().hasData()) {
                return true;
            }
            if (this.getCollateralizationType() != null && this.getCollateralizationType().hasData()) {
                return true;
            }
            if (this.getCollateralPortfolio() != null && this.getCollateralPortfolio().hasData()) {
                return true;
            }
            if (this.getCollateralPortfolioInitialMargin() != null && this.getCollateralPortfolioInitialMargin().hasData()) {
                return true;
            }
            if (this.getCollateralPortfolioVariationMargin() != null && this.getCollateralPortfolioVariationMargin().hasData()) {
                return true;
            }
            if (this.getReportingRegime() != null && this.getReportingRegime().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEndUserExceptionModel() != null && this.getEndUserExceptionModel().hasData()) {
                return true;
            }
            if (this.getNonStandardTerms() != null) {
                return true;
            }
            if (this.getOffMarketPrice() != null) {
                return true;
            }
            if (this.getPricingContext() != null && this.getPricingContext().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBlockTradeModel() != null && this.getBlockTradeModel().hasData()) {
                return true;
            }
            if (this.getExecutionType() != null && this.getExecutionType().hasData()) {
                return true;
            }
            if (this.getExecutionVenueType() != null && this.getExecutionVenueType().hasData()) {
                return true;
            }
            if (this.getVerificationMethod() != null && this.getVerificationMethod().hasData()) {
                return true;
            }
            if (this.getConfirmationMethod() != null && this.getConfirmationMethod().hasData()) {
                return true;
            }
            if (this.getCompressedTrade() != null) {
                return true;
            }
            if (this.getTransactionClassificationModel() != null && this.getTransactionClassificationModel().hasData()) {
                return true;
            }
            if (this.getIsDisputed() != null) {
                return true;
            }
            if (this.getUnit() != null && this.getUnit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getTrader() != null && this.getTrader().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartyTradeInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyTradeInformationBuilder o = (PartyTradeInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyAndAccountReferencesModel(), (RosettaModelObjectBuilder)o.getPartyAndAccountReferencesModel(), this::setPartyAndAccountReferencesModel);
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingRole(), (RosettaModelObjectBuilder)o.getReportingRole(), this::setReportingRole);
            merger.mergeRosetta(this.getRelatedBusinessUnit(), o.getRelatedBusinessUnit(), this::getOrCreateRelatedBusinessUnit);
            merger.mergeRosetta(this.getRelatedPerson(), o.getRelatedPerson(), this::getOrCreateRelatedPerson);
            merger.mergeRosetta(this.getAlgorithm(), o.getAlgorithm(), this::getOrCreateAlgorithm);
            merger.mergeRosetta(this.getCategory(), o.getCategory(), this::getOrCreateCategory);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDateTime(), (RosettaModelObjectBuilder)o.getExecutionDateTime(), this::setExecutionDateTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTimestamps(), (RosettaModelObjectBuilder)o.getTimestamps(), this::setTimestamps);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocationStatus(), (RosettaModelObjectBuilder)o.getAllocationStatus(), this::setAllocationStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingStatus(), (RosettaModelObjectBuilder)o.getClearingStatus(), this::setClearingStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralizationType(), (RosettaModelObjectBuilder)o.getCollateralizationType(), this::setCollateralizationType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralPortfolio(), (RosettaModelObjectBuilder)o.getCollateralPortfolio(), this::setCollateralPortfolio);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralPortfolioInitialMargin(), (RosettaModelObjectBuilder)o.getCollateralPortfolioInitialMargin(), this::setCollateralPortfolioInitialMargin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralPortfolioVariationMargin(), (RosettaModelObjectBuilder)o.getCollateralPortfolioVariationMargin(), this::setCollateralPortfolioVariationMargin);
            merger.mergeRosetta(this.getReportingRegime(), o.getReportingRegime(), this::getOrCreateReportingRegime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEndUserExceptionModel(), (RosettaModelObjectBuilder)o.getEndUserExceptionModel(), this::setEndUserExceptionModel);
            merger.mergeRosetta(this.getPricingContext(), o.getPricingContext(), this::getOrCreatePricingContext);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBlockTradeModel(), (RosettaModelObjectBuilder)o.getBlockTradeModel(), this::setBlockTradeModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionType(), (RosettaModelObjectBuilder)o.getExecutionType(), this::setExecutionType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionVenueType(), (RosettaModelObjectBuilder)o.getExecutionVenueType(), this::setExecutionVenueType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVerificationMethod(), (RosettaModelObjectBuilder)o.getVerificationMethod(), this::setVerificationMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConfirmationMethod(), (RosettaModelObjectBuilder)o.getConfirmationMethod(), this::setConfirmationMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTransactionClassificationModel(), (RosettaModelObjectBuilder)o.getTransactionClassificationModel(), this::setTransactionClassificationModel);
            merger.mergeRosetta(this.getUnit(), o.getUnit(), this::getOrCreateUnit);
            merger.mergeRosetta(this.getTrader(), o.getTrader(), this::getOrCreateTrader);
            merger.mergeBasic((Object)this.getIsAccountingHedge(), (Object)o.getIsAccountingHedge(), this::setIsAccountingHedge, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntentToAllocate(), (Object)o.getIntentToAllocate(), this::setIntentToAllocate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntentToClear(), (Object)o.getIntentToClear(), this::setIntentToClear, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonStandardTerms(), (Object)o.getNonStandardTerms(), this::setNonStandardTerms, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOffMarketPrice(), (Object)o.getOffMarketPrice(), this::setOffMarketPrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCompressedTrade(), (Object)o.getCompressedTrade(), this::setCompressedTrade, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsDisputed(), (Object)o.getIsDisputed(), this::setIsDisputed, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyTradeInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyAndAccountReferencesModel, _that.getPartyAndAccountReferencesModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            if (!Objects.equals(this.reportingRole, _that.getReportingRole())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedBusinessUnit, _that.getRelatedBusinessUnit())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedPerson, _that.getRelatedPerson())) {
                return false;
            }
            if (!ListEquals.listEquals(this.algorithm, _that.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this.isAccountingHedge, _that.getIsAccountingHedge())) {
                return false;
            }
            if (!ListEquals.listEquals(this.category, _that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.executionDateTime, _that.getExecutionDateTime())) {
                return false;
            }
            if (!Objects.equals(this.timestamps, _that.getTimestamps())) {
                return false;
            }
            if (!Objects.equals(this.intentToAllocate, _that.getIntentToAllocate())) {
                return false;
            }
            if (!Objects.equals(this.allocationStatus, _that.getAllocationStatus())) {
                return false;
            }
            if (!Objects.equals(this.intentToClear, _that.getIntentToClear())) {
                return false;
            }
            if (!Objects.equals(this.clearingStatus, _that.getClearingStatus())) {
                return false;
            }
            if (!Objects.equals(this.collateralizationType, _that.getCollateralizationType())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioInitialMargin, _that.getCollateralPortfolioInitialMargin())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioVariationMargin, _that.getCollateralPortfolioVariationMargin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingRegime, _that.getReportingRegime())) {
                return false;
            }
            if (!Objects.equals(this.endUserExceptionModel, _that.getEndUserExceptionModel())) {
                return false;
            }
            if (!Objects.equals(this.nonStandardTerms, _that.getNonStandardTerms())) {
                return false;
            }
            if (!Objects.equals(this.offMarketPrice, _that.getOffMarketPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.pricingContext, _that.getPricingContext())) {
                return false;
            }
            if (!Objects.equals(this.blockTradeModel, _that.getBlockTradeModel())) {
                return false;
            }
            if (!Objects.equals(this.executionType, _that.getExecutionType())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueType, _that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.verificationMethod, _that.getVerificationMethod())) {
                return false;
            }
            if (!Objects.equals(this.confirmationMethod, _that.getConfirmationMethod())) {
                return false;
            }
            if (!Objects.equals(this.compressedTrade, _that.getCompressedTrade())) {
                return false;
            }
            if (!Objects.equals(this.transactionClassificationModel, _that.getTransactionClassificationModel())) {
                return false;
            }
            if (!Objects.equals(this.isDisputed, _that.getIsDisputed())) {
                return false;
            }
            if (!ListEquals.listEquals(this.unit, _that.getUnit())) {
                return false;
            }
            return ListEquals.listEquals(this.trader, _that.getTrader());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyAndAccountReferencesModel != null ? this.partyAndAccountReferencesModel.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.reportingRole != null ? this.reportingRole.hashCode() : 0);
            _result = 31 * _result + (this.relatedBusinessUnit != null ? this.relatedBusinessUnit.hashCode() : 0);
            _result = 31 * _result + (this.relatedPerson != null ? this.relatedPerson.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            _result = 31 * _result + (this.isAccountingHedge != null ? this.isAccountingHedge.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? this.category.hashCode() : 0);
            _result = 31 * _result + (this.executionDateTime != null ? this.executionDateTime.hashCode() : 0);
            _result = 31 * _result + (this.timestamps != null ? this.timestamps.hashCode() : 0);
            _result = 31 * _result + (this.intentToAllocate != null ? this.intentToAllocate.hashCode() : 0);
            _result = 31 * _result + (this.allocationStatus != null ? this.allocationStatus.hashCode() : 0);
            _result = 31 * _result + (this.intentToClear != null ? this.intentToClear.hashCode() : 0);
            _result = 31 * _result + (this.clearingStatus != null ? this.clearingStatus.hashCode() : 0);
            _result = 31 * _result + (this.collateralizationType != null ? this.collateralizationType.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioInitialMargin != null ? this.collateralPortfolioInitialMargin.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioVariationMargin != null ? this.collateralPortfolioVariationMargin.hashCode() : 0);
            _result = 31 * _result + (this.reportingRegime != null ? this.reportingRegime.hashCode() : 0);
            _result = 31 * _result + (this.endUserExceptionModel != null ? this.endUserExceptionModel.hashCode() : 0);
            _result = 31 * _result + (this.nonStandardTerms != null ? this.nonStandardTerms.hashCode() : 0);
            _result = 31 * _result + (this.offMarketPrice != null ? this.offMarketPrice.hashCode() : 0);
            _result = 31 * _result + (this.pricingContext != null ? this.pricingContext.hashCode() : 0);
            _result = 31 * _result + (this.blockTradeModel != null ? this.blockTradeModel.hashCode() : 0);
            _result = 31 * _result + (this.executionType != null ? this.executionType.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            _result = 31 * _result + (this.verificationMethod != null ? this.verificationMethod.hashCode() : 0);
            _result = 31 * _result + (this.confirmationMethod != null ? this.confirmationMethod.hashCode() : 0);
            _result = 31 * _result + (this.compressedTrade != null ? this.compressedTrade.hashCode() : 0);
            _result = 31 * _result + (this.transactionClassificationModel != null ? this.transactionClassificationModel.hashCode() : 0);
            _result = 31 * _result + (this.isDisputed != null ? this.isDisputed.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.trader != null ? this.trader.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyTradeInformationBuilder {partyAndAccountReferencesModel=" + String.valueOf(this.partyAndAccountReferencesModel) + ", relatedParty=" + String.valueOf(this.relatedParty) + ", reportingRole=" + String.valueOf(this.reportingRole) + ", relatedBusinessUnit=" + String.valueOf(this.relatedBusinessUnit) + ", relatedPerson=" + String.valueOf(this.relatedPerson) + ", algorithm=" + String.valueOf(this.algorithm) + ", isAccountingHedge=" + this.isAccountingHedge + ", category=" + String.valueOf(this.category) + ", executionDateTime=" + String.valueOf(this.executionDateTime) + ", timestamps=" + String.valueOf(this.timestamps) + ", intentToAllocate=" + this.intentToAllocate + ", allocationStatus=" + String.valueOf(this.allocationStatus) + ", intentToClear=" + this.intentToClear + ", clearingStatus=" + String.valueOf(this.clearingStatus) + ", collateralizationType=" + String.valueOf(this.collateralizationType) + ", collateralPortfolio=" + String.valueOf(this.collateralPortfolio) + ", collateralPortfolioInitialMargin=" + String.valueOf(this.collateralPortfolioInitialMargin) + ", collateralPortfolioVariationMargin=" + String.valueOf(this.collateralPortfolioVariationMargin) + ", reportingRegime=" + String.valueOf(this.reportingRegime) + ", endUserExceptionModel=" + String.valueOf(this.endUserExceptionModel) + ", nonStandardTerms=" + this.nonStandardTerms + ", offMarketPrice=" + this.offMarketPrice + ", pricingContext=" + String.valueOf(this.pricingContext) + ", blockTradeModel=" + String.valueOf(this.blockTradeModel) + ", executionType=" + String.valueOf(this.executionType) + ", executionVenueType=" + String.valueOf(this.executionVenueType) + ", verificationMethod=" + String.valueOf(this.verificationMethod) + ", confirmationMethod=" + String.valueOf(this.confirmationMethod) + ", compressedTrade=" + this.compressedTrade + ", transactionClassificationModel=" + String.valueOf(this.transactionClassificationModel) + ", isDisputed=" + this.isDisputed + ", unit=" + String.valueOf(this.unit) + ", trader=" + String.valueOf(this.trader) + "}";
        }
    }

    public static interface PartyTradeInformationBuilder
    extends PartyTradeInformation,
    RosettaModelObjectBuilder {
        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getOrCreatePartyAndAccountReferencesModel();

        @Override
        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getPartyAndAccountReferencesModel();

        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public ReportingRole.ReportingRoleBuilder getOrCreateReportingRole();

        @Override
        public ReportingRole.ReportingRoleBuilder getReportingRole();

        public RelatedBusinessUnit.RelatedBusinessUnitBuilder getOrCreateRelatedBusinessUnit(int var1);

        public List<? extends RelatedBusinessUnit.RelatedBusinessUnitBuilder> getRelatedBusinessUnit();

        public RelatedPerson.RelatedPersonBuilder getOrCreateRelatedPerson(int var1);

        public List<? extends RelatedPerson.RelatedPersonBuilder> getRelatedPerson();

        public Algorithm.AlgorithmBuilder getOrCreateAlgorithm(int var1);

        public List<? extends Algorithm.AlgorithmBuilder> getAlgorithm();

        public TradeCategory.TradeCategoryBuilder getOrCreateCategory(int var1);

        public List<? extends TradeCategory.TradeCategoryBuilder> getCategory();

        public ExecutionDateTime.ExecutionDateTimeBuilder getOrCreateExecutionDateTime();

        @Override
        public ExecutionDateTime.ExecutionDateTimeBuilder getExecutionDateTime();

        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getOrCreateTimestamps();

        @Override
        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getTimestamps();

        public AllocationReportingStatus.AllocationReportingStatusBuilder getOrCreateAllocationStatus();

        @Override
        public AllocationReportingStatus.AllocationReportingStatusBuilder getAllocationStatus();

        public ClearingStatusValue.ClearingStatusValueBuilder getOrCreateClearingStatus();

        @Override
        public ClearingStatusValue.ClearingStatusValueBuilder getClearingStatus();

        public CollateralizationType.CollateralizationTypeBuilder getOrCreateCollateralizationType();

        @Override
        public CollateralizationType.CollateralizationTypeBuilder getCollateralizationType();

        public PortfolioName.PortfolioNameBuilder getOrCreateCollateralPortfolio();

        @Override
        public PortfolioName.PortfolioNameBuilder getCollateralPortfolio();

        public PortfolioName.PortfolioNameBuilder getOrCreateCollateralPortfolioInitialMargin();

        @Override
        public PortfolioName.PortfolioNameBuilder getCollateralPortfolioInitialMargin();

        public PortfolioName.PortfolioNameBuilder getOrCreateCollateralPortfolioVariationMargin();

        @Override
        public PortfolioName.PortfolioNameBuilder getCollateralPortfolioVariationMargin();

        public ReportingRegime.ReportingRegimeBuilder getOrCreateReportingRegime(int var1);

        public List<? extends ReportingRegime.ReportingRegimeBuilder> getReportingRegime();

        public EndUserExceptionModel.EndUserExceptionModelBuilder getOrCreateEndUserExceptionModel();

        @Override
        public EndUserExceptionModel.EndUserExceptionModelBuilder getEndUserExceptionModel();

        public PricingContext.PricingContextBuilder getOrCreatePricingContext(int var1);

        public List<? extends PricingContext.PricingContextBuilder> getPricingContext();

        public BlockTradeModel.BlockTradeModelBuilder getOrCreateBlockTradeModel();

        @Override
        public BlockTradeModel.BlockTradeModelBuilder getBlockTradeModel();

        public ExecutionType.ExecutionTypeBuilder getOrCreateExecutionType();

        @Override
        public ExecutionType.ExecutionTypeBuilder getExecutionType();

        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType();

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType();

        public VerificationMethod.VerificationMethodBuilder getOrCreateVerificationMethod();

        @Override
        public VerificationMethod.VerificationMethodBuilder getVerificationMethod();

        public ConfirmationMethod.ConfirmationMethodBuilder getOrCreateConfirmationMethod();

        @Override
        public ConfirmationMethod.ConfirmationMethodBuilder getConfirmationMethod();

        public TransactionClassificationModel.TransactionClassificationModelBuilder getOrCreateTransactionClassificationModel();

        @Override
        public TransactionClassificationModel.TransactionClassificationModelBuilder getTransactionClassificationModel();

        public Unit.UnitBuilder getOrCreateUnit(int var1);

        public List<? extends Unit.UnitBuilder> getUnit();

        public Trader.TraderBuilder getOrCreateTrader(int var1);

        public List<? extends Trader.TraderBuilder> getTrader();

        public PartyTradeInformationBuilder setPartyAndAccountReferencesModel(PartyAndAccountReferencesModel var1);

        public PartyTradeInformationBuilder addRelatedParty(RelatedParty var1);

        public PartyTradeInformationBuilder addRelatedParty(RelatedParty var1, int var2);

        public PartyTradeInformationBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public PartyTradeInformationBuilder setRelatedParty(List<? extends RelatedParty> var1);

        public PartyTradeInformationBuilder setReportingRole(ReportingRole var1);

        public PartyTradeInformationBuilder addRelatedBusinessUnit(RelatedBusinessUnit var1);

        public PartyTradeInformationBuilder addRelatedBusinessUnit(RelatedBusinessUnit var1, int var2);

        public PartyTradeInformationBuilder addRelatedBusinessUnit(List<? extends RelatedBusinessUnit> var1);

        public PartyTradeInformationBuilder setRelatedBusinessUnit(List<? extends RelatedBusinessUnit> var1);

        public PartyTradeInformationBuilder addRelatedPerson(RelatedPerson var1);

        public PartyTradeInformationBuilder addRelatedPerson(RelatedPerson var1, int var2);

        public PartyTradeInformationBuilder addRelatedPerson(List<? extends RelatedPerson> var1);

        public PartyTradeInformationBuilder setRelatedPerson(List<? extends RelatedPerson> var1);

        public PartyTradeInformationBuilder addAlgorithm(Algorithm var1);

        public PartyTradeInformationBuilder addAlgorithm(Algorithm var1, int var2);

        public PartyTradeInformationBuilder addAlgorithm(List<? extends Algorithm> var1);

        public PartyTradeInformationBuilder setAlgorithm(List<? extends Algorithm> var1);

        public PartyTradeInformationBuilder setIsAccountingHedge(Boolean var1);

        public PartyTradeInformationBuilder addCategory(TradeCategory var1);

        public PartyTradeInformationBuilder addCategory(TradeCategory var1, int var2);

        public PartyTradeInformationBuilder addCategory(List<? extends TradeCategory> var1);

        public PartyTradeInformationBuilder setCategory(List<? extends TradeCategory> var1);

        public PartyTradeInformationBuilder setExecutionDateTime(ExecutionDateTime var1);

        public PartyTradeInformationBuilder setTimestamps(TradeProcessingTimestamps var1);

        public PartyTradeInformationBuilder setIntentToAllocate(Boolean var1);

        public PartyTradeInformationBuilder setAllocationStatus(AllocationReportingStatus var1);

        public PartyTradeInformationBuilder setIntentToClear(Boolean var1);

        public PartyTradeInformationBuilder setClearingStatus(ClearingStatusValue var1);

        public PartyTradeInformationBuilder setCollateralizationType(CollateralizationType var1);

        public PartyTradeInformationBuilder setCollateralPortfolio(PortfolioName var1);

        public PartyTradeInformationBuilder setCollateralPortfolioInitialMargin(PortfolioName var1);

        public PartyTradeInformationBuilder setCollateralPortfolioVariationMargin(PortfolioName var1);

        public PartyTradeInformationBuilder addReportingRegime(ReportingRegime var1);

        public PartyTradeInformationBuilder addReportingRegime(ReportingRegime var1, int var2);

        public PartyTradeInformationBuilder addReportingRegime(List<? extends ReportingRegime> var1);

        public PartyTradeInformationBuilder setReportingRegime(List<? extends ReportingRegime> var1);

        public PartyTradeInformationBuilder setEndUserExceptionModel(EndUserExceptionModel var1);

        public PartyTradeInformationBuilder setNonStandardTerms(Boolean var1);

        public PartyTradeInformationBuilder setOffMarketPrice(Boolean var1);

        public PartyTradeInformationBuilder addPricingContext(PricingContext var1);

        public PartyTradeInformationBuilder addPricingContext(PricingContext var1, int var2);

        public PartyTradeInformationBuilder addPricingContext(List<? extends PricingContext> var1);

        public PartyTradeInformationBuilder setPricingContext(List<? extends PricingContext> var1);

        public PartyTradeInformationBuilder setBlockTradeModel(BlockTradeModel var1);

        public PartyTradeInformationBuilder setExecutionType(ExecutionType var1);

        public PartyTradeInformationBuilder setExecutionVenueType(ExecutionVenueType var1);

        public PartyTradeInformationBuilder setVerificationMethod(VerificationMethod var1);

        public PartyTradeInformationBuilder setConfirmationMethod(ConfirmationMethod var1);

        public PartyTradeInformationBuilder setCompressedTrade(Boolean var1);

        public PartyTradeInformationBuilder setTransactionClassificationModel(TransactionClassificationModel var1);

        public PartyTradeInformationBuilder setIsDisputed(Boolean var1);

        public PartyTradeInformationBuilder addUnit(Unit var1);

        public PartyTradeInformationBuilder addUnit(Unit var1, int var2);

        public PartyTradeInformationBuilder addUnit(List<? extends Unit> var1);

        public PartyTradeInformationBuilder setUnit(List<? extends Unit> var1);

        public PartyTradeInformationBuilder addTrader(Trader var1);

        public PartyTradeInformationBuilder addTrader(Trader var1, int var2);

        public PartyTradeInformationBuilder addTrader(List<? extends Trader> var1);

        public PartyTradeInformationBuilder setTrader(List<? extends Trader> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyAndAccountReferencesModel"), processor, PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder.class, this.getPartyAndAccountReferencesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRole"), processor, ReportingRole.ReportingRoleBuilder.class, this.getReportingRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedBusinessUnit"), processor, RelatedBusinessUnit.RelatedBusinessUnitBuilder.class, this.getRelatedBusinessUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedPerson"), processor, RelatedPerson.RelatedPersonBuilder.class, this.getRelatedPerson(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("algorithm"), processor, Algorithm.AlgorithmBuilder.class, this.getAlgorithm(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isAccountingHedge"), Boolean.class, (Object)this.getIsAccountingHedge(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("category"), processor, TradeCategory.TradeCategoryBuilder.class, this.getCategory(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDateTime"), processor, ExecutionDateTime.ExecutionDateTimeBuilder.class, this.getExecutionDateTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("timestamps"), processor, TradeProcessingTimestamps.TradeProcessingTimestampsBuilder.class, this.getTimestamps(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intentToAllocate"), Boolean.class, (Object)this.getIntentToAllocate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationStatus"), processor, AllocationReportingStatus.AllocationReportingStatusBuilder.class, this.getAllocationStatus(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intentToClear"), Boolean.class, (Object)this.getIntentToClear(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingStatus"), processor, ClearingStatusValue.ClearingStatusValueBuilder.class, this.getClearingStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralizationType"), processor, CollateralizationType.CollateralizationTypeBuilder.class, this.getCollateralizationType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolio"), processor, PortfolioName.PortfolioNameBuilder.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolioInitialMargin"), processor, PortfolioName.PortfolioNameBuilder.class, this.getCollateralPortfolioInitialMargin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolioVariationMargin"), processor, PortfolioName.PortfolioNameBuilder.class, this.getCollateralPortfolioVariationMargin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRegime"), processor, ReportingRegime.ReportingRegimeBuilder.class, this.getReportingRegime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("endUserExceptionModel"), processor, EndUserExceptionModel.EndUserExceptionModelBuilder.class, this.getEndUserExceptionModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonStandardTerms"), Boolean.class, (Object)this.getNonStandardTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("offMarketPrice"), Boolean.class, (Object)this.getOffMarketPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingContext"), processor, PricingContext.PricingContextBuilder.class, this.getPricingContext(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("blockTradeModel"), processor, BlockTradeModel.BlockTradeModelBuilder.class, this.getBlockTradeModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionType"), processor, ExecutionType.ExecutionTypeBuilder.class, this.getExecutionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.ExecutionVenueTypeBuilder.class, this.getExecutionVenueType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("verificationMethod"), processor, VerificationMethod.VerificationMethodBuilder.class, this.getVerificationMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("confirmationMethod"), processor, ConfirmationMethod.ConfirmationMethodBuilder.class, this.getConfirmationMethod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compressedTrade"), Boolean.class, (Object)this.getCompressedTrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transactionClassificationModel"), processor, TransactionClassificationModel.TransactionClassificationModelBuilder.class, this.getTransactionClassificationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isDisputed"), Boolean.class, (Object)this.getIsDisputed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, Unit.UnitBuilder.class, this.getUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trader"), processor, Trader.TraderBuilder.class, this.getTrader(), new AttributeMeta[0]);
        }

        public PartyTradeInformationBuilder prune();
    }

    public static class PartyTradeInformationImpl
    implements PartyTradeInformation {
        private final PartyAndAccountReferencesModel partyAndAccountReferencesModel;
        private final List<? extends RelatedParty> relatedParty;
        private final ReportingRole reportingRole;
        private final List<? extends RelatedBusinessUnit> relatedBusinessUnit;
        private final List<? extends RelatedPerson> relatedPerson;
        private final List<? extends Algorithm> algorithm;
        private final Boolean isAccountingHedge;
        private final List<? extends TradeCategory> category;
        private final ExecutionDateTime executionDateTime;
        private final TradeProcessingTimestamps timestamps;
        private final Boolean intentToAllocate;
        private final AllocationReportingStatus allocationStatus;
        private final Boolean intentToClear;
        private final ClearingStatusValue clearingStatus;
        private final CollateralizationType collateralizationType;
        private final PortfolioName collateralPortfolio;
        private final PortfolioName collateralPortfolioInitialMargin;
        private final PortfolioName collateralPortfolioVariationMargin;
        private final List<? extends ReportingRegime> reportingRegime;
        private final EndUserExceptionModel endUserExceptionModel;
        private final Boolean nonStandardTerms;
        private final Boolean offMarketPrice;
        private final List<? extends PricingContext> pricingContext;
        private final BlockTradeModel blockTradeModel;
        private final ExecutionType executionType;
        private final ExecutionVenueType executionVenueType;
        private final VerificationMethod verificationMethod;
        private final ConfirmationMethod confirmationMethod;
        private final Boolean compressedTrade;
        private final TransactionClassificationModel transactionClassificationModel;
        private final Boolean isDisputed;
        private final List<? extends Unit> unit;
        private final List<? extends Trader> trader;

        protected PartyTradeInformationImpl(PartyTradeInformationBuilder builder) {
            this.partyAndAccountReferencesModel = Optional.ofNullable(builder.getPartyAndAccountReferencesModel()).map(f -> f.build()).orElse(null);
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.reportingRole = Optional.ofNullable(builder.getReportingRole()).map(f -> f.build()).orElse(null);
            this.relatedBusinessUnit = Optional.ofNullable(builder.getRelatedBusinessUnit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.relatedPerson = Optional.ofNullable(builder.getRelatedPerson()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.algorithm = Optional.ofNullable(builder.getAlgorithm()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.isAccountingHedge = builder.getIsAccountingHedge();
            this.category = Optional.ofNullable(builder.getCategory()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.executionDateTime = Optional.ofNullable(builder.getExecutionDateTime()).map(f -> f.build()).orElse(null);
            this.timestamps = Optional.ofNullable(builder.getTimestamps()).map(f -> f.build()).orElse(null);
            this.intentToAllocate = builder.getIntentToAllocate();
            this.allocationStatus = Optional.ofNullable(builder.getAllocationStatus()).map(f -> f.build()).orElse(null);
            this.intentToClear = builder.getIntentToClear();
            this.clearingStatus = Optional.ofNullable(builder.getClearingStatus()).map(f -> f.build()).orElse(null);
            this.collateralizationType = Optional.ofNullable(builder.getCollateralizationType()).map(f -> f.build()).orElse(null);
            this.collateralPortfolio = Optional.ofNullable(builder.getCollateralPortfolio()).map(f -> f.build()).orElse(null);
            this.collateralPortfolioInitialMargin = Optional.ofNullable(builder.getCollateralPortfolioInitialMargin()).map(f -> f.build()).orElse(null);
            this.collateralPortfolioVariationMargin = Optional.ofNullable(builder.getCollateralPortfolioVariationMargin()).map(f -> f.build()).orElse(null);
            this.reportingRegime = Optional.ofNullable(builder.getReportingRegime()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.endUserExceptionModel = Optional.ofNullable(builder.getEndUserExceptionModel()).map(f -> f.build()).orElse(null);
            this.nonStandardTerms = builder.getNonStandardTerms();
            this.offMarketPrice = builder.getOffMarketPrice();
            this.pricingContext = Optional.ofNullable(builder.getPricingContext()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.blockTradeModel = Optional.ofNullable(builder.getBlockTradeModel()).map(f -> f.build()).orElse(null);
            this.executionType = Optional.ofNullable(builder.getExecutionType()).map(f -> f.build()).orElse(null);
            this.executionVenueType = Optional.ofNullable(builder.getExecutionVenueType()).map(f -> f.build()).orElse(null);
            this.verificationMethod = Optional.ofNullable(builder.getVerificationMethod()).map(f -> f.build()).orElse(null);
            this.confirmationMethod = Optional.ofNullable(builder.getConfirmationMethod()).map(f -> f.build()).orElse(null);
            this.compressedTrade = builder.getCompressedTrade();
            this.transactionClassificationModel = Optional.ofNullable(builder.getTransactionClassificationModel()).map(f -> f.build()).orElse(null);
            this.isDisputed = builder.getIsDisputed();
            this.unit = Optional.ofNullable(builder.getUnit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.trader = Optional.ofNullable(builder.getTrader()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        @RuneAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        public PartyAndAccountReferencesModel getPartyAndAccountReferencesModel() {
            return this.partyAndAccountReferencesModel;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingRole getReportingRole() {
            return this.reportingRole;
        }

        @Override
        @RosettaAttribute(value="relatedBusinessUnit")
        @RuneAttribute(value="relatedBusinessUnit")
        public List<? extends RelatedBusinessUnit> getRelatedBusinessUnit() {
            return this.relatedBusinessUnit;
        }

        @Override
        @RosettaAttribute(value="relatedPerson")
        @RuneAttribute(value="relatedPerson")
        public List<? extends RelatedPerson> getRelatedPerson() {
            return this.relatedPerson;
        }

        @Override
        @RosettaAttribute(value="algorithm")
        @RuneAttribute(value="algorithm")
        public List<? extends Algorithm> getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @RosettaAttribute(value="isAccountingHedge")
        @RuneAttribute(value="isAccountingHedge")
        public Boolean getIsAccountingHedge() {
            return this.isAccountingHedge;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public List<? extends TradeCategory> getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public ExecutionDateTime getExecutionDateTime() {
            return this.executionDateTime;
        }

        @Override
        @RosettaAttribute(value="timestamps")
        @RuneAttribute(value="timestamps")
        public TradeProcessingTimestamps getTimestamps() {
            return this.timestamps;
        }

        @Override
        @RosettaAttribute(value="intentToAllocate")
        @RuneAttribute(value="intentToAllocate")
        public Boolean getIntentToAllocate() {
            return this.intentToAllocate;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public AllocationReportingStatus getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        @RosettaAttribute(value="intentToClear")
        @RuneAttribute(value="intentToClear")
        public Boolean getIntentToClear() {
            return this.intentToClear;
        }

        @Override
        @RosettaAttribute(value="clearingStatus")
        @RuneAttribute(value="clearingStatus")
        public ClearingStatusValue getClearingStatus() {
            return this.clearingStatus;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public CollateralizationType getCollateralizationType() {
            return this.collateralizationType;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public PortfolioName getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioInitialMargin")
        @RuneAttribute(value="collateralPortfolioInitialMargin")
        public PortfolioName getCollateralPortfolioInitialMargin() {
            return this.collateralPortfolioInitialMargin;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioVariationMargin")
        @RuneAttribute(value="collateralPortfolioVariationMargin")
        public PortfolioName getCollateralPortfolioVariationMargin() {
            return this.collateralPortfolioVariationMargin;
        }

        @Override
        @RosettaAttribute(value="reportingRegime")
        @RuneAttribute(value="reportingRegime")
        public List<? extends ReportingRegime> getReportingRegime() {
            return this.reportingRegime;
        }

        @Override
        @RosettaAttribute(value="endUserExceptionModel")
        @RuneAttribute(value="endUserExceptionModel")
        public EndUserExceptionModel getEndUserExceptionModel() {
            return this.endUserExceptionModel;
        }

        @Override
        @RosettaAttribute(value="nonStandardTerms")
        @RuneAttribute(value="nonStandardTerms")
        public Boolean getNonStandardTerms() {
            return this.nonStandardTerms;
        }

        @Override
        @RosettaAttribute(value="offMarketPrice")
        @RuneAttribute(value="offMarketPrice")
        public Boolean getOffMarketPrice() {
            return this.offMarketPrice;
        }

        @Override
        @RosettaAttribute(value="pricingContext")
        @RuneAttribute(value="pricingContext")
        public List<? extends PricingContext> getPricingContext() {
            return this.pricingContext;
        }

        @Override
        @RosettaAttribute(value="blockTradeModel")
        @RuneAttribute(value="blockTradeModel")
        public BlockTradeModel getBlockTradeModel() {
            return this.blockTradeModel;
        }

        @Override
        @RosettaAttribute(value="executionType")
        @RuneAttribute(value="executionType")
        public ExecutionType getExecutionType() {
            return this.executionType;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        @RosettaAttribute(value="verificationMethod")
        @RuneAttribute(value="verificationMethod")
        public VerificationMethod getVerificationMethod() {
            return this.verificationMethod;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ConfirmationMethod getConfirmationMethod() {
            return this.confirmationMethod;
        }

        @Override
        @RosettaAttribute(value="compressedTrade")
        @RuneAttribute(value="compressedTrade")
        public Boolean getCompressedTrade() {
            return this.compressedTrade;
        }

        @Override
        @RosettaAttribute(value="transactionClassificationModel")
        @RuneAttribute(value="transactionClassificationModel")
        public TransactionClassificationModel getTransactionClassificationModel() {
            return this.transactionClassificationModel;
        }

        @Override
        @RosettaAttribute(value="isDisputed")
        @RuneAttribute(value="isDisputed")
        public Boolean getIsDisputed() {
            return this.isDisputed;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public List<? extends Unit> getUnit() {
            return this.unit;
        }

        @Override
        @RosettaAttribute(value="trader")
        @RuneAttribute(value="trader")
        public List<? extends Trader> getTrader() {
            return this.trader;
        }

        @Override
        public PartyTradeInformation build() {
            return this;
        }

        @Override
        public PartyTradeInformationBuilder toBuilder() {
            PartyTradeInformationBuilder builder = PartyTradeInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyTradeInformationBuilder builder) {
            Optional.ofNullable(this.getPartyAndAccountReferencesModel()).ifPresent(builder::setPartyAndAccountReferencesModel);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
            Optional.ofNullable(this.getReportingRole()).ifPresent(builder::setReportingRole);
            Optional.ofNullable(this.getRelatedBusinessUnit()).ifPresent(builder::setRelatedBusinessUnit);
            Optional.ofNullable(this.getRelatedPerson()).ifPresent(builder::setRelatedPerson);
            Optional.ofNullable(this.getAlgorithm()).ifPresent(builder::setAlgorithm);
            Optional.ofNullable(this.getIsAccountingHedge()).ifPresent(builder::setIsAccountingHedge);
            Optional.ofNullable(this.getCategory()).ifPresent(builder::setCategory);
            Optional.ofNullable(this.getExecutionDateTime()).ifPresent(builder::setExecutionDateTime);
            Optional.ofNullable(this.getTimestamps()).ifPresent(builder::setTimestamps);
            Optional.ofNullable(this.getIntentToAllocate()).ifPresent(builder::setIntentToAllocate);
            Optional.ofNullable(this.getAllocationStatus()).ifPresent(builder::setAllocationStatus);
            Optional.ofNullable(this.getIntentToClear()).ifPresent(builder::setIntentToClear);
            Optional.ofNullable(this.getClearingStatus()).ifPresent(builder::setClearingStatus);
            Optional.ofNullable(this.getCollateralizationType()).ifPresent(builder::setCollateralizationType);
            Optional.ofNullable(this.getCollateralPortfolio()).ifPresent(builder::setCollateralPortfolio);
            Optional.ofNullable(this.getCollateralPortfolioInitialMargin()).ifPresent(builder::setCollateralPortfolioInitialMargin);
            Optional.ofNullable(this.getCollateralPortfolioVariationMargin()).ifPresent(builder::setCollateralPortfolioVariationMargin);
            Optional.ofNullable(this.getReportingRegime()).ifPresent(builder::setReportingRegime);
            Optional.ofNullable(this.getEndUserExceptionModel()).ifPresent(builder::setEndUserExceptionModel);
            Optional.ofNullable(this.getNonStandardTerms()).ifPresent(builder::setNonStandardTerms);
            Optional.ofNullable(this.getOffMarketPrice()).ifPresent(builder::setOffMarketPrice);
            Optional.ofNullable(this.getPricingContext()).ifPresent(builder::setPricingContext);
            Optional.ofNullable(this.getBlockTradeModel()).ifPresent(builder::setBlockTradeModel);
            Optional.ofNullable(this.getExecutionType()).ifPresent(builder::setExecutionType);
            Optional.ofNullable(this.getExecutionVenueType()).ifPresent(builder::setExecutionVenueType);
            Optional.ofNullable(this.getVerificationMethod()).ifPresent(builder::setVerificationMethod);
            Optional.ofNullable(this.getConfirmationMethod()).ifPresent(builder::setConfirmationMethod);
            Optional.ofNullable(this.getCompressedTrade()).ifPresent(builder::setCompressedTrade);
            Optional.ofNullable(this.getTransactionClassificationModel()).ifPresent(builder::setTransactionClassificationModel);
            Optional.ofNullable(this.getIsDisputed()).ifPresent(builder::setIsDisputed);
            Optional.ofNullable(this.getUnit()).ifPresent(builder::setUnit);
            Optional.ofNullable(this.getTrader()).ifPresent(builder::setTrader);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyTradeInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyAndAccountReferencesModel, _that.getPartyAndAccountReferencesModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            if (!Objects.equals(this.reportingRole, _that.getReportingRole())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedBusinessUnit, _that.getRelatedBusinessUnit())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedPerson, _that.getRelatedPerson())) {
                return false;
            }
            if (!ListEquals.listEquals(this.algorithm, _that.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this.isAccountingHedge, _that.getIsAccountingHedge())) {
                return false;
            }
            if (!ListEquals.listEquals(this.category, _that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.executionDateTime, _that.getExecutionDateTime())) {
                return false;
            }
            if (!Objects.equals(this.timestamps, _that.getTimestamps())) {
                return false;
            }
            if (!Objects.equals(this.intentToAllocate, _that.getIntentToAllocate())) {
                return false;
            }
            if (!Objects.equals(this.allocationStatus, _that.getAllocationStatus())) {
                return false;
            }
            if (!Objects.equals(this.intentToClear, _that.getIntentToClear())) {
                return false;
            }
            if (!Objects.equals(this.clearingStatus, _that.getClearingStatus())) {
                return false;
            }
            if (!Objects.equals(this.collateralizationType, _that.getCollateralizationType())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioInitialMargin, _that.getCollateralPortfolioInitialMargin())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioVariationMargin, _that.getCollateralPortfolioVariationMargin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingRegime, _that.getReportingRegime())) {
                return false;
            }
            if (!Objects.equals(this.endUserExceptionModel, _that.getEndUserExceptionModel())) {
                return false;
            }
            if (!Objects.equals(this.nonStandardTerms, _that.getNonStandardTerms())) {
                return false;
            }
            if (!Objects.equals(this.offMarketPrice, _that.getOffMarketPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.pricingContext, _that.getPricingContext())) {
                return false;
            }
            if (!Objects.equals(this.blockTradeModel, _that.getBlockTradeModel())) {
                return false;
            }
            if (!Objects.equals(this.executionType, _that.getExecutionType())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueType, _that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.verificationMethod, _that.getVerificationMethod())) {
                return false;
            }
            if (!Objects.equals(this.confirmationMethod, _that.getConfirmationMethod())) {
                return false;
            }
            if (!Objects.equals(this.compressedTrade, _that.getCompressedTrade())) {
                return false;
            }
            if (!Objects.equals(this.transactionClassificationModel, _that.getTransactionClassificationModel())) {
                return false;
            }
            if (!Objects.equals(this.isDisputed, _that.getIsDisputed())) {
                return false;
            }
            if (!ListEquals.listEquals(this.unit, _that.getUnit())) {
                return false;
            }
            return ListEquals.listEquals(this.trader, _that.getTrader());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyAndAccountReferencesModel != null ? this.partyAndAccountReferencesModel.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.reportingRole != null ? this.reportingRole.hashCode() : 0);
            _result = 31 * _result + (this.relatedBusinessUnit != null ? this.relatedBusinessUnit.hashCode() : 0);
            _result = 31 * _result + (this.relatedPerson != null ? this.relatedPerson.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            _result = 31 * _result + (this.isAccountingHedge != null ? this.isAccountingHedge.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? this.category.hashCode() : 0);
            _result = 31 * _result + (this.executionDateTime != null ? this.executionDateTime.hashCode() : 0);
            _result = 31 * _result + (this.timestamps != null ? this.timestamps.hashCode() : 0);
            _result = 31 * _result + (this.intentToAllocate != null ? this.intentToAllocate.hashCode() : 0);
            _result = 31 * _result + (this.allocationStatus != null ? this.allocationStatus.hashCode() : 0);
            _result = 31 * _result + (this.intentToClear != null ? this.intentToClear.hashCode() : 0);
            _result = 31 * _result + (this.clearingStatus != null ? this.clearingStatus.hashCode() : 0);
            _result = 31 * _result + (this.collateralizationType != null ? this.collateralizationType.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioInitialMargin != null ? this.collateralPortfolioInitialMargin.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioVariationMargin != null ? this.collateralPortfolioVariationMargin.hashCode() : 0);
            _result = 31 * _result + (this.reportingRegime != null ? this.reportingRegime.hashCode() : 0);
            _result = 31 * _result + (this.endUserExceptionModel != null ? this.endUserExceptionModel.hashCode() : 0);
            _result = 31 * _result + (this.nonStandardTerms != null ? this.nonStandardTerms.hashCode() : 0);
            _result = 31 * _result + (this.offMarketPrice != null ? this.offMarketPrice.hashCode() : 0);
            _result = 31 * _result + (this.pricingContext != null ? this.pricingContext.hashCode() : 0);
            _result = 31 * _result + (this.blockTradeModel != null ? this.blockTradeModel.hashCode() : 0);
            _result = 31 * _result + (this.executionType != null ? this.executionType.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            _result = 31 * _result + (this.verificationMethod != null ? this.verificationMethod.hashCode() : 0);
            _result = 31 * _result + (this.confirmationMethod != null ? this.confirmationMethod.hashCode() : 0);
            _result = 31 * _result + (this.compressedTrade != null ? this.compressedTrade.hashCode() : 0);
            _result = 31 * _result + (this.transactionClassificationModel != null ? this.transactionClassificationModel.hashCode() : 0);
            _result = 31 * _result + (this.isDisputed != null ? this.isDisputed.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.trader != null ? this.trader.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyTradeInformation {partyAndAccountReferencesModel=" + String.valueOf(this.partyAndAccountReferencesModel) + ", relatedParty=" + String.valueOf(this.relatedParty) + ", reportingRole=" + String.valueOf(this.reportingRole) + ", relatedBusinessUnit=" + String.valueOf(this.relatedBusinessUnit) + ", relatedPerson=" + String.valueOf(this.relatedPerson) + ", algorithm=" + String.valueOf(this.algorithm) + ", isAccountingHedge=" + this.isAccountingHedge + ", category=" + String.valueOf(this.category) + ", executionDateTime=" + String.valueOf(this.executionDateTime) + ", timestamps=" + String.valueOf(this.timestamps) + ", intentToAllocate=" + this.intentToAllocate + ", allocationStatus=" + String.valueOf(this.allocationStatus) + ", intentToClear=" + this.intentToClear + ", clearingStatus=" + String.valueOf(this.clearingStatus) + ", collateralizationType=" + String.valueOf(this.collateralizationType) + ", collateralPortfolio=" + String.valueOf(this.collateralPortfolio) + ", collateralPortfolioInitialMargin=" + String.valueOf(this.collateralPortfolioInitialMargin) + ", collateralPortfolioVariationMargin=" + String.valueOf(this.collateralPortfolioVariationMargin) + ", reportingRegime=" + String.valueOf(this.reportingRegime) + ", endUserExceptionModel=" + String.valueOf(this.endUserExceptionModel) + ", nonStandardTerms=" + this.nonStandardTerms + ", offMarketPrice=" + this.offMarketPrice + ", pricingContext=" + String.valueOf(this.pricingContext) + ", blockTradeModel=" + String.valueOf(this.blockTradeModel) + ", executionType=" + String.valueOf(this.executionType) + ", executionVenueType=" + String.valueOf(this.executionVenueType) + ", verificationMethod=" + String.valueOf(this.verificationMethod) + ", confirmationMethod=" + String.valueOf(this.confirmationMethod) + ", compressedTrade=" + this.compressedTrade + ", transactionClassificationModel=" + String.valueOf(this.transactionClassificationModel) + ", isDisputed=" + this.isDisputed + ", unit=" + String.valueOf(this.unit) + ", trader=" + String.valueOf(this.trader) + "}";
        }
    }
}

