/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.CreditDocument;
import fpml.consolidated.doc.OrganizationCharacteristic;
import fpml.consolidated.doc.SupervisorRegistration;
import fpml.consolidated.doc.TransactionCharacteristic;
import fpml.consolidated.doc.meta.EndUserExceptionDeclarationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EndUserExceptionDeclaration", builder=EndUserExceptionDeclarationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EndUserExceptionDeclaration", model="fpml", builder=EndUserExceptionDeclarationBuilderImpl.class, version="1.2.2")
public interface EndUserExceptionDeclaration
extends RosettaModelObject {
    public static final EndUserExceptionDeclarationMeta metaData = new EndUserExceptionDeclarationMeta();

    public List<? extends CreditDocument> getCreditDocument();

    public List<? extends OrganizationCharacteristic> getOrganizationCharacteristic();

    public List<? extends TransactionCharacteristic> getTransactionCharacteristic();

    public List<? extends SupervisorRegistration> getSupervisorRegistration();

    public EndUserExceptionDeclaration build();

    public EndUserExceptionDeclarationBuilder toBuilder();

    public static EndUserExceptionDeclarationBuilder builder() {
        return new EndUserExceptionDeclarationBuilderImpl();
    }

    default public RosettaMetaData<? extends EndUserExceptionDeclaration> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EndUserExceptionDeclaration> getType() {
        return EndUserExceptionDeclaration.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("creditDocument"), processor, CreditDocument.class, this.getCreditDocument(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("organizationCharacteristic"), processor, OrganizationCharacteristic.class, this.getOrganizationCharacteristic(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transactionCharacteristic"), processor, TransactionCharacteristic.class, this.getTransactionCharacteristic(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("supervisorRegistration"), processor, SupervisorRegistration.class, this.getSupervisorRegistration(), new AttributeMeta[0]);
    }

    public static class EndUserExceptionDeclarationBuilderImpl
    implements EndUserExceptionDeclarationBuilder {
        protected List<CreditDocument.CreditDocumentBuilder> creditDocument = new ArrayList<CreditDocument.CreditDocumentBuilder>();
        protected List<OrganizationCharacteristic.OrganizationCharacteristicBuilder> organizationCharacteristic = new ArrayList<OrganizationCharacteristic.OrganizationCharacteristicBuilder>();
        protected List<TransactionCharacteristic.TransactionCharacteristicBuilder> transactionCharacteristic = new ArrayList<TransactionCharacteristic.TransactionCharacteristicBuilder>();
        protected List<SupervisorRegistration.SupervisorRegistrationBuilder> supervisorRegistration = new ArrayList<SupervisorRegistration.SupervisorRegistrationBuilder>();

        @Override
        @RosettaAttribute(value="creditDocument")
        @RuneAttribute(value="creditDocument")
        public List<? extends CreditDocument.CreditDocumentBuilder> getCreditDocument() {
            return this.creditDocument;
        }

        @Override
        public CreditDocument.CreditDocumentBuilder getOrCreateCreditDocument(int index) {
            if (this.creditDocument == null) {
                this.creditDocument = new ArrayList<CreditDocument.CreditDocumentBuilder>();
            }
            return (CreditDocument.CreditDocumentBuilder)this.getIndex(this.creditDocument, index, () -> {
                CreditDocument.CreditDocumentBuilder newCreditDocument = CreditDocument.builder();
                return newCreditDocument;
            });
        }

        @Override
        @RosettaAttribute(value="organizationCharacteristic")
        @RuneAttribute(value="organizationCharacteristic")
        public List<? extends OrganizationCharacteristic.OrganizationCharacteristicBuilder> getOrganizationCharacteristic() {
            return this.organizationCharacteristic;
        }

        @Override
        public OrganizationCharacteristic.OrganizationCharacteristicBuilder getOrCreateOrganizationCharacteristic(int index) {
            if (this.organizationCharacteristic == null) {
                this.organizationCharacteristic = new ArrayList<OrganizationCharacteristic.OrganizationCharacteristicBuilder>();
            }
            return (OrganizationCharacteristic.OrganizationCharacteristicBuilder)this.getIndex(this.organizationCharacteristic, index, () -> {
                OrganizationCharacteristic.OrganizationCharacteristicBuilder newOrganizationCharacteristic = OrganizationCharacteristic.builder();
                return newOrganizationCharacteristic;
            });
        }

        @Override
        @RosettaAttribute(value="transactionCharacteristic")
        @RuneAttribute(value="transactionCharacteristic")
        public List<? extends TransactionCharacteristic.TransactionCharacteristicBuilder> getTransactionCharacteristic() {
            return this.transactionCharacteristic;
        }

        @Override
        public TransactionCharacteristic.TransactionCharacteristicBuilder getOrCreateTransactionCharacteristic(int index) {
            if (this.transactionCharacteristic == null) {
                this.transactionCharacteristic = new ArrayList<TransactionCharacteristic.TransactionCharacteristicBuilder>();
            }
            return (TransactionCharacteristic.TransactionCharacteristicBuilder)this.getIndex(this.transactionCharacteristic, index, () -> {
                TransactionCharacteristic.TransactionCharacteristicBuilder newTransactionCharacteristic = TransactionCharacteristic.builder();
                return newTransactionCharacteristic;
            });
        }

        @Override
        @RosettaAttribute(value="supervisorRegistration")
        @RuneAttribute(value="supervisorRegistration")
        public List<? extends SupervisorRegistration.SupervisorRegistrationBuilder> getSupervisorRegistration() {
            return this.supervisorRegistration;
        }

        @Override
        public SupervisorRegistration.SupervisorRegistrationBuilder getOrCreateSupervisorRegistration(int index) {
            if (this.supervisorRegistration == null) {
                this.supervisorRegistration = new ArrayList<SupervisorRegistration.SupervisorRegistrationBuilder>();
            }
            return (SupervisorRegistration.SupervisorRegistrationBuilder)this.getIndex(this.supervisorRegistration, index, () -> {
                SupervisorRegistration.SupervisorRegistrationBuilder newSupervisorRegistration = SupervisorRegistration.builder();
                return newSupervisorRegistration;
            });
        }

        @Override
        @RosettaAttribute(value="creditDocument")
        @RuneAttribute(value="creditDocument")
        public EndUserExceptionDeclarationBuilder addCreditDocument(CreditDocument _creditDocument) {
            if (_creditDocument != null) {
                this.creditDocument.add(_creditDocument.toBuilder());
            }
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addCreditDocument(CreditDocument _creditDocument, int idx) {
            this.getIndex(this.creditDocument, idx, () -> _creditDocument.toBuilder());
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addCreditDocument(List<? extends CreditDocument> creditDocuments) {
            if (creditDocuments != null) {
                for (CreditDocument creditDocument : creditDocuments) {
                    this.creditDocument.add(creditDocument.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditDocument")
        public EndUserExceptionDeclarationBuilder setCreditDocument(List<? extends CreditDocument> creditDocuments) {
            this.creditDocument = creditDocuments == null ? new ArrayList<CreditDocument.CreditDocumentBuilder>() : (List)creditDocuments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="organizationCharacteristic")
        @RuneAttribute(value="organizationCharacteristic")
        public EndUserExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristic _organizationCharacteristic) {
            if (_organizationCharacteristic != null) {
                this.organizationCharacteristic.add(_organizationCharacteristic.toBuilder());
            }
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristic _organizationCharacteristic, int idx) {
            this.getIndex(this.organizationCharacteristic, idx, () -> _organizationCharacteristic.toBuilder());
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addOrganizationCharacteristic(List<? extends OrganizationCharacteristic> organizationCharacteristics) {
            if (organizationCharacteristics != null) {
                for (OrganizationCharacteristic organizationCharacteristic : organizationCharacteristics) {
                    this.organizationCharacteristic.add(organizationCharacteristic.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="organizationCharacteristic")
        public EndUserExceptionDeclarationBuilder setOrganizationCharacteristic(List<? extends OrganizationCharacteristic> organizationCharacteristics) {
            this.organizationCharacteristic = organizationCharacteristics == null ? new ArrayList<OrganizationCharacteristic.OrganizationCharacteristicBuilder>() : (List)organizationCharacteristics.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="transactionCharacteristic")
        @RuneAttribute(value="transactionCharacteristic")
        public EndUserExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristic _transactionCharacteristic) {
            if (_transactionCharacteristic != null) {
                this.transactionCharacteristic.add(_transactionCharacteristic.toBuilder());
            }
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristic _transactionCharacteristic, int idx) {
            this.getIndex(this.transactionCharacteristic, idx, () -> _transactionCharacteristic.toBuilder());
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addTransactionCharacteristic(List<? extends TransactionCharacteristic> transactionCharacteristics) {
            if (transactionCharacteristics != null) {
                for (TransactionCharacteristic transactionCharacteristic : transactionCharacteristics) {
                    this.transactionCharacteristic.add(transactionCharacteristic.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="transactionCharacteristic")
        public EndUserExceptionDeclarationBuilder setTransactionCharacteristic(List<? extends TransactionCharacteristic> transactionCharacteristics) {
            this.transactionCharacteristic = transactionCharacteristics == null ? new ArrayList<TransactionCharacteristic.TransactionCharacteristicBuilder>() : (List)transactionCharacteristics.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="supervisorRegistration")
        @RuneAttribute(value="supervisorRegistration")
        public EndUserExceptionDeclarationBuilder addSupervisorRegistration(SupervisorRegistration _supervisorRegistration) {
            if (_supervisorRegistration != null) {
                this.supervisorRegistration.add(_supervisorRegistration.toBuilder());
            }
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addSupervisorRegistration(SupervisorRegistration _supervisorRegistration, int idx) {
            this.getIndex(this.supervisorRegistration, idx, () -> _supervisorRegistration.toBuilder());
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder addSupervisorRegistration(List<? extends SupervisorRegistration> supervisorRegistrations) {
            if (supervisorRegistrations != null) {
                for (SupervisorRegistration supervisorRegistration : supervisorRegistrations) {
                    this.supervisorRegistration.add(supervisorRegistration.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="supervisorRegistration")
        public EndUserExceptionDeclarationBuilder setSupervisorRegistration(List<? extends SupervisorRegistration> supervisorRegistrations) {
            this.supervisorRegistration = supervisorRegistrations == null ? new ArrayList<SupervisorRegistration.SupervisorRegistrationBuilder>() : (List)supervisorRegistrations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public EndUserExceptionDeclaration build() {
            return new EndUserExceptionDeclarationImpl(this);
        }

        @Override
        public EndUserExceptionDeclarationBuilder toBuilder() {
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder prune() {
            this.creditDocument = this.creditDocument.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.organizationCharacteristic = this.organizationCharacteristic.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.transactionCharacteristic = this.transactionCharacteristic.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.supervisorRegistration = this.supervisorRegistration.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCreditDocument() != null && this.getCreditDocument().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOrganizationCharacteristic() != null && this.getOrganizationCharacteristic().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTransactionCharacteristic() != null && this.getTransactionCharacteristic().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSupervisorRegistration() != null && this.getSupervisorRegistration().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public EndUserExceptionDeclarationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EndUserExceptionDeclarationBuilder o = (EndUserExceptionDeclarationBuilder)other;
            merger.mergeRosetta(this.getCreditDocument(), o.getCreditDocument(), this::getOrCreateCreditDocument);
            merger.mergeRosetta(this.getOrganizationCharacteristic(), o.getOrganizationCharacteristic(), this::getOrCreateOrganizationCharacteristic);
            merger.mergeRosetta(this.getTransactionCharacteristic(), o.getTransactionCharacteristic(), this::getOrCreateTransactionCharacteristic);
            merger.mergeRosetta(this.getSupervisorRegistration(), o.getSupervisorRegistration(), this::getOrCreateSupervisorRegistration);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EndUserExceptionDeclaration _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.creditDocument, _that.getCreditDocument())) {
                return false;
            }
            if (!ListEquals.listEquals(this.organizationCharacteristic, _that.getOrganizationCharacteristic())) {
                return false;
            }
            if (!ListEquals.listEquals(this.transactionCharacteristic, _that.getTransactionCharacteristic())) {
                return false;
            }
            return ListEquals.listEquals(this.supervisorRegistration, _that.getSupervisorRegistration());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditDocument != null ? this.creditDocument.hashCode() : 0);
            _result = 31 * _result + (this.organizationCharacteristic != null ? this.organizationCharacteristic.hashCode() : 0);
            _result = 31 * _result + (this.transactionCharacteristic != null ? this.transactionCharacteristic.hashCode() : 0);
            _result = 31 * _result + (this.supervisorRegistration != null ? this.supervisorRegistration.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EndUserExceptionDeclarationBuilder {creditDocument=" + String.valueOf(this.creditDocument) + ", organizationCharacteristic=" + String.valueOf(this.organizationCharacteristic) + ", transactionCharacteristic=" + String.valueOf(this.transactionCharacteristic) + ", supervisorRegistration=" + String.valueOf(this.supervisorRegistration) + "}";
        }
    }

    public static interface EndUserExceptionDeclarationBuilder
    extends EndUserExceptionDeclaration,
    RosettaModelObjectBuilder {
        public CreditDocument.CreditDocumentBuilder getOrCreateCreditDocument(int var1);

        public List<? extends CreditDocument.CreditDocumentBuilder> getCreditDocument();

        public OrganizationCharacteristic.OrganizationCharacteristicBuilder getOrCreateOrganizationCharacteristic(int var1);

        public List<? extends OrganizationCharacteristic.OrganizationCharacteristicBuilder> getOrganizationCharacteristic();

        public TransactionCharacteristic.TransactionCharacteristicBuilder getOrCreateTransactionCharacteristic(int var1);

        public List<? extends TransactionCharacteristic.TransactionCharacteristicBuilder> getTransactionCharacteristic();

        public SupervisorRegistration.SupervisorRegistrationBuilder getOrCreateSupervisorRegistration(int var1);

        public List<? extends SupervisorRegistration.SupervisorRegistrationBuilder> getSupervisorRegistration();

        public EndUserExceptionDeclarationBuilder addCreditDocument(CreditDocument var1);

        public EndUserExceptionDeclarationBuilder addCreditDocument(CreditDocument var1, int var2);

        public EndUserExceptionDeclarationBuilder addCreditDocument(List<? extends CreditDocument> var1);

        public EndUserExceptionDeclarationBuilder setCreditDocument(List<? extends CreditDocument> var1);

        public EndUserExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristic var1);

        public EndUserExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristic var1, int var2);

        public EndUserExceptionDeclarationBuilder addOrganizationCharacteristic(List<? extends OrganizationCharacteristic> var1);

        public EndUserExceptionDeclarationBuilder setOrganizationCharacteristic(List<? extends OrganizationCharacteristic> var1);

        public EndUserExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristic var1);

        public EndUserExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristic var1, int var2);

        public EndUserExceptionDeclarationBuilder addTransactionCharacteristic(List<? extends TransactionCharacteristic> var1);

        public EndUserExceptionDeclarationBuilder setTransactionCharacteristic(List<? extends TransactionCharacteristic> var1);

        public EndUserExceptionDeclarationBuilder addSupervisorRegistration(SupervisorRegistration var1);

        public EndUserExceptionDeclarationBuilder addSupervisorRegistration(SupervisorRegistration var1, int var2);

        public EndUserExceptionDeclarationBuilder addSupervisorRegistration(List<? extends SupervisorRegistration> var1);

        public EndUserExceptionDeclarationBuilder setSupervisorRegistration(List<? extends SupervisorRegistration> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("creditDocument"), processor, CreditDocument.CreditDocumentBuilder.class, this.getCreditDocument(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("organizationCharacteristic"), processor, OrganizationCharacteristic.OrganizationCharacteristicBuilder.class, this.getOrganizationCharacteristic(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transactionCharacteristic"), processor, TransactionCharacteristic.TransactionCharacteristicBuilder.class, this.getTransactionCharacteristic(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("supervisorRegistration"), processor, SupervisorRegistration.SupervisorRegistrationBuilder.class, this.getSupervisorRegistration(), new AttributeMeta[0]);
        }

        public EndUserExceptionDeclarationBuilder prune();
    }

    public static class EndUserExceptionDeclarationImpl
    implements EndUserExceptionDeclaration {
        private final List<? extends CreditDocument> creditDocument;
        private final List<? extends OrganizationCharacteristic> organizationCharacteristic;
        private final List<? extends TransactionCharacteristic> transactionCharacteristic;
        private final List<? extends SupervisorRegistration> supervisorRegistration;

        protected EndUserExceptionDeclarationImpl(EndUserExceptionDeclarationBuilder builder) {
            this.creditDocument = Optional.ofNullable(builder.getCreditDocument()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.organizationCharacteristic = Optional.ofNullable(builder.getOrganizationCharacteristic()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.transactionCharacteristic = Optional.ofNullable(builder.getTransactionCharacteristic()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.supervisorRegistration = Optional.ofNullable(builder.getSupervisorRegistration()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="creditDocument")
        @RuneAttribute(value="creditDocument")
        public List<? extends CreditDocument> getCreditDocument() {
            return this.creditDocument;
        }

        @Override
        @RosettaAttribute(value="organizationCharacteristic")
        @RuneAttribute(value="organizationCharacteristic")
        public List<? extends OrganizationCharacteristic> getOrganizationCharacteristic() {
            return this.organizationCharacteristic;
        }

        @Override
        @RosettaAttribute(value="transactionCharacteristic")
        @RuneAttribute(value="transactionCharacteristic")
        public List<? extends TransactionCharacteristic> getTransactionCharacteristic() {
            return this.transactionCharacteristic;
        }

        @Override
        @RosettaAttribute(value="supervisorRegistration")
        @RuneAttribute(value="supervisorRegistration")
        public List<? extends SupervisorRegistration> getSupervisorRegistration() {
            return this.supervisorRegistration;
        }

        @Override
        public EndUserExceptionDeclaration build() {
            return this;
        }

        @Override
        public EndUserExceptionDeclarationBuilder toBuilder() {
            EndUserExceptionDeclarationBuilder builder = EndUserExceptionDeclaration.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EndUserExceptionDeclarationBuilder builder) {
            Optional.ofNullable(this.getCreditDocument()).ifPresent(builder::setCreditDocument);
            Optional.ofNullable(this.getOrganizationCharacteristic()).ifPresent(builder::setOrganizationCharacteristic);
            Optional.ofNullable(this.getTransactionCharacteristic()).ifPresent(builder::setTransactionCharacteristic);
            Optional.ofNullable(this.getSupervisorRegistration()).ifPresent(builder::setSupervisorRegistration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EndUserExceptionDeclaration _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.creditDocument, _that.getCreditDocument())) {
                return false;
            }
            if (!ListEquals.listEquals(this.organizationCharacteristic, _that.getOrganizationCharacteristic())) {
                return false;
            }
            if (!ListEquals.listEquals(this.transactionCharacteristic, _that.getTransactionCharacteristic())) {
                return false;
            }
            return ListEquals.listEquals(this.supervisorRegistration, _that.getSupervisorRegistration());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditDocument != null ? this.creditDocument.hashCode() : 0);
            _result = 31 * _result + (this.organizationCharacteristic != null ? this.organizationCharacteristic.hashCode() : 0);
            _result = 31 * _result + (this.transactionCharacteristic != null ? this.transactionCharacteristic.hashCode() : 0);
            _result = 31 * _result + (this.supervisorRegistration != null ? this.supervisorRegistration.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EndUserExceptionDeclaration {creditDocument=" + String.valueOf(this.creditDocument) + ", organizationCharacteristic=" + String.valueOf(this.organizationCharacteristic) + ", transactionCharacteristic=" + String.valueOf(this.transactionCharacteristic) + ", supervisorRegistration=" + String.valueOf(this.supervisorRegistration) + "}";
        }
    }
}

