/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.dividend.swaps;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.AssetReference;
import fpml.consolidated.dividend.swaps.meta.DividendPeriodPaymentMeta;
import fpml.consolidated.eq.shared.DividendPeriod;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.BusinessDayAdjustments;
import fpml.consolidated.shared.IdentifiedDate;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DividendPeriodPayment", builder=DividendPeriodPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="DividendPeriodPayment", model="fpml", builder=DividendPeriodPaymentBuilderImpl.class, version="1.2.2")
public interface DividendPeriodPayment
extends DividendPeriod {
    public static final DividendPeriodPaymentMeta metaData = new DividendPeriodPaymentMeta();

    public BigDecimal getFixedStrike();

    public AdjustableOrRelativeDate getPaymentDate();

    public AdjustableOrRelativeDate getValuationDate();

    @Override
    public DividendPeriodPayment build();

    @Override
    public DividendPeriodPaymentBuilder toBuilder();

    public static DividendPeriodPaymentBuilder builder() {
        return new DividendPeriodPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends DividendPeriodPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DividendPeriodPayment> getType() {
        return DividendPeriodPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("unadjustedStartDate"), processor, IdentifiedDate.class, this.getUnadjustedStartDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unadjustedEndDate"), processor, IdentifiedDate.class, this.getUnadjustedEndDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerReference"), processor, AssetReference.class, this.getUnderlyerReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedStrike"), BigDecimal.class, (Object)this.getFixedStrike(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDate"), processor, AdjustableOrRelativeDate.class, this.getValuationDate(), new AttributeMeta[0]);
    }

    public static class DividendPeriodPaymentBuilderImpl
    extends DividendPeriod.DividendPeriodBuilderImpl
    implements DividendPeriodPaymentBuilder {
        protected BigDecimal fixedStrike;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder paymentDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder valuationDate;

        @Override
        @RosettaAttribute(value="fixedStrike")
        @RuneAttribute(value="fixedStrike")
        public BigDecimal getFixedStrike() {
            return this.fixedStrike;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getValuationDate() {
            return this.valuationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateValuationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.valuationDate != null ? this.valuationDate : (this.valuationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="unadjustedStartDate")
        @RuneAttribute(value="unadjustedStartDate")
        public DividendPeriodPaymentBuilder setUnadjustedStartDate(IdentifiedDate _unadjustedStartDate) {
            this.unadjustedStartDate = _unadjustedStartDate == null ? null : _unadjustedStartDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="unadjustedEndDate")
        @RuneAttribute(value="unadjustedEndDate")
        public DividendPeriodPaymentBuilder setUnadjustedEndDate(IdentifiedDate _unadjustedEndDate) {
            this.unadjustedEndDate = _unadjustedEndDate == null ? null : _unadjustedEndDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public DividendPeriodPaymentBuilder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerReference")
        @RuneAttribute(value="underlyerReference")
        public DividendPeriodPaymentBuilder setUnderlyerReference(AssetReference _underlyerReference) {
            this.underlyerReference = _underlyerReference == null ? null : _underlyerReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DividendPeriodPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedStrike")
        @RuneAttribute(value="fixedStrike")
        public DividendPeriodPaymentBuilder setFixedStrike(BigDecimal _fixedStrike) {
            this.fixedStrike = _fixedStrike == null ? null : _fixedStrike;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public DividendPeriodPaymentBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public DividendPeriodPaymentBuilder setValuationDate(AdjustableOrRelativeDate _valuationDate) {
            this.valuationDate = _valuationDate == null ? null : _valuationDate.toBuilder();
            return this;
        }

        @Override
        public DividendPeriodPayment build() {
            return new DividendPeriodPaymentImpl(this);
        }

        @Override
        public DividendPeriodPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendPeriodPaymentBuilder prune() {
            super.prune();
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.valuationDate != null && !this.valuationDate.prune().hasData()) {
                this.valuationDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFixedStrike() != null) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            return this.getValuationDate() != null && this.getValuationDate().hasData();
        }

        @Override
        public DividendPeriodPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DividendPeriodPaymentBuilder o = (DividendPeriodPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDate(), (RosettaModelObjectBuilder)o.getValuationDate(), this::setValuationDate);
            merger.mergeBasic((Object)this.getFixedStrike(), (Object)o.getFixedStrike(), this::setFixedStrike, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DividendPeriodPayment _that = (DividendPeriodPayment)this.getType().cast(o);
            if (!Objects.equals(this.fixedStrike, _that.getFixedStrike())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            return Objects.equals(this.valuationDate, _that.getValuationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedStrike != null ? this.fixedStrike.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DividendPeriodPaymentBuilder {fixedStrike=" + String.valueOf(this.fixedStrike) + ", paymentDate=" + String.valueOf(this.paymentDate) + ", valuationDate=" + String.valueOf(this.valuationDate) + "} " + super.toString();
        }
    }

    public static interface DividendPeriodPaymentBuilder
    extends DividendPeriodPayment,
    DividendPeriod.DividendPeriodBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateValuationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getValuationDate();

        @Override
        public DividendPeriodPaymentBuilder setUnadjustedStartDate(IdentifiedDate var1);

        @Override
        public DividendPeriodPaymentBuilder setUnadjustedEndDate(IdentifiedDate var1);

        @Override
        public DividendPeriodPaymentBuilder setDateAdjustments(BusinessDayAdjustments var1);

        @Override
        public DividendPeriodPaymentBuilder setUnderlyerReference(AssetReference var1);

        @Override
        public DividendPeriodPaymentBuilder setId(String var1);

        public DividendPeriodPaymentBuilder setFixedStrike(BigDecimal var1);

        public DividendPeriodPaymentBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        public DividendPeriodPaymentBuilder setValuationDate(AdjustableOrRelativeDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("unadjustedStartDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, (RosettaModelObjectBuilder)this.getUnadjustedStartDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unadjustedEndDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, (RosettaModelObjectBuilder)this.getUnadjustedEndDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, (RosettaModelObjectBuilder)this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerReference"), processor, AssetReference.AssetReferenceBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyerReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedStrike"), BigDecimal.class, (Object)this.getFixedStrike(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getValuationDate(), new AttributeMeta[0]);
        }

        @Override
        public DividendPeriodPaymentBuilder prune();
    }

    public static class DividendPeriodPaymentImpl
    extends DividendPeriod.DividendPeriodImpl
    implements DividendPeriodPayment {
        private final BigDecimal fixedStrike;
        private final AdjustableOrRelativeDate paymentDate;
        private final AdjustableOrRelativeDate valuationDate;

        protected DividendPeriodPaymentImpl(DividendPeriodPaymentBuilder builder) {
            super(builder);
            this.fixedStrike = builder.getFixedStrike();
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.valuationDate = Optional.ofNullable(builder.getValuationDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedStrike")
        @RuneAttribute(value="fixedStrike")
        public BigDecimal getFixedStrike() {
            return this.fixedStrike;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrRelativeDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public AdjustableOrRelativeDate getValuationDate() {
            return this.valuationDate;
        }

        @Override
        public DividendPeriodPayment build() {
            return this;
        }

        @Override
        public DividendPeriodPaymentBuilder toBuilder() {
            DividendPeriodPaymentBuilder builder = DividendPeriodPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendPeriodPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFixedStrike()).ifPresent(builder::setFixedStrike);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getValuationDate()).ifPresent(builder::setValuationDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DividendPeriodPayment _that = (DividendPeriodPayment)this.getType().cast(o);
            if (!Objects.equals(this.fixedStrike, _that.getFixedStrike())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            return Objects.equals(this.valuationDate, _that.getValuationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedStrike != null ? this.fixedStrike.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DividendPeriodPayment {fixedStrike=" + String.valueOf(this.fixedStrike) + ", paymentDate=" + String.valueOf(this.paymentDate) + ", valuationDate=" + String.valueOf(this.valuationDate) + "} " + super.toString();
        }
    }
}

