/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.TradeChangeContent;
import fpml.consolidated.confirmation.processes.meta.TradeChangeAdviceRetractedMeta;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.shared.PaymentDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeChangeAdviceRetracted", builder=TradeChangeAdviceRetractedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TradeChangeAdviceRetracted", model="fpml", builder=TradeChangeAdviceRetractedBuilderImpl.class, version="1.2.2")
public interface TradeChangeAdviceRetracted
extends NonCorrectableRequestMessage {
    public static final TradeChangeAdviceRetractedMeta metaData = new TradeChangeAdviceRetractedMeta();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public TradeChangeContent getChange();

    public List<? extends PaymentDetails> getPaymentDetails();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public TradeChangeAdviceRetracted build();

    @Override
    public TradeChangeAdviceRetractedBuilder toBuilder();

    public static TradeChangeAdviceRetractedBuilder builder() {
        return new TradeChangeAdviceRetractedBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeChangeAdviceRetracted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeChangeAdviceRetracted> getType() {
        return TradeChangeAdviceRetracted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("change"), processor, TradeChangeContent.class, this.getChange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDetails"), processor, PaymentDetails.class, this.getPaymentDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class TradeChangeAdviceRetractedBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements TradeChangeAdviceRetractedBuilder {
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected TradeChangeContent.TradeChangeContentBuilder change;
        protected List<PaymentDetails.PaymentDetailsBuilder> paymentDetails = new ArrayList<PaymentDetails.PaymentDetailsBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="change")
        @RuneAttribute(value="change")
        public TradeChangeContent.TradeChangeContentBuilder getChange() {
            return this.change;
        }

        @Override
        public TradeChangeContent.TradeChangeContentBuilder getOrCreateChange() {
            TradeChangeContent.TradeChangeContentBuilder result = this.change != null ? this.change : (this.change = TradeChangeContent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public List<? extends PaymentDetails.PaymentDetailsBuilder> getPaymentDetails() {
            return this.paymentDetails;
        }

        @Override
        public PaymentDetails.PaymentDetailsBuilder getOrCreatePaymentDetails(int index) {
            if (this.paymentDetails == null) {
                this.paymentDetails = new ArrayList<PaymentDetails.PaymentDetailsBuilder>();
            }
            return (PaymentDetails.PaymentDetailsBuilder)this.getIndex(this.paymentDetails, index, () -> {
                PaymentDetails.PaymentDetailsBuilder newPaymentDetails = PaymentDetails.builder();
                return newPaymentDetails;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public TradeChangeAdviceRetractedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public TradeChangeAdviceRetractedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public TradeChangeAdviceRetractedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public TradeChangeAdviceRetractedBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public TradeChangeAdviceRetractedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public TradeChangeAdviceRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public TradeChangeAdviceRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public TradeChangeAdviceRetractedBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeChangeAdviceRetractedBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeChangeAdviceRetractedBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public TradeChangeAdviceRetractedBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="change")
        @RuneAttribute(value="change")
        public TradeChangeAdviceRetractedBuilder setChange(TradeChangeContent _change) {
            this.change = _change == null ? null : _change.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public TradeChangeAdviceRetractedBuilder addPaymentDetails(PaymentDetails _paymentDetails) {
            if (_paymentDetails != null) {
                this.paymentDetails.add(_paymentDetails.toBuilder());
            }
            return this;
        }

        @Override
        public TradeChangeAdviceRetractedBuilder addPaymentDetails(PaymentDetails _paymentDetails, int idx) {
            this.getIndex(this.paymentDetails, idx, () -> _paymentDetails.toBuilder());
            return this;
        }

        @Override
        public TradeChangeAdviceRetractedBuilder addPaymentDetails(List<? extends PaymentDetails> paymentDetailss) {
            if (paymentDetailss != null) {
                for (PaymentDetails paymentDetails : paymentDetailss) {
                    this.paymentDetails.add(paymentDetails.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentDetails")
        public TradeChangeAdviceRetractedBuilder setPaymentDetails(List<? extends PaymentDetails> paymentDetailss) {
            this.paymentDetails = paymentDetailss == null ? new ArrayList<PaymentDetails.PaymentDetailsBuilder>() : (List)paymentDetailss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public TradeChangeAdviceRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public TradeChangeAdviceRetracted build() {
            return new TradeChangeAdviceRetractedImpl(this);
        }

        @Override
        public TradeChangeAdviceRetractedBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeChangeAdviceRetractedBuilder prune() {
            super.prune();
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.change != null && !this.change.prune().hasData()) {
                this.change = null;
            }
            this.paymentDetails = this.paymentDetails.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getChange() != null && this.getChange().hasData()) {
                return true;
            }
            if (this.getPaymentDetails() != null && this.getPaymentDetails().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public TradeChangeAdviceRetractedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TradeChangeAdviceRetractedBuilder o = (TradeChangeAdviceRetractedBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getChange(), (RosettaModelObjectBuilder)o.getChange(), this::setChange);
            merger.mergeRosetta(this.getPaymentDetails(), o.getPaymentDetails(), this::getOrCreatePaymentDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeChangeAdviceRetracted _that = (TradeChangeAdviceRetracted)this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.change, _that.getChange())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentDetails, _that.getPaymentDetails())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetails != null ? this.paymentDetails.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeChangeAdviceRetractedBuilder {tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", change=" + String.valueOf(this.change) + ", paymentDetails=" + String.valueOf(this.paymentDetails) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface TradeChangeAdviceRetractedBuilder
    extends TradeChangeAdviceRetracted,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public TradeChangeContent.TradeChangeContentBuilder getOrCreateChange();

        @Override
        public TradeChangeContent.TradeChangeContentBuilder getChange();

        public PaymentDetails.PaymentDetailsBuilder getOrCreatePaymentDetails(int var1);

        public List<? extends PaymentDetails.PaymentDetailsBuilder> getPaymentDetails();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public TradeChangeAdviceRetractedBuilder setFpmlVersion(String var1);

        @Override
        public TradeChangeAdviceRetractedBuilder setExpectedBuild(Integer var1);

        @Override
        public TradeChangeAdviceRetractedBuilder setActualBuild(Integer var1);

        @Override
        public TradeChangeAdviceRetractedBuilder setHeader(RequestMessageHeader var1);

        @Override
        public TradeChangeAdviceRetractedBuilder setValidationModel(ValidationModel var1);

        @Override
        public TradeChangeAdviceRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public TradeChangeAdviceRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public TradeChangeAdviceRetractedBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public TradeChangeAdviceRetractedBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public TradeChangeAdviceRetractedBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeChangeAdviceRetractedBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeChangeAdviceRetractedBuilder setChange(TradeChangeContent var1);

        public TradeChangeAdviceRetractedBuilder addPaymentDetails(PaymentDetails var1);

        public TradeChangeAdviceRetractedBuilder addPaymentDetails(PaymentDetails var1, int var2);

        public TradeChangeAdviceRetractedBuilder addPaymentDetails(List<? extends PaymentDetails> var1);

        public TradeChangeAdviceRetractedBuilder setPaymentDetails(List<? extends PaymentDetails> var1);

        public TradeChangeAdviceRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("change"), processor, TradeChangeContent.TradeChangeContentBuilder.class, this.getChange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDetails"), processor, PaymentDetails.PaymentDetailsBuilder.class, this.getPaymentDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public TradeChangeAdviceRetractedBuilder prune();
    }

    public static class TradeChangeAdviceRetractedImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements TradeChangeAdviceRetracted {
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final TradeChangeContent change;
        private final List<? extends PaymentDetails> paymentDetails;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected TradeChangeAdviceRetractedImpl(TradeChangeAdviceRetractedBuilder builder) {
            super(builder);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.change = Optional.ofNullable(builder.getChange()).map(f -> f.build()).orElse(null);
            this.paymentDetails = Optional.ofNullable(builder.getPaymentDetails()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="change")
        @RuneAttribute(value="change")
        public TradeChangeContent getChange() {
            return this.change;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public List<? extends PaymentDetails> getPaymentDetails() {
            return this.paymentDetails;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public TradeChangeAdviceRetracted build() {
            return this;
        }

        @Override
        public TradeChangeAdviceRetractedBuilder toBuilder() {
            TradeChangeAdviceRetractedBuilder builder = TradeChangeAdviceRetracted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeChangeAdviceRetractedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getChange()).ifPresent(builder::setChange);
            Optional.ofNullable(this.getPaymentDetails()).ifPresent(builder::setPaymentDetails);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeChangeAdviceRetracted _that = (TradeChangeAdviceRetracted)this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.change, _that.getChange())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentDetails, _that.getPaymentDetails())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.change != null ? this.change.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetails != null ? this.paymentDetails.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeChangeAdviceRetracted {tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", change=" + String.valueOf(this.change) + ", paymentDetails=" + String.valueOf(this.paymentDetails) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

