/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.OptionExercise;
import fpml.consolidated.business.events.TradingEventsModel;
import fpml.consolidated.confirmation.processes.meta.ExecutionRetractedMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExecutionRetracted", builder=ExecutionRetractedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ExecutionRetracted", model="fpml", builder=ExecutionRetractedBuilderImpl.class, version="1.2.2")
public interface ExecutionRetracted
extends NonCorrectableRequestMessage {
    public static final ExecutionRetractedMeta metaData = new ExecutionRetractedMeta();

    public TradingEventsModel getTradingEventsModel();

    public OptionExercise getOptionExercise();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ExecutionRetracted build();

    @Override
    public ExecutionRetractedBuilder toBuilder();

    public static ExecutionRetractedBuilder builder() {
        return new ExecutionRetractedBuilderImpl();
    }

    default public RosettaMetaData<? extends ExecutionRetracted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExecutionRetracted> getType() {
        return ExecutionRetracted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.class, this.getTradingEventsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.class, this.getOptionExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ExecutionRetractedBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements ExecutionRetractedBuilder {
        protected TradingEventsModel.TradingEventsModelBuilder tradingEventsModel;
        protected OptionExercise.OptionExerciseBuilder optionExercise;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel() {
            TradingEventsModel.TradingEventsModelBuilder result = this.tradingEventsModel != null ? this.tradingEventsModel : (this.tradingEventsModel = TradingEventsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise.OptionExerciseBuilder getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise() {
            OptionExercise.OptionExerciseBuilder result = this.optionExercise != null ? this.optionExercise : (this.optionExercise = OptionExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ExecutionRetractedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ExecutionRetractedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ExecutionRetractedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ExecutionRetractedBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ExecutionRetractedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public ExecutionRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ExecutionRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public ExecutionRetractedBuilder setTradingEventsModel(TradingEventsModel _tradingEventsModel) {
            this.tradingEventsModel = _tradingEventsModel == null ? null : _tradingEventsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public ExecutionRetractedBuilder setOptionExercise(OptionExercise _optionExercise) {
            this.optionExercise = _optionExercise == null ? null : _optionExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ExecutionRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ExecutionRetracted build() {
            return new ExecutionRetractedImpl(this);
        }

        @Override
        public ExecutionRetractedBuilder toBuilder() {
            return this;
        }

        @Override
        public ExecutionRetractedBuilder prune() {
            super.prune();
            if (this.tradingEventsModel != null && !this.tradingEventsModel.prune().hasData()) {
                this.tradingEventsModel = null;
            }
            if (this.optionExercise != null && !this.optionExercise.prune().hasData()) {
                this.optionExercise = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingEventsModel() != null && this.getTradingEventsModel().hasData()) {
                return true;
            }
            if (this.getOptionExercise() != null && this.getOptionExercise().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ExecutionRetractedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExecutionRetractedBuilder o = (ExecutionRetractedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsModel(), (RosettaModelObjectBuilder)o.getTradingEventsModel(), this::setTradingEventsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionExercise(), (RosettaModelObjectBuilder)o.getOptionExercise(), this::setOptionExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExecutionRetracted _that = (ExecutionRetracted)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExecutionRetractedBuilder {tradingEventsModel=" + String.valueOf(this.tradingEventsModel) + ", optionExercise=" + String.valueOf(this.optionExercise) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface ExecutionRetractedBuilder
    extends ExecutionRetracted,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel();

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel();

        public OptionExercise.OptionExerciseBuilder getOrCreateOptionExercise();

        @Override
        public OptionExercise.OptionExerciseBuilder getOptionExercise();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ExecutionRetractedBuilder setFpmlVersion(String var1);

        @Override
        public ExecutionRetractedBuilder setExpectedBuild(Integer var1);

        @Override
        public ExecutionRetractedBuilder setActualBuild(Integer var1);

        @Override
        public ExecutionRetractedBuilder setHeader(RequestMessageHeader var1);

        @Override
        public ExecutionRetractedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ExecutionRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public ExecutionRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ExecutionRetractedBuilder setTradingEventsModel(TradingEventsModel var1);

        public ExecutionRetractedBuilder setOptionExercise(OptionExercise var1);

        public ExecutionRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.TradingEventsModelBuilder.class, this.getTradingEventsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionExercise"), processor, OptionExercise.OptionExerciseBuilder.class, this.getOptionExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ExecutionRetractedBuilder prune();
    }

    public static class ExecutionRetractedImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements ExecutionRetracted {
        private final TradingEventsModel tradingEventsModel;
        private final OptionExercise optionExercise;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ExecutionRetractedImpl(ExecutionRetractedBuilder builder) {
            super(builder);
            this.tradingEventsModel = Optional.ofNullable(builder.getTradingEventsModel()).map(f -> f.build()).orElse(null);
            this.optionExercise = Optional.ofNullable(builder.getOptionExercise()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        @RosettaAttribute(value="optionExercise")
        @RuneAttribute(value="optionExercise")
        public OptionExercise getOptionExercise() {
            return this.optionExercise;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ExecutionRetracted build() {
            return this;
        }

        @Override
        public ExecutionRetractedBuilder toBuilder() {
            ExecutionRetractedBuilder builder = ExecutionRetracted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExecutionRetractedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingEventsModel()).ifPresent(builder::setTradingEventsModel);
            Optional.ofNullable(this.getOptionExercise()).ifPresent(builder::setOptionExercise);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExecutionRetracted _that = (ExecutionRetracted)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.optionExercise, _that.getOptionExercise())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.optionExercise != null ? this.optionExercise.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExecutionRetracted {tradingEventsModel=" + String.valueOf(this.tradingEventsModel) + ", optionExercise=" + String.valueOf(this.optionExercise) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

