/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AdditionalEvent;
import fpml.consolidated.business.events.EventValuationModel;
import fpml.consolidated.business.events.OptionsEventsBaseModel;
import fpml.consolidated.business.events.TradeAmendmentContent;
import fpml.consolidated.business.events.TradingEventsBaseModel;
import fpml.consolidated.confirmation.processes.meta.ExecutionNotificationMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.reg.fpmlreporting.shared.RegulatoryReportingCollateralization;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExecutionNotification", builder=ExecutionNotificationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ExecutionNotification", model="fpml", builder=ExecutionNotificationBuilderImpl.class, version="1.2.2")
public interface ExecutionNotification
extends CorrectableRequestMessage {
    public static final ExecutionNotificationMeta metaData = new ExecutionNotificationMeta();

    public TradingEventsBaseModel getTradingEventsBaseModel();

    public TradeAmendmentContent getAmendment();

    public OptionsEventsBaseModel getOptionsEventsBaseModel();

    public AdditionalEvent getAdditionalEvent();

    public EventValuationModel getEventValuationModel();

    public List<? extends RegulatoryReportingCollateralization> getCollateralization();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ExecutionNotification build();

    @Override
    public ExecutionNotificationBuilder toBuilder();

    public static ExecutionNotificationBuilder builder() {
        return new ExecutionNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends ExecutionNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExecutionNotification> getType() {
        return ExecutionNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsBaseModel"), processor, TradingEventsBaseModel.class, this.getTradingEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amendment"), processor, TradeAmendmentContent.class, this.getAmendment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.class, this.getAdditionalEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.class, this.getEventValuationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.class, this.getCollateralization(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ExecutionNotificationBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements ExecutionNotificationBuilder {
        protected TradingEventsBaseModel.TradingEventsBaseModelBuilder tradingEventsBaseModel;
        protected TradeAmendmentContent.TradeAmendmentContentBuilder amendment;
        protected OptionsEventsBaseModel.OptionsEventsBaseModelBuilder optionsEventsBaseModel;
        protected AdditionalEvent.AdditionalEventBuilder additionalEvent;
        protected EventValuationModel.EventValuationModelBuilder eventValuationModel;
        protected List<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getTradingEventsBaseModel() {
            return this.tradingEventsBaseModel;
        }

        @Override
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getOrCreateTradingEventsBaseModel() {
            TradingEventsBaseModel.TradingEventsBaseModelBuilder result = this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel : (this.tradingEventsBaseModel = TradingEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amendment")
        @RuneAttribute(value="amendment")
        public TradeAmendmentContent.TradeAmendmentContentBuilder getAmendment() {
            return this.amendment;
        }

        @Override
        public TradeAmendmentContent.TradeAmendmentContentBuilder getOrCreateAmendment() {
            TradeAmendmentContent.TradeAmendmentContentBuilder result = this.amendment != null ? this.amendment : (this.amendment = TradeAmendmentContent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel() {
            OptionsEventsBaseModel.OptionsEventsBaseModelBuilder result = this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel : (this.optionsEventsBaseModel = OptionsEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent() {
            AdditionalEvent.AdditionalEventBuilder result = this.additionalEvent != null ? this.additionalEvent : (this.additionalEvent = AdditionalEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel() {
            EventValuationModel.EventValuationModelBuilder result = this.eventValuationModel != null ? this.eventValuationModel : (this.eventValuationModel = EventValuationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization() {
            return this.collateralization;
        }

        @Override
        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int index) {
            if (this.collateralization == null) {
                this.collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
            }
            return (RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder)this.getIndex(this.collateralization, index, () -> {
                RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder newCollateralization = RegulatoryReportingCollateralization.builder();
                return newCollateralization;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ExecutionNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ExecutionNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ExecutionNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ExecutionNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ExecutionNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public ExecutionNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public ExecutionNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ExecutionNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public ExecutionNotificationBuilder setTradingEventsBaseModel(TradingEventsBaseModel _tradingEventsBaseModel) {
            this.tradingEventsBaseModel = _tradingEventsBaseModel == null ? null : _tradingEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amendment")
        @RuneAttribute(value="amendment")
        public ExecutionNotificationBuilder setAmendment(TradeAmendmentContent _amendment) {
            this.amendment = _amendment == null ? null : _amendment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public ExecutionNotificationBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel _optionsEventsBaseModel) {
            this.optionsEventsBaseModel = _optionsEventsBaseModel == null ? null : _optionsEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public ExecutionNotificationBuilder setAdditionalEvent(AdditionalEvent _additionalEvent) {
            this.additionalEvent = _additionalEvent == null ? null : _additionalEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public ExecutionNotificationBuilder setEventValuationModel(EventValuationModel _eventValuationModel) {
            this.eventValuationModel = _eventValuationModel == null ? null : _eventValuationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public ExecutionNotificationBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization) {
            if (_collateralization != null) {
                this.collateralization.add(_collateralization.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionNotificationBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization, int idx) {
            this.getIndex(this.collateralization, idx, () -> _collateralization.toBuilder());
            return this;
        }

        @Override
        public ExecutionNotificationBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            if (collateralizations != null) {
                for (RegulatoryReportingCollateralization regulatoryReportingCollateralization : collateralizations) {
                    this.collateralization.add(regulatoryReportingCollateralization.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralization")
        public ExecutionNotificationBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            this.collateralization = collateralizations == null ? new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>() : (List)collateralizations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public ExecutionNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ExecutionNotification build() {
            return new ExecutionNotificationImpl(this);
        }

        @Override
        public ExecutionNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public ExecutionNotificationBuilder prune() {
            super.prune();
            if (this.tradingEventsBaseModel != null && !this.tradingEventsBaseModel.prune().hasData()) {
                this.tradingEventsBaseModel = null;
            }
            if (this.amendment != null && !this.amendment.prune().hasData()) {
                this.amendment = null;
            }
            if (this.optionsEventsBaseModel != null && !this.optionsEventsBaseModel.prune().hasData()) {
                this.optionsEventsBaseModel = null;
            }
            if (this.additionalEvent != null && !this.additionalEvent.prune().hasData()) {
                this.additionalEvent = null;
            }
            if (this.eventValuationModel != null && !this.eventValuationModel.prune().hasData()) {
                this.eventValuationModel = null;
            }
            this.collateralization = this.collateralization.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingEventsBaseModel() != null && this.getTradingEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getAmendment() != null && this.getAmendment().hasData()) {
                return true;
            }
            if (this.getOptionsEventsBaseModel() != null && this.getOptionsEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getAdditionalEvent() != null && this.getAdditionalEvent().hasData()) {
                return true;
            }
            if (this.getEventValuationModel() != null && this.getEventValuationModel().hasData()) {
                return true;
            }
            if (this.getCollateralization() != null && this.getCollateralization().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ExecutionNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExecutionNotificationBuilder o = (ExecutionNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsBaseModel(), (RosettaModelObjectBuilder)o.getTradingEventsBaseModel(), this::setTradingEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmendment(), (RosettaModelObjectBuilder)o.getAmendment(), this::setAmendment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionsEventsBaseModel(), (RosettaModelObjectBuilder)o.getOptionsEventsBaseModel(), this::setOptionsEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalEvent(), (RosettaModelObjectBuilder)o.getAdditionalEvent(), this::setAdditionalEvent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventValuationModel(), (RosettaModelObjectBuilder)o.getEventValuationModel(), this::setEventValuationModel);
            merger.mergeRosetta(this.getCollateralization(), o.getCollateralization(), this::getOrCreateCollateralization);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExecutionNotification _that = (ExecutionNotification)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsBaseModel, _that.getTradingEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.amendment, _that.getAmendment())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.amendment != null ? this.amendment.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExecutionNotificationBuilder {tradingEventsBaseModel=" + String.valueOf(this.tradingEventsBaseModel) + ", amendment=" + String.valueOf(this.amendment) + ", optionsEventsBaseModel=" + String.valueOf(this.optionsEventsBaseModel) + ", additionalEvent=" + String.valueOf(this.additionalEvent) + ", eventValuationModel=" + String.valueOf(this.eventValuationModel) + ", collateralization=" + String.valueOf(this.collateralization) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface ExecutionNotificationBuilder
    extends ExecutionNotification,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getOrCreateTradingEventsBaseModel();

        @Override
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getTradingEventsBaseModel();

        public TradeAmendmentContent.TradeAmendmentContentBuilder getOrCreateAmendment();

        @Override
        public TradeAmendmentContent.TradeAmendmentContentBuilder getAmendment();

        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel();

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel();

        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent();

        @Override
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent();

        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel();

        @Override
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel();

        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int var1);

        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ExecutionNotificationBuilder setFpmlVersion(String var1);

        @Override
        public ExecutionNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public ExecutionNotificationBuilder setActualBuild(Integer var1);

        @Override
        public ExecutionNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public ExecutionNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public ExecutionNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public ExecutionNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public ExecutionNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ExecutionNotificationBuilder setTradingEventsBaseModel(TradingEventsBaseModel var1);

        public ExecutionNotificationBuilder setAmendment(TradeAmendmentContent var1);

        public ExecutionNotificationBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel var1);

        public ExecutionNotificationBuilder setAdditionalEvent(AdditionalEvent var1);

        public ExecutionNotificationBuilder setEventValuationModel(EventValuationModel var1);

        public ExecutionNotificationBuilder addCollateralization(RegulatoryReportingCollateralization var1);

        public ExecutionNotificationBuilder addCollateralization(RegulatoryReportingCollateralization var1, int var2);

        public ExecutionNotificationBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public ExecutionNotificationBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public ExecutionNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsBaseModel"), processor, TradingEventsBaseModel.TradingEventsBaseModelBuilder.class, this.getTradingEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amendment"), processor, TradeAmendmentContent.TradeAmendmentContentBuilder.class, this.getAmendment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.OptionsEventsBaseModelBuilder.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.AdditionalEventBuilder.class, this.getAdditionalEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.EventValuationModelBuilder.class, this.getEventValuationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder.class, this.getCollateralization(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ExecutionNotificationBuilder prune();
    }

    public static class ExecutionNotificationImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements ExecutionNotification {
        private final TradingEventsBaseModel tradingEventsBaseModel;
        private final TradeAmendmentContent amendment;
        private final OptionsEventsBaseModel optionsEventsBaseModel;
        private final AdditionalEvent additionalEvent;
        private final EventValuationModel eventValuationModel;
        private final List<? extends RegulatoryReportingCollateralization> collateralization;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ExecutionNotificationImpl(ExecutionNotificationBuilder builder) {
            super(builder);
            this.tradingEventsBaseModel = Optional.ofNullable(builder.getTradingEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.amendment = Optional.ofNullable(builder.getAmendment()).map(f -> f.build()).orElse(null);
            this.optionsEventsBaseModel = Optional.ofNullable(builder.getOptionsEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.additionalEvent = Optional.ofNullable(builder.getAdditionalEvent()).map(f -> f.build()).orElse(null);
            this.eventValuationModel = Optional.ofNullable(builder.getEventValuationModel()).map(f -> f.build()).orElse(null);
            this.collateralization = Optional.ofNullable(builder.getCollateralization()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public TradingEventsBaseModel getTradingEventsBaseModel() {
            return this.tradingEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="amendment")
        @RuneAttribute(value="amendment")
        public TradeAmendmentContent getAmendment() {
            return this.amendment;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization> getCollateralization() {
            return this.collateralization;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ExecutionNotification build() {
            return this;
        }

        @Override
        public ExecutionNotificationBuilder toBuilder() {
            ExecutionNotificationBuilder builder = ExecutionNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExecutionNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingEventsBaseModel()).ifPresent(builder::setTradingEventsBaseModel);
            Optional.ofNullable(this.getAmendment()).ifPresent(builder::setAmendment);
            Optional.ofNullable(this.getOptionsEventsBaseModel()).ifPresent(builder::setOptionsEventsBaseModel);
            Optional.ofNullable(this.getAdditionalEvent()).ifPresent(builder::setAdditionalEvent);
            Optional.ofNullable(this.getEventValuationModel()).ifPresent(builder::setEventValuationModel);
            Optional.ofNullable(this.getCollateralization()).ifPresent(builder::setCollateralization);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExecutionNotification _that = (ExecutionNotification)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsBaseModel, _that.getTradingEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.amendment, _that.getAmendment())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.amendment != null ? this.amendment.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExecutionNotification {tradingEventsBaseModel=" + String.valueOf(this.tradingEventsBaseModel) + ", amendment=" + String.valueOf(this.amendment) + ", optionsEventsBaseModel=" + String.valueOf(this.optionsEventsBaseModel) + ", additionalEvent=" + String.valueOf(this.additionalEvent) + ", eventValuationModel=" + String.valueOf(this.eventValuationModel) + ", collateralization=" + String.valueOf(this.collateralization) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

