/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.EventValuationModel;
import fpml.consolidated.business.events.TradingEventsModel;
import fpml.consolidated.confirmation.processes.meta.ClearingRefusedMeta;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.NotificationMessage;
import fpml.consolidated.msg.NotificationMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ClearingRefused", builder=ClearingRefusedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ClearingRefused", model="fpml", builder=ClearingRefusedBuilderImpl.class, version="1.2.2")
public interface ClearingRefused
extends NotificationMessage {
    public static final ClearingRefusedMeta metaData = new ClearingRefusedMeta();

    public TradingEventsModel getTradingEventsModel();

    public EventValuationModel getEventValuationModel();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    public List<? extends Reason> getReason();

    @Override
    public ClearingRefused build();

    @Override
    public ClearingRefusedBuilder toBuilder();

    public static ClearingRefusedBuilder builder() {
        return new ClearingRefusedBuilderImpl();
    }

    default public RosettaMetaData<? extends ClearingRefused> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ClearingRefused> getType() {
        return ClearingRefused.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.class, this.getTradingEventsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.class, this.getEventValuationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class ClearingRefusedBuilderImpl
    extends NotificationMessage.NotificationMessageBuilderImpl
    implements ClearingRefusedBuilder {
        protected TradingEventsModel.TradingEventsModelBuilder tradingEventsModel;
        protected EventValuationModel.EventValuationModelBuilder eventValuationModel;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel() {
            TradingEventsModel.TradingEventsModelBuilder result = this.tradingEventsModel != null ? this.tradingEventsModel : (this.tradingEventsModel = TradingEventsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel() {
            EventValuationModel.EventValuationModelBuilder result = this.eventValuationModel != null ? this.eventValuationModel : (this.eventValuationModel = EventValuationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ClearingRefusedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ClearingRefusedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ClearingRefusedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ClearingRefusedBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ClearingRefusedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel")
        @RuneAttribute(value="correlationAndOptionalSequenceModel")
        public ClearingRefusedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ClearingRefusedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public ClearingRefusedBuilder setTradingEventsModel(TradingEventsModel _tradingEventsModel) {
            this.tradingEventsModel = _tradingEventsModel == null ? null : _tradingEventsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public ClearingRefusedBuilder setEventValuationModel(EventValuationModel _eventValuationModel) {
            this.eventValuationModel = _eventValuationModel == null ? null : _eventValuationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ClearingRefusedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public ClearingRefusedBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public ClearingRefusedBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public ClearingRefusedBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public ClearingRefusedBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ClearingRefused build() {
            return new ClearingRefusedImpl(this);
        }

        @Override
        public ClearingRefusedBuilder toBuilder() {
            return this;
        }

        @Override
        public ClearingRefusedBuilder prune() {
            super.prune();
            if (this.tradingEventsModel != null && !this.tradingEventsModel.prune().hasData()) {
                this.tradingEventsModel = null;
            }
            if (this.eventValuationModel != null && !this.eventValuationModel.prune().hasData()) {
                this.eventValuationModel = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingEventsModel() != null && this.getTradingEventsModel().hasData()) {
                return true;
            }
            if (this.getEventValuationModel() != null && this.getEventValuationModel().hasData()) {
                return true;
            }
            if (this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData()) {
                return true;
            }
            return this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ClearingRefusedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ClearingRefusedBuilder o = (ClearingRefusedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsModel(), (RosettaModelObjectBuilder)o.getTradingEventsModel(), this::setTradingEventsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventValuationModel(), (RosettaModelObjectBuilder)o.getEventValuationModel(), this::setEventValuationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClearingRefused _that = (ClearingRefused)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClearingRefusedBuilder {tradingEventsModel=" + String.valueOf(this.tradingEventsModel) + ", eventValuationModel=" + String.valueOf(this.eventValuationModel) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + ", reason=" + String.valueOf(this.reason) + "} " + super.toString();
        }
    }

    public static interface ClearingRefusedBuilder
    extends ClearingRefused,
    NotificationMessage.NotificationMessageBuilder {
        public TradingEventsModel.TradingEventsModelBuilder getOrCreateTradingEventsModel();

        @Override
        public TradingEventsModel.TradingEventsModelBuilder getTradingEventsModel();

        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel();

        @Override
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        @Override
        public ClearingRefusedBuilder setFpmlVersion(String var1);

        @Override
        public ClearingRefusedBuilder setExpectedBuild(Integer var1);

        @Override
        public ClearingRefusedBuilder setActualBuild(Integer var1);

        @Override
        public ClearingRefusedBuilder setHeader(NotificationMessageHeader var1);

        @Override
        public ClearingRefusedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ClearingRefusedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ClearingRefusedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ClearingRefusedBuilder setTradingEventsModel(TradingEventsModel var1);

        public ClearingRefusedBuilder setEventValuationModel(EventValuationModel var1);

        public ClearingRefusedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        public ClearingRefusedBuilder addReason(Reason var1);

        public ClearingRefusedBuilder addReason(Reason var1, int var2);

        public ClearingRefusedBuilder addReason(List<? extends Reason> var1);

        public ClearingRefusedBuilder setReason(List<? extends Reason> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsModel"), processor, TradingEventsModel.TradingEventsModelBuilder.class, this.getTradingEventsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.EventValuationModelBuilder.class, this.getEventValuationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        @Override
        public ClearingRefusedBuilder prune();
    }

    public static class ClearingRefusedImpl
    extends NotificationMessage.NotificationMessageImpl
    implements ClearingRefused {
        private final TradingEventsModel tradingEventsModel;
        private final EventValuationModel eventValuationModel;
        private final PartiesAndAccountsModel partiesAndAccountsModel;
        private final List<? extends Reason> reason;

        protected ClearingRefusedImpl(ClearingRefusedBuilder builder) {
            super(builder);
            this.tradingEventsModel = Optional.ofNullable(builder.getTradingEventsModel()).map(f -> f.build()).orElse(null);
            this.eventValuationModel = Optional.ofNullable(builder.getEventValuationModel()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingEventsModel")
        @RuneAttribute(value="tradingEventsModel")
        public TradingEventsModel getTradingEventsModel() {
            return this.tradingEventsModel;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        public ClearingRefused build() {
            return this;
        }

        @Override
        public ClearingRefusedBuilder toBuilder() {
            ClearingRefusedBuilder builder = ClearingRefused.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClearingRefusedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingEventsModel()).ifPresent(builder::setTradingEventsModel);
            Optional.ofNullable(this.getEventValuationModel()).ifPresent(builder::setEventValuationModel);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClearingRefused _that = (ClearingRefused)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsModel, _that.getTradingEventsModel())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsModel != null ? this.tradingEventsModel.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClearingRefused {tradingEventsModel=" + String.valueOf(this.tradingEventsModel) + ", eventValuationModel=" + String.valueOf(this.eventValuationModel) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + ", reason=" + String.valueOf(this.reason) + "} " + super.toString();
        }
    }
}

