/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.confirmation.processes.meta.AllocationApprovedMeta;
import fpml.consolidated.doc.Allocations;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.ResponseMessage;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AllocationApproved", builder=AllocationApprovedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AllocationApproved", model="fpml", builder=AllocationApprovedBuilderImpl.class, version="1.2.2")
public interface AllocationApproved
extends ResponseMessage {
    public static final AllocationApprovedMeta metaData = new AllocationApprovedMeta();

    public TradeIdentifier getBlockTradeIdentifier();

    public Allocations getAllocations();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public AllocationApproved build();

    @Override
    public AllocationApprovedBuilder toBuilder();

    public static AllocationApprovedBuilder builder() {
        return new AllocationApprovedBuilderImpl();
    }

    default public RosettaMetaData<? extends AllocationApproved> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AllocationApproved> getType() {
        return AllocationApproved.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocations"), processor, Allocations.class, this.getAllocations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class AllocationApprovedBuilderImpl
    extends ResponseMessage.ResponseMessageBuilderImpl
    implements AllocationApprovedBuilder {
        protected TradeIdentifier.TradeIdentifierBuilder blockTradeIdentifier;
        protected Allocations.AllocationsBuilder allocations;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.blockTradeIdentifier != null ? this.blockTradeIdentifier : (this.blockTradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public Allocations.AllocationsBuilder getAllocations() {
            return this.allocations;
        }

        @Override
        public Allocations.AllocationsBuilder getOrCreateAllocations() {
            Allocations.AllocationsBuilder result = this.allocations != null ? this.allocations : (this.allocations = Allocations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public AllocationApprovedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public AllocationApprovedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public AllocationApprovedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public AllocationApprovedBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public AllocationApprovedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        @RuneAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        public AllocationApprovedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public AllocationApprovedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public AllocationApprovedBuilder setBlockTradeIdentifier(TradeIdentifier _blockTradeIdentifier) {
            this.blockTradeIdentifier = _blockTradeIdentifier == null ? null : _blockTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public AllocationApprovedBuilder setAllocations(Allocations _allocations) {
            this.allocations = _allocations == null ? null : _allocations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public AllocationApprovedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public AllocationApproved build() {
            return new AllocationApprovedImpl(this);
        }

        @Override
        public AllocationApprovedBuilder toBuilder() {
            return this;
        }

        @Override
        public AllocationApprovedBuilder prune() {
            super.prune();
            if (this.blockTradeIdentifier != null && !this.blockTradeIdentifier.prune().hasData()) {
                this.blockTradeIdentifier = null;
            }
            if (this.allocations != null && !this.allocations.prune().hasData()) {
                this.allocations = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBlockTradeIdentifier() != null && this.getBlockTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getAllocations() != null && this.getAllocations().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public AllocationApprovedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AllocationApprovedBuilder o = (AllocationApprovedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBlockTradeIdentifier(), (RosettaModelObjectBuilder)o.getBlockTradeIdentifier(), this::setBlockTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocations(), (RosettaModelObjectBuilder)o.getAllocations(), this::setAllocations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AllocationApproved _that = (AllocationApproved)this.getType().cast(o);
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AllocationApprovedBuilder {blockTradeIdentifier=" + String.valueOf(this.blockTradeIdentifier) + ", allocations=" + String.valueOf(this.allocations) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface AllocationApprovedBuilder
    extends AllocationApproved,
    ResponseMessage.ResponseMessageBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateBlockTradeIdentifier();

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getBlockTradeIdentifier();

        public Allocations.AllocationsBuilder getOrCreateAllocations();

        @Override
        public Allocations.AllocationsBuilder getAllocations();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public AllocationApprovedBuilder setFpmlVersion(String var1);

        @Override
        public AllocationApprovedBuilder setExpectedBuild(Integer var1);

        @Override
        public AllocationApprovedBuilder setActualBuild(Integer var1);

        @Override
        public AllocationApprovedBuilder setHeader(ResponseMessageHeader var1);

        @Override
        public AllocationApprovedBuilder setValidationModel(ValidationModel var1);

        @Override
        public AllocationApprovedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public AllocationApprovedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public AllocationApprovedBuilder setBlockTradeIdentifier(TradeIdentifier var1);

        public AllocationApprovedBuilder setAllocations(Allocations var1);

        public AllocationApprovedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("blockTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getBlockTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocations"), processor, Allocations.AllocationsBuilder.class, this.getAllocations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public AllocationApprovedBuilder prune();
    }

    public static class AllocationApprovedImpl
    extends ResponseMessage.ResponseMessageImpl
    implements AllocationApproved {
        private final TradeIdentifier blockTradeIdentifier;
        private final Allocations allocations;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected AllocationApprovedImpl(AllocationApprovedBuilder builder) {
            super(builder);
            this.blockTradeIdentifier = Optional.ofNullable(builder.getBlockTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.allocations = Optional.ofNullable(builder.getAllocations()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="blockTradeIdentifier")
        @RuneAttribute(value="blockTradeIdentifier")
        public TradeIdentifier getBlockTradeIdentifier() {
            return this.blockTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public Allocations getAllocations() {
            return this.allocations;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public AllocationApproved build() {
            return this;
        }

        @Override
        public AllocationApprovedBuilder toBuilder() {
            AllocationApprovedBuilder builder = AllocationApproved.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AllocationApprovedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBlockTradeIdentifier()).ifPresent(builder::setBlockTradeIdentifier);
            Optional.ofNullable(this.getAllocations()).ifPresent(builder::setAllocations);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AllocationApproved _that = (AllocationApproved)this.getType().cast(o);
            if (!Objects.equals(this.blockTradeIdentifier, _that.getBlockTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.allocations, _that.getAllocations())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.blockTradeIdentifier != null ? this.blockTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AllocationApproved {blockTradeIdentifier=" + String.valueOf(this.blockTradeIdentifier) + ", allocations=" + String.valueOf(this.allocations) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

