/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.com.WeatherStation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="WeatherStationChoice")
@ImplementedBy(value=Default.class)
public interface WeatherStationChoice
extends Validator<WeatherStation> {
    public static final String NAME = "WeatherStationChoice";
    public static final String DEFINITION = "optional choice weatherStationCity, weatherStationAirport , weatherStationWBAN , weatherStationWMO";

    public static class NoOp
    implements WeatherStationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, WeatherStation weatherStation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements WeatherStationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, WeatherStation weatherStation) {
            ComparisonResult result = this.executeDataRule(weatherStation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)WeatherStationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"WeatherStation", (RosettaPath)path, (String)WeatherStationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)WeatherStationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"WeatherStation", (RosettaPath)path, (String)WeatherStationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(WeatherStation weatherStation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)weatherStation), Arrays.asList("weatherStationCity", "weatherStationAirport", "weatherStationWBAN", "weatherStationWMO"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

