/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.com.CoalDelivery;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CoalDeliveryChoice")
@ImplementedBy(value=Default.class)
public interface CoalDeliveryChoice
extends Validator<CoalDelivery> {
    public static final String NAME = "CoalDeliveryChoice";
    public static final String DEFINITION = "optional choice deliveryPoint, deliveryAtSource";

    public static class NoOp
    implements CoalDeliveryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CoalDelivery coalDelivery) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CoalDeliveryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CoalDelivery coalDelivery) {
            ComparisonResult result = this.executeDataRule(coalDelivery);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CoalDeliveryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CoalDelivery", (RosettaPath)path, (String)CoalDeliveryChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CoalDeliveryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CoalDelivery", (RosettaPath)path, (String)CoalDeliveryChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CoalDelivery coalDelivery) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)coalDelivery), Arrays.asList("deliveryPoint", "deliveryAtSource"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

