/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.QuantityUnit;
import fpml.consolidated.com.meta.WeatherIndexMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="WeatherIndex", builder=WeatherIndexBuilderImpl.class, version="1.2.2")
@RuneDataType(value="WeatherIndex", model="fpml", builder=WeatherIndexBuilderImpl.class, version="1.2.2")
public interface WeatherIndex
extends RosettaModelObject {
    public static final WeatherIndexMeta metaData = new WeatherIndexMeta();

    public BigDecimal getQuantity();

    public QuantityUnit getUnit();

    public String getId();

    public WeatherIndex build();

    public WeatherIndexBuilder toBuilder();

    public static WeatherIndexBuilder builder() {
        return new WeatherIndexBuilderImpl();
    }

    default public RosettaMetaData<? extends WeatherIndex> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends WeatherIndex> getType() {
        return WeatherIndex.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, (Object)this.getQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, QuantityUnit.class, this.getUnit(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class WeatherIndexBuilderImpl
    implements WeatherIndexBuilder {
        protected BigDecimal quantity;
        protected QuantityUnit.QuantityUnitBuilder unit;
        protected String id;

        @Override
        @RosettaAttribute(value="quantity", isRequired=true)
        @RuneAttribute(value="quantity", isRequired=true)
        public BigDecimal getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="unit", isRequired=true)
        @RuneAttribute(value="unit", isRequired=true)
        public QuantityUnit.QuantityUnitBuilder getUnit() {
            return this.unit;
        }

        @Override
        public QuantityUnit.QuantityUnitBuilder getOrCreateUnit() {
            QuantityUnit.QuantityUnitBuilder result = this.unit != null ? this.unit : (this.unit = QuantityUnit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="quantity", isRequired=true)
        @RuneAttribute(value="quantity", isRequired=true)
        public WeatherIndexBuilder setQuantity(BigDecimal _quantity) {
            this.quantity = _quantity == null ? null : _quantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit", isRequired=true)
        @RuneAttribute(value="unit", isRequired=true)
        public WeatherIndexBuilder setUnit(QuantityUnit _unit) {
            this.unit = _unit == null ? null : _unit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public WeatherIndexBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public WeatherIndex build() {
            return new WeatherIndexImpl(this);
        }

        @Override
        public WeatherIndexBuilder toBuilder() {
            return this;
        }

        @Override
        public WeatherIndexBuilder prune() {
            if (this.unit != null && !this.unit.prune().hasData()) {
                this.unit = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getQuantity() != null) {
                return true;
            }
            if (this.getUnit() != null && this.getUnit().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public WeatherIndexBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            WeatherIndexBuilder o = (WeatherIndexBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnit(), (RosettaModelObjectBuilder)o.getUnit(), this::setUnit);
            merger.mergeBasic((Object)this.getQuantity(), (Object)o.getQuantity(), this::setQuantity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WeatherIndex _that = this.getType().cast(o);
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WeatherIndexBuilder {quantity=" + String.valueOf(this.quantity) + ", unit=" + String.valueOf(this.unit) + ", id=" + this.id + "}";
        }
    }

    public static interface WeatherIndexBuilder
    extends WeatherIndex,
    RosettaModelObjectBuilder {
        public QuantityUnit.QuantityUnitBuilder getOrCreateUnit();

        @Override
        public QuantityUnit.QuantityUnitBuilder getUnit();

        public WeatherIndexBuilder setQuantity(BigDecimal var1);

        public WeatherIndexBuilder setUnit(QuantityUnit var1);

        public WeatherIndexBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, (Object)this.getQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, QuantityUnit.QuantityUnitBuilder.class, this.getUnit(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public WeatherIndexBuilder prune();
    }

    public static class WeatherIndexImpl
    implements WeatherIndex {
        private final BigDecimal quantity;
        private final QuantityUnit unit;
        private final String id;

        protected WeatherIndexImpl(WeatherIndexBuilder builder) {
            this.quantity = builder.getQuantity();
            this.unit = Optional.ofNullable(builder.getUnit()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="quantity", isRequired=true)
        @RuneAttribute(value="quantity", isRequired=true)
        public BigDecimal getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="unit", isRequired=true)
        @RuneAttribute(value="unit", isRequired=true)
        public QuantityUnit getUnit() {
            return this.unit;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public WeatherIndex build() {
            return this;
        }

        @Override
        public WeatherIndexBuilder toBuilder() {
            WeatherIndexBuilder builder = WeatherIndex.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(WeatherIndexBuilder builder) {
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getUnit()).ifPresent(builder::setUnit);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WeatherIndex _that = this.getType().cast(o);
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WeatherIndex {quantity=" + String.valueOf(this.quantity) + ", unit=" + String.valueOf(this.unit) + ", id=" + this.id + "}";
        }
    }
}

