/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Commodity;
import fpml.consolidated.com.CommodityFx;
import fpml.consolidated.com.CommodityPricingDates;
import fpml.consolidated.com.CommoditySpread;
import fpml.consolidated.com.CommoditySpreadSchedule;
import fpml.consolidated.com.FloatingLegCalculation;
import fpml.consolidated.com.meta.FloatingStrikePriceMeta;
import fpml.consolidated.fpmlenum.AveragingMethodEnum;
import fpml.consolidated.shared.Rounding;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FloatingStrikePrice", builder=FloatingStrikePriceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FloatingStrikePrice", model="fpml", builder=FloatingStrikePriceBuilderImpl.class, version="1.2.2")
public interface FloatingStrikePrice
extends FloatingLegCalculation {
    public static final FloatingStrikePriceMeta metaData = new FloatingStrikePriceMeta();

    public Commodity getCommodity();

    @Override
    public FloatingStrikePrice build();

    @Override
    public FloatingStrikePriceBuilder toBuilder();

    public static FloatingStrikePriceBuilder builder() {
        return new FloatingStrikePriceBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingStrikePrice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingStrikePrice> getType() {
        return FloatingStrikePrice.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.class, this.getPricingDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, CommoditySpread.class, this.getSpread(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadSchedule"), processor, CommoditySpreadSchedule.class, this.getSpreadSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadPercentage"), BigDecimal.class, (Object)this.getSpreadPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fx"), processor, CommodityFx.class, this.getFx(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodity"), processor, Commodity.class, this.getCommodity(), new AttributeMeta[0]);
    }

    public static class FloatingStrikePriceBuilderImpl
    extends FloatingLegCalculation.FloatingLegCalculationBuilderImpl
    implements FloatingStrikePriceBuilder {
        protected Commodity.CommodityBuilder commodity;

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        public Commodity.CommodityBuilder getCommodity() {
            return this.commodity;
        }

        @Override
        public Commodity.CommodityBuilder getOrCreateCommodity() {
            Commodity.CommodityBuilder result = this.commodity != null ? this.commodity : (this.commodity = Commodity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingDates", isRequired=true)
        @RuneAttribute(value="pricingDates", isRequired=true)
        public FloatingStrikePriceBuilder setPricingDates(CommodityPricingDates _pricingDates) {
            this.pricingDates = _pricingDates == null ? null : _pricingDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public FloatingStrikePriceBuilder setAveragingMethod(AveragingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public FloatingStrikePriceBuilder setConversionFactor(BigDecimal _conversionFactor) {
            this.conversionFactor = _conversionFactor == null ? null : _conversionFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public FloatingStrikePriceBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public FloatingStrikePriceBuilder setSpread(CommoditySpread _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public FloatingStrikePriceBuilder addSpreadSchedule(CommoditySpreadSchedule _spreadSchedule) {
            if (_spreadSchedule != null) {
                this.spreadSchedule.add(_spreadSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingStrikePriceBuilder addSpreadSchedule(CommoditySpreadSchedule _spreadSchedule, int idx) {
            this.getIndex(this.spreadSchedule, idx, () -> _spreadSchedule.toBuilder());
            return this;
        }

        @Override
        public FloatingStrikePriceBuilder addSpreadSchedule(List<? extends CommoditySpreadSchedule> spreadSchedules) {
            if (spreadSchedules != null) {
                for (CommoditySpreadSchedule commoditySpreadSchedule : spreadSchedules) {
                    this.spreadSchedule.add(commoditySpreadSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spreadSchedule")
        public FloatingStrikePriceBuilder setSpreadSchedule(List<? extends CommoditySpreadSchedule> spreadSchedules) {
            this.spreadSchedule = spreadSchedules == null ? new ArrayList() : (List)spreadSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadPercentage")
        @RuneAttribute(value="spreadPercentage")
        public FloatingStrikePriceBuilder setSpreadPercentage(BigDecimal _spreadPercentage) {
            this.spreadPercentage = _spreadPercentage == null ? null : _spreadPercentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="fx")
        @RuneAttribute(value="fx")
        public FloatingStrikePriceBuilder setFx(CommodityFx _fx) {
            this.fx = _fx == null ? null : _fx.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        public FloatingStrikePriceBuilder setCommodity(Commodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        public FloatingStrikePrice build() {
            return new FloatingStrikePriceImpl(this);
        }

        @Override
        public FloatingStrikePriceBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingStrikePriceBuilder prune() {
            super.prune();
            if (this.commodity != null && !this.commodity.prune().hasData()) {
                this.commodity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getCommodity() != null && this.getCommodity().hasData();
        }

        @Override
        public FloatingStrikePriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FloatingStrikePriceBuilder o = (FloatingStrikePriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodity(), (RosettaModelObjectBuilder)o.getCommodity(), this::setCommodity);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingStrikePrice _that = (FloatingStrikePrice)this.getType().cast(o);
            return Objects.equals(this.commodity, _that.getCommodity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingStrikePriceBuilder {commodity=" + String.valueOf(this.commodity) + "} " + super.toString();
        }
    }

    public static interface FloatingStrikePriceBuilder
    extends FloatingStrikePrice,
    FloatingLegCalculation.FloatingLegCalculationBuilder {
        public Commodity.CommodityBuilder getOrCreateCommodity();

        @Override
        public Commodity.CommodityBuilder getCommodity();

        @Override
        public FloatingStrikePriceBuilder setPricingDates(CommodityPricingDates var1);

        @Override
        public FloatingStrikePriceBuilder setAveragingMethod(AveragingMethodEnum var1);

        @Override
        public FloatingStrikePriceBuilder setConversionFactor(BigDecimal var1);

        @Override
        public FloatingStrikePriceBuilder setRounding(Rounding var1);

        @Override
        public FloatingStrikePriceBuilder setSpread(CommoditySpread var1);

        @Override
        public FloatingStrikePriceBuilder addSpreadSchedule(CommoditySpreadSchedule var1);

        @Override
        public FloatingStrikePriceBuilder addSpreadSchedule(CommoditySpreadSchedule var1, int var2);

        @Override
        public FloatingStrikePriceBuilder addSpreadSchedule(List<? extends CommoditySpreadSchedule> var1);

        @Override
        public FloatingStrikePriceBuilder setSpreadSchedule(List<? extends CommoditySpreadSchedule> var1);

        @Override
        public FloatingStrikePriceBuilder setSpreadPercentage(BigDecimal var1);

        @Override
        public FloatingStrikePriceBuilder setFx(CommodityFx var1);

        public FloatingStrikePriceBuilder setCommodity(Commodity var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.CommodityPricingDatesBuilder.class, (RosettaModelObjectBuilder)this.getPricingDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, (RosettaModelObjectBuilder)this.getRounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, CommoditySpread.CommoditySpreadBuilder.class, (RosettaModelObjectBuilder)this.getSpread(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadSchedule"), processor, CommoditySpreadSchedule.CommoditySpreadScheduleBuilder.class, this.getSpreadSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadPercentage"), BigDecimal.class, (Object)this.getSpreadPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fx"), processor, CommodityFx.CommodityFxBuilder.class, (RosettaModelObjectBuilder)this.getFx(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodity"), processor, Commodity.CommodityBuilder.class, this.getCommodity(), new AttributeMeta[0]);
        }

        @Override
        public FloatingStrikePriceBuilder prune();
    }

    public static class FloatingStrikePriceImpl
    extends FloatingLegCalculation.FloatingLegCalculationImpl
    implements FloatingStrikePrice {
        private final Commodity commodity;

        protected FloatingStrikePriceImpl(FloatingStrikePriceBuilder builder) {
            super(builder);
            this.commodity = Optional.ofNullable(builder.getCommodity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        public Commodity getCommodity() {
            return this.commodity;
        }

        @Override
        public FloatingStrikePrice build() {
            return this;
        }

        @Override
        public FloatingStrikePriceBuilder toBuilder() {
            FloatingStrikePriceBuilder builder = FloatingStrikePrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingStrikePriceBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCommodity()).ifPresent(builder::setCommodity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FloatingStrikePrice _that = (FloatingStrikePrice)this.getType().cast(o);
            return Objects.equals(this.commodity, _that.getCommodity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FloatingStrikePrice {commodity=" + String.valueOf(this.commodity) + "} " + super.toString();
        }
    }
}

